from graphlab.deploy._executionenvironment import LocalExecutionEnvironment as _LocalExecutionEnvironment
from graphlab.deploy._job import Job as _Job

import sys as _sys
import tempfile as _tempfile
import os as _os
import pickle as _pickle


if __name__ == '__main__':
    if(len(_sys.argv) != 2):
        print 'Did not get required args. Usage:'
        print "%s <job file> " % _os.path.basename(_sys.argv[0])
        exit(1)
    
    try:

        print '\nargs received: %s' % _sys.argv
        serialized_job_location = _sys.argv[1]
        
        path = _os.path.dirname(serialized_job_location)
        job = _Job._deserialize(serialized_job_location)

        # Now use the local launcher to run the job in this thread, will be async w.r.t other thread.
        runner = _LocalExecutionEnvironment()
        runner.run_job(job, None)

        # write out job metrics to file, so session process can incorporate into client job
        with open(_os.path.join(path, 'metrics'), 'w') as f:
            f.writelines(str(job.metrics))

        # now that completed successfully write success exitcode to file, so client job can 
        # correctly report that execution completed successfully
        with open(_os.path.join(path, 'exitcode'), 'w') as f:
            f.write('0')

    except Exception as e:
        print "Exception: %s" % e
        exit(1)
