"""
Models that rank items based on their popularity.
"""
import graphlab.connect as _mt
import graphlab as _graphlab
from graphlab.toolkits.recommender.recommender import RecommenderModel
from graphlab.data_structures.sframe import SFrame as _SFrame
import logging as _logging


class FactorizationModel(RecommenderModel):
    """
    A factorization model is able to learn a set of parameters for
    each user and for each item, scoring a (user, item) pair based on
    the similarity of the user and the item.  In other words, the
    method will compose a set of user-item ratings (when are
    represented as a matrix) into a number of latent factors for each
    item and corresponding factors for each user.

    This method differs from :class:`MatrixFactorization
    <graphlab.recommender.MatrixFactorization>` primarily in how side
    features and additional observation columns are treated.  While
    :class:`MatrixFactorization
    <graphlab.recommender.MatrixFactorization>` assigns only a linear
    bias term to any features beyond user and item, this model assigns
    interaction factors to all features.  This allows the model to be
    much more expressive about relationships in the data.

    For further documentation on this model and the pure
    :class:`MatrixFactorization
    <graphlab.recommender.MatrixFactorization>` model, see :class:`MatrixFactorization
    <graphlab.recommender.MatrixFactorization>`.

    References
    ------------------------------------------------------------

    See Steffen Rendle (2010): Factorization Machines, in Proceedings
    of the 10th IEEE International Conference on Data Mining (ICDM 2010).
    """

    def __init__(self, model_proxy):
        self.__proxy__ = model_proxy

    def _get_wrapper(self):
        def model_wrapper(model_proxy):
            return FactorizationModel(model_proxy)
        return model_wrapper
