#!/bin/bash

#TODO use getops 
#TODO allow any tar name


while getopts "c:dn:s:ag:t:x:" OPTION; do
  case "$OPTION" in
    c)
      cache=$OPTARG
      ;;
    d)
      deps=1
      ;;
    n)
      native=$OPTARG
      ;;
    s)
      script=$OPTARG
      ;;
    a)
      artifact=1
      ;;
    g)
      stage_dir=$OPTARG
      ;;
    t)
      task_file=$OPTARG
      ;;
    x)
      python_args=$OPTARG
      ;;
    *)
      echo "unknown option"
      exit 2
  esac
done

echo "cache=$cache"
echo "deps=$deps"
echo "native=$native"
echo "script=$script"
echo "artifact=$artifact"
echo "stage_dir=$stage_dir"
echo "task_file=$task_file"
echo "python_args=$python_args"

PATH=$PATH:/usr/local/bin

echo "************ENV******************"
echo `env`
echo "************ENV******************"

DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
echo "DIR=$DIR"

echo "Creating virtualenv"

gl_junk=`mktemp -d --suffix __GL_JUNK` 
echo "gl_junk=${gl_junk}"


mkdir -p ${gl_junk}/gl_reqs
mkdir -p ${gl_junk}/UserPythonDep
mkdir -p ${gl_junk}/UserResources
cp gl_reqs.tar.gz ${gl_junk}/gl_reqs
cp product_key ${gl_junk}


if [ ! -z $cache ] && [ -d $cache ] ;
then
  	echo "Found a GRAPHLAB_CACHE_VIRTENV to use" 
	virtenv=${cache}
  	echo "virtenv=${virtenv}"
  	${virtenv}/bin/pip uninstall -y graphlab-create
	cd ${gl_junk}/gl_reqs
	tar xvf gl_reqs.tar.gz
	echo "installing reqs"
	echo "installing graphlab with cmd = ${virtenv}/bin/pip install graphlab-create --no-index --find-links file://${gl_junk}/gl_reqs/gl_reqs "
	${virtenv}/bin/pip install graphlab-create --no-index --find-links file://${gl_junk}/gl_reqs/gl_reqs

elif [ ! -z $cache ] && [ ! -d $cache ] ;
then

  	echo "cache requested but not found, making virtenv"
  	virtualenv-2.7 --no-site-packages $cache
  	virtenv=${cache}
  	echo "new virtenv=${virtenv}"
	cd ${gl_junk}/gl_reqs
	tar xvf gl_reqs.tar.gz
	echo "installing reqs"
	echo "installing graphlab with cmd = ${virtenv}/bin/pip install graphlab-create --no-index --find-links file://${gl_junk}/gl_reqs/gl_reqs "
	${virtenv}/bin/pip install graphlab-create --no-index --find-links file://${gl_junk}/gl_reqs/gl_reqs

elif [ "$native" = "hdfs" ] || [ "$native" = "none" ]; then 
	"creating a virtualenv from hdfs gl_reqs"
	virtenv=`mktemp -d --suffix __GL_VIRTENV`
	virtualenv-2.7 --no-site-packages ${virtenv}
	echo "extracting reqs"
	cd ${gl_junk}/gl_reqs
	tar xvf gl_reqs.tar.gz
	echo "installing reqs"
	echo "installing graphlab with cmd = ${virtenv}/bin/pip install graphlab-create --no-index --find-links file://${gl_junk}/gl_reqs/gl_reqs "
	${virtenv}/bin/pip install graphlab-create --no-index --find-links file://${gl_junk}/gl_reqs/gl_reqs

else
	echo "using native graphlab installation"
	virtenv=`mktemp -d --suffix __GL_VIRTENV`
    virtualenv-2.7 --system-site-packages ${virtenv}
fi





if [ "${deps}" = 1 ]; then
  echo "copying user deps"
  cp ${DIR}/UserPythonDep.tar.gz ${gl_junk}/UserPythonDep
fi

cp ${DIR}/UserResources.tar.gz ${gl_junk}/UserResources
cp ${DIR}/product_key ${gl_junk}
cd ${gl_junk}



echo "sourcing virtualenv"
source ${virtenv}/bin/activate

cd ${gl_junk}
KEY="$(cat product_key | grep product_key | cut -d= -f2)"
export GRAPHLAB_PRODUCT_KEY=${KEY}
echo $GRAPHLAB_PRODUCT_KEY
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/cloudera/parcels/CDH/lib64:/usr/local/lib:${JAVA_HOME}/jre/lib/amd64/server
echo "LD_LIBRARY_PATH=$LD_LIBRARY_PATH"

echo "HADOOP_HDFS_HOME=${HADOOP_HDFS_HOME}"
echo "HADOOP_COMMON_HOME=${HADOOP_COMMON_HOME}"
echo "HADOOP_YARN_HOME=${HADOOP_YARN_HOME}"
echo "HADOOP_MAPRED_HOME=${HADOOP_MAPRED_HOME}"


# yucheng magic
#export LD_LIBRARY_PATH=/opt/cloudera/parcels/CDH-5.0.0-1.cdh5.0.0.p0.47/lib64:${JAVA_HOME}/jre/lib/amd64/server:/usr/local/lib
#unset CLASSPATH
for i in `ls ${HADOOP_HDFS_HOME}/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_HDFS_HOME}/lib/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_COMMON_HOME}/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_COMMON_HOME}/lib/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_MAPRED_HOME}/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_MAPRED_HOME}/lib/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_YARN_HOME}/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done
for i in `ls ${HADOOP_YARN_HOME}/lib/*.jar`; do export CLASSPATH=${CLASSPATH}:$i; done

echo "CLASSPATH=${CLASSPATH}"


ldd ${virtenv}/lib/python2.7/site-packages/graphlab/unity_server | grep -q "not found"  && test="not_found" || test="found"
ldd ${virtenv}/lib/python2.7/site-packages/graphlab/libhdfs.so | grep -q "not found"  && hdfso_test="hdfsso_not_found" || hdfso_test="hdfsso_found"
echo "hdfso_test=$hdfso_test"

if [ "${deps}" = "1" ] ; then
  echo "installing user deps"
  cd ${gl_junk}/UserPythonDep
  tar xvf UserPythonDep.tar.gz
  ${virtenv}/bin/pip2.7 install -r UserPythonDep/requirements.txt --no-index --find-links file://${gl_junk}/UserPythonDep/UserPythonDep
fi


if [ ${test} = "not_found" ] ; then
  echo "could not find a required so file in ${virtenv}/lib/python2.7/site-packages/graphlab/unity_server"
  echo `ldd ${virtenv}/lib/python2.7/site-packages/graphlab/unity_server `
  echo "exiting"
  exit 1
fi

cd ${gl_junk}/UserResources
tar xvf UserResources.tar.gz

command=${script}

if [ ! -z "$python_args" ] ; then

  command="${script} ${python_args}"

fi 

if [ "$artifact" = "1" ] ; then
  
  command="$script artifact -d $DIR/top_async.tar.gz/steps/$stage_dir -t $DIR/$task_file"
  
fi

export GRAPHLAB_LOG_PATH=${LOG_DIRS}

echo "command is $command"

${virtenv}/bin/python ${command} 

#TODO delete your mess
