define("job",["react","plots","d3","dagre","common_util","taskqueue","jquery","common_controls","logging","bowser"],function(React,Plots,d3,_dagre,Util,TaskQueue,jQuery,Controls,Logging,Bowser){var vertexWidth=160;var vertexHeight=75;var textLen=14;var maxTextLen=0;var polygonSide=16;function constructJobJSON(tasks){var jobJSON={};var nodesJSON=[];var linksJSON=[];for(var i=0;i<tasks.length;i++){var task=tasks[i];var taskNode={};taskNode["name"]=task.name;taskNode["color"]="#b0007f";taskNode["status"]="pending";taskNode["prop"]="Task";nodesJSON.push(taskNode)}for(var i=0;i<nodesJSON.length-1;i++){var taskNode=nodesJSON[i];var nextNode=nodesJSON[i+1];var linkNode={};linkNode["source"]=taskNode["name"];linkNode["target"]=nextNode["name"];linksJSON.push(linkNode)}jobJSON["nodes"]=nodesJSON;jobJSON["links"]=linksJSON;return jobJSON}function isStageOutput(input){var stage="stage: ";if(input.length<=stage.length){return false}var substr=input.substring(0,stage.length);if(substr==stage){var splitStr=input.split(", ");var output=splitStr[1].split(": ")[0];if(output=="output_name"){return true}}return false}function splitTaskName(name,size){var name_list=[];var name_split=name.split(" ");var line="";for(var idx in name_split){var str=name_split[idx];var line_length=line.length+1+str.length;if(line_length<=size){line=line+str+" "}else{name_list.push(line);if(str.length>size){var subStr=str.substring(0,size-3)+"...";name_list.push(subStr);line="";continue}line=str+" "}}if(line.length>0){name_list.push(line)}return name_list}function calculateRectSize(rows,length){var width=length*10;var height=(rows+2)*15;return{width:width,height:height}}var GraphLayout=React.createClass({displayName:"GraphLayout",handleClick:function(name,evt){var selected_column=this.props.selected_variable.name.concat([name]);this.props.selectVariable(selected_column)},layout:function(){var layoutFn=Util.dagreLayout;return layoutFn(this.props.vertices,this.props.edges,vertexWidth,vertexHeight,vertexWidth*.5)},getInitialState:function(){return{showTask:""}},setTaskShow:function(name){var val=name;if(name==this.state.showTask){val=""}this.setState({showTask:val})},getMinMaxValues:function(graph,axis){var vertexSize=axis=="x"?vertexWidth:vertexHeight;var idx=axis=="x"?0:1;var valuesMin=graph.edges.map(function(e){return d3.min(e.points.map(function(p){return p[idx]}))-vertexSize});var valuesMax=graph.edges.map(function(e){return d3.max(e.points.map(function(p){return p[idx]}))+vertexSize});return[valuesMin,valuesMax]},getMaxRange:function(valuesMin,valuesMax){var maxRange=Math.round((d3.max(valuesMax)-d3.min(valuesMin))/100)*100;if(maxRange==0){maxRange=100}else if(maxRange>2e3){maxRange=2e3}return maxRange},printFA:function(task_pos,task_status){var ret=[];for(var task in task_pos){var x=task_pos[task][0]-215;var abs_x=x.toString().concat("px");var abs_y=task_pos[task][1].toString().concat("px");abs_y="-100px";var style={left:abs_x,top:abs_y,position:"absolute",color:"#fff"};if(task_status.hasOwnProperty(task)){var stat=task_status[task];if(stat=="Running"){style={left:abs_x,top:abs_y,position:"absolute",color:"#fff"};ret.push(React.DOM.i({style:style,className:"fa fa-spinner fa-spin fa-2x"}))}else if(stat=="Completed"){style={left:abs_x,top:abs_y,position:"absolute",color:"#fff"};ret.push(React.DOM.i({style:style,className:"fa fa-check fa-2x"}))}else if(stat=="Failed"){style={left:abs_x,top:abs_y,position:"absolute",color:"#fff"};ret.push(React.DOM.i({style:style,className:"fa fa-times fa-2x"}))}}else{ret.push(React.DOM.i({style:style,className:"fa fa-clock-o fa-2x"}))}}return ret},printTask:function(taskName,tasks){var ret=[];if(taskName==""){ret.push(React.DOM.div(null))}else{var showTask;for(var i=0;i<tasks.length;i++){var task=tasks[i];if(taskName==task.name){showTask=task;break}}ret.push(React.DOM.div({className:"canvas-task-view-border"},TaskInfo({key:showTask.name,name:showTask.name,description:showTask.description,inputs:showTask.inputs,outputs:showTask.outputs,params:showTask.params,required_pkg:showTask.required_packages,code:showTask.code})))}return ret},render:function(){var graph=this.layout();var scaleToAxis=function(axis){var minmaxValues=this.getMinMaxValues(graph,axis);var valuesMin=minmaxValues[0];var valuesMax=minmaxValues[1];var maxRange=this.getMaxRange(valuesMin,valuesMax);return[d3.scale.linear().domain([d3.min(valuesMin),d3.max(valuesMax)]).range([0,maxRange]),maxRange]}.bind(this);var scaleToX=scaleToAxis("x");var scaleToY=scaleToAxis("y");var scaleX=scaleToX[0];var scaleY=scaleToY[0];var max_X=scaleToX[1];var max_Y=scaleToY[1];var task_status=this.props.taskstatus;var task_status_pos={};return React.DOM.div({className:"task-graph-container"},React.DOM.svg({className:"task-graph",width:max_X,height:max_Y+10},graph.edges.map(function(e,idx){var ret=[];var p1=[];var p2=[];for(var i=0;i<e.points.length-1;i++){p1=e.points[i];p2=e.points[i+1];ret.push(React.DOM.line({key:i+"_"+idx+"_line",x1:scaleX(p1[0]),y1:scaleY(p1[1]),x2:scaleX(p2[0]),y2:scaleY(p2[1]),stroke:"#B2B2B2",strokeWidth:5}));var slope=0;var b=0;var points="";if(p2[0]!=p1[0]){slope=(p2[1]-p1[1])/(p2[0]-p1[0]);b=p2[1]-p2[0]*slope}if(slope==0){p2[0]=p2[0]-vertexWidth/2;var points=scaleX(p2[0])+","+scaleY(p2[1])+" "+scaleX(p2[0]-polygonSide)+","+scaleY(p2[1]+polygonSide/2)+" "+scaleX(p2[0]-polygonSide)+","+scaleY(p2[1]-polygonSide/2)}ret.push(React.DOM.polygon({points:points,stroke:"#B2B2B2",fill:"#B2B2B2",strokeWidth:1}))}return ret}.bind(this)),graph.vertices.map(function(n,idx){var ret=[];var x1=scaleX(n.x-vertexWidth/2);var y1=scaleY(n.y-vertexHeight/2);var x2=scaleX(n.x+vertexWidth/2);var y2=scaleY(n.y+vertexHeight/2);var style={"font-size":"12","font-weight":"350",fill:"#000"};var name=n.display;var prop=n.prop;var fill="#b0007f";if(n.name.indexOf("deploy_")==0){fill="#0a8cc4"}Util.assert(x1>=0);Util.assert(y1>=0);ret.push(React.DOM.rect({className:"no-select pointer",onClick:this.handleClick.bind(null,n.name),width:x2-x1,height:y2-y1,x:x1,y:y1,stroke:fill,strokeWidth:.75,fill:fill,key:"_"+idx+"_rect"}));if(prop=="Task"){name=n.name;var fsize=14;var offset=0;if(name.length>14){fsize=11;offset=10}if(name.length>20){offset=15}if(name.length>23){offset=20}style={fill:"#fff","font-size":fsize,"font-weight":"400"};name_list=splitTaskName(name,30);text_x=scaleX(n.x-textLen*2);text_y=scaleY(n.y)-name_list.length*textLen/4;y_diff=0;for(var n_line in name_list){var strlen=5-name_list[n_line].length;ret.push(React.DOM.text({className:"no-select",x:text_x+strlen-offset,y:text_y+y_diff,key:"task_"+n_line+"_"+idx+"_str",style:style},name_list[n_line]));y_diff=y_diff+textLen}}var task_x=scaleX(n.x)-5;var task_y=scaleY(n.y)+name_list.length*textLen/2;task_status_pos[n.name]=[task_x+260,task_y+180];return ret}.bind(this))),React.DOM.div({style:{position:"absolute"}},this.printFA(task_status_pos,task_status)))}});function getKeys(metrics){var keys=[];for(var key in metrics){if(key=="summary"){continue}var keySplit=key.split(".");var name=keySplit[1];if(keys.indexOf(name)==-1){keys.push(name)}}return keys.reverse()}var TaskMetrics=React.createClass({displayName:"TaskMetrics",render:function(){var metricsTable=this.props.metrics;var keys=getKeys(metricsTable);return React.DOM.table({className:"canvas-task-param-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.th(null,"Task Name"),React.DOM.th(null,"Last Run"),React.DOM.th(null,"Run Time")),keys.map(function(k){var ret=[];var lastrun_key="task."+k+".last_run";var time_key="task."+k+".runtime";var lastrun_value=metricsTable[lastrun_key];var time_value=metricsTable[time_key];var lastrun_value_arr=lastrun_value.split(".");lastrun_value_arr.pop();lastrun_value=lastrun_value_arr.join(".");return React.DOM.tr(null,React.DOM.td(null,k),React.DOM.td(null,lastrun_value),React.DOM.td(null,time_value.toFixed(3)))}.bind(this))))}});function compareRun(d1,d2){var t1=Date.parse(d1["order"].split(".")[0]);var t2=Date.parse(d2["order"].split(".")[0]);if(t1<t2){return-1}else if(t1>t2){return 1}else{return 0}}var TaskMetricsGantt=React.createClass({displayName:"TaskMetricsGantt",mixins:[Controls.SizeToWindow],getInitialState:function(){return{collapsed:false}},getDuration:function(ms){var seconds=ms;if(seconds<=60){return seconds.toString().concat("s")}else if(seconds>60&&seconds<=3600){var minutes=Math.ceil(seconds/60);return minutes.toString()+"m"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.round(sec1/60);return hour.toString()+"h "+minutes.toString()+"m"}},render:function(){var metricsTable=this.props.metrics;var keys=getKeys(metricsTable);var numStage=keys.length;var height_stage=150;var height=numStage*height_stage;var width=this.state.windowWidth-600;var plotWidth=width*.95;var plotHeight=height*.95;var plotX=width*.025;var plotY=height*.025;var totalTime=0;var t=[];for(var k=0;k<keys.length;k++){var time_key="task."+keys[k]+".runtime";var last_key="task."+keys[k]+".last_run";var time_value=metricsTable[time_key];var last_run=metricsTable[last_key];var time_table={};time_table[keys[k]]=time_value;t.push({key:keys[k],val:time_value,order:last_run});totalTime=totalTime+time_value}t.sort(compareRun);var totalTimeCeil=Math.ceil(totalTime);var xBinCount=100;var yBinCount=numStage;var binScale=d3.scale.linear().domain([0,5]).range([0,totalTimeCeil]);var scaleX=d3.scale.linear().domain([0,totalTimeCeil]).range([plotX,plotX+plotWidth]);var scaleXbar=d3.scale.linear().domain([0,totalTimeCeil]).range([plotX,plotWidth-plotX]);var scaleY=d3.scale.linear().domain([0,yBinCount+1]).range([plotY,plotY+plotHeight]);var scaleXtick=d3.scale.linear().domain([0,5]).range([plotX,plotWidth-plotX]);var xTicks=d3.range(6);var yTicks=d3.range(yBinCount+2);var max_width=scaleXbar(totalTimeCeil);var xLabels=xTicks.map(function(idx){return{idx:idx,text:binScale(idx).toFixed(1)}}.bind(this));while(xLabels.length>8){xLabels=xLabels.filter(function(item,idx){return idx%2===0})}var yLabels=yTicks.map(function(idx){if(idx==0||idx==yTicks.length-1){return{idx:idx,text:""}}else{return{idx:idx,text:keys[idx-1]}}}.bind(this));yLabels.reverse();var currentY=0;var ySquares=t.map(function(key,val){var k=key["key"];var time=key["val"];var y1=currentY;currentY=currentY+time;return{key:k,x1:y1,x2:currentY}}.bind(this));return React.DOM.div({className:"canvas-gantt-chart"},React.DOM.table({className:"canvas-task-gantt-table"},React.DOM.tr(null,React.DOM.th(null),React.DOM.th(null,React.DOM.svg({style:{width:width,height:30},preserveAspectRatio:"xMinYMin"},React.DOM.line({x1:plotX,y1:18,x2:plotWidth,y2:18,strokeWidth:2,className:"canvas-task-gantt-axes"}),xTicks.map(function(bin,idx){var x=scaleXtick(idx);if(idx!=0&&idx!=5){return null}return React.DOM.line({key:idx,x1:x,x2:x,y1:15,y2:20,strokeWidth:2,className:"canvas-task-gantt-axes"})}.bind(this)),xLabels.map(function(label,idx){var x=scaleXtick(label.idx);if(idx!=0&&idx!=5){return null}return React.DOM.text({key:label.idx,x:x,y:12,textAnchor:"middle",className:"canvas-gantt-label"},this.getDuration(label.text))}.bind(this))))),ySquares.map(function(key){var name=key["key"];var x1=scaleXbar(key["x1"]);var x2=scaleXbar(key["x2"]);var width=x2-x1;if(width<4){width=4}return React.DOM.tr({style:{"border-bottom":"8px solid #fff",height:"35px"}},React.DOM.td({style:{"background-color":"#f6f6f6","padding-top":"4px","text-align":"center"}},React.DOM.div({style:{color:"#b0007f","font-size":"14","margin-top":"5px"}},name)),React.DOM.td({style:{"background-color":"#f6f6f6","padding-top":"4px"}},React.DOM.svg({style:{"min-width":max_width,height:25,"margin-top":"5px"}},React.DOM.rect({x:x1,y:0,width:width,height:30,fill:"#85bd00"}))))}.bind(this))))}});var TaskEnvTable=React.createClass({displayName:"TaskEnvTable",render:function(){var envJSON=this.props.envJSON;return React.DOM.table({className:"canvas-task-param-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.th(null,"Name"),React.DOM.th(null,"Type"),React.DOM.th(null,"Params")),React.DOM.tr(null,React.DOM.td(null,envJSON.name),React.DOM.td(null,envJSON.type),React.DOM.td(null,envJSON.params))))}});var ExpandCollapseSection=React.createClass({displayName:"ExpandCollapseSection",getInitialState:function(){return{collapsed:false}},expandCollapse:function(evt){this.setState({collapsed:!this.state.collapsed})},getCollapseStyle:function(name,child){if(name=="Task Params"){return React.DOM.div({className:"canvas-stage-info"},TaskParamsView({params:child}))}else if(name=="Environment"){return React.DOM.div({className:"canvas-stage-info"},TaskEnvTable({envJSON:child}))}else if(name=="Metrics"){return React.DOM.div({className:"canvas-stage-info"},TaskMetricsGantt({metrics:child}))}else{return React.DOM.div({className:"canvas-stage-info"})}},render:function(){var name=this.state.collapsed?this.props.name:"";var child=this.props.children;return React.DOM.div(null,React.DOM.div(null,React.DOM.div({href:"javascript:",onClick:this.expandCollapse,className:"canvas-stage-title"},this.props.name)),this.getCollapseStyle(name,child))}});var TaskStatus=React.createClass({displayName:"TaskStatus",printFA:function(tstatus){var ret=[];var style={color:"#85bd00"};if(tstatus=="Running"){style={color:"#85bd00"};ret.push(React.DOM.i({style:style,className:"fa fa-spinner fa-spin fa-lg"}))}else if(tstatus=="Completed"){style={color:"#0a8cc4"};ret.push(React.DOM.i({style:style,className:"fa fa-check fa-lg"}))}else if(tstatus=="Failed"){style={color:"#B80000"};ret.push(React.DOM.i({style:style,className:"fa fa-times fa-lg"}))}else{ret.push(React.DOM.i({style:style,className:"fa fa-clock-o fa-lg"}))}return ret},render:function(){var stat="";var style="";var tstatus=this.props.taskStatus;return React.DOM.div({className:"canvas-task-status-container"},React.DOM.div({className:"canvas-task-status no-select"},"Task Status:"),React.DOM.div({className:"canvas-task-status"},tstatus),React.DOM.div({className:"canvas-task-status-fa"},this.printFA(tstatus)))}});var TaskTableViews=React.createClass({displayName:"TaskTableViews",getContent:function(name,child,envTab){if(name=="params"){return React.DOM.div({className:"canvas-task-info"},TaskParamsView({params:child}))}else if(name=="env"){if(envTab==false){return React.DOM.div(null)}return React.DOM.div({className:"canvas-job-wrapper"},TaskEnvTable({envJSON:child}))}else if(name=="metrics"){return React.DOM.div({className:"canvas-job-wrapper"},TaskMetricsGantt({metrics:child}))}else{return React.DOM.div({className:"canvas-job-wrapper"})}},render:function(){var name=this.props.name;var child=this.props.children;var envTab=this.props.envTab;return React.DOM.div(null,this.getContent(name,child,envTab))}});var TaskView=React.createClass({displayName:"TaskView",render:function(){var tasks=this.props.tasks;var name=this.props.name;if(name==""){return React.DOM.div(null)}var showTask;for(var i=0;i<tasks.length;i++){var task=tasks[i];if(name==task.name){showTask=task;break}}return React.DOM.div({className:"canvas-task-view-border"},TaskInfo({name:showTask.name,description:showTask.description,inputs:showTask.inputs,outputs:showTask.outputs,params:showTask.params,required_pkg:showTask.required_packages,code:showTask.code}))}});var StageCodeView=React.createClass({displayName:"StageCodeView",componentDidMount:function(){var node=this.getDOMNode()},shouldComponentUpdate:function(){return false},render:function(){var code=this.props.code;return React.DOM.pre(null,React.DOM.code({"class":"python"},code))}});var TaskInfo=React.createClass({displayName:"TaskInfo",componentDidMount:function(){var block=this.getDOMNode()},shouldComponentUpdate:function(){return false},render:function(){var name=this.props.name;var description=this.props.description;var inputs=this.props.inputs;var outputs=this.props.outputs;var params=this.props.params;var code=this.props.code;var packages=this.props.packages;return React.DOM.div({className:"canvas-stage-table"},React.DOM.div({className:"canvas-stage-title"},"Task: ",name),React.DOM.div({className:"canvas-stage-title"},"Inputs :"),React.DOM.div({className:"canvas-stage-info"},inputs),React.DOM.div({className:"canvas-stage-title"},"Params :"),React.DOM.div({className:"canvas-stage-info"},JSON.stringify(params)),React.DOM.div({className:"canvas-stage-title"},"Outputs :"),React.DOM.div({className:"canvas-stage-info"},Object.keys(outputs)),React.DOM.div({className:"canvas-stage-title"},"Code :"),React.DOM.div({className:"canvas-stage-code"},StageCodeView({code:code})))}});var StatusBox=React.createClass({displayName:"StatusBox",getStatusFA:function(tstatus){var ret=[];var style={color:"#fff"};if(tstatus=="Running"){ret.push(React.DOM.i({style:style,className:"fa fa-gear fa-spin fa-lg"}))}else if(tstatus=="Completed"){ret.push(React.DOM.i({style:style,className:"fa fa-check fa-lg"}))}else if(tstatus=="Failed"){ret.push(React.DOM.i({style:style,className:"fa fa-times fa-lg"}))}else{ret.push(React.DOM.i({style:style,className:"fa fa-clock-o fa-lg"}))}return ret},render:function(){var stat=this.props.jobStatus;var background="#85bd00";if(stat=="Running"){background="#85bd00"}else if(stat=="Failed"){background="#B80000"}else if(stat=="Completed"){background="#0a8cc4"}return React.DOM.div({className:"canvas-job-statusbox",style:{"background-color":background}},React.DOM.div({style:{width:"20px","float":"left"}},this.getStatusFA(stat)),React.DOM.div({style:{"float":"left","margin-left":"5px"}},stat))}});return{View:React.createClass({displayName:"View",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(){return{metrics:{},status:false,stageView:"stage",tabView:"metrics",envTab:false,stageElementColor:{"background-color":"#fff"},fullElementColor:{"background-color":"#fff"},metricsElementColor:{"background-color":"#fff",color:"#000"},paramsElementColor:{"background-color":"#fff"},envElementColor:{"background-color":"#c5c5c5",color:"#0a8cc4"}}},changeView:function(setView){this.setState({stageView:setView});if(setView=="stage"){this.setState({stageElementColor:{"background-color":"#fff"},fullElementColor:{"background-color":"#fff"}})}else{this.setState({stageElementColor:{"background-color":"#fff"},fullElementColor:{"background-color":"#fff"}})}},changeTab:function(setTab){this.setState({tabView:setTab});if(setTab=="metrics"){this.setState({metricsElementColor:{"background-color":"#fff",color:"#000"},paramsElementColor:{"background-color":"#fff"},envElementColor:{"background-color":"#c5c5c5",color:"#0a8cc4"}})}else if(setTab=="params"){this.setState({metricsElementColor:{"background-color":"#fff"},paramsElementColor:{"background-color":"#fff"},envElementColor:{"background-color":"#fff"}})}else if(setTab=="env"){this.setState({metricsElementColor:{"background-color":"#c5c5c4",color:"#0a8cc4"},paramsElementColor:{"background-color":"#fff"},envElementColor:{"background-color":"#fff",color:"#000"}});this.setState({envTab:!this.state.envTab})}},updateAsyncState:function(nextProps){var pageTasks=[];TaskQueue.add(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"Job"})}))},render:function(){var name=Util.tryGetProperty(this.props.selected_variable,"jobname");var tasks=Util.tryGetProperty(this.props.selected_variable,"tasks");var env=Util.tryGetProperty(this.props.selected_variable,"env");var metrics=Util.tryGetProperty(this.props.selected_variable,"metrics");var isRunning=Util.tryGetProperty(this.props.selected_variable,"status");var task_status=Util.tryGetProperty(this.props.selected_variable,"taskstatus");var envJSON=env;var jobJSON=constructJobJSON(tasks);var tabContent={};if(this.state.tabView=="metrics"){tabContent=metrics}else if(this.state.tabView=="env"){tabContent=envJSON}return React.DOM.div({className:"tab-content",style:{"max-width":this.state.windowWidth-(190+50),"max-height":this.state.windowHeight-(74+20),overflow:"auto"}},StatusBox({jobStatus:isRunning}),React.DOM.div({className:"canvas-stage-table"},React.DOM.br(null),React.DOM.div({className:"canvas-task-tab"},React.DOM.div({className:"canvas-task-tab-element no-select",style:this.state.stageElementColor,onClick:this.changeView.bind(null,"stage")},"Tasks Graph")),React.DOM.div({className:"canvas-task-views"},GraphLayout({vertices:jobJSON.nodes,edges:jobJSON.links,tasks:tasks,taskstatus:task_status,selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable})),React.DOM.div({className:"canvas-task-tab"},React.DOM.div({className:"canvas-task-tab-element no-select"},"Metrics")),React.DOM.br(null),React.DOM.div({className:"canvas-job-tab"},React.DOM.div({className:"canvas-job-tab-element no-select",style:this.state.metricsElementColor,onClick:this.changeTab.bind(null,"metrics")},"Timeline"),React.DOM.div({className:"canvas-job-tab-element no-select",style:this.state.envElementColor,onClick:this.changeTab.bind(null,"env")},"Environment")),React.DOM.div(null,TaskTableViews({name:this.state.tabView,children:tabContent}))))}})}});