import graphlab.canvas
import graphlab.canvas.views as views
import graphlab.canvas.views.base

import json

class JobView(graphlab.canvas.views.base.BaseView):

    def __init__(self, obj, params):
        super(JobView, self).__init__(obj, params)
        self.__child_views = {}

    def get_metadata(self):
        self.__update_child_views()
        return {
            'jobname' : [self.obj.name],
            'tasks' : list([stage[0].__to_dict__() for stage in self.obj.tasks]),
            'env' : self.obj.environment.__to_dict__(),
            'status' : self.obj.get_status(),
            'metrics' : self.obj.get_metrics(),
            'taskstatus' : self.obj.get_task_status()
        }

    def get_staticdata(self):
        data = {
            'status' : self.obj.get_status(),
        }
        data.update(get_metadata())
        return data


    def __update_child_views(self):
        self.__child_views = {}
        tasks = list([stage[0] for stage in self.obj.tasks])
        for t in tasks:
            self.__child_views[t.name] = views.get_view(t)
        graphlab.canvas.get_target().state.update_child_views(self)

    def child_views(self):
        return self.__child_views

    def get_js_file(self):
        return 'job'

