import graphlab.canvas
import graphlab.canvas.views as views
import graphlab.canvas.views.base
import graphlab.deploy

import json

class ScopedSessionView(graphlab.canvas.views.base.BaseView):

    def __init__(self, obj, params):
        super(ScopedSessionView, self).__init__(obj, params)
        self.__child_views = {}
        self.__job_list = {}
        self.objectType = 'Dashboard' # override default object type

    def get_metadata(self):
        joblist = self.__update_child_views()
        data = {
            'sessionname' : 'Dashboard',
            'list' : joblist
        }
        return data
    
    def __update_child_views(self):
        joblist = self.obj.list()
        # load all jobs
        self.__child_views = {}
        job_dict = []
        for jobblock in joblist:
            job_info = {}
            job = graphlab.deploy.jobs.load(jobblock['Name'])
            job_info['name'] = job.name
            job_info['status'] = job.get_status()
            job_info['starttime'] = job.get_start_time()
            job_info['type'] = jobblock['Type']
            # get rest of the completed info
            if job.get_status() == 'Completed':
                job_info['endtime'] = job.get_end_time()
                job_info['metrics'] = job.get_metrics()
            job_dict.append(job_info)
            self.__child_views[job.name] = views.get_view(job)
        graphlab.canvas.get_target().state.update_child_views(self)
        return job_dict
    
    def child_views(self):
        return self.__child_views

    def get_js_file(self):
        return 'session'

    def get_temporary_name(self):
        return ('Job Dashboard',)
