"""
The GraphLab nearest neighbors toolkit is used to find the rows in a data table
that are most similar to a query row.

Finding nearest neighbors is a two-stage process, analogous to many other
GraphLab toolkits. First a
:py:class:`~graphlab.nearest_neighbors.NearestNeighborsModel` is created, using
a reference dataset contained in an :class:`~graphlab.SFrame`. Then this model
is queried to find the nearest reference data points to a set of new query
points, also stored in an SFrame.

.. sourcecode:: python

    >>> references = graphlab.SFrame({'label': [str(x) for x in range(3)],
                                     'feature1': [0.98, 0.62, 0.11],
                                     'feature2': [0.69, 0.58, 0.36]})    
    >>> model = graphlab.nearest_neighbors.create(references, 'label')

    >>> queries = graphlab.SFrame({'label': [str(x) for x in range(3)],
                                  'feature1': [0.05, 0.61, 0.99],
                                  'feature2': [0.06, 0.97, 0.86]})    
    >>> model.query(queries, 'label', k=2)
    +-------------+-----------------+----------------+------+
    | query_label | reference_label |    distance    | rank |
    +-------------+-----------------+----------------+------+
    |      0      |        2        | 0.305941170816 |  1   |
    |      0      |        1        | 0.771556867638 |  2   |
    |      1      |        1        | 0.390128184063 |  1   |
    |      1      |        0        | 0.464004310325 |  2   |
    |      2      |        0        | 0.170293863659 |  1   |
    |      2      |        1        | 0.464004310325 |  2   |
    +-------------+-----------------+----------------+------+

In addition to the API documentation, please see the data science `Gallery
<http://www.graphlab.com/learn/gallery>`_, `How-tos
<http://www.graphlab.com/learn/how-to>`_, and the `clustering chapter of the
User Guide 
<http://www.graphlab.com/learn/userguide.html#Modeling_data_Clustering_and_nearest_neighbors>`_
for more details and extended examples.
"""

from graphlab.toolkits.nearest_neighbors import nearest_neighbors