r"""
The GraphLab tree_ensembles toolkit currently includes
:py:func:`Gradient Boosted Trees <graphlab.tree_ensembles.boosted_trees.create>` for regression and classification tasks.

The Gradient Boosted Trees model uses a collection of base learners, `regression trees or classification trees <http://en.wikipedia.org/wiki/Decision_tree_learning>`_ depending on the task, and combines them through a technique called `gradient boosting <http://en.wikipedia.org/wiki/Gradient_boosting>`_.

Compared to linear models, tree ensemble models are able to make predictions of the target variable as a non-linear function over feature variables,
and typically produce more accurate results across a wide range of real world datasets. However, trees do not handle high dimensional sparse features very well.

**Quick Start**

Create a regression model for predicting the median house value in the `Boston housing <http://archive.ics.uci.edu/ml/datasets/Housing>`_ dataset:

>>> import graphlab
>>> sf = graphlab.SFrame.read_csv('http://s3.amazonaws.com/GraphLab-Datasets/boosted_trees/boston-housing.csv')
>>> (training_data, test_data) = sf.random_split(0.8)
>>> m = graphlab.boosted_trees.create(training_data, target_column='MEDV', objective='regression')
>>> prediction = m.predict(test_data)
>>> rmse = m.evaluate(test_data)['rmse']

Create a classification model for classifying the target variable 'label' in the `mushroom <https://archive.ics.uci.edu/ml/datasets/Mushroom>`_ dataset:

>>> import graphlab
>>> sf = graphlab.SFrame.read_csv('http://s3.amazonaws.com/GraphLab-Datasets/boosted_trees/mushroom.csv')
>>> # Target column must be numerical
>>> sf['label'] = sf['label'] == 'e'
>>> (training_data, test_data) = sf.random_split(0.8)
>>> m = graphlab.boosted_trees.create(training_data, target_column='label', objective='classification')
>>> prediction = m.predict(test_data)
>>> classification_error = m.evaluate(test_data, metric='error')['error']

**Notes**

The current implementation of the gradient boosted trees model is based on
an open source optimized general purpose gradient boosting (tree) library
`eXtreme Gradient Boosting <https://github.com/tqchen/xgboost>`_ created by
`Tianqi Chen <http://homes.cs.washington.edu/~tqchen/>`_.
The limitation of the current implmenetation is that the model will be held in memory
after created, and the dataset needs to fit the memory during training.
"""

import boosted_trees 
