define("plot_box",["react","d3","common_controls","common_util"],function(React,d3,Controls,Util){return{BoxAndWhisker:React.createClass({displayName:"BoxAndWhisker",transformData:function(data,params,states){var quantile=data.quantile;var Q0=quantile[0];var Q1=quantile[25];var Q2=quantile[50];var Q3=quantile[75];var Q4=quantile[100];var IQR=Q3-Q1;var lowWhiskerValue=Math.max(Q0,Q1-1.5*IQR);var highWhiskerValue=Math.min(Q4,Q3+1.5*IQR);var lowOutlierValues=[];var highOutlierValues=[];for(var i=0;i<quantile.length;i++){if(quantile[i]<lowWhiskerValue){lowOutlierValues.push(quantile[i])}if(quantile[i]>highWhiskerValue){highOutlierValues.push(quantile[i])}}return{minValue:Q0,maxValue:Q4,lowOutliers:lowOutlierValues,highOutliers:highOutlierValues,lowWhisker:{low:lowWhiskerValue,high:Q1},highWhisker:{low:Q3,high:highWhiskerValue},lowBox:{low:Q1,high:Q2},highBox:{low:Q2,high:Q3},median:{value:Q2}}},calculateScales:function(data,params,states){var yScale=d3.scale.linear().domain([0,1]).range([0,params.height]);var xScale=d3.scale.linear().domain([params.minValue,params.maxValue]).range([10,params.width-10]);var heightScale=yScale;var widthScale=d3.scale.linear().domain([0,params.maxValue-params.minValue]).range([0,params.width-20]);return{x:xScale,y:yScale,width:widthScale,height:heightScale}},render:function(){var hasData=Util.tryGetProperty(this.props.data,"quantile",null)!==null;var isInsideSvg=Util.tryGetProperty(this.props,"is_inside_svg",false);if(!hasData){return isInsideSvg?React.DOM.div(null):React.DOM.g(null)}var width=Util.tryGetProperty(this.props,"width",152);if(this.props.vertical){width*=6}var height=width/6;var style={width:width,height:this.props.vertical?width:height};var transform=this.props.vertical?"rotate(270deg) translateX(-"+width+"px) translateY("+width/4+"px)":"";var containerStyle=this.props.vertical?{transform:transform,"-webkit-transform":transform}:{};var params={width:width,height:height,maxValue:Util.tryGetProperty(this.props,"max_value",this.props.data.max),minValue:Util.tryGetProperty(this.props,"min_value",this.props.data.min)};var data=this.transformData(this.props.data,params,this.states);var scales=this.calculateScales(this.props.data,params,this.states);var viewBody=React.DOM.g({className:"BoxAndWhisker",style:containerStyle},React.DOM.g({className:"lowOutliers"},data.lowOutliers.map(function(d,idx){return React.DOM.circle({key:idx,cx:scales.x(d),cy:scales.y(.5),r:2.5,fill:"#85bd00"})})),React.DOM.g({className:"lowWhisker"},function(d){return React.DOM.g(null,React.DOM.line({x1:scales.x(d.low),x2:scales.x(d.low),y1:scales.y(0),y2:scales.y(1),className:"canvas-boxplot-end"}),React.DOM.line({x1:scales.x(d.low),x2:scales.x(d.high),y1:scales.y(.5),y2:scales.y(.5),className:"canvas-boxplot-line"}))}(data.lowWhisker)),React.DOM.g({className:"lowBox"},function(d){return React.DOM.rect({x:scales.x(d.low),width:scales.width(d.high-d.low)-1,y:scales.y(.05),height:scales.height(.9),fill:"#85bd00"})}(data.lowBox)),React.DOM.g({className:"median"},function(d){return React.DOM.rect({x:scales.x(d.value)-.5,width:2,y:scales.y(.05),height:scales.height(.9),fill:"#fff"})}(data.median)),React.DOM.g({className:"highBox"},function(d){return React.DOM.rect({x:scales.x(d.low),width:scales.width(d.high-d.low)-1,y:scales.y(.05),height:scales.height(.9),fill:"#85bd00"})}(data.highBox)),React.DOM.g({className:"highWhisker"},function(d){return React.DOM.g(null,React.DOM.line({x1:scales.x(d.high),x2:scales.x(d.high),y1:scales.y(0),y2:scales.y(1),className:"canvas-boxplot-end"}),React.DOM.line({x1:scales.x(d.low),x2:scales.x(d.high),y1:scales.y(.5),y2:scales.y(.5),className:"canvas-boxplot-line"}))}(data.highWhisker)),React.DOM.g({className:"highOutliers"},data.highOutliers.map(function(d,idx){return React.DOM.circle({key:idx,cx:scales.x(d),cy:scales.y(.5),r:2.5,fill:"#85bd00"})})));return isInsideSvg?viewBody:React.DOM.div({className:"canvas-plot-boxandwhisker"},React.DOM.svg({style:style},viewBody))}})}});