"""
GraphLab offers multiple ways to work with your data beyond your desktop or
laptop. GraphLab has a Data Pipeline framework for quickly building automated
data products.

The GraphLab Data Pipeline is a light-weight framework for building reusable
units-of-work, specifying the execution environment (ex. EC2, Hadoop), with
late-binding and loose coupling, and management tools to support asynchronous
execution.

Explore the detailed functionality via the following API documentation or the
`Deployment chapter of the User Guide
<http://www.graphlab.com/learn/userguide.html#Deployment>`_, as well as the
`Gallery <http://www.graphlab.com/learn/gallery>`_.
"""

__all__ = [ 'Task', 'tasks', 'environments', 'jobs', 'job' ]

# Job
from _job import Job as _Job

# Tasks and pipelines
from _artifact import Task
from _artifact import Pipeline as _Pipeline

import _session
_default_session = _session.open()

import _hadoop_wrap as _hadoop_wrap
from environment import Environment as _Environment

# session helpers
tasks = _session.ScopedSession(_default_session, Task, """
View and manage Tasks available in the workbench.

Tasks currently available can be listed, loaded, and deleted using this object.
This object represents the portion of the workbench for Tasks that have been
defined in GraphLab Create.

Examples
--------
>>> t = graphlab.deploy.Task("init-ex1-task")
>>> graphlab.deploy.tasks
Task(s): 
+-------+---------------+------+------------------+
| Index |      Name     | Type | Unsaved changes? |
+-------+---------------+------+------------------+
|   0   | init-ex1-task | Task |       Yes        |
+-------+---------------+------+------------------+
>>> 
>>> # to load a Task by index number:
>>> task = graphlab.deploy.tasks[0]
>>> # to load a Task by name:
>>> task = graphlab.deploy.tasks['init-ex1-task']
>>>
>>> # to delete a Task by name (deleting by index number also supported):
>>> del graphlab.deploy.tasks['init-ex1-task']
""")

environments = _session.ScopedSession(_default_session, _Environment, """
View and manage Environments available in the workbench.

Environments currently available can be listed, loaded, and deleted using this
object.  This object represents the portion of the workbench for Environments
that have been defined in GraphLab Create.

Examples
--------

>>> my_env = graphlab.deploy.environment.Local("init-ex2-env")
>>> graphlab.deploy.environments
Environment(s): 
+-------+--------------+------------------+------------------+
| Index |     Name     |       Type       | Unsaved changes? |
+-------+--------------+------------------+------------------+
|   0   | init-ex2-env | LocalEnvironment |       Yes        |
+-------+--------------+------------------+------------------+
>>> 
>>> # to load an Environment by index number:
>>> environment = graphlab.deploy.environments[0]
>>> # to load an Environment by name:
>>> environment = graphlab.deploy.environments['init-ex2-env']
>>>
>>> # to delete an Environment by name 
>>> # (deleting by index number also supported):
>>> del graphlab.deploy.environments['init-ex2-env']

""")

jobs = _session.ScopedSession(_default_session, _Job, """
View and manage Jobs available in the workbench.

Jobs currently available can be listed, loaded, and deleted using this object.
This object represents the portion of the workbench for Jobs that have been
defined in GraphLab Create.

Examples
--------

>>> t = graphlab.deploy.Task("print-hello-world-task")
>>> my_env = graphlab.deploy.environment.Local("init-ex3-env")
>>> def hello_world(task): print "Hello, world"
>>> t.set_code(hello_world)
>>> graphlab.deploy.job.create(t, environment=my_env)
>>> graphlab.deploy.jobs
Job(s): 
+-------+----------------------------------------------------+------+------------------+
| Index |                        Name                        | Type | Unsaved changes? |
+-------+----------------------------------------------------+------+------------------+
|   0   | job-print-hello-world-task-init-ex3-env-1407900916 | Job  |        No        |
+-------+----------------------------------------------------+------+------------------+
>>> 
>>> # to load a Job by index number:
>>> job = graphlab.deploy.jobs[0]
>>> # to load a Job by name:
>>> job = graphlab.deploy.jobs['job-print-hello-world-task-init-ex3-env-1407900916']
>>>
>>> # to delete a Job by index number (deleting by name also supported):
>>> del graphlab.deploy.jobs[0]

""")

import job

