"""
Methods for creating a model that predicts using the mean item rating.
"""

import graphlab.connect as _mt
import graphlab as _graphlab
from graphlab.toolkits.recommender.recommender import RecommenderModel
from graphlab.data_structures.sframe import SFrame as _SFrame
from graphlab.deps import pandas as _pandas, HAS_PANDAS as _HAS_PANDAS
import logging


class ItemMeansModel(RecommenderModel):
    """
    The Item Means Model ranks an item according to its average rating across
    all users.

    This model extends the :class:`~graphlab.recommender.PopularityModel` when
    observation data includes a `target` column of ratings. The score of an item
    is the average of this items rating across users. Thus, all users receive 
    the same item recommendations.

    **Creating a ItemMeansModel**

    This model can be created using
    :func:`graphlab.recommender.create(..., method='item_means') <graphlab.recommender.create>`.
    Do NOT instantiate this model class directly.

    >>> sf = graphlab.SFrame({'user_id': ["0", "0", "0", "1", "1", "2", "2", "2"], 
    ...                       'item_id': ["a", "b", "c", "a", "b", "b", "c", "d"],
    ...                       'rating': [1, 3, 2, 5, 4, 1, 4, 3]})
    >>> m = graphlab.recommender.create(sf, target='rating', method='item_means')

    See Also
    --------
    PopularityModel
    """

    def __init__(self, model_proxy):
        '''__init___(self)'''
        self.__proxy__ = model_proxy

    def _get_wrapper(self):
        def model_wrapper(model_proxy):
            return ItemMeansModel(model_proxy)
        return model_wrapper
