"""
Models that rank items based on their popularity.
"""
import graphlab.connect as _mt
import graphlab as _graphlab
from graphlab.toolkits.recommender.recommender import RecommenderModel
from graphlab.data_structures.sframe import SFrame as _SFrame
from graphlab.deps import pandas as _pandas, HAS_PANDAS as _HAS_PANDAS
import logging

class PopularityModel(RecommenderModel):
    """
    The Popularity Model ranks an item according to its overall popularity.

    When making recommendations, the items are scored by the number of times it
    is seen in the training set. The item scores are the same for all users. 
    Hence the recommendations are not tailored for individuals.

    The Popularity Model is simple and fast and provides a reasonable baseline.
    It can work well when observation data is sparse. It can be used as a 
    "background" model for new users.

    **Creating a PopularityModel**

    This model can be created using
    :func:`graphlab.recommender.create(..., method='popularity') <graphlab.recommender.create>`.
    Do NOT instantiate this model class directly.

    >>> sf = graphlab.SFrame({'user_id': ["0", "0", "0", "1", "1", "2", "2", "2"], 
    ...                       'item_id': ["a", "b", "c", "a", "b", "b", "c", "d"]})
    >>> m = graphlab.recommender.create(sf, method='popularity')

    See Also
    --------
    ItemMeansModel
    """

    def __init__(self, model_proxy):
        '''__init__(self)'''
        self.__proxy__ = model_proxy

    def _get_wrapper(self):
        def model_wrapper(model_proxy):
            return PopularityModel(model_proxy)
        return model_wrapper
