"""
@package graphlab
...
more contents
"""

import graphlab.connect.aws as aws

import graphlab.deploy

from graphlab.data_structures.sgraph import Vertex, Edge
from graphlab.data_structures.sgraph import SGraph
from graphlab.data_structures.sarray import SArray
from graphlab.data_structures.sframe import SFrame
from graphlab.data_structures.sketch import Sketch
from graphlab.data_structures.image import Image


from graphlab.toolkits._model import Model

import graphlab.aggregate
import graphlab.canvas
import graphlab.toolkits
import graphlab.toolkits.clustering as clustering

from graphlab.toolkits import evaluation
import graphlab.toolkits.vowpal_wabbit as vowpal_wabbit
import graphlab.toolkits.text_analytics as text_analytics
import graphlab.toolkits.graph_analytics as graph_analytics

import graphlab.toolkits.recommender as recommender
from graphlab.toolkits.recommender import popularity_recommender
from graphlab.toolkits.recommender import item_similarity_recommender
from graphlab.toolkits.recommender import ranking_factorization_recommender
from graphlab.toolkits.recommender import factorization_recommender

from graphlab.toolkits.graph_analytics import connected_components
from graphlab.toolkits.graph_analytics import shortest_path
from graphlab.toolkits.graph_analytics import kcore
from graphlab.toolkits.graph_analytics import pagerank
from graphlab.toolkits.graph_analytics import graph_coloring
from graphlab.toolkits.graph_analytics import triangle_counting

import graphlab.toolkits.regression as regression
from graphlab.toolkits.regression import boosted_trees_regression
from graphlab.toolkits.regression import linear_regression

import graphlab.toolkits.classifier as classifier
from graphlab.toolkits.classifier import svm_classifier
from graphlab.toolkits.classifier import logistic_classifier
from graphlab.toolkits.classifier import boosted_trees_classifier
from graphlab.toolkits.classifier import neuralnet_classifier

import graphlab.toolkits.deeplearning as deeplearning
import graphlab.toolkits.nearest_neighbors as nearest_neighbors
from graphlab.toolkits.clustering import kmeans
from graphlab.toolkits.topic_model import topic_model

from graphlab.toolkits.image_analysis import image_analysis

## bring load functions to the top level
from graphlab.data_structures.sgraph import load_sgraph, load_graph
from graphlab.data_structures.sframe import load_sframe, get_spark_integration_jar_path
from graphlab.toolkits._model import load_model




# internal util
from graphlab.connect.main import launch as _launch
from graphlab.connect.main import stop as _stop
import graphlab.connect.main as glconnect

# python egg version
__VERSION__ = '1.0.1'
version = '1.0.1'

from graphlab.util import get_newest_version
from graphlab.util import perform_version_check
from graphlab.util import get_environment_config
from graphlab.util import get_runtime_config
from graphlab.util import set_runtime_config

from graphlab.version_info import version
from graphlab.version_info import __VERSION__


class DeprecationHelper(object):
    def __init__(self, new_target):
        self.new_target = new_target

    def _warn(self):
        import warnings
        import logging
        warnings.warn("Graph has been renamed to SGraph. The Graph class will be removed in the next release.", PendingDeprecationWarning)
        logging.warning("Graph has been renamed to SGraph. The Graph class will be removed in the next release.")

    def __call__(self, *args, **kwargs):
        self._warn()
        return self.new_target(*args, **kwargs)

    def __getattr__(self, attr):
        self._warn()
        return getattr(self.new_target, attr)

Graph = DeprecationHelper(SGraph)

perform_version_check()

################### Extension Importing ########################
import graphlab.extensions
from graphlab.extensions import ext_import

graphlab.extensions._add_meta_path()

# rewrite the extensions module
class _extensions_wrapper(object):
  def __init__(self, wrapped):
    self._wrapped = wrapped

  def __getattr__(self, name):
    try:
        return getattr(self._wrapped, name)
    except:
        pass
    graphlab.connect.main.get_unity()
    return getattr(self._wrapped, name)

import sys as _sys
_sys.modules["graphlab.extensions"] = _extensions_wrapper(_sys.modules["graphlab.extensions"])
# rewrite the import
extensions = _sys.modules["graphlab.extensions"]
