import graphlab.canvas
import graphlab.canvas.views as views
import graphlab.canvas.views.base
import graphlab.canvas.views.job
import graphlab.deploy

import __builtin__
import json
import datetime

class ScopedSessionView(graphlab.canvas.views.base.BaseView):

    def __init__(self, obj, params=None):
        super(ScopedSessionView, self).__init__(obj, params)
        self.__max_loads = 20 # max number of jobs loaded at each time interval
        self.__child_views = {}
        self.__job_list = {}
        self.objectType = 'Jobs' # override default object type

    def get_metadata(self):
        joblist = self.__update_child_views()
        data = {
            'sessionname' : 'Dashboard',
            'list' : joblist,
        }
        return data
    
    def __update_child_views(self):
        job_dict = []
        cur_loads = 0

        # load all jobs
        joblist = self.obj._list()
        for jobname in joblist:
            job_info = {}
            # check if job is already loaded
            if jobname in self.__job_list:
                job = self.__job_list[jobname]
            else:
                # load and store the job if we have not reach the maximum number of loads
                if cur_loads >= self.__max_loads:
                    continue
                job = graphlab.deploy.jobs[jobname]
                self.__job_list[jobname] = job
                cur_loads += 1

            job_info['name'] = job.name
            job_info['status'] = job.get_status()
            job_info['starttime'] = job._get_start_time()
            job_info['type'] = __builtin__.type(job).__name__
            # get rest of the completed info
            if job.get_status() == 'Completed':
                job_info['endtime'] = job._get_end_time()
                job_info['metrics'] = job.get_metrics()
            job_dict.append(job_info)
            if not job.name in self.__child_views:
                self.__child_views[job.name] = graphlab.canvas.views.job.JobView(job)

        # delete saved jobs that are not in the current list
        for jobname in self.__job_list.keys():
            if jobname not in joblist:
                del self.__job_list[jobname]

        return job_dict
    
    def child_views(self):
        self.__update_child_views()
        return self.__child_views

    def get_js_file(self):
        return 'job_session'

    def get_temporary_name(self):
        return ('Jobs',)
