"""
GraphLab Create includes GraphLab Canvas, a built-in visualization platform and
web application designed to compliment the GraphLab Create data science and
development workflow. GraphLab Canvas can be used interactively in
a browser-based application or directly via API methods.

**Visualizing GraphLab data structures in GraphLab Canvas**

GraphLab Canvas allows you to explore interactive visuals and a table of the
data in an :class:`~graphlab.SFrame`, :class:`~graphlab.SGraph` and
:class:`~graphlab.SArray` in the local machine's default browser or inside an
IPython Notebook. To launch GraphLab Canvas and generate views of these data
structures, simply call `.show()` on a supported GraphLab data structure.
Subsequent calls of `.show()` will update the GraphLab Canvas session.

Details on the use of GraphLab Canvas with GraphLab data structures are
provided below. In addition to the API documentation, please see the data
science `Gallery <http://www.graphlab.com/learn/gallery>`_, `How-tos
<http://www.graphlab.com/learn/gallery>`_, and the `visualization chapter of
the User Guide
<http://www.graphlab.com/learn/userguide/index.html#Working_with_data_Visualization>`_
for more details and extended examples.


**Resuming Graphlab Canvas after ending browser session**

The Graphlab Canvas session is hosted by the GraphLab Create Python session.
While the GraphLab Create Python session is active you can re-launch GraphLab
Canvas and resume its prior state. 

>>> gl.canvas.show()

**Using Graphlab Canvas with IPython notebook**

GraphLab Canvas `.show()` methods can be used in IPython notebook.  By default,
`.show()` will launch GraphLab Canvas in the browser. Optionally, you can
output a single GraphLab Canvas view to an IPython Notebook cell using the
:method:`~graphlab.canvas.set_target` method, as follows:

>>> gl.canvas.set_target('ipynb')

In the same session, you can set the output to the browser using

>>> gl.canvas.set_target('browser')
"""

from graphlab.canvas.utils import set_target
from graphlab.canvas.utils import get_target
from graphlab.canvas.utils import show
from graphlab.canvas.utils import _get_id
from graphlab.canvas.utils import _same_object
