from graphlab.canvas.views.bivariate import BivariateView as _bivariate
import graphlab as gl
import math
import time
import threading
import re

class ScatterPlot(_bivariate):

    def __init__(self, obj, params):
        # x is the name of the column in the X axis
        # y is the name of the column in the Y axis
        super(ScatterPlot, self).__init__(obj, params)
        self.col1 = self.get_numeric_column('x')
        self.col2 = self.get_numeric_column('y', self.col1)

    def __get_values(self):
        #making the array of dictionary of points
        # dropna first so we don't get null values shown
        obj = self.obj.dropna(columns=list(set([self.col1, self.col2])))
        xList = list(obj[self.col1])
        yList = list(obj[self.col2])
        valArray = []
        for i in range(0, len(xList)):
            valArray.append({'x': xList[i], 'y': yList[i]})
        return valArray

    def _get_values(self, url, handler):
        data = []
        if self.col1 is not None and self.col2 is not None:
            data = self.__get_values()
        handler.write({'data': data})

    def __get_sketchvalues(self):
        if self.col1 is None or \
           self.col2 is None:
           return {}
        #maxes and mins
        xMin = float(self.obj[self.col1].min())
        xMax = float(self.obj[self.col1].max())
        yMin = float(self.obj[self.col2].min())
        yMax = float(self.obj[self.col2].max())
        return {
            'minX': xMin,
            'minY': yMin,
            'maxX': xMax,
            'maxY': yMax
        }

    def _get_sketchvalues(self, url, handler):
        handler.write(self.__get_sketchvalues())

    def __get_coefficients(self):
        #cannot run regression if the columsn are the same!
        if self.col1 == self.col2 or \
           self.col1 is None or \
           self.col2 is None:
            return {}

        #running linear regression to get the coefficients
        # dropna to make sure we don't try to run with None values
        model = gl.linear_regression.create(self.obj.dropna(columns=[self.col1, self.col2]), target = self.col2, features = [self.col1], l2_penalty = 0)
        #writting the coefficients as m and b values (because y = mx+b)
        coefficients = model.get('coefficients')['value']
        b = coefficients[0]
        m = coefficients[1]
        return {'b':b, 'm':m}

    def _get_coefficients(self, url, handler):
        handler.write(self.__get_coefficients())

    def get_staticdata(self):
        return {
            'pointsList': self.__get_values(),
            'extrema': self.__get_sketchvalues(),
            'coefficients': self.__get_coefficients()
        }

