"use strict";define("plot_bar",["react","d3","jquery","common_controls","common_util"],function(React,d3,jQuery,Controls,Util){var FRAME_PADDING=75;var TICK_WIDTH=10;var TICK_HEIGHT=10;var PADDING_FRACTION=.25;var BAR_SPACING=5;var formatLabels=function(num){if(d3.format(".3g")(num).length>7)return d3.format(".1g")(num);else return d3.format(".3g")(num)};var abbreviateLabel=function(numRows,string){if(numRows>10){return""}if(string.length>8){string=string.substring(0,6);string=string.concat("...")}return string};var BarRenderer=React.createClass({displayName:"BarRenderer",render:function(){var xScale=this.props.xScale;var yScale=this.props.yScale;var width=this.props.width;var height=this.props.height;var barData=this.props.barData;var bars=[];for(var i=0;i<barData.length;i++){var minVal=yScale.domain()[0];var maxVal=yScale.domain()[1];var xVal=FRAME_PADDING+xScale(i);var barTooltip=barData[i].name+": "+barData[i].value;if(minVal>=0){bars.push(React.DOM.rect({className:"canvas-bar-barRect",x:xVal,y:yScale(barData[i].value)+FRAME_PADDING,width:width/barData.length,height:yScale(minVal)-yScale(barData[i].value),key:i},React.DOM.title(null," ",barTooltip," ")))}else if(maxVal<=0){bars.push(React.DOM.rect({className:"canvas-bar-barRect",x:xVal,y:FRAME_PADDING,width:width/barData.length,height:yScale(barData[i].value),key:i},React.DOM.title(null," ",barTooltip," ")))}else if(barData[i].value>=0){bars.push(React.DOM.rect({className:"canvas-bar-barRect",x:xVal,y:yScale(barData[i].value)+FRAME_PADDING,width:width/barData.length,height:yScale(0)-yScale(barData[i].value),key:i},React.DOM.title(null," ",barTooltip," ")))}else{bars.push(React.DOM.rect({className:"canvas-bar-barRect",x:xVal,y:yScale(0)+FRAME_PADDING,width:width/barData.length,height:yScale(barData[i].value)-yScale(0),key:i},React.DOM.title(null," ",barTooltip," ")))}}return React.DOM.g(null,bars)}});var LabelRenderer=React.createClass({displayName:"LabelRenderer",render:function(){var width=this.props.width/this.props.barData.length;if(width<12){return React.DOM.div(null)}return React.DOM.div(null,this.props.barData.map(function(bar,idx){return React.DOM.div({style:{position:"absolute",top:this.props.height+FRAME_PADDING*1.35-12,left:FRAME_PADDING+this.props.xScale(idx),width:width,fontSize:10,color:"#4b4b4b",textAlign:"center",textOverflow:"ellipsis",overflow:"hidden",whiteSpace:"nowrap",paddingLeft:3,paddingRight:3}},bar.name)}.bind(this)))}});var AxisRenderer=React.createClass({displayName:"AxisRenderer",render:function(){var xScale=this.props.xScale;var yScale=this.props.yScale;var width=this.props.width;var height=this.props.height;var gridlinesVisible=this.props.gridlinesVisible;var barData=this.props.barData;var axisYVal=yScale(0);if(axisYVal<0){axisYVal=0}else if(axisYVal>height){axisYVal=height}axisYVal+=FRAME_PADDING;var gridlineVisibility=gridlinesVisible?"visible":"hidden";var xLinesAndLabels=[];for(var i=0;i<barData.length;i++){xLinesAndLabels.push(React.DOM.line({key:i,className:"canvas-bar-ticks",x1:FRAME_PADDING+xScale(i)+width/barData.length/2,x2:FRAME_PADDING+xScale(i)+width/barData.length/2,y1:height+FRAME_PADDING+TICK_HEIGHT/2,y2:height+FRAME_PADDING-TICK_HEIGHT/2},React.DOM.title(null,barData[i].name)))}var yLinesAndLabels=yScale.ticks().map(function(yValue,idx){return React.DOM.g({key:"Yg-"+idx},React.DOM.line({className:"canvas-bar-gridlines",x1:FRAME_PADDING,x2:width+FRAME_PADDING,y1:yScale(yValue)+FRAME_PADDING,y2:yScale(yValue)+FRAME_PADDING,key:"Ygridline-"+yValue,style:{visibility:gridlineVisibility}}),React.DOM.line({className:"canvas-bar-ticks",x1:FRAME_PADDING-TICK_WIDTH/2,x2:FRAME_PADDING+TICK_WIDTH/2,y1:yScale(yValue)+FRAME_PADDING,y2:yScale(yValue)+FRAME_PADDING,key:"Yticks-"+yValue}),React.DOM.text({className:"canvas-bar-numLabel",x:FRAME_PADDING/1.75,y:yScale(yValue)+FRAME_PADDING+4,key:"YnumLabel-"+yValue},formatLabels(yValue)))});return React.DOM.g(null,xLinesAndLabels,yLinesAndLabels,React.DOM.line({className:"canvas-bar-axes",x1:FRAME_PADDING,y1:axisYVal,x2:width+FRAME_PADDING,y2:axisYVal}),React.DOM.line({className:"canvas-bar-axes",x1:FRAME_PADDING,y1:FRAME_PADDING,x2:FRAME_PADDING,y2:height+FRAME_PADDING}))}});var AxisLabel=React.createClass({displayName:"AxisLabel",handleClick:function(evt){var selected_column=[this.props.plotName,this.props.name];this.props.selectVariable(selected_column)},render:function(){var link=this.props.ipython?this.props.name:React.DOM.a({href:"javascript:",onClick:this.handleClick},this.props.name);return React.DOM.span({className:"canvas-scatter-axesLabel",style:{position:"absolute",top:""+this.props.y+"px",left:""+this.props.x+"px",width:""+this.props.width+"px"}},link)}});return{Bar:React.createClass({displayName:"Bar",getDefaultProps:function(){return{width:500,height:500,barData:[],extrema:{min:0,max:10},catLabel:"",numLabel:""}},getInitialState:function(){return{gridlinesVisible:true,sortedBars:false,barsToDisplay:this.props.barData}},padExtrema:function(extrema){var originalDomain=extrema.max-extrema.min;var paddedExtrema={};paddedExtrema.min=extrema.min-PADDING_FRACTION*originalDomain;paddedExtrema.max=extrema.max+PADDING_FRACTION*originalDomain;if(extrema.min>=0&&paddedExtrema.min<0)paddedExtrema.min=0;if(extrema.max<=0&&paddedExtrema.max>0)paddedExtrema.max=0;return paddedExtrema},toggleGridlines:function(){this.setState({gridlinesVisible:!this.state.gridlinesVisible})},toggleSortedBars:function(){if(this.state.sortedBars){this.setState({barsToDisplay:this.props.barData})}else{var tempBars=$.extend(true,[],this.props.barData);tempBars.sort(function(bar1,bar2){return bar1.value-bar2.value});this.setState({barsToDisplay:tempBars})}this.setState({sortedBars:!this.state.sortedBars})},componentWillReceiveProps:function(nextProps){this.setState({barsToDisplay:nextProps.barData})},render:function(){var newExtrema=this.padExtrema(this.props.extrema);var min=newExtrema.min;var max=newExtrema.max;var xScale=d3.scale.linear().domain([0,this.props.barData.length]).range([0,this.props.width]);var yScale=d3.scale.linear().domain([min,max]).range([this.props.height,0]);return React.DOM.div({className:"canvas-bar-frame",style:{position:"relative"}},LabelRenderer({xScale:xScale,barData:this.state.barsToDisplay,height:this.props.height,width:this.props.width}),React.DOM.svg({className:"canvas-bar-svgFrame",width:this.props.width+2*FRAME_PADDING,height:this.props.height+2*FRAME_PADDING},React.DOM.rect({className:"canvas-bar-rectFrame",width:this.props.width,height:this.props.height,x:FRAME_PADDING,y:FRAME_PADDING}),AxisRenderer({xScale:xScale,yScale:yScale,width:this.props.width,height:this.props.height,barData:this.state.barsToDisplay,gridlinesVisible:this.state.gridlinesVisible}),BarRenderer({xScale:xScale,yScale:yScale,width:this.props.width,height:this.props.height,barData:this.state.barsToDisplay})),React.DOM.input({className:"canvas-bar-toggleButton",type:"checkbox",name:"gridlineToggle",onClick:this.toggleGridlines,style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING-25)/2+"px",left:""+(this.props.width+1.5*FRAME_PADDING)+"px"}},React.DOM.p({className:"canvas-bar-toggleLabel",style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING-25)/2+"px",left:""+(this.props.width+1.75*FRAME_PADDING)+"px"}},"Toggle gridlines")),React.DOM.input({className:"canvas-bar-toggleButton",type:"checkbox",name:"sortedBarsToggle",onClick:this.toggleSortedBars,style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING+25)/2+"px",left:""+(this.props.width+1.5*FRAME_PADDING)+"px"}},React.DOM.p({className:"canvas-bar-toggleLabel",style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING+25)/2+"px",left:""+(this.props.width+1.75*FRAME_PADDING)+"px"}},"Toggle bar sorting")),[{name:this.props.catLabel,x:FRAME_PADDING,y:this.props.height+FRAME_PADDING*1.5,width:this.props.width},{name:this.props.numLabel,x:0,y:FRAME_PADDING/2.5,width:"auto"}].map(function(axis,idx){return AxisLabel({key:idx,name:axis.name,selectVariable:this.props.selectVariable,plotName:this.props.plotName,x:axis.x,y:axis.y,width:axis.width,ipython:this.props.ipython})}.bind(this)))}})}});