from imputil import _os_bootstrap
import os as _os
import argparse
import tempfile as _tempfile

from graphlab.deploy._job import Job as Job
from graphlab.deploy._artifact import Task as Task

def hadoop_setup(path, job, memory):
    import graphlab
    import shutil as _shutil
    #TODO log nicely
    #check args
    #write product key to file in tmp dir
    pk = graphlab.product_key.get_product_key()
    pk_file = str(_os.path.join(path, "product_key"))

    with open(pk_file, "w") as pkf:
        pkf.write("[Product]\n")
        pkf.write("product_key=%s\n" % pk )
        
    #use task serialize
    task_dir = _tempfile.mkdtemp(prefix='graphlab-async-')
    task_path = _os.path.join(task_dir, job.name)
    #print "task_path=%s" % task_path
    full_task_path= task_path + ".zip"
    #print "full_task_path= %s" % full_task_path
    job._serialize(full_task_path)

    # write this file to tmpdir
    wrapper = _os.path.realpath(__file__)
    # HACK to replace .pyc with .py
    if wrapper.endswith('.pyc'):
        wrapper = wrapper.replace('.pyc', '.py')

    loc = _os.path.join(path, _os.path.basename(wrapper))
    _shutil.copy(wrapper, loc)

    cmd_args = dict()
    cmd_args['product_key'] = pk_file
    cmd_args['python_script'] = str(loc)
    cmd_args['resource_dir'] = path
    cmd_args['appname'] = str("GraphLab_Deploys")
    cmd_args['container_memory'] = memory
    cmd_args['task_zip'] = full_task_path

    return cmd_args


def do_work(args):
    directory_ = args['directory']
    print "directory=%s" % directory_

    task_location = args['task_file']
    print "task_file=%s" % task_location
    
    # load task from pickled file, use regular pickle
    try:
        d = _os.path.dirname(_os.path.abspath(__file__))

        exec_dir = _os.mkdir(_os.path.join(d, 'gl_art-'))
        print "exec_dir=%s" % exec_dir
        metrics = {}
        path = _os.path.dirname(task_location)
        
        with open(task_location, 'rb') as task_file:
            task = _pickle.load(task_file)
        runner = _LocalExecutionEnvironment()

        if isinstance(task, Task):
            print "Running task: %s" % task.name
            runner.run_task(task, metrics=metrics, location=exec_dir)
        elif isinstance(task, Job):
            print "Running job: %s" % task.name
            runner.run_job(task, None)
        else:
            print "Unknown type of work, failing."
            exit(1)

        # write out task metrics to file, so session process can incorporate into client task
        with open(_os.path.join(path, 'metrics'), 'w') as f:
            f.writelines(str(metrics))

        #task = None
        # with open(task_location, 'rb') as task_file:
        #     task = _pickle.load(task_file)
        # session = Session(d)


        #print "Running task: %s " % task

        # call local_environment.run
        #le = execenv.LocalExecutionEnvironment()
        #le.run_stage(session, stage)
    except Exception as e:
        print "Exception: %s" % e
        exit(1)



if __name__ == '__main__':
    # This code is run from the Hadoop Node when executing. It simply creates a Local Environment for
    # execution and then runs the Job locally.

    import pickle as _pickle
    from graphlab.deploy._executionenvironment import LocalExecutionEnvironment as _LocalExecutionEnvironment


    # get args
    arrg = argparse.ArgumentParser(description="execute a graphlab job on a hadoop node",
                                   formatter_class=argparse.RawTextHelpFormatter)
    subparsers = arrg.add_subparsers(help='option help')
    artifact_subparser = subparsers.add_parser('artifact', help='running artifacts')
    artifact_subparser.add_argument('-d', '--directory', help = 'directory the current step is in', required=True)
    artifact_subparser.add_argument('-t', '--task_file', help = 'task file in that directory')

    artifact_subparser.set_defaults(func=do_work)

    args = arrg.parse_args()
    args.func(vars(args))


