/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass2;

import net.sourceforge.cobertura.instrument.TouchPointListener;
import net.sourceforge.cobertura.instrument.tp.ClassMap;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;

public class BuildClassMapTouchPointListener
implements TouchPointListener {
    private final ClassMap classmap;

    public BuildClassMapTouchPointListener(ClassMap classMap) {
        this.classmap = classMap;
    }

    public void beforeJump(int eventId, Label label, int currentLine, MethodVisitor nextMethodVisitor) {
        this.classmap.registerNewJump(eventId, currentLine, label);
    }

    public void beforeLabel(int eventId, Label label, int currentLine, MethodVisitor mv) {
        this.classmap.registerNewLabel(eventId, currentLine, label);
    }

    public void afterLineNumber(int eventId, Label label, int currentLine, MethodVisitor nextMethodVisitor, String methodName, String methodSignature) {
        this.classmap.registerLineNumber(eventId, currentLine, label, methodName, methodSignature);
    }

    public void beforeSwitch(int eventId, Label def, Label[] labels, int currentLine, MethodVisitor mv, String conditionType) {
        this.classmap.registerSwitch(eventId, currentLine, def, labels, conditionType);
    }

    public void ignoreLine(int eventId, int currentLine) {
        this.classmap.unregisterLine(eventId, currentLine);
    }

    public void afterJump(int eventId, Label label, int currentLine, MethodVisitor nextMethodVisitor) {
    }

    public void afterLabel(int eventId, Label label, int currentLine, MethodVisitor mv) {
    }

    public void afterMethodStart(MethodVisitor nextMethodVisitor) {
    }
}

