/*
 * Decompiled with CFR 0.152.
 */
package org.graphlab.hadoop.yarn.applications;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.ContainerState;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.NodeReport;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.async.AMRMClientAsync;
import org.apache.hadoop.yarn.client.api.async.NMClientAsync;
import org.apache.hadoop.yarn.client.api.async.impl.NMClientAsyncImpl;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.security.AMRMTokenIdentifier;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.graphlab.hadoop.yarn.applications.Log4jPropertyHelper;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class ApplicationMaster {
    public static final transient int[] __cobertura_counters;
    private static final Log LOG;
    private Configuration conf;
    private AMRMClientAsync amRMClient;
    private NMClientAsync nmClientAsync;
    private NMCallbackHandler containerListener;
    private ApplicationAttemptId appAttemptID;
    private String appMasterHostname;
    private int appMasterRpcPort;
    private String appMasterTrackingUrl;
    private int numTotalContainers;
    private int containerMemory;
    private int containerVirtualCores;
    private int requestPriority;
    private String glBasePath;
    private String glBaseTimestamp;
    private String glBaseLength;
    private String glUserPath;
    private String glUserTimestamp;
    private String glUserLength;
    private boolean includeUserDeps;
    private String glResourcePath;
    private String glResourceTimestamp;
    private String glResourceLength;
    private boolean includeResources;
    private String glUserPythonScript;
    private String glUserPythonScriptTimestamp;
    private String glUserPythonScriptLength;
    private String glUserPythonScriptArgs;
    private String glProductKeyPath;
    private String glProductKeyTimestamp;
    private String glProductKeyLength;
    private String taskPath;
    long taskTimestamp;
    long taskLength;
    private boolean is_gl_native;
    private boolean use_cache;
    private String cacheDir;
    private String glInstallType;
    private AtomicInteger numCompletedContainers;
    private AtomicInteger numAllocatedContainers;
    private AtomicInteger numFailedContainers;
    private AtomicInteger numRequestedContainers;
    private AtomicInteger totalContainersInStage;
    private AtomicInteger totalAllocatedContainersInStage;
    private AtomicInteger totalRequestedThisStage;
    private AtomicInteger totalCompletedThisStage;
    private AtomicInteger totalFailedThisStage;
    private AtomicInteger totalFailedAllStages;
    private AtomicInteger currentTaskPosition;
    private File[] tasksInStgDir;
    private String stageDir;
    private AtomicInteger numStages;
    private AtomicInteger currentStage;
    private String shellCommand;
    private String shellArgs;
    private Map<String, String> shellEnv;
    private String shellScriptPath;
    private String resourceDir;
    private static final String ExecShellStringPath = "ExecShellScript.py";
    private static final String ExecBatScripStringtPath = "ExecBatScript.bat";
    private static final String log4jPath = "log4j.properties";
    private volatile boolean done;
    private volatile boolean success;
    private volatile boolean stageDone;
    private ByteBuffer allTokens;
    private List<Thread> launchThreads;
    private List<Thread> stageLaunchedThreads;

    public static void main(String[] stringArray) {
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[77] = __cobertura_counters[77] + 1;
        boolean result = false;
        try {
            String[] args;
            __cobertura_counters[78] = __cobertura_counters[78] + 1;
            ApplicationMaster appMaster = new ApplicationMaster();
            __cobertura_counters[79] = __cobertura_counters[79] + 1;
            System.out.println("Initializing ApplicationMaster");
            __cobertura_counters[80] = __cobertura_counters[80] + 1;
            boolean doRun = appMaster.init(args);
            __cobertura_counters[81] = __cobertura_counters[81] + 1;
            n = 83;
            if (!doRun) {
                __cobertura_counters[82] = __cobertura_counters[82] + 1;
                n = 0;
                __cobertura_counters[84] = __cobertura_counters[84] + 1;
                System.exit(0);
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[85] = __cobertura_counters[85] + 1;
            result = appMaster.run();
        }
        catch (Throwable throwable) {
            __cobertura_counters[86] = __cobertura_counters[86] + 1;
            Throwable t = throwable;
            __cobertura_counters[87] = __cobertura_counters[87] + 1;
            LOG.fatal((Object)"Error running ApplicationMaster", t);
            __cobertura_counters[88] = __cobertura_counters[88] + 1;
            System.exit(1);
        }
        __cobertura_counters[89] = __cobertura_counters[89] + 1;
        __cobertura_counters[90] = __cobertura_counters[90] + 1;
        n = 92;
        if (result) {
            __cobertura_counters[91] = __cobertura_counters[91] + 1;
            n = 0;
            __cobertura_counters[93] = __cobertura_counters[93] + 1;
            System.out.println("Application Master completed successfully. exiting");
            __cobertura_counters[94] = __cobertura_counters[94] + 1;
            System.exit(0);
        } else {
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[95] = __cobertura_counters[95] + 1;
            System.out.println("Application Master failed. exiting");
            __cobertura_counters[96] = __cobertura_counters[96] + 1;
            System.exit(2);
        }
        __cobertura_counters[97] = __cobertura_counters[97] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpOutDebugInfo() {
        int n;
        int n2 = 0;
        __cobertura_counters[98] = __cobertura_counters[98] + 1;
        System.out.println("Dump debug output");
        __cobertura_counters[99] = __cobertura_counters[99] + 1;
        Map<String, String> envs = System.getenv();
        __cobertura_counters[100] = __cobertura_counters[100] + 1;
        Iterator<Map.Entry<String, String>> i$ = envs.entrySet().iterator();
        while (true) {
            n2 = 102;
            if (!i$.hasNext()) break;
            __cobertura_counters[101] = __cobertura_counters[101] + 1;
            n2 = 0;
            Map.Entry<String, String> env = i$.next();
            __cobertura_counters[103] = __cobertura_counters[103] + 1;
            System.out.println("System env: key=" + env.getKey() + ", val=" + env.getValue());
            __cobertura_counters[104] = __cobertura_counters[104] + 1;
        }
        int n3 = n2;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n2 = 0;
        __cobertura_counters[105] = __cobertura_counters[105] + 1;
        BufferedReader buf = null;
        try {
            String string;
            __cobertura_counters[106] = __cobertura_counters[106] + 1;
            n2 = 108;
            if (Shell.WINDOWS) {
                __cobertura_counters[107] = __cobertura_counters[107] + 1;
                n2 = 0;
                string = Shell.execCommand((String[])new String[]{"cmd", "/c", "dir"});
            } else {
                int n4 = n2;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n2 = 0;
                string = Shell.execCommand((String[])new String[]{"ls", "-al"});
            }
            String lines = string;
            __cobertura_counters[109] = __cobertura_counters[109] + 1;
            buf = new BufferedReader(new StringReader(lines));
            __cobertura_counters[110] = __cobertura_counters[110] + 1;
            String line = "";
            while (true) {
                __cobertura_counters[111] = __cobertura_counters[111] + 1;
                line = buf.readLine();
                n2 = 113;
                if (line == null) break;
                __cobertura_counters[112] = __cobertura_counters[112] + 1;
                n2 = 0;
                __cobertura_counters[114] = __cobertura_counters[114] + 1;
                System.out.println("System CWD content: " + line);
                __cobertura_counters[115] = __cobertura_counters[115] + 1;
                System.out.println("System CWD content: " + line);
            }
            n = n2;
        }
        catch (IOException iOException) {
            try {
                __cobertura_counters[116] = __cobertura_counters[116] + 1;
                IOException e = iOException;
                __cobertura_counters[117] = __cobertura_counters[117] + 1;
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                __cobertura_counters[118] = __cobertura_counters[118] + 1;
                Throwable throwable2 = throwable;
                org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
                throw throwable2;
            }
            __cobertura_counters[118] = __cobertura_counters[118] + 1;
            org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
            __cobertura_counters[120] = __cobertura_counters[120] + 1;
        }
        __cobertura_counters[n] = __cobertura_counters[n] + 1;
        n2 = 0;
        __cobertura_counters[118] = __cobertura_counters[118] + 1;
        org.apache.hadoop.io.IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{buf});
        __cobertura_counters[119] = __cobertura_counters[119] + 1;
        __cobertura_counters[121] = __cobertura_counters[121] + 1;
    }

    public ApplicationMaster() {
        int n = 0;
        __cobertura_counters[122] = __cobertura_counters[122] + 1;
        __cobertura_counters[44] = __cobertura_counters[44] + 1;
        this.appMasterHostname = "";
        __cobertura_counters[45] = __cobertura_counters[45] + 1;
        this.appMasterRpcPort = -1;
        __cobertura_counters[46] = __cobertura_counters[46] + 1;
        this.appMasterTrackingUrl = "";
        __cobertura_counters[47] = __cobertura_counters[47] + 1;
        this.numTotalContainers = 1;
        __cobertura_counters[48] = __cobertura_counters[48] + 1;
        this.containerMemory = 10;
        __cobertura_counters[49] = __cobertura_counters[49] + 1;
        this.containerVirtualCores = 1;
        __cobertura_counters[50] = __cobertura_counters[50] + 1;
        this.includeUserDeps = false;
        __cobertura_counters[51] = __cobertura_counters[51] + 1;
        this.includeResources = false;
        __cobertura_counters[52] = __cobertura_counters[52] + 1;
        this.glUserPythonScriptArgs = null;
        __cobertura_counters[53] = __cobertura_counters[53] + 1;
        this.is_gl_native = false;
        __cobertura_counters[54] = __cobertura_counters[54] + 1;
        this.use_cache = false;
        __cobertura_counters[55] = __cobertura_counters[55] + 1;
        this.cacheDir = "";
        __cobertura_counters[56] = __cobertura_counters[56] + 1;
        this.numCompletedContainers = new AtomicInteger();
        __cobertura_counters[57] = __cobertura_counters[57] + 1;
        this.numAllocatedContainers = new AtomicInteger();
        __cobertura_counters[58] = __cobertura_counters[58] + 1;
        this.numFailedContainers = new AtomicInteger();
        __cobertura_counters[59] = __cobertura_counters[59] + 1;
        this.numRequestedContainers = new AtomicInteger();
        __cobertura_counters[60] = __cobertura_counters[60] + 1;
        this.totalContainersInStage = new AtomicInteger();
        __cobertura_counters[61] = __cobertura_counters[61] + 1;
        this.totalAllocatedContainersInStage = new AtomicInteger();
        __cobertura_counters[62] = __cobertura_counters[62] + 1;
        this.totalRequestedThisStage = new AtomicInteger();
        __cobertura_counters[63] = __cobertura_counters[63] + 1;
        this.totalCompletedThisStage = new AtomicInteger();
        __cobertura_counters[64] = __cobertura_counters[64] + 1;
        this.totalFailedThisStage = new AtomicInteger();
        __cobertura_counters[65] = __cobertura_counters[65] + 1;
        this.totalFailedAllStages = new AtomicInteger(0);
        __cobertura_counters[66] = __cobertura_counters[66] + 1;
        this.currentTaskPosition = new AtomicInteger(0);
        __cobertura_counters[67] = __cobertura_counters[67] + 1;
        this.stageDir = null;
        __cobertura_counters[68] = __cobertura_counters[68] + 1;
        this.numStages = new AtomicInteger(0);
        __cobertura_counters[69] = __cobertura_counters[69] + 1;
        this.currentStage = new AtomicInteger(0);
        __cobertura_counters[70] = __cobertura_counters[70] + 1;
        this.shellCommand = "";
        __cobertura_counters[71] = __cobertura_counters[71] + 1;
        this.shellArgs = "";
        __cobertura_counters[72] = __cobertura_counters[72] + 1;
        this.shellEnv = new HashMap<String, String>();
        __cobertura_counters[73] = __cobertura_counters[73] + 1;
        this.shellScriptPath = "";
        __cobertura_counters[74] = __cobertura_counters[74] + 1;
        this.resourceDir = "";
        __cobertura_counters[75] = __cobertura_counters[75] + 1;
        this.launchThreads = new ArrayList<Thread>();
        __cobertura_counters[76] = __cobertura_counters[76] + 1;
        this.stageLaunchedThreads = new ArrayList<Thread>();
        __cobertura_counters[123] = __cobertura_counters[123] + 1;
        this.conf = new YarnConfiguration();
        __cobertura_counters[124] = __cobertura_counters[124] + 1;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean init(String[] stringArray) throws ParseException, IOException {
        CommandLine cliParser;
        int n;
        block43: {
            block42: {
                Options opts;
                block41: {
                    void args;
                    n = 0;
                    __cobertura_counters[125] = __cobertura_counters[125] + 1;
                    opts = new Options();
                    __cobertura_counters[126] = __cobertura_counters[126] + 1;
                    opts.addOption("app_attempt_id", true, "App Attempt ID. Not to be used unless for testing purposes");
                    __cobertura_counters[127] = __cobertura_counters[127] + 1;
                    opts.addOption("shell_env", true, "Environment for shell script. Specified as env_key=env_val pairs");
                    __cobertura_counters[128] = __cobertura_counters[128] + 1;
                    opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the shell command");
                    __cobertura_counters[129] = __cobertura_counters[129] + 1;
                    opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the shell command");
                    __cobertura_counters[130] = __cobertura_counters[130] + 1;
                    opts.addOption("num_containers", true, "No. of containers on which the shell command needs to be executed");
                    __cobertura_counters[131] = __cobertura_counters[131] + 1;
                    opts.addOption("priority", true, "Application Priority. Default 0");
                    __cobertura_counters[132] = __cobertura_counters[132] + 1;
                    opts.addOption("debug", false, "Dump out debug information");
                    __cobertura_counters[133] = __cobertura_counters[133] + 1;
                    opts.addOption("help", false, "Print usage");
                    __cobertura_counters[134] = __cobertura_counters[134] + 1;
                    cliParser = new GnuParser().parse(opts, (String[])args);
                    __cobertura_counters[135] = __cobertura_counters[135] + 1;
                    n = 137;
                    if (((void)args).length == 0) {
                        __cobertura_counters[136] = __cobertura_counters[136] + 1;
                        n = 0;
                        __cobertura_counters[138] = __cobertura_counters[138] + 1;
                        this.printUsage(opts);
                        __cobertura_counters[139] = __cobertura_counters[139] + 1;
                        throw new IllegalArgumentException("No args specified for application master to initialize");
                    }
                    int n2 = n;
                    __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                    n = 0;
                    __cobertura_counters[140] = __cobertura_counters[140] + 1;
                    n = 142;
                    if (this.fileExist(log4jPath)) {
                        __cobertura_counters[141] = __cobertura_counters[141] + 1;
                        n = 0;
                        try {
                            __cobertura_counters[143] = __cobertura_counters[143] + 1;
                            Log4jPropertyHelper.updateLog4jConfiguration(ApplicationMaster.class, log4jPath);
                        }
                        catch (Exception exception) {
                            __cobertura_counters[144] = __cobertura_counters[144] + 1;
                            Exception e = exception;
                            __cobertura_counters[145] = __cobertura_counters[145] + 1;
                            LOG.warn((Object)("Can not set up custom log4j properties. " + e));
                            break block41;
                        }
                        __cobertura_counters[146] = __cobertura_counters[146] + 1;
                    }
                }
                int n3 = n;
                __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                n = 0;
                __cobertura_counters[147] = __cobertura_counters[147] + 1;
                n = 149;
                if (cliParser.hasOption("help")) {
                    __cobertura_counters[148] = __cobertura_counters[148] + 1;
                    n = 0;
                    __cobertura_counters[150] = __cobertura_counters[150] + 1;
                    this.printUsage(opts);
                    __cobertura_counters[151] = __cobertura_counters[151] + 1;
                    return false;
                }
                int n4 = n;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n = 0;
                __cobertura_counters[152] = __cobertura_counters[152] + 1;
                n = 154;
                if (cliParser.hasOption("debug")) {
                    __cobertura_counters[153] = __cobertura_counters[153] + 1;
                    n = 0;
                    __cobertura_counters[155] = __cobertura_counters[155] + 1;
                    this.dumpOutDebugInfo();
                }
                int n5 = n;
                __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                n = 0;
                __cobertura_counters[156] = __cobertura_counters[156] + 1;
                Map<String, String> envs = System.getenv();
                __cobertura_counters[157] = __cobertura_counters[157] + 1;
                n = 159;
                if (!envs.containsKey(ApplicationConstants.Environment.CONTAINER_ID.name())) {
                    __cobertura_counters[158] = __cobertura_counters[158] + 1;
                    n = 0;
                    __cobertura_counters[160] = __cobertura_counters[160] + 1;
                    n = 162;
                    if (!cliParser.hasOption("app_attempt_id")) {
                        int n6 = n;
                        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                        n = 0;
                        __cobertura_counters[166] = __cobertura_counters[166] + 1;
                        throw new IllegalArgumentException("Application Attempt Id not set in the environment");
                    }
                    __cobertura_counters[161] = __cobertura_counters[161] + 1;
                    n = 0;
                    __cobertura_counters[163] = __cobertura_counters[163] + 1;
                    String appIdStr = cliParser.getOptionValue("app_attempt_id", "");
                    __cobertura_counters[164] = __cobertura_counters[164] + 1;
                    this.appAttemptID = ConverterUtils.toApplicationAttemptId((String)appIdStr);
                    __cobertura_counters[165] = __cobertura_counters[165] + 1;
                } else {
                    int n7 = n;
                    __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                    n = 0;
                    __cobertura_counters[167] = __cobertura_counters[167] + 1;
                    ContainerId containerId = ConverterUtils.toContainerId((String)envs.get(ApplicationConstants.Environment.CONTAINER_ID.name()));
                    __cobertura_counters[168] = __cobertura_counters[168] + 1;
                    this.appAttemptID = containerId.getApplicationAttemptId();
                }
                __cobertura_counters[169] = __cobertura_counters[169] + 1;
                n = 171;
                if (!envs.containsKey("APP_SUBMIT_TIME_ENV")) {
                    __cobertura_counters[170] = __cobertura_counters[170] + 1;
                    n = 0;
                    __cobertura_counters[172] = __cobertura_counters[172] + 1;
                    throw new RuntimeException("APP_SUBMIT_TIME_ENV not set in the environment");
                }
                int n8 = n;
                __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                n = 0;
                __cobertura_counters[173] = __cobertura_counters[173] + 1;
                n = 175;
                if (!envs.containsKey(ApplicationConstants.Environment.NM_HOST.name())) {
                    __cobertura_counters[174] = __cobertura_counters[174] + 1;
                    n = 0;
                    __cobertura_counters[176] = __cobertura_counters[176] + 1;
                    throw new RuntimeException(ApplicationConstants.Environment.NM_HOST.name() + " not set in the environment");
                }
                int n9 = n;
                __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                n = 0;
                __cobertura_counters[177] = __cobertura_counters[177] + 1;
                n = 179;
                if (!envs.containsKey(ApplicationConstants.Environment.NM_HTTP_PORT.name())) {
                    __cobertura_counters[178] = __cobertura_counters[178] + 1;
                    n = 0;
                    __cobertura_counters[180] = __cobertura_counters[180] + 1;
                    throw new RuntimeException(ApplicationConstants.Environment.NM_HTTP_PORT + " not set in the environment");
                }
                int n10 = n;
                __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                n = 0;
                __cobertura_counters[181] = __cobertura_counters[181] + 1;
                n = 183;
                if (!envs.containsKey(ApplicationConstants.Environment.NM_PORT.name())) {
                    __cobertura_counters[182] = __cobertura_counters[182] + 1;
                    n = 0;
                    __cobertura_counters[184] = __cobertura_counters[184] + 1;
                    throw new RuntimeException(ApplicationConstants.Environment.NM_PORT.name() + " not set in the environment");
                }
                int n11 = n;
                __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                n = 0;
                __cobertura_counters[185] = __cobertura_counters[185] + 1;
                System.out.println("Application master for app, appId=" + this.appAttemptID.getApplicationId().getId() + ", clustertimestamp=" + this.appAttemptID.getApplicationId().getClusterTimestamp() + ", attemptId=" + this.appAttemptID.getAttemptId());
                __cobertura_counters[186] = __cobertura_counters[186] + 1;
                n = 188;
                if (cliParser.hasOption("shell_env")) {
                    __cobertura_counters[187] = __cobertura_counters[187] + 1;
                    n = 0;
                    __cobertura_counters[189] = __cobertura_counters[189] + 1;
                    String[] shellEnvs = cliParser.getOptionValues("shell_env");
                    __cobertura_counters[190] = __cobertura_counters[190] + 1;
                    String[] arr$ = shellEnvs;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        n = 192;
                        if (i$ >= len$) break;
                        __cobertura_counters[191] = __cobertura_counters[191] + 1;
                        n = 0;
                        String env = arr$[i$];
                        __cobertura_counters[194] = __cobertura_counters[194] + 1;
                        env = env.trim();
                        __cobertura_counters[195] = __cobertura_counters[195] + 1;
                        int index = env.indexOf(61);
                        __cobertura_counters[196] = __cobertura_counters[196] + 1;
                        n = 198;
                        if (index == -1) {
                            __cobertura_counters[197] = __cobertura_counters[197] + 1;
                            n = 0;
                            __cobertura_counters[199] = __cobertura_counters[199] + 1;
                            this.shellEnv.put(env, "");
                            __cobertura_counters[200] = __cobertura_counters[200] + 1;
                        } else {
                            int n12 = n;
                            __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
                            n = 0;
                            __cobertura_counters[201] = __cobertura_counters[201] + 1;
                            String key = env.substring(0, index);
                            __cobertura_counters[202] = __cobertura_counters[202] + 1;
                            String val = "";
                            __cobertura_counters[203] = __cobertura_counters[203] + 1;
                            n = 205;
                            if (index < env.length() - 1) {
                                __cobertura_counters[204] = __cobertura_counters[204] + 1;
                                n = 0;
                                __cobertura_counters[206] = __cobertura_counters[206] + 1;
                                val = env.substring(index + 1);
                            }
                            int n13 = n;
                            __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
                            n = 0;
                            __cobertura_counters[207] = __cobertura_counters[207] + 1;
                            this.shellEnv.put(key, val);
                        }
                        __cobertura_counters[193] = __cobertura_counters[193] + 1;
                        ++i$;
                    }
                }
                int n14 = n;
                __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
                n = 0;
                __cobertura_counters[208] = __cobertura_counters[208] + 1;
                n = 210;
                if (envs.containsKey("USE_CACHE")) {
                    __cobertura_counters[209] = __cobertura_counters[209] + 1;
                    n = 0;
                    __cobertura_counters[211] = __cobertura_counters[211] + 1;
                    this.use_cache = true;
                    __cobertura_counters[212] = __cobertura_counters[212] + 1;
                    this.cacheDir = "/tmp/GRAPHLAB_CACHE_VIRTENV";
                }
                int n15 = n;
                __cobertura_counters[n15] = __cobertura_counters[n15] + 1;
                n = 0;
                __cobertura_counters[213] = __cobertura_counters[213] + 1;
                n = 215;
                if (envs.containsKey("GL_SOURCE_TAR")) {
                    __cobertura_counters[214] = __cobertura_counters[214] + 1;
                    n = 0;
                    __cobertura_counters[216] = __cobertura_counters[216] + 1;
                    this.glBasePath = envs.get("GL_SOURCE_TAR");
                    __cobertura_counters[217] = __cobertura_counters[217] + 1;
                    n = 219;
                    if (envs.containsKey("GL_SOURCE_LEN")) {
                        __cobertura_counters[218] = __cobertura_counters[218] + 1;
                        n = 0;
                        __cobertura_counters[220] = __cobertura_counters[220] + 1;
                        this.glBaseLength = envs.get("GL_SOURCE_LEN");
                    }
                    int n16 = n;
                    __cobertura_counters[n16] = __cobertura_counters[n16] + 1;
                    n = 0;
                    __cobertura_counters[221] = __cobertura_counters[221] + 1;
                    n = 223;
                    if (envs.containsKey("GL_SOURCE_TIMESTAMP")) {
                        __cobertura_counters[222] = __cobertura_counters[222] + 1;
                        n = 0;
                        __cobertura_counters[224] = __cobertura_counters[224] + 1;
                        this.glBaseTimestamp = envs.get("GL_SOURCE_TIMESTAMP");
                    }
                }
                int n17 = n;
                __cobertura_counters[n17] = __cobertura_counters[n17] + 1;
                n = 0;
                __cobertura_counters[225] = __cobertura_counters[225] + 1;
                n = 227;
                if (envs.containsKey("GL_USER_RESOURCE_TAR")) {
                    __cobertura_counters[226] = __cobertura_counters[226] + 1;
                    n = 0;
                    n = 229;
                    if (!envs.get("GL_USER_RESOURCE_TAR").isEmpty()) {
                        __cobertura_counters[228] = __cobertura_counters[228] + 1;
                        n = 0;
                        __cobertura_counters[230] = __cobertura_counters[230] + 1;
                        this.includeResources = true;
                        __cobertura_counters[231] = __cobertura_counters[231] + 1;
                        this.glResourcePath = envs.get("GL_USER_RESOURCE_TAR");
                        __cobertura_counters[232] = __cobertura_counters[232] + 1;
                        n = 234;
                        if (envs.containsKey("GL_USER_RESOURCE_LENGTH")) {
                            __cobertura_counters[233] = __cobertura_counters[233] + 1;
                            n = 0;
                            __cobertura_counters[235] = __cobertura_counters[235] + 1;
                            this.glResourceLength = envs.get("GL_USER_RESOURCE_LENGTH");
                        }
                        int n18 = n;
                        __cobertura_counters[n18] = __cobertura_counters[n18] + 1;
                        n = 0;
                        __cobertura_counters[236] = __cobertura_counters[236] + 1;
                        n = 238;
                        if (envs.containsKey("GL_USER_RESOURCE_TIMESTAMP")) {
                            __cobertura_counters[237] = __cobertura_counters[237] + 1;
                            n = 0;
                            __cobertura_counters[239] = __cobertura_counters[239] + 1;
                            this.glResourceTimestamp = envs.get("GL_USER_RESOURCE_TIMESTAMP");
                        }
                    }
                }
                int n19 = n;
                __cobertura_counters[n19] = __cobertura_counters[n19] + 1;
                n = 0;
                __cobertura_counters[240] = __cobertura_counters[240] + 1;
                n = 242;
                if (envs.containsKey("GL_USER_REQS_TAR")) {
                    __cobertura_counters[241] = __cobertura_counters[241] + 1;
                    n = 0;
                    n = 244;
                    if (!envs.get("GL_USER_REQS_TAR").isEmpty()) {
                        __cobertura_counters[243] = __cobertura_counters[243] + 1;
                        n = 0;
                        __cobertura_counters[245] = __cobertura_counters[245] + 1;
                        this.includeUserDeps = true;
                        __cobertura_counters[246] = __cobertura_counters[246] + 1;
                        this.glUserPath = envs.get("GL_USER_REQS_TAR");
                        __cobertura_counters[247] = __cobertura_counters[247] + 1;
                        n = 249;
                        if (envs.containsKey("GL_USER_REQS_LENGTH")) {
                            __cobertura_counters[248] = __cobertura_counters[248] + 1;
                            n = 0;
                            __cobertura_counters[250] = __cobertura_counters[250] + 1;
                            this.glUserLength = envs.get("GL_USER_REQS_LENGTH");
                        }
                        int n20 = n;
                        __cobertura_counters[n20] = __cobertura_counters[n20] + 1;
                        n = 0;
                        __cobertura_counters[251] = __cobertura_counters[251] + 1;
                        n = 253;
                        if (envs.containsKey("GL_USER_REQS_TIMESTAMP")) {
                            __cobertura_counters[252] = __cobertura_counters[252] + 1;
                            n = 0;
                            __cobertura_counters[254] = __cobertura_counters[254] + 1;
                            this.glUserTimestamp = envs.get("GL_USER_REQS_TIMESTAMP");
                        }
                    }
                }
                int n21 = n;
                __cobertura_counters[n21] = __cobertura_counters[n21] + 1;
                n = 0;
                __cobertura_counters[255] = __cobertura_counters[255] + 1;
                n = 257;
                if (envs.containsKey("GL_USER_PYTHON_NAME")) {
                    __cobertura_counters[256] = __cobertura_counters[256] + 1;
                    n = 0;
                    __cobertura_counters[258] = __cobertura_counters[258] + 1;
                    this.glUserPythonScript = envs.get("GL_USER_PYTHON_NAME");
                }
                int n22 = n;
                __cobertura_counters[n22] = __cobertura_counters[n22] + 1;
                n = 0;
                __cobertura_counters[259] = __cobertura_counters[259] + 1;
                n = 261;
                if (envs.containsKey("GL_SOURCE_NATIVE")) {
                    __cobertura_counters[260] = __cobertura_counters[260] + 1;
                    n = 0;
                    __cobertura_counters[262] = __cobertura_counters[262] + 1;
                    this.glInstallType = envs.get("GL_SOURCE_NATIVE");
                    __cobertura_counters[263] = __cobertura_counters[263] + 1;
                    n = 265;
                    if (this.glInstallType.equals("native")) {
                        __cobertura_counters[264] = __cobertura_counters[264] + 1;
                        n = 0;
                        __cobertura_counters[266] = __cobertura_counters[266] + 1;
                        this.is_gl_native = true;
                    }
                }
                int n23 = n;
                __cobertura_counters[n23] = __cobertura_counters[n23] + 1;
                n = 0;
                __cobertura_counters[267] = __cobertura_counters[267] + 1;
                n = 269;
                if (envs.containsKey("GL_USER_CERT_PATH")) {
                    __cobertura_counters[268] = __cobertura_counters[268] + 1;
                    n = 0;
                    __cobertura_counters[270] = __cobertura_counters[270] + 1;
                    this.glProductKeyPath = envs.get("GL_USER_CERT_PATH");
                    __cobertura_counters[271] = __cobertura_counters[271] + 1;
                    this.glProductKeyLength = envs.get("GL_USER_CERT_LENGTH");
                    __cobertura_counters[272] = __cobertura_counters[272] + 1;
                    this.glProductKeyTimestamp = envs.get("GL_USER_CERT_TIMESTAMP");
                }
                int n24 = n;
                __cobertura_counters[n24] = __cobertura_counters[n24] + 1;
                n = 0;
                __cobertura_counters[273] = __cobertura_counters[273] + 1;
                n = 275;
                if (envs.containsKey("TASK_ZIP_PATH")) {
                    __cobertura_counters[274] = __cobertura_counters[274] + 1;
                    n = 0;
                    __cobertura_counters[276] = __cobertura_counters[276] + 1;
                    this.taskPath = envs.get("TASK_ZIP_PATH");
                    __cobertura_counters[277] = __cobertura_counters[277] + 1;
                    this.taskTimestamp = Long.parseLong(envs.get("TASK_ZIP_TIMESTAMP"));
                    __cobertura_counters[278] = __cobertura_counters[278] + 1;
                    this.taskLength = Long.parseLong(envs.get("TASK_ZIP_LEN"));
                }
                int n25 = n;
                __cobertura_counters[n25] = __cobertura_counters[n25] + 1;
                n = 0;
                __cobertura_counters[279] = __cobertura_counters[279] + 1;
                n = 281;
                if (envs.containsKey("GL_USER_PYTHON_ARGS")) {
                    __cobertura_counters[280] = __cobertura_counters[280] + 1;
                    n = 0;
                    __cobertura_counters[282] = __cobertura_counters[282] + 1;
                    this.glUserPythonScriptArgs = envs.get("GL_USER_PYTHON_ARGS");
                }
                int n26 = n;
                __cobertura_counters[n26] = __cobertura_counters[n26] + 1;
                n = 0;
                __cobertura_counters[283] = __cobertura_counters[283] + 1;
                LOG.info((Object)"\n************************GRAPHLAB VALS****************************");
                __cobertura_counters[284] = __cobertura_counters[284] + 1;
                LOG.info((Object)("\nglBasePath=" + this.glBasePath + "\nglUserPath=" + this.glUserPath + "\nglResource=" + this.glResourcePath + "\nglUserPythonScript=" + this.glUserPythonScript + "\nglProductKeyPath=" + this.glProductKeyPath + "\ntaskPath=" + this.taskPath));
                __cobertura_counters[285] = __cobertura_counters[285] + 1;
                LOG.info((Object)"\n*****************************************************************");
                __cobertura_counters[286] = __cobertura_counters[286] + 1;
                n = 288;
                if (this.glBasePath == null) break block42;
                __cobertura_counters[287] = __cobertura_counters[287] + 1;
                n = 0;
                n = 290;
                if (!this.glBasePath.isEmpty()) break block43;
                __cobertura_counters[289] = __cobertura_counters[289] + 1;
                n = 0;
            }
            int n27 = n;
            __cobertura_counters[n27] = __cobertura_counters[n27] + 1;
            n = 0;
            __cobertura_counters[291] = __cobertura_counters[291] + 1;
            throw new IllegalArgumentException("GL_SOURCE_TAR must be provided");
        }
        int n28 = n;
        __cobertura_counters[n28] = __cobertura_counters[n28] + 1;
        n = 0;
        __cobertura_counters[292] = __cobertura_counters[292] + 1;
        this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
        __cobertura_counters[293] = __cobertura_counters[293] + 1;
        this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "2"));
        __cobertura_counters[294] = __cobertura_counters[294] + 1;
        this.numTotalContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
        __cobertura_counters[295] = __cobertura_counters[295] + 1;
        n = 297;
        if (this.numTotalContainers == 0) {
            __cobertura_counters[296] = __cobertura_counters[296] + 1;
            n = 0;
            __cobertura_counters[298] = __cobertura_counters[298] + 1;
            throw new IllegalArgumentException("Cannot run distributed shell with no containers");
        }
        int n29 = n;
        __cobertura_counters[n29] = __cobertura_counters[n29] + 1;
        n = 0;
        __cobertura_counters[299] = __cobertura_counters[299] + 1;
        this.requestPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
        __cobertura_counters[300] = __cobertura_counters[300] + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private void printUsage(Options options) {
        void opts;
        int n = 0;
        __cobertura_counters[301] = __cobertura_counters[301] + 1;
        new HelpFormatter().printHelp("ApplicationMaster", (Options)opts);
        __cobertura_counters[302] = __cobertura_counters[302] + 1;
    }

    public boolean run() throws YarnException, IOException {
        Object allocListener;
        int n = 0;
        __cobertura_counters[303] = __cobertura_counters[303] + 1;
        System.out.println("Starting ApplicationMaster");
        __cobertura_counters[304] = __cobertura_counters[304] + 1;
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        __cobertura_counters[305] = __cobertura_counters[305] + 1;
        DataOutputBuffer dob = new DataOutputBuffer();
        __cobertura_counters[306] = __cobertura_counters[306] + 1;
        credentials.writeTokenStorageToStream((DataOutputStream)dob);
        __cobertura_counters[307] = __cobertura_counters[307] + 1;
        Iterator iter = credentials.getAllTokens().iterator();
        while (true) {
            __cobertura_counters[308] = __cobertura_counters[308] + 1;
            n = 310;
            if (!iter.hasNext()) break;
            __cobertura_counters[309] = __cobertura_counters[309] + 1;
            n = 0;
            __cobertura_counters[311] = __cobertura_counters[311] + 1;
            Token token = (Token)iter.next();
            __cobertura_counters[312] = __cobertura_counters[312] + 1;
            n = 314;
            if (token.getKind().equals((Object)AMRMTokenIdentifier.KIND_NAME)) {
                __cobertura_counters[313] = __cobertura_counters[313] + 1;
                n = 0;
                __cobertura_counters[315] = __cobertura_counters[315] + 1;
                iter.remove();
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[316] = __cobertura_counters[316] + 1;
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[317] = __cobertura_counters[317] + 1;
        this.allTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
        __cobertura_counters[318] = __cobertura_counters[318] + 1;
        n = 320;
        if (this.taskPath != null) {
            __cobertura_counters[319] = __cobertura_counters[319] + 1;
            n = 0;
            __cobertura_counters[321] = __cobertura_counters[321] + 1;
            allocListener = new ArtifactRMCallbackHandler(this, null);
        } else {
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[322] = __cobertura_counters[322] + 1;
            allocListener = new RMCallbackHandler(this, null);
        }
        __cobertura_counters[323] = __cobertura_counters[323] + 1;
        this.amRMClient = AMRMClientAsync.createAMRMClientAsync((int)1000, (AMRMClientAsync.CallbackHandler)allocListener);
        __cobertura_counters[324] = __cobertura_counters[324] + 1;
        this.amRMClient.init(this.conf);
        __cobertura_counters[325] = __cobertura_counters[325] + 1;
        this.amRMClient.start();
        __cobertura_counters[326] = __cobertura_counters[326] + 1;
        this.containerListener = this.createNMCallbackHandler();
        __cobertura_counters[327] = __cobertura_counters[327] + 1;
        this.nmClientAsync = new NMClientAsyncImpl((NMClientAsync.CallbackHandler)this.containerListener);
        __cobertura_counters[328] = __cobertura_counters[328] + 1;
        this.nmClientAsync.init(this.conf);
        __cobertura_counters[329] = __cobertura_counters[329] + 1;
        this.nmClientAsync.start();
        __cobertura_counters[330] = __cobertura_counters[330] + 1;
        this.appMasterHostname = NetUtils.getHostname();
        __cobertura_counters[331] = __cobertura_counters[331] + 1;
        RegisterApplicationMasterResponse response = this.amRMClient.registerApplicationMaster(this.appMasterHostname, this.appMasterRpcPort, this.appMasterTrackingUrl);
        __cobertura_counters[332] = __cobertura_counters[332] + 1;
        int maxMem = response.getMaximumResourceCapability().getMemory();
        __cobertura_counters[333] = __cobertura_counters[333] + 1;
        System.out.println("Max mem capabililty of resources in this cluster " + maxMem);
        __cobertura_counters[334] = __cobertura_counters[334] + 1;
        int maxVCores = response.getMaximumResourceCapability().getVirtualCores();
        __cobertura_counters[335] = __cobertura_counters[335] + 1;
        System.out.println("Max vcores capabililty of resources in this cluster " + maxVCores);
        __cobertura_counters[336] = __cobertura_counters[336] + 1;
        n = 338;
        if (this.containerMemory > maxMem) {
            __cobertura_counters[337] = __cobertura_counters[337] + 1;
            n = 0;
            __cobertura_counters[339] = __cobertura_counters[339] + 1;
            System.out.println("Container memory specified above max threshold of cluster. Using max value., specified=" + this.containerMemory + ", max=" + maxMem);
            __cobertura_counters[340] = __cobertura_counters[340] + 1;
            this.containerMemory = maxMem;
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[341] = __cobertura_counters[341] + 1;
        n = 343;
        if (this.containerVirtualCores > maxVCores) {
            __cobertura_counters[342] = __cobertura_counters[342] + 1;
            n = 0;
            __cobertura_counters[344] = __cobertura_counters[344] + 1;
            System.out.println("Container virtual cores specified above max threshold of cluster. Using max value., specified=" + this.containerVirtualCores + ", max=" + maxVCores);
            __cobertura_counters[345] = __cobertura_counters[345] + 1;
            this.containerVirtualCores = maxVCores;
        }
        int n6 = n;
        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
        n = 0;
        __cobertura_counters[346] = __cobertura_counters[346] + 1;
        n = 348;
        if (this.taskPath != null) {
            __cobertura_counters[347] = __cobertura_counters[347] + 1;
            n = 0;
            __cobertura_counters[349] = __cobertura_counters[349] + 1;
            File topDir = new File("top_async.zip/steps");
            __cobertura_counters[350] = __cobertura_counters[350] + 1;
            Object[] listing = topDir.listFiles();
            __cobertura_counters[351] = __cobertura_counters[351] + 1;
            Arrays.sort(listing);
            __cobertura_counters[352] = __cobertura_counters[352] + 1;
            n = 354;
            if (listing == null) {
                __cobertura_counters[353] = __cobertura_counters[353] + 1;
                n = 0;
                __cobertura_counters[355] = __cobertura_counters[355] + 1;
                throw new IllegalArgumentException("i was expecting dirs in top_async.zip/steps and didn't find any");
            }
            int n7 = n;
            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
            n = 0;
            __cobertura_counters[356] = __cobertura_counters[356] + 1;
            this.numStages.set(listing.length);
            __cobertura_counters[357] = __cobertura_counters[357] + 1;
            System.out.println("numStages=" + this.numStages);
            __cobertura_counters[358] = __cobertura_counters[358] + 1;
            this.currentStage.set(0);
            __cobertura_counters[359] = __cobertura_counters[359] + 1;
            Object[] arr$ = listing;
            int len$ = arr$.length;
            int i$ = 0;
            while (true) {
                n = 361;
                if (i$ >= len$) break;
                __cobertura_counters[360] = __cobertura_counters[360] + 1;
                n = 0;
                Object child = arr$[i$];
                __cobertura_counters[363] = __cobertura_counters[363] + 1;
                System.out.println("starting a new stage, stage_directory=" + ((File)child).getName());
                __cobertura_counters[364] = __cobertura_counters[364] + 1;
                System.out.println("currentstage=" + this.currentStage);
                __cobertura_counters[365] = __cobertura_counters[365] + 1;
                this.stageDone = false;
                __cobertura_counters[366] = __cobertura_counters[366] + 1;
                this.stageDir = ((File)child).getName();
                __cobertura_counters[367] = __cobertura_counters[367] + 1;
                this.totalCompletedThisStage.set(0);
                __cobertura_counters[368] = __cobertura_counters[368] + 1;
                this.totalRequestedThisStage.set(0);
                __cobertura_counters[369] = __cobertura_counters[369] + 1;
                this.totalCompletedThisStage.set(0);
                __cobertura_counters[370] = __cobertura_counters[370] + 1;
                this.totalAllocatedContainersInStage.set(0);
                __cobertura_counters[371] = __cobertura_counters[371] + 1;
                this.totalFailedThisStage.set(0);
                __cobertura_counters[372] = __cobertura_counters[372] + 1;
                this.currentTaskPosition.set(0);
                __cobertura_counters[373] = __cobertura_counters[373] + 1;
                this.tasksInStgDir = ((File)child).listFiles();
                __cobertura_counters[374] = __cobertura_counters[374] + 1;
                Arrays.sort(this.tasksInStgDir);
                __cobertura_counters[375] = __cobertura_counters[375] + 1;
                this.totalContainersInStage.set(this.tasksInStgDir.length);
                __cobertura_counters[376] = __cobertura_counters[376] + 1;
                System.out.println("totalContainersInStage=" + this.totalContainersInStage);
                __cobertura_counters[377] = __cobertura_counters[377] + 1;
                int i = 0;
                while (true) {
                    n = 379;
                    if (i >= this.totalContainersInStage.get()) break;
                    __cobertura_counters[378] = __cobertura_counters[378] + 1;
                    n = 0;
                    __cobertura_counters[381] = __cobertura_counters[381] + 1;
                    AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
                    __cobertura_counters[382] = __cobertura_counters[382] + 1;
                    this.amRMClient.addContainerRequest(containerAsk);
                    __cobertura_counters[380] = __cobertura_counters[380] + 1;
                    ++i;
                }
                int n8 = n;
                __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                n = 0;
                __cobertura_counters[383] = __cobertura_counters[383] + 1;
                this.totalRequestedThisStage.set(this.totalContainersInStage.get());
                while (true) {
                    __cobertura_counters[384] = __cobertura_counters[384] + 1;
                    n = 386;
                    if (this.done) break;
                    __cobertura_counters[385] = __cobertura_counters[385] + 1;
                    n = 0;
                    n = 388;
                    if (this.stageDone) break;
                    __cobertura_counters[387] = __cobertura_counters[387] + 1;
                    n = 0;
                    n = 390;
                    if (this.totalCompletedThisStage.get() == this.totalContainersInStage.get()) break;
                    __cobertura_counters[389] = __cobertura_counters[389] + 1;
                    n = 0;
                    try {
                        __cobertura_counters[391] = __cobertura_counters[391] + 1;
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException e) {
                        continue;
                    }
                    __cobertura_counters[392] = __cobertura_counters[392] + 1;
                    continue;
                    break;
                }
                int n9 = n;
                __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                n = 0;
                __cobertura_counters[393] = __cobertura_counters[393] + 1;
                this.waitForStage();
                __cobertura_counters[394] = __cobertura_counters[394] + 1;
                System.out.println("incrementing stage");
                __cobertura_counters[395] = __cobertura_counters[395] + 1;
                this.currentStage.incrementAndGet();
                __cobertura_counters[362] = __cobertura_counters[362] + 1;
                ++i$;
            }
            int n10 = n;
            __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
            n = 0;
            __cobertura_counters[396] = __cobertura_counters[396] + 1;
            this.finishAllStages();
            __cobertura_counters[397] = __cobertura_counters[397] + 1;
        } else {
            int n11 = n;
            __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
            n = 0;
            __cobertura_counters[398] = __cobertura_counters[398] + 1;
            int i = 0;
            while (true) {
                n = 400;
                if (i >= this.numTotalContainers) break;
                __cobertura_counters[399] = __cobertura_counters[399] + 1;
                n = 0;
                __cobertura_counters[402] = __cobertura_counters[402] + 1;
                AMRMClient.ContainerRequest containerAsk = this.setupContainerAskForRM();
                __cobertura_counters[403] = __cobertura_counters[403] + 1;
                this.amRMClient.addContainerRequest(containerAsk);
                __cobertura_counters[401] = __cobertura_counters[401] + 1;
                ++i;
            }
            int n12 = n;
            __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
            n = 0;
            __cobertura_counters[404] = __cobertura_counters[404] + 1;
            this.numRequestedContainers.set(this.numTotalContainers);
            while (true) {
                __cobertura_counters[405] = __cobertura_counters[405] + 1;
                n = 407;
                if (this.done) break;
                __cobertura_counters[406] = __cobertura_counters[406] + 1;
                n = 0;
                n = 409;
                if (this.numCompletedContainers.get() == this.numTotalContainers) break;
                __cobertura_counters[408] = __cobertura_counters[408] + 1;
                n = 0;
                try {
                    __cobertura_counters[410] = __cobertura_counters[410] + 1;
                    Thread.sleep(200L);
                }
                catch (InterruptedException ex) {
                    continue;
                }
                __cobertura_counters[411] = __cobertura_counters[411] + 1;
                continue;
                break;
            }
            int n13 = n;
            __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
            n = 0;
            __cobertura_counters[412] = __cobertura_counters[412] + 1;
            this.finish();
        }
        __cobertura_counters[413] = __cobertura_counters[413] + 1;
        return this.success;
    }

    @VisibleForTesting
    NMCallbackHandler createNMCallbackHandler() {
        int n = 0;
        __cobertura_counters[414] = __cobertura_counters[414] + 1;
        return new NMCallbackHandler(this);
    }

    private void waitForStage() {
        int n = 0;
        __cobertura_counters[415] = __cobertura_counters[415] + 1;
        System.out.println("waitingForStage to finish at stage=" + this.currentStage + " and there are " + this.stageLaunchedThreads.size() + " threads");
        __cobertura_counters[416] = __cobertura_counters[416] + 1;
        Iterator<Thread> i$ = this.stageLaunchedThreads.iterator();
        while (true) {
            n = 418;
            if (!i$.hasNext()) break;
            __cobertura_counters[417] = __cobertura_counters[417] + 1;
            n = 0;
            Thread launchThread = i$.next();
            try {
                __cobertura_counters[419] = __cobertura_counters[419] + 1;
                launchThread.join(10000L);
            }
            catch (InterruptedException interruptedException) {
                __cobertura_counters[420] = __cobertura_counters[420] + 1;
                InterruptedException e = interruptedException;
                __cobertura_counters[421] = __cobertura_counters[421] + 1;
                System.out.println("Exception thrown in thread join: " + e.getMessage());
                __cobertura_counters[422] = __cobertura_counters[422] + 1;
                e.printStackTrace();
            }
            __cobertura_counters[423] = __cobertura_counters[423] + 1;
            __cobertura_counters[424] = __cobertura_counters[424] + 1;
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[425] = __cobertura_counters[425] + 1;
        System.out.println("stage " + this.currentStage + " should be finished");
        __cobertura_counters[426] = __cobertura_counters[426] + 1;
        this.stageLaunchedThreads.clear();
        __cobertura_counters[427] = __cobertura_counters[427] + 1;
    }

    private void finishAllStages() {
        FinalApplicationStatus appStatus;
        int n = 0;
        __cobertura_counters[428] = __cobertura_counters[428] + 1;
        System.out.println("Artifact application completed. Stopping running containers");
        __cobertura_counters[429] = __cobertura_counters[429] + 1;
        this.nmClientAsync.stop();
        __cobertura_counters[430] = __cobertura_counters[430] + 1;
        System.out.println("Application completed. Signalling finish to RM");
        __cobertura_counters[431] = __cobertura_counters[431] + 1;
        String appMessage = null;
        __cobertura_counters[432] = __cobertura_counters[432] + 1;
        this.success = true;
        __cobertura_counters[433] = __cobertura_counters[433] + 1;
        n = 435;
        if (this.totalFailedAllStages.get() == 0) {
            __cobertura_counters[434] = __cobertura_counters[434] + 1;
            n = 0;
            __cobertura_counters[436] = __cobertura_counters[436] + 1;
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else {
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[437] = __cobertura_counters[437] + 1;
            appStatus = FinalApplicationStatus.FAILED;
            __cobertura_counters[438] = __cobertura_counters[438] + 1;
            this.success = false;
        }
        try {
            __cobertura_counters[439] = __cobertura_counters[439] + 1;
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException yarnException) {
            __cobertura_counters[440] = __cobertura_counters[440] + 1;
            YarnException ex = yarnException;
            __cobertura_counters[441] = __cobertura_counters[441] + 1;
            System.out.println("Failed to unregister application");
            __cobertura_counters[442] = __cobertura_counters[442] + 1;
            ex.printStackTrace();
            __cobertura_counters[447] = __cobertura_counters[447] + 1;
        }
        catch (IOException iOException) {
            __cobertura_counters[443] = __cobertura_counters[443] + 1;
            IOException e = iOException;
            __cobertura_counters[444] = __cobertura_counters[444] + 1;
            System.out.println("Failed to unregister application");
            __cobertura_counters[445] = __cobertura_counters[445] + 1;
            e.printStackTrace();
        }
        __cobertura_counters[446] = __cobertura_counters[446] + 1;
        __cobertura_counters[448] = __cobertura_counters[448] + 1;
        this.amRMClient.stop();
        __cobertura_counters[449] = __cobertura_counters[449] + 1;
    }

    /*
     * Unable to fully structure code
     */
    private void finish() {
        var1_1 = 0;
        ApplicationMaster.__cobertura_counters[450] = ApplicationMaster.__cobertura_counters[450] + 1;
        i$ = this.launchThreads.iterator();
        while (true) {
            var1_1 = 452;
            if (!i$.hasNext()) break;
            ApplicationMaster.__cobertura_counters[451] = ApplicationMaster.__cobertura_counters[451] + 1;
            var1_1 = 0;
            launchThread = i$.next();
            try {
                ApplicationMaster.__cobertura_counters[453] = ApplicationMaster.__cobertura_counters[453] + 1;
                launchThread.join(10000L);
            }
            catch (InterruptedException v0) {
                ApplicationMaster.__cobertura_counters[454] = ApplicationMaster.__cobertura_counters[454] + 1;
                e = v0;
                ApplicationMaster.__cobertura_counters[455] = ApplicationMaster.__cobertura_counters[455] + 1;
                System.out.println("Exception thrown in thread join: " + e.getMessage());
                ApplicationMaster.__cobertura_counters[456] = ApplicationMaster.__cobertura_counters[456] + 1;
                e.printStackTrace();
            }
            ApplicationMaster.__cobertura_counters[457] = ApplicationMaster.__cobertura_counters[457] + 1;
            ApplicationMaster.__cobertura_counters[458] = ApplicationMaster.__cobertura_counters[458] + 1;
        }
        v1 = var1_1;
        ApplicationMaster.__cobertura_counters[v1] = ApplicationMaster.__cobertura_counters[v1] + 1;
        var1_1 = 0;
        ApplicationMaster.__cobertura_counters[459] = ApplicationMaster.__cobertura_counters[459] + 1;
        System.out.println("Application completed. Stopping running containers");
        ApplicationMaster.__cobertura_counters[460] = ApplicationMaster.__cobertura_counters[460] + 1;
        this.nmClientAsync.stop();
        ApplicationMaster.__cobertura_counters[461] = ApplicationMaster.__cobertura_counters[461] + 1;
        System.out.println("Application completed. Signalling finish to RM");
        ApplicationMaster.__cobertura_counters[462] = ApplicationMaster.__cobertura_counters[462] + 1;
        appMessage = null;
        ApplicationMaster.__cobertura_counters[463] = ApplicationMaster.__cobertura_counters[463] + 1;
        this.success = true;
        ApplicationMaster.__cobertura_counters[464] = ApplicationMaster.__cobertura_counters[464] + 1;
        var1_1 = 466;
        if (this.numFailedContainers.get() != 0) ** GOTO lbl-1000
        ApplicationMaster.__cobertura_counters[465] = ApplicationMaster.__cobertura_counters[465] + 1;
        var1_1 = 0;
        var1_1 = 468;
        if (this.numCompletedContainers.get() == this.numTotalContainers) {
            ApplicationMaster.__cobertura_counters[467] = ApplicationMaster.__cobertura_counters[467] + 1;
            var1_1 = 0;
            ApplicationMaster.__cobertura_counters[469] = ApplicationMaster.__cobertura_counters[469] + 1;
            appStatus = FinalApplicationStatus.SUCCEEDED;
        } else lbl-1000:
        // 2 sources

        {
            v2 = var1_1;
            ApplicationMaster.__cobertura_counters[v2] = ApplicationMaster.__cobertura_counters[v2] + 1;
            var1_1 = 0;
            ApplicationMaster.__cobertura_counters[470] = ApplicationMaster.__cobertura_counters[470] + 1;
            appStatus = FinalApplicationStatus.FAILED;
            ApplicationMaster.__cobertura_counters[471] = ApplicationMaster.__cobertura_counters[471] + 1;
            appMessage = "Diagnostics., total=" + this.numTotalContainers + ", completed=" + this.numCompletedContainers.get() + ", allocated=" + this.numAllocatedContainers.get() + ", failed=" + this.numFailedContainers.get();
            ApplicationMaster.__cobertura_counters[472] = ApplicationMaster.__cobertura_counters[472] + 1;
            this.success = false;
        }
        try {
            ApplicationMaster.__cobertura_counters[473] = ApplicationMaster.__cobertura_counters[473] + 1;
            this.amRMClient.unregisterApplicationMaster(appStatus, appMessage, null);
        }
        catch (YarnException v3) {
            ApplicationMaster.__cobertura_counters[474] = ApplicationMaster.__cobertura_counters[474] + 1;
            ex = v3;
            ApplicationMaster.__cobertura_counters[475] = ApplicationMaster.__cobertura_counters[475] + 1;
            System.out.println("Failed to unregister application");
            ApplicationMaster.__cobertura_counters[476] = ApplicationMaster.__cobertura_counters[476] + 1;
            ex.printStackTrace();
            ApplicationMaster.__cobertura_counters[481] = ApplicationMaster.__cobertura_counters[481] + 1;
        }
        catch (IOException v4) {
            ApplicationMaster.__cobertura_counters[477] = ApplicationMaster.__cobertura_counters[477] + 1;
            e = v4;
            ApplicationMaster.__cobertura_counters[478] = ApplicationMaster.__cobertura_counters[478] + 1;
            System.out.println("Failed to unregister application");
            ApplicationMaster.__cobertura_counters[479] = ApplicationMaster.__cobertura_counters[479] + 1;
            e.printStackTrace();
        }
        ApplicationMaster.__cobertura_counters[480] = ApplicationMaster.__cobertura_counters[480] + 1;
        ApplicationMaster.__cobertura_counters[482] = ApplicationMaster.__cobertura_counters[482] + 1;
        this.amRMClient.stop();
        ApplicationMaster.__cobertura_counters[483] = ApplicationMaster.__cobertura_counters[483] + 1;
    }

    private AMRMClient.ContainerRequest setupContainerAskForRM() {
        int n = 0;
        __cobertura_counters[484] = __cobertura_counters[484] + 1;
        Priority pri = (Priority)Records.newRecord(Priority.class);
        __cobertura_counters[485] = __cobertura_counters[485] + 1;
        pri.setPriority(this.requestPriority);
        __cobertura_counters[486] = __cobertura_counters[486] + 1;
        Resource capability = (Resource)Records.newRecord(Resource.class);
        __cobertura_counters[487] = __cobertura_counters[487] + 1;
        capability.setMemory(this.containerMemory);
        __cobertura_counters[488] = __cobertura_counters[488] + 1;
        capability.setVirtualCores(this.containerVirtualCores);
        __cobertura_counters[489] = __cobertura_counters[489] + 1;
        AMRMClient.ContainerRequest request = new AMRMClient.ContainerRequest(capability, null, null, pri);
        __cobertura_counters[490] = __cobertura_counters[490] + 1;
        System.out.println("Requested container ask: " + request.toString());
        __cobertura_counters[491] = __cobertura_counters[491] + 1;
        return request;
    }

    /*
     * WARNING - void declaration
     */
    private boolean fileExist(String string) {
        void filePath;
        int n = 0;
        __cobertura_counters[492] = __cobertura_counters[492] + 1;
        return new File((String)filePath).exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private String readContent(String string) throws IOException {
        String string2;
        int n = 0;
        __cobertura_counters[493] = __cobertura_counters[493] + 1;
        DataInputStream ds = null;
        try {
            void filePath;
            __cobertura_counters[494] = __cobertura_counters[494] + 1;
            ds = new DataInputStream(new FileInputStream((String)filePath));
            __cobertura_counters[495] = __cobertura_counters[495] + 1;
            string2 = ds.readUTF();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(ds);
            throw throwable;
        }
        __cobertura_counters[496] = __cobertura_counters[496] + 1;
        IOUtils.closeQuietly((InputStream)ds);
        return string2;
    }

    static /* synthetic */ AtomicInteger access$200(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        return x0.numCompletedContainers;
    }

    static /* synthetic */ AtomicInteger access$300(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
        return x0.numFailedContainers;
    }

    static /* synthetic */ AtomicInteger access$400(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        return x0.numAllocatedContainers;
    }

    static /* synthetic */ AtomicInteger access$500(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        return x0.numRequestedContainers;
    }

    static /* synthetic */ int access$600(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[5] = __cobertura_counters[5] + 1;
        return x0.numTotalContainers;
    }

    static /* synthetic */ AMRMClient.ContainerRequest access$700(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[6] = __cobertura_counters[6] + 1;
        return x0.setupContainerAskForRM();
    }

    static /* synthetic */ AMRMClientAsync access$800(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[7] = __cobertura_counters[7] + 1;
        return x0.amRMClient;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$902(ApplicationMaster applicationMaster, boolean bl) {
        ApplicationMaster x0;
        void x1;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[8] = __cobertura_counters[8] + 1;
        x0.done = x1;
        return x0.done;
    }

    static /* synthetic */ NMCallbackHandler access$1000(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
        return x0.containerListener;
    }

    static /* synthetic */ List access$1100(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        return x0.launchThreads;
    }

    static /* synthetic */ AtomicInteger access$1200(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        return x0.totalCompletedThisStage;
    }

    static /* synthetic */ AtomicInteger access$1300(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        return x0.totalFailedThisStage;
    }

    static /* synthetic */ AtomicInteger access$1400(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
        return x0.totalFailedAllStages;
    }

    static /* synthetic */ AtomicInteger access$1500(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[14] = __cobertura_counters[14] + 1;
        return x0.totalAllocatedContainersInStage;
    }

    static /* synthetic */ AtomicInteger access$1600(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[15] = __cobertura_counters[15] + 1;
        return x0.totalRequestedThisStage;
    }

    static /* synthetic */ AtomicInteger access$1700(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
        return x0.totalContainersInStage;
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$1802(ApplicationMaster applicationMaster, boolean bl) {
        ApplicationMaster x0;
        void x1;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[17] = __cobertura_counters[17] + 1;
        x0.stageDone = x1;
        return x0.stageDone;
    }

    static /* synthetic */ AtomicInteger access$1900(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[18] = __cobertura_counters[18] + 1;
        return x0.currentTaskPosition;
    }

    static /* synthetic */ List access$2000(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[19] = __cobertura_counters[19] + 1;
        return x0.stageLaunchedThreads;
    }

    static /* synthetic */ AtomicInteger access$2100(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[20] = __cobertura_counters[20] + 1;
        return x0.currentStage;
    }

    static /* synthetic */ AtomicInteger access$2200(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[21] = __cobertura_counters[21] + 1;
        return x0.numStages;
    }

    static /* synthetic */ Log access$2300() {
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        return LOG;
    }

    static /* synthetic */ NMClientAsync access$2400(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        return x0.nmClientAsync;
    }

    static /* synthetic */ Map access$2500(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[24] = __cobertura_counters[24] + 1;
        return x0.shellEnv;
    }

    static /* synthetic */ String access$2600(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[25] = __cobertura_counters[25] + 1;
        return x0.resourceDir;
    }

    static /* synthetic */ String access$2700(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[26] = __cobertura_counters[26] + 1;
        return x0.taskPath;
    }

    static /* synthetic */ boolean access$2800(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        return x0.is_gl_native;
    }

    static /* synthetic */ String access$2900(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[28] = __cobertura_counters[28] + 1;
        return x0.glBasePath;
    }

    static /* synthetic */ String access$3000(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[29] = __cobertura_counters[29] + 1;
        return x0.glResourcePath;
    }

    static /* synthetic */ boolean access$3100(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[30] = __cobertura_counters[30] + 1;
        return x0.includeUserDeps;
    }

    static /* synthetic */ String access$3200(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[31] = __cobertura_counters[31] + 1;
        return x0.glUserPath;
    }

    static /* synthetic */ String access$3300(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[32] = __cobertura_counters[32] + 1;
        return x0.glProductKeyPath;
    }

    static /* synthetic */ String access$3400(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[33] = __cobertura_counters[33] + 1;
        return x0.shellCommand;
    }

    static /* synthetic */ String access$3500(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[34] = __cobertura_counters[34] + 1;
        return x0.shellScriptPath;
    }

    static /* synthetic */ boolean access$3600(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[35] = __cobertura_counters[35] + 1;
        return x0.use_cache;
    }

    static /* synthetic */ String access$3700(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[36] = __cobertura_counters[36] + 1;
        return x0.cacheDir;
    }

    static /* synthetic */ String access$3800(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[37] = __cobertura_counters[37] + 1;
        return x0.stageDir;
    }

    static /* synthetic */ File[] access$3900(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[38] = __cobertura_counters[38] + 1;
        return x0.tasksInStgDir;
    }

    static /* synthetic */ String access$4000(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[39] = __cobertura_counters[39] + 1;
        return x0.glUserPythonScriptArgs;
    }

    static /* synthetic */ String access$4100(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[40] = __cobertura_counters[40] + 1;
        return x0.glUserPythonScript;
    }

    static /* synthetic */ String access$4200(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[41] = __cobertura_counters[41] + 1;
        return x0.shellArgs;
    }

    static /* synthetic */ ByteBuffer access$4300(ApplicationMaster applicationMaster) {
        ApplicationMaster x0;
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[42] = __cobertura_counters[42] + 1;
        return x0.allTokens;
    }

    static {
        ApplicationMaster.__cobertura_init();
        int n = 0;
        __cobertura_counters[43] = __cobertura_counters[43] + 1;
        LOG = LogFactory.getLog(ApplicationMaster.class);
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[497];
            TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/ApplicationMaster");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(166, 1, "access$200", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 2, "access$300", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 3, "access$400", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 4, "access$500", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 5, "access$600", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)I");
        lightClassmapListener2.putLineTouchPoint(166, 6, "access$700", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(166, 7, "access$800", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Lorg/apache/hadoop/yarn/client/api/async/AMRMClientAsync;");
        lightClassmapListener2.putLineTouchPoint(166, 8, "access$902", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Z)Z");
        lightClassmapListener2.putLineTouchPoint(166, 9, "access$1000", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler;");
        lightClassmapListener2.putLineTouchPoint(166, 10, "access$1100", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/List;");
        lightClassmapListener2.putLineTouchPoint(166, 11, "access$1200", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 12, "access$1300", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 13, "access$1400", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 14, "access$1500", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 15, "access$1600", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 16, "access$1700", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 17, "access$1802", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Z)Z");
        lightClassmapListener2.putLineTouchPoint(166, 18, "access$1900", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 19, "access$2000", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/List;");
        lightClassmapListener2.putLineTouchPoint(166, 20, "access$2100", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 21, "access$2200", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/concurrent/atomic/AtomicInteger;");
        lightClassmapListener2.putLineTouchPoint(166, 22, "access$2300", "()Lorg/apache/commons/logging/Log;");
        lightClassmapListener2.putLineTouchPoint(166, 23, "access$2400", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Lorg/apache/hadoop/yarn/client/api/async/NMClientAsync;");
        lightClassmapListener2.putLineTouchPoint(166, 24, "access$2500", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/util/Map;");
        lightClassmapListener2.putLineTouchPoint(166, 25, "access$2600", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 26, "access$2700", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 27, "access$2800", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Z");
        lightClassmapListener2.putLineTouchPoint(166, 28, "access$2900", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 29, "access$3000", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 30, "access$3100", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Z");
        lightClassmapListener2.putLineTouchPoint(166, 31, "access$3200", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 32, "access$3300", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 33, "access$3400", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 34, "access$3500", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 35, "access$3600", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Z");
        lightClassmapListener2.putLineTouchPoint(166, 36, "access$3700", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 37, "access$3800", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 38, "access$3900", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)[Ljava/io/File;");
        lightClassmapListener2.putLineTouchPoint(166, 39, "access$4000", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 40, "access$4100", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 41, "access$4200", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(166, 42, "access$4300", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)Ljava/nio/ByteBuffer;");
        lightClassmapListener2.putLineTouchPoint(170, 43, "<clinit>", "()V");
        lightClassmapListener2.putLineTouchPoint(190, 44, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(192, 45, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(194, 46, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(198, 47, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(200, 48, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(202, 49, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(210, 50, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(214, 51, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(218, 52, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(227, 53, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(228, 54, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(229, 55, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(233, 56, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(236, 57, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(238, 58, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(242, 59, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(244, 60, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(245, 61, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(246, 62, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(247, 63, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(248, 64, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(249, 65, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(252, 66, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(254, 67, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(257, 68, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(258, 69, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(262, 70, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(264, 71, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(266, 72, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(270, 73, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(272, 74, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(289, 75, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(291, 76, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(297, 77, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(299, 78, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(300, 79, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(301, 80, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(302, 81, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(302, 83, 82);
        lightClassmapListener2.putLineTouchPoint(303, 84, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(305, 85, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(306, 86, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(307, 87, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(308, 88, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(309, 89, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(310, 90, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(310, 92, 91);
        lightClassmapListener2.putLineTouchPoint(311, 93, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(312, 94, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(314, 95, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(315, 96, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(317, 97, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(324, 98, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(325, 99, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(326, 100, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putJumpTouchPoint(326, 102, 101);
        lightClassmapListener2.putLineTouchPoint(327, 103, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(328, 104, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(331, 105, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(333, 106, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putJumpTouchPoint(333, 108, 107);
        lightClassmapListener2.putLineTouchPoint(335, 109, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(336, 110, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(337, 111, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putJumpTouchPoint(337, 113, 112);
        lightClassmapListener2.putLineTouchPoint(338, 114, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(339, 115, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(341, 116, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(342, 117, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(344, 118, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(345, 119, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(345, 120, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(346, 121, "dumpOutDebugInfo", "()V");
        lightClassmapListener2.putLineTouchPoint(348, 122, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(350, 123, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(351, 124, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(363, 125, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(364, 126, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(366, 127, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(368, 128, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(370, 129, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(372, 130, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(374, 131, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(375, 132, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(377, 133, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(378, 134, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(380, 135, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(380, 137, 136);
        lightClassmapListener2.putLineTouchPoint(381, 138, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(382, 139, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(387, 140, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(387, 142, 141);
        lightClassmapListener2.putLineTouchPoint(389, 143, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(391, 144, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(392, 145, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(393, 146, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(396, 147, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(396, 149, 148);
        lightClassmapListener2.putLineTouchPoint(397, 150, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(398, 151, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(401, 152, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(401, 154, 153);
        lightClassmapListener2.putLineTouchPoint(402, 155, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(405, 156, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(407, 157, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(407, 159, 158);
        lightClassmapListener2.putLineTouchPoint(408, 160, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(408, 162, 161);
        lightClassmapListener2.putLineTouchPoint(409, 163, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(410, 164, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(411, 165, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(412, 166, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(416, 167, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(418, 168, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(421, 169, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(421, 171, 170);
        lightClassmapListener2.putLineTouchPoint(422, 172, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(425, 173, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(425, 175, 174);
        lightClassmapListener2.putLineTouchPoint(426, 176, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(429, 177, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(429, 179, 178);
        lightClassmapListener2.putLineTouchPoint(430, 180, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(433, 181, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(433, 183, 182);
        lightClassmapListener2.putLineTouchPoint(434, 184, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(438, 185, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(447, 186, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(447, 188, 187);
        lightClassmapListener2.putLineTouchPoint(448, 189, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(449, 190, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(449, 192, 191);
        lightClassmapListener2.putLineTouchPoint(449, 193, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(450, 194, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(451, 195, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(452, 196, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(452, 198, 197);
        lightClassmapListener2.putLineTouchPoint(453, 199, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(454, 200, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(456, 201, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(457, 202, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(458, 203, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(458, 205, 204);
        lightClassmapListener2.putLineTouchPoint(459, 206, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(461, 207, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(465, 208, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(465, 210, 209);
        lightClassmapListener2.putLineTouchPoint(466, 211, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(467, 212, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(470, 213, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(470, 215, 214);
        lightClassmapListener2.putLineTouchPoint(471, 216, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(472, 217, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(472, 219, 218);
        lightClassmapListener2.putLineTouchPoint(473, 220, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(474, 221, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(474, 223, 222);
        lightClassmapListener2.putLineTouchPoint(475, 224, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(479, 225, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(479, 227, 226);
        lightClassmapListener2.putJumpTouchPoint(479, 229, 228);
        lightClassmapListener2.putLineTouchPoint(480, 230, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(481, 231, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(482, 232, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(482, 234, 233);
        lightClassmapListener2.putLineTouchPoint(483, 235, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(484, 236, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(484, 238, 237);
        lightClassmapListener2.putLineTouchPoint(485, 239, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(489, 240, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(489, 242, 241);
        lightClassmapListener2.putJumpTouchPoint(489, 244, 243);
        lightClassmapListener2.putLineTouchPoint(490, 245, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(491, 246, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(492, 247, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(492, 249, 248);
        lightClassmapListener2.putLineTouchPoint(493, 250, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(494, 251, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(494, 253, 252);
        lightClassmapListener2.putLineTouchPoint(495, 254, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(499, 255, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(499, 257, 256);
        lightClassmapListener2.putLineTouchPoint(500, 258, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(503, 259, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(503, 261, 260);
        lightClassmapListener2.putLineTouchPoint(504, 262, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(505, 263, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(505, 265, 264);
        lightClassmapListener2.putLineTouchPoint(506, 266, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(510, 267, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(510, 269, 268);
        lightClassmapListener2.putLineTouchPoint(511, 270, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(512, 271, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(513, 272, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(516, 273, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(516, 275, 274);
        lightClassmapListener2.putLineTouchPoint(517, 276, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(518, 277, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(519, 278, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(521, 279, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(521, 281, 280);
        lightClassmapListener2.putLineTouchPoint(522, 282, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(525, 283, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(526, 284, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(529, 285, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(530, 286, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(530, 288, 287);
        lightClassmapListener2.putJumpTouchPoint(530, 290, 289);
        lightClassmapListener2.putLineTouchPoint(531, 291, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(534, 292, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(536, 293, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(538, 294, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(540, 295, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(540, 297, 296);
        lightClassmapListener2.putLineTouchPoint(541, 298, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(544, 299, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(547, 300, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(556, 301, "printUsage", "(Lorg/apache/commons/cli/Options;)V");
        lightClassmapListener2.putLineTouchPoint(557, 302, "printUsage", "(Lorg/apache/commons/cli/Options;)V");
        lightClassmapListener2.putLineTouchPoint(567, 303, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(569, 304, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(571, 305, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(572, 306, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(574, 307, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(575, 308, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(575, 310, 309);
        lightClassmapListener2.putLineTouchPoint(576, 311, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(577, 312, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(577, 314, 313);
        lightClassmapListener2.putLineTouchPoint(578, 315, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(580, 316, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(581, 317, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(585, 318, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(585, 320, 319);
        lightClassmapListener2.putLineTouchPoint(586, 321, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(589, 322, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(591, 323, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(592, 324, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(593, 325, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(595, 326, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(596, 327, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(597, 328, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(598, 329, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(608, 330, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(609, 331, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(614, 332, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(615, 333, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(617, 334, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(618, 335, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(621, 336, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(621, 338, 337);
        lightClassmapListener2.putLineTouchPoint(622, 339, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(625, 340, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(628, 341, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(628, 343, 342);
        lightClassmapListener2.putLineTouchPoint(629, 344, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(632, 345, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(640, 346, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(640, 348, 347);
        lightClassmapListener2.putLineTouchPoint(653, 349, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(654, 350, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(655, 351, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(656, 352, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(656, 354, 353);
        lightClassmapListener2.putLineTouchPoint(657, 355, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(659, 356, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(660, 357, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(661, 358, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(662, 359, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(662, 361, 360);
        lightClassmapListener2.putLineTouchPoint(662, 362, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(663, 363, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(664, 364, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(665, 365, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(666, 366, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(667, 367, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(668, 368, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(669, 369, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(670, 370, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(671, 371, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(673, 372, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(675, 373, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(676, 374, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(677, 375, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(678, 376, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(680, 377, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(680, 379, 378);
        lightClassmapListener2.putLineTouchPoint(680, 380, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(681, 381, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(682, 382, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(684, 383, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(685, 384, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(685, 386, 385);
        lightClassmapListener2.putJumpTouchPoint(685, 388, 387);
        lightClassmapListener2.putJumpTouchPoint(685, 390, 389);
        lightClassmapListener2.putLineTouchPoint(687, 391, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(690, 392, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(692, 393, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(693, 394, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(694, 395, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(697, 396, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(698, 397, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(706, 398, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(706, 400, 399);
        lightClassmapListener2.putLineTouchPoint(706, 401, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(707, 402, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(708, 403, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(710, 404, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(712, 405, "run", "()Z");
        lightClassmapListener2.putJumpTouchPoint(712, 407, 406);
        lightClassmapListener2.putJumpTouchPoint(712, 409, 408);
        lightClassmapListener2.putLineTouchPoint(715, 410, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(716, 411, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(718, 412, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(724, 413, "run", "()Z");
        lightClassmapListener2.putLineTouchPoint(731, 414, "createNMCallbackHandler", "()Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler;");
        lightClassmapListener2.putLineTouchPoint(735, 415, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(737, 416, "waitForStage", "()V");
        lightClassmapListener2.putJumpTouchPoint(737, 418, 417);
        lightClassmapListener2.putLineTouchPoint(739, 419, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(740, 420, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(741, 421, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(742, 422, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(743, 423, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(744, 424, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(745, 425, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(746, 426, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(748, 427, "waitForStage", "()V");
        lightClassmapListener2.putLineTouchPoint(752, 428, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(753, 429, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(757, 430, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(760, 431, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(761, 432, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(762, 433, "finishAllStages", "()V");
        lightClassmapListener2.putJumpTouchPoint(762, 435, 434);
        lightClassmapListener2.putLineTouchPoint(763, 436, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(765, 437, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(771, 438, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(774, 439, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(775, 440, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(776, 441, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(777, 442, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(778, 443, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(779, 444, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(780, 445, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(781, 446, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(781, 447, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(783, 448, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(784, 449, "finishAllStages", "()V");
        lightClassmapListener2.putLineTouchPoint(791, 450, "finish", "()V");
        lightClassmapListener2.putJumpTouchPoint(791, 452, 451);
        lightClassmapListener2.putLineTouchPoint(793, 453, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(794, 454, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(795, 455, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(796, 456, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(797, 457, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(798, 458, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(801, 459, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(802, 460, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(806, 461, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(809, 462, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(810, 463, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(811, 464, "finish", "()V");
        lightClassmapListener2.putJumpTouchPoint(811, 466, 465);
        lightClassmapListener2.putJumpTouchPoint(811, 468, 467);
        lightClassmapListener2.putLineTouchPoint(813, 469, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(815, 470, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(816, 471, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(820, 472, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(823, 473, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(824, 474, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(825, 475, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(826, 476, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(827, 477, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(828, 478, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(829, 479, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(830, 480, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(830, 481, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(832, 482, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(833, 483, "finish", "()V");
        lightClassmapListener2.putLineTouchPoint(1444, 484, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1446, 485, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1450, 486, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1451, 487, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1452, 488, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1454, 489, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1456, 490, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1457, 491, "setupContainerAskForRM", "()Lorg/apache/hadoop/yarn/client/api/AMRMClient$ContainerRequest;");
        lightClassmapListener2.putLineTouchPoint(1461, 492, "fileExist", "(Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1465, 493, "readContent", "(Ljava/lang/String;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1467, 494, "readContent", "(Ljava/lang/String;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1468, 495, "readContent", "(Ljava/lang/String;)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1470, 496, "readContent", "(Ljava/lang/String;)Ljava/lang/String;");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/ApplicationMaster");
        lightClassmapListener2.setSource("ApplicationMaster.java");
        ApplicationMaster.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }

    static class 1 {
        public static final transient int[] __cobertura_counters;

        static {
            1.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[1];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/ApplicationMaster$1");
            }
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/ApplicationMaster$1");
            lightClassmapListener2.setSource("ApplicationMaster.java");
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private class LaunchContainerRunnable
    implements Runnable {
        public static final transient int[] __cobertura_counters;
        Container container;
        NMCallbackHandler containerListener;
        final /* synthetic */ ApplicationMaster this$0;

        /*
         * WARNING - void declaration
         */
        public LaunchContainerRunnable(ApplicationMaster applicationMaster, Container container, NMCallbackHandler nMCallbackHandler) {
            void containerListener;
            void lcontainer;
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.this$0 = applicationMaster;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this.container = lcontainer;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.containerListener = containerListener;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
        }

        @Override
        public void run() {
            Exception e;
            HashMap<String, LocalResource> localResources;
            ContainerLaunchContext ctx;
            int n;
            block30: {
                n = 0;
                __cobertura_counters[5] = __cobertura_counters[5] + 1;
                System.out.println("Setting up container launch container for containerid=" + this.container.getId());
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                ctx = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
                __cobertura_counters[7] = __cobertura_counters[7] + 1;
                ctx.setEnvironment(ApplicationMaster.access$2500(this.this$0));
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                localResources = new HashMap<String, LocalResource>();
                __cobertura_counters[9] = __cobertura_counters[9] + 1;
                n = 11;
                if (ApplicationMaster.access$2600(this.this$0).isEmpty()) break block30;
                __cobertura_counters[10] = __cobertura_counters[10] + 1;
                n = 0;
                __cobertura_counters[12] = __cobertura_counters[12] + 1;
                FileStatus[] fsStatusList = null;
                try {
                    __cobertura_counters[13] = __cobertura_counters[13] + 1;
                    FileSystem fs = FileSystem.get((Configuration)new YarnConfiguration());
                    __cobertura_counters[14] = __cobertura_counters[14] + 1;
                    fsStatusList = fs.listStatus(new Path(ApplicationMaster.access$2600(this.this$0)));
                }
                catch (IOException iOException) {
                    __cobertura_counters[15] = __cobertura_counters[15] + 1;
                    IOException e2 = iOException;
                    __cobertura_counters[16] = __cobertura_counters[16] + 1;
                    System.out.println("Error when getting resource directory");
                    __cobertura_counters[17] = __cobertura_counters[17] + 1;
                    e2.printStackTrace();
                    __cobertura_counters[18] = __cobertura_counters[18] + 1;
                    n = 20;
                    if (ApplicationMaster.access$2700(this.this$0) != null) {
                        __cobertura_counters[19] = __cobertura_counters[19] + 1;
                        n = 0;
                        __cobertura_counters[21] = __cobertura_counters[21] + 1;
                        ApplicationMaster.access$1200(this.this$0).incrementAndGet();
                        __cobertura_counters[22] = __cobertura_counters[22] + 1;
                        ApplicationMaster.access$1300(this.this$0).incrementAndGet();
                        __cobertura_counters[23] = __cobertura_counters[23] + 1;
                        ApplicationMaster.access$1400(this.this$0).incrementAndGet();
                    } else {
                        int n2 = n;
                        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                        n = 0;
                        __cobertura_counters[24] = __cobertura_counters[24] + 1;
                        ApplicationMaster.access$200(this.this$0).incrementAndGet();
                        __cobertura_counters[25] = __cobertura_counters[25] + 1;
                        ApplicationMaster.access$300(this.this$0).incrementAndGet();
                    }
                    __cobertura_counters[26] = __cobertura_counters[26] + 1;
                    return;
                }
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
                __cobertura_counters[28] = __cobertura_counters[28] + 1;
                n = 30;
                if (fsStatusList == null) break block30;
                __cobertura_counters[29] = __cobertura_counters[29] + 1;
                n = 0;
                n = 32;
                if (fsStatusList.length == 0) break block30;
                __cobertura_counters[31] = __cobertura_counters[31] + 1;
                n = 0;
                __cobertura_counters[33] = __cobertura_counters[33] + 1;
                FileStatus[] arr$ = fsStatusList;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    n = 35;
                    if (i$ >= len$) break;
                    __cobertura_counters[34] = __cobertura_counters[34] + 1;
                    n = 0;
                    FileStatus fsStatus = arr$[i$];
                    __cobertura_counters[37] = __cobertura_counters[37] + 1;
                    String path = fsStatus.getPath().toString();
                    __cobertura_counters[38] = __cobertura_counters[38] + 1;
                    String fileName = path.substring(path.lastIndexOf("/") + 1, path.length());
                    __cobertura_counters[39] = __cobertura_counters[39] + 1;
                    LocalResource fileRsrc = (LocalResource)Records.newRecord(LocalResource.class);
                    __cobertura_counters[40] = __cobertura_counters[40] + 1;
                    fileRsrc.setType(LocalResourceType.FILE);
                    __cobertura_counters[41] = __cobertura_counters[41] + 1;
                    fileRsrc.setVisibility(LocalResourceVisibility.APPLICATION);
                    __cobertura_counters[42] = __cobertura_counters[42] + 1;
                    fileRsrc.setSize(fsStatus.getLen());
                    __cobertura_counters[43] = __cobertura_counters[43] + 1;
                    fileRsrc.setTimestamp(fsStatus.getModificationTime());
                    try {
                        __cobertura_counters[44] = __cobertura_counters[44] + 1;
                        fileRsrc.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(path)));
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        __cobertura_counters[45] = __cobertura_counters[45] + 1;
                        URISyntaxException e3 = uRISyntaxException;
                        __cobertura_counters[46] = __cobertura_counters[46] + 1;
                        System.out.println("Error when trying to use resource file path specified in env, path=" + path);
                        __cobertura_counters[47] = __cobertura_counters[47] + 1;
                        e3.printStackTrace();
                        __cobertura_counters[48] = __cobertura_counters[48] + 1;
                        n = 50;
                        if (ApplicationMaster.access$2700(this.this$0) != null) {
                            __cobertura_counters[49] = __cobertura_counters[49] + 1;
                            n = 0;
                            __cobertura_counters[51] = __cobertura_counters[51] + 1;
                            ApplicationMaster.access$1200(this.this$0).incrementAndGet();
                            __cobertura_counters[52] = __cobertura_counters[52] + 1;
                            ApplicationMaster.access$1300(this.this$0).incrementAndGet();
                            __cobertura_counters[53] = __cobertura_counters[53] + 1;
                            ApplicationMaster.access$1400(this.this$0).incrementAndGet();
                        } else {
                            int n3 = n;
                            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                            n = 0;
                            __cobertura_counters[54] = __cobertura_counters[54] + 1;
                            ApplicationMaster.access$200(this.this$0).incrementAndGet();
                            __cobertura_counters[55] = __cobertura_counters[55] + 1;
                            ApplicationMaster.access$300(this.this$0).incrementAndGet();
                        }
                        __cobertura_counters[56] = __cobertura_counters[56] + 1;
                        return;
                    }
                    __cobertura_counters[57] = __cobertura_counters[57] + 1;
                    __cobertura_counters[58] = __cobertura_counters[58] + 1;
                    localResources.put(fileName, fileRsrc);
                    __cobertura_counters[36] = __cobertura_counters[36] + 1;
                    ++i$;
                }
            }
            int n4 = n;
            __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
            n = 0;
            __cobertura_counters[59] = __cobertura_counters[59] + 1;
            LocalResource glBase = (LocalResource)Records.newRecord(LocalResource.class);
            __cobertura_counters[60] = __cobertura_counters[60] + 1;
            LocalResource virtScript = (LocalResource)Records.newRecord(LocalResource.class);
            __cobertura_counters[61] = __cobertura_counters[61] + 1;
            LocalResource glUserReqs = (LocalResource)Records.newRecord(LocalResource.class);
            __cobertura_counters[62] = __cobertura_counters[62] + 1;
            LocalResource glUsrResources = (LocalResource)Records.newRecord(LocalResource.class);
            __cobertura_counters[63] = __cobertura_counters[63] + 1;
            LocalResource glProdKeylr = (LocalResource)Records.newRecord(LocalResource.class);
            try {
                __cobertura_counters[64] = __cobertura_counters[64] + 1;
                FileSystem fs = FileSystem.get((Configuration)new YarnConfiguration());
                __cobertura_counters[65] = __cobertura_counters[65] + 1;
                n = 67;
                if (!ApplicationMaster.access$2800(this.this$0)) {
                    __cobertura_counters[66] = __cobertura_counters[66] + 1;
                    n = 0;
                    __cobertura_counters[68] = __cobertura_counters[68] + 1;
                    FileStatus fnStatus = fs.getFileStatus(new Path(ApplicationMaster.access$2900(this.this$0)));
                    __cobertura_counters[69] = __cobertura_counters[69] + 1;
                    glBase.setSize(fnStatus.getLen());
                    __cobertura_counters[70] = __cobertura_counters[70] + 1;
                    glBase.setType(LocalResourceType.FILE);
                    __cobertura_counters[71] = __cobertura_counters[71] + 1;
                    glBase.setVisibility(LocalResourceVisibility.APPLICATION);
                    __cobertura_counters[72] = __cobertura_counters[72] + 1;
                    glBase.setTimestamp(fnStatus.getModificationTime());
                    __cobertura_counters[73] = __cobertura_counters[73] + 1;
                    String fnPath = fnStatus.getPath().toString();
                    __cobertura_counters[74] = __cobertura_counters[74] + 1;
                    ApplicationMaster.access$2300().info((Object)("LocalResource path=" + fnPath));
                    __cobertura_counters[75] = __cobertura_counters[75] + 1;
                    glBase.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(fnPath)));
                }
                int n5 = n;
                __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                n = 0;
                __cobertura_counters[76] = __cobertura_counters[76] + 1;
                int lastIndexOf = ApplicationMaster.access$3000(this.this$0).lastIndexOf("/");
                __cobertura_counters[77] = __cobertura_counters[77] + 1;
                String one = ApplicationMaster.access$3000(this.this$0).substring(0, lastIndexOf);
                __cobertura_counters[78] = __cobertura_counters[78] + 1;
                String wrkDir = one.substring(0, one.lastIndexOf("/")) + "/gl_reqs";
                __cobertura_counters[79] = __cobertura_counters[79] + 1;
                FileStatus scriptStat = fs.getFileStatus(new Path(wrkDir + "/gl_create_base_virtenv.sh"));
                __cobertura_counters[80] = __cobertura_counters[80] + 1;
                virtScript.setSize(scriptStat.getLen());
                __cobertura_counters[81] = __cobertura_counters[81] + 1;
                virtScript.setType(LocalResourceType.FILE);
                __cobertura_counters[82] = __cobertura_counters[82] + 1;
                virtScript.setVisibility(LocalResourceVisibility.APPLICATION);
                __cobertura_counters[83] = __cobertura_counters[83] + 1;
                virtScript.setTimestamp(scriptStat.getModificationTime());
                __cobertura_counters[84] = __cobertura_counters[84] + 1;
                ApplicationMaster.access$2300().info((Object)("LocalResource path=" + scriptStat.getPath().toString()));
                __cobertura_counters[85] = __cobertura_counters[85] + 1;
                virtScript.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(scriptStat.getPath().toString())));
                __cobertura_counters[86] = __cobertura_counters[86] + 1;
                n = 88;
                if (ApplicationMaster.access$3100(this.this$0)) {
                    __cobertura_counters[87] = __cobertura_counters[87] + 1;
                    n = 0;
                    __cobertura_counters[89] = __cobertura_counters[89] + 1;
                    FileStatus reqsStat = fs.getFileStatus(new Path(ApplicationMaster.access$3200(this.this$0)));
                    __cobertura_counters[90] = __cobertura_counters[90] + 1;
                    glUserReqs.setSize(reqsStat.getLen());
                    __cobertura_counters[91] = __cobertura_counters[91] + 1;
                    glUserReqs.setType(LocalResourceType.FILE);
                    __cobertura_counters[92] = __cobertura_counters[92] + 1;
                    glUserReqs.setVisibility(LocalResourceVisibility.APPLICATION);
                    __cobertura_counters[93] = __cobertura_counters[93] + 1;
                    glUserReqs.setTimestamp(reqsStat.getModificationTime());
                    __cobertura_counters[94] = __cobertura_counters[94] + 1;
                    ApplicationMaster.access$2300().info((Object)("LocalResource path=" + reqsStat.getPath().toString()));
                    __cobertura_counters[95] = __cobertura_counters[95] + 1;
                    glUserReqs.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(reqsStat.getPath().toString())));
                }
                int n6 = n;
                __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                n = 0;
                __cobertura_counters[96] = __cobertura_counters[96] + 1;
                n = 98;
                if (ApplicationMaster.access$2700(this.this$0) != null) {
                    __cobertura_counters[97] = __cobertura_counters[97] + 1;
                    n = 0;
                    __cobertura_counters[99] = __cobertura_counters[99] + 1;
                    LocalResource taskLR = (LocalResource)Records.newRecord(LocalResource.class);
                    __cobertura_counters[100] = __cobertura_counters[100] + 1;
                    FileStatus taskStat = fs.getFileLinkStatus(new Path(ApplicationMaster.access$2700(this.this$0)));
                    __cobertura_counters[101] = __cobertura_counters[101] + 1;
                    taskLR.setSize(this.this$0.taskLength);
                    __cobertura_counters[102] = __cobertura_counters[102] + 1;
                    taskLR.setTimestamp(this.this$0.taskTimestamp);
                    __cobertura_counters[103] = __cobertura_counters[103] + 1;
                    taskLR.setType(LocalResourceType.ARCHIVE);
                    __cobertura_counters[104] = __cobertura_counters[104] + 1;
                    taskLR.setVisibility(LocalResourceVisibility.APPLICATION);
                    __cobertura_counters[105] = __cobertura_counters[105] + 1;
                    taskLR.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(ApplicationMaster.access$2700(this.this$0))));
                    __cobertura_counters[106] = __cobertura_counters[106] + 1;
                    ApplicationMaster.access$2300().info((Object)("LocalResource path=" + taskStat.getPath().toString()));
                    __cobertura_counters[107] = __cobertura_counters[107] + 1;
                    localResources.put("top_async.zip", taskLR);
                }
                int n7 = n;
                __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                n = 0;
                __cobertura_counters[108] = __cobertura_counters[108] + 1;
                FileStatus resStat = fs.getFileStatus(new Path(ApplicationMaster.access$3000(this.this$0)));
                __cobertura_counters[109] = __cobertura_counters[109] + 1;
                glUsrResources.setSize(resStat.getLen());
                __cobertura_counters[110] = __cobertura_counters[110] + 1;
                glUsrResources.setType(LocalResourceType.FILE);
                __cobertura_counters[111] = __cobertura_counters[111] + 1;
                glUsrResources.setVisibility(LocalResourceVisibility.APPLICATION);
                __cobertura_counters[112] = __cobertura_counters[112] + 1;
                glUsrResources.setTimestamp(resStat.getModificationTime());
                __cobertura_counters[113] = __cobertura_counters[113] + 1;
                ApplicationMaster.access$2300().info((Object)("LocalResource path==" + resStat.getPath().toString()));
                __cobertura_counters[114] = __cobertura_counters[114] + 1;
                glUsrResources.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(resStat.getPath().toString())));
                __cobertura_counters[115] = __cobertura_counters[115] + 1;
                FileStatus pkStat = fs.getFileStatus(new Path(ApplicationMaster.access$3300(this.this$0)));
                __cobertura_counters[116] = __cobertura_counters[116] + 1;
                glProdKeylr.setSize(pkStat.getLen());
                __cobertura_counters[117] = __cobertura_counters[117] + 1;
                glProdKeylr.setType(LocalResourceType.FILE);
                __cobertura_counters[118] = __cobertura_counters[118] + 1;
                glProdKeylr.setVisibility(LocalResourceVisibility.APPLICATION);
                __cobertura_counters[119] = __cobertura_counters[119] + 1;
                glProdKeylr.setTimestamp(pkStat.getModificationTime());
                __cobertura_counters[120] = __cobertura_counters[120] + 1;
                ApplicationMaster.access$2300().info((Object)("LocalResource path=" + pkStat.getPath().toString()));
                __cobertura_counters[121] = __cobertura_counters[121] + 1;
                glProdKeylr.setResource(ConverterUtils.getYarnUrlFromURI((URI)new URI(pkStat.getPath().toString())));
            }
            catch (URISyntaxException uRISyntaxException) {
                __cobertura_counters[122] = __cobertura_counters[122] + 1;
                e = uRISyntaxException;
                __cobertura_counters[123] = __cobertura_counters[123] + 1;
                e.printStackTrace();
                __cobertura_counters[124] = __cobertura_counters[124] + 1;
                n = 126;
                if (ApplicationMaster.access$2700(this.this$0) != null) {
                    __cobertura_counters[125] = __cobertura_counters[125] + 1;
                    n = 0;
                    __cobertura_counters[127] = __cobertura_counters[127] + 1;
                    ApplicationMaster.access$1200(this.this$0).incrementAndGet();
                    __cobertura_counters[128] = __cobertura_counters[128] + 1;
                    ApplicationMaster.access$1300(this.this$0).incrementAndGet();
                    __cobertura_counters[129] = __cobertura_counters[129] + 1;
                    ApplicationMaster.access$1400(this.this$0).incrementAndGet();
                } else {
                    int n8 = n;
                    __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                    n = 0;
                    __cobertura_counters[130] = __cobertura_counters[130] + 1;
                    ApplicationMaster.access$200(this.this$0).incrementAndGet();
                    __cobertura_counters[131] = __cobertura_counters[131] + 1;
                    ApplicationMaster.access$300(this.this$0).incrementAndGet();
                }
                __cobertura_counters[132] = __cobertura_counters[132] + 1;
                return;
            }
            catch (IOException iOException) {
                __cobertura_counters[133] = __cobertura_counters[133] + 1;
                e = iOException;
                __cobertura_counters[134] = __cobertura_counters[134] + 1;
                e.printStackTrace();
            }
            __cobertura_counters[135] = __cobertura_counters[135] + 1;
            __cobertura_counters[136] = __cobertura_counters[136] + 1;
            n = 138;
            if (!ApplicationMaster.access$2800(this.this$0)) {
                __cobertura_counters[137] = __cobertura_counters[137] + 1;
                n = 0;
                __cobertura_counters[139] = __cobertura_counters[139] + 1;
                localResources.put("gl_reqs.tar.gz", glBase);
            }
            int n9 = n;
            __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
            n = 0;
            __cobertura_counters[140] = __cobertura_counters[140] + 1;
            localResources.put("gl_create_base_virtenv.sh", virtScript);
            __cobertura_counters[141] = __cobertura_counters[141] + 1;
            n = 143;
            if (ApplicationMaster.access$3100(this.this$0)) {
                __cobertura_counters[142] = __cobertura_counters[142] + 1;
                n = 0;
                __cobertura_counters[144] = __cobertura_counters[144] + 1;
                localResources.put("UserPythonDep.tar.gz", glUserReqs);
            }
            int n10 = n;
            __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
            n = 0;
            __cobertura_counters[145] = __cobertura_counters[145] + 1;
            localResources.put("UserResources.tar.gz", glUsrResources);
            __cobertura_counters[146] = __cobertura_counters[146] + 1;
            localResources.put("product_key", glProdKeylr);
            __cobertura_counters[147] = __cobertura_counters[147] + 1;
            ctx.setLocalResources(localResources);
            __cobertura_counters[148] = __cobertura_counters[148] + 1;
            Vector<String> vargs = new Vector<String>(5);
            __cobertura_counters[149] = __cobertura_counters[149] + 1;
            vargs.add(ApplicationMaster.access$3400(this.this$0));
            __cobertura_counters[150] = __cobertura_counters[150] + 1;
            n = 152;
            if (!ApplicationMaster.access$3500(this.this$0).isEmpty()) {
                String string;
                __cobertura_counters[151] = __cobertura_counters[151] + 1;
                n = 0;
                __cobertura_counters[153] = __cobertura_counters[153] + 1;
                n = 155;
                if (Shell.WINDOWS) {
                    __cobertura_counters[154] = __cobertura_counters[154] + 1;
                    n = 0;
                    string = ApplicationMaster.ExecBatScripStringtPath;
                } else {
                    int n11 = n;
                    __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                    n = 0;
                    string = ApplicationMaster.ExecShellStringPath;
                }
                vargs.add(string);
            }
            int n12 = n;
            __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
            n = 0;
            __cobertura_counters[156] = __cobertura_counters[156] + 1;
            StringBuffer giantCommand = new StringBuffer();
            __cobertura_counters[157] = __cobertura_counters[157] + 1;
            giantCommand.append("/bin/bash gl_create_base_virtenv.sh ");
            __cobertura_counters[158] = __cobertura_counters[158] + 1;
            n = 160;
            if (ApplicationMaster.access$3100(this.this$0)) {
                __cobertura_counters[159] = __cobertura_counters[159] + 1;
                n = 0;
                __cobertura_counters[161] = __cobertura_counters[161] + 1;
                giantCommand.append(" -d ");
            }
            int n13 = n;
            __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
            n = 0;
            __cobertura_counters[162] = __cobertura_counters[162] + 1;
            n = 164;
            if (ApplicationMaster.access$3600(this.this$0)) {
                __cobertura_counters[163] = __cobertura_counters[163] + 1;
                n = 0;
                __cobertura_counters[165] = __cobertura_counters[165] + 1;
                giantCommand.append(" -c " + ApplicationMaster.access$3700(this.this$0) + " ");
            }
            int n14 = n;
            __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
            n = 0;
            __cobertura_counters[166] = __cobertura_counters[166] + 1;
            n = 168;
            if (ApplicationMaster.access$2800(this.this$0)) {
                __cobertura_counters[167] = __cobertura_counters[167] + 1;
                n = 0;
                __cobertura_counters[169] = __cobertura_counters[169] + 1;
                giantCommand.append(" -n native");
            } else {
                int n15 = n;
                __cobertura_counters[n15] = __cobertura_counters[n15] + 1;
                n = 0;
                __cobertura_counters[170] = __cobertura_counters[170] + 1;
                giantCommand.append(" -n hdfs ");
            }
            __cobertura_counters[171] = __cobertura_counters[171] + 1;
            n = 173;
            if (ApplicationMaster.access$2700(this.this$0) != null) {
                __cobertura_counters[172] = __cobertura_counters[172] + 1;
                n = 0;
                __cobertura_counters[174] = __cobertura_counters[174] + 1;
                giantCommand.append(" -a -g " + ApplicationMaster.access$3800(this.this$0) + " -t " + ApplicationMaster.access$3900(this.this$0)[ApplicationMaster.access$1900(this.this$0).getAndIncrement()]);
            }
            int n16 = n;
            __cobertura_counters[n16] = __cobertura_counters[n16] + 1;
            n = 0;
            __cobertura_counters[175] = __cobertura_counters[175] + 1;
            n = 177;
            if (ApplicationMaster.access$4000(this.this$0) != null) {
                __cobertura_counters[176] = __cobertura_counters[176] + 1;
                n = 0;
                __cobertura_counters[178] = __cobertura_counters[178] + 1;
                giantCommand.append(" -x '" + ApplicationMaster.access$4000(this.this$0) + "' ");
            }
            int n17 = n;
            __cobertura_counters[n17] = __cobertura_counters[n17] + 1;
            n = 0;
            __cobertura_counters[179] = __cobertura_counters[179] + 1;
            giantCommand.append(" -s " + ApplicationMaster.access$4100(this.this$0) + " &>" + "<LOG_DIR>" + "/gl_log");
            __cobertura_counters[180] = __cobertura_counters[180] + 1;
            vargs.add(ApplicationMaster.access$4200(this.this$0));
            __cobertura_counters[181] = __cobertura_counters[181] + 1;
            vargs.add("1>/tmp/stdout");
            __cobertura_counters[182] = __cobertura_counters[182] + 1;
            vargs.add("2>/tmp/stderr");
            __cobertura_counters[183] = __cobertura_counters[183] + 1;
            StringBuilder command = new StringBuilder();
            __cobertura_counters[184] = __cobertura_counters[184] + 1;
            Iterator i$ = vargs.iterator();
            while (true) {
                n = 186;
                if (!i$.hasNext()) break;
                __cobertura_counters[185] = __cobertura_counters[185] + 1;
                n = 0;
                CharSequence str = (CharSequence)i$.next();
                __cobertura_counters[187] = __cobertura_counters[187] + 1;
                command.append(str).append(" ");
                __cobertura_counters[188] = __cobertura_counters[188] + 1;
            }
            int n18 = n;
            __cobertura_counters[n18] = __cobertura_counters[n18] + 1;
            n = 0;
            __cobertura_counters[189] = __cobertura_counters[189] + 1;
            ArrayList<String> commands = new ArrayList<String>();
            __cobertura_counters[190] = __cobertura_counters[190] + 1;
            commands.add(giantCommand.toString());
            __cobertura_counters[191] = __cobertura_counters[191] + 1;
            ctx.setCommands(commands);
            __cobertura_counters[192] = __cobertura_counters[192] + 1;
            Iterator i$2 = ctx.getCommands().iterator();
            while (true) {
                n = 194;
                if (!i$2.hasNext()) break;
                __cobertura_counters[193] = __cobertura_counters[193] + 1;
                n = 0;
                String cmd = (String)i$2.next();
                __cobertura_counters[195] = __cobertura_counters[195] + 1;
                System.out.println("ctx.commands=" + cmd);
                __cobertura_counters[196] = __cobertura_counters[196] + 1;
            }
            int n19 = n;
            __cobertura_counters[n19] = __cobertura_counters[n19] + 1;
            n = 0;
            __cobertura_counters[197] = __cobertura_counters[197] + 1;
            ctx.setTokens(ApplicationMaster.access$4300(this.this$0).duplicate());
            __cobertura_counters[198] = __cobertura_counters[198] + 1;
            this.containerListener.addContainer(this.container.getId(), this.container);
            __cobertura_counters[199] = __cobertura_counters[199] + 1;
            ApplicationMaster.access$2400(this.this$0).startContainerAsync(this.container, ctx);
            __cobertura_counters[200] = __cobertura_counters[200] + 1;
        }

        static {
            LaunchContainerRunnable.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[201];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/ApplicationMaster$LaunchContainerRunnable");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1154, 1, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Lorg/apache/hadoop/yarn/api/records/Container;Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler;)V");
            lightClassmapListener2.putLineTouchPoint(1155, 2, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Lorg/apache/hadoop/yarn/api/records/Container;Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler;)V");
            lightClassmapListener2.putLineTouchPoint(1156, 3, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Lorg/apache/hadoop/yarn/api/records/Container;Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler;)V");
            lightClassmapListener2.putLineTouchPoint(1157, 4, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Lorg/apache/hadoop/yarn/api/records/Container;Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler;)V");
            lightClassmapListener2.putLineTouchPoint(1166, 5, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1168, 6, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1172, 7, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1175, 8, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1178, 9, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1178, 11, 10);
            lightClassmapListener2.putLineTouchPoint(1179, 12, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1181, 13, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1182, 14, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1185, 15, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1186, 16, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1187, 17, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1190, 18, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1190, 20, 19);
            lightClassmapListener2.putLineTouchPoint(1191, 21, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1192, 22, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1193, 23, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1196, 24, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1197, 25, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1201, 26, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1202, 27, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1205, 28, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1205, 30, 29);
            lightClassmapListener2.putJumpTouchPoint(1205, 32, 31);
            lightClassmapListener2.putLineTouchPoint(1206, 33, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1206, 35, 34);
            lightClassmapListener2.putLineTouchPoint(1206, 36, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1207, 37, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1208, 38, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1209, 39, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1210, 40, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1211, 41, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1212, 42, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1213, 43, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1215, 44, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1216, 45, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1217, 46, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1219, 47, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1225, 48, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1225, 50, 49);
            lightClassmapListener2.putLineTouchPoint(1226, 51, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1227, 52, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1228, 53, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1232, 54, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1233, 55, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1235, 56, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1236, 57, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1237, 58, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1243, 59, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1244, 60, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1245, 61, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1246, 62, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1247, 63, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1250, 64, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1251, 65, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1251, 67, 66);
            lightClassmapListener2.putLineTouchPoint(1253, 68, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1255, 69, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1256, 70, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1257, 71, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1258, 72, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1259, 73, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1260, 74, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1261, 75, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1267, 76, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1268, 77, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1269, 78, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1272, 79, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1273, 80, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1274, 81, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1275, 82, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1276, 83, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1277, 84, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1278, 85, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1280, 86, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1280, 88, 87);
            lightClassmapListener2.putLineTouchPoint(1281, 89, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1282, 90, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1283, 91, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1284, 92, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1285, 93, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1286, 94, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1287, 95, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1290, 96, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1290, 98, 97);
            lightClassmapListener2.putLineTouchPoint(1291, 99, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1292, 100, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1293, 101, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1294, 102, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1295, 103, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1296, 104, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1297, 105, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1298, 106, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1299, 107, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1303, 108, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1304, 109, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1305, 110, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1306, 111, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1307, 112, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1308, 113, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1309, 114, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1311, 115, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1312, 116, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1313, 117, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1314, 118, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1315, 119, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1316, 120, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1317, 121, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1319, 122, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1320, 123, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1326, 124, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1326, 126, 125);
            lightClassmapListener2.putLineTouchPoint(1327, 127, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1328, 128, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1329, 129, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1333, 130, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1334, 131, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1336, 132, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1337, 133, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1339, 134, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1340, 135, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1343, 136, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1343, 138, 137);
            lightClassmapListener2.putLineTouchPoint(1344, 139, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1346, 140, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1347, 141, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1347, 143, 142);
            lightClassmapListener2.putLineTouchPoint(1348, 144, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1351, 145, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1352, 146, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1353, 147, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1356, 148, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1359, 149, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1361, 150, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1361, 152, 151);
            lightClassmapListener2.putLineTouchPoint(1362, 153, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1362, 155, 154);
            lightClassmapListener2.putLineTouchPoint(1366, 156, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1368, 157, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1374, 158, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1374, 160, 159);
            lightClassmapListener2.putLineTouchPoint(1375, 161, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1378, 162, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1378, 164, 163);
            lightClassmapListener2.putLineTouchPoint(1379, 165, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1383, 166, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1383, 168, 167);
            lightClassmapListener2.putLineTouchPoint(1384, 169, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1387, 170, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1390, 171, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1390, 173, 172);
            lightClassmapListener2.putLineTouchPoint(1391, 174, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1394, 175, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1394, 177, 176);
            lightClassmapListener2.putLineTouchPoint(1395, 178, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1398, 179, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1402, 180, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1404, 181, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1405, 182, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1408, 183, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1409, 184, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1409, 186, 185);
            lightClassmapListener2.putLineTouchPoint(1410, 187, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1411, 188, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1413, 189, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1414, 190, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1417, 191, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1418, 192, "run", "()V");
            lightClassmapListener2.putJumpTouchPoint(1418, 194, 193);
            lightClassmapListener2.putLineTouchPoint(1419, 195, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1420, 196, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1428, 197, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1430, 198, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1431, 199, "run", "()V");
            lightClassmapListener2.putLineTouchPoint(1432, 200, "run", "()V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/ApplicationMaster$LaunchContainerRunnable");
            lightClassmapListener2.setSource("ApplicationMaster.java");
            LaunchContainerRunnable.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    @VisibleForTesting
    static class NMCallbackHandler
    implements NMClientAsync.CallbackHandler {
        public static final transient int[] __cobertura_counters;
        private ConcurrentMap<ContainerId, Container> containers;
        private final ApplicationMaster applicationMaster;

        /*
         * WARNING - void declaration
         */
        public NMCallbackHandler(ApplicationMaster applicationMaster) {
            void applicationMaster2;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.containers = new ConcurrentHashMap<ContainerId, Container>();
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
            this.applicationMaster = applicationMaster2;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void addContainer(ContainerId containerId, Container container) {
            void container2;
            void containerId2;
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            this.containers.putIfAbsent((ContainerId)containerId2, (Container)container2);
            __cobertura_counters[6] = __cobertura_counters[6] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainerStopped(ContainerId containerId) {
            void containerId2;
            int n = 0;
            __cobertura_counters[7] = __cobertura_counters[7] + 1;
            n = 9;
            if (ApplicationMaster.access$2300().isDebugEnabled()) {
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                n = 0;
                __cobertura_counters[10] = __cobertura_counters[10] + 1;
                System.out.println("Succeeded to stop Container " + containerId2);
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[11] = __cobertura_counters[11] + 1;
            this.containers.remove(containerId2);
            __cobertura_counters[12] = __cobertura_counters[12] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainerStatusReceived(ContainerId containerId, ContainerStatus containerStatus) {
            int n = 0;
            __cobertura_counters[13] = __cobertura_counters[13] + 1;
            n = 15;
            if (ApplicationMaster.access$2300().isDebugEnabled()) {
                void containerStatus2;
                void containerId2;
                __cobertura_counters[14] = __cobertura_counters[14] + 1;
                n = 0;
                __cobertura_counters[16] = __cobertura_counters[16] + 1;
                System.out.println("Container Status: id=" + containerId2 + ", status=" + containerStatus2);
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[17] = __cobertura_counters[17] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainerStarted(ContainerId containerId, Map<String, ByteBuffer> map) {
            void containerId2;
            int n = 0;
            __cobertura_counters[18] = __cobertura_counters[18] + 1;
            n = 20;
            if (ApplicationMaster.access$2300().isDebugEnabled()) {
                __cobertura_counters[19] = __cobertura_counters[19] + 1;
                n = 0;
                __cobertura_counters[21] = __cobertura_counters[21] + 1;
                System.out.println("Succeeded to start Container " + containerId2);
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[22] = __cobertura_counters[22] + 1;
            Container container = (Container)this.containers.get(containerId2);
            __cobertura_counters[23] = __cobertura_counters[23] + 1;
            n = 25;
            if (container != null) {
                __cobertura_counters[24] = __cobertura_counters[24] + 1;
                n = 0;
                __cobertura_counters[26] = __cobertura_counters[26] + 1;
                ApplicationMaster.access$2400(this.applicationMaster).getContainerStatusAsync((ContainerId)containerId2, container.getNodeId());
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[27] = __cobertura_counters[27] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onStartContainerError(ContainerId containerId, Throwable throwable) {
            void containerId2;
            int n = 0;
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
            System.out.println("Failed to start Container " + containerId2);
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            this.containers.remove(containerId2);
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            ApplicationMaster.access$200(this.applicationMaster).incrementAndGet();
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            ApplicationMaster.access$300(this.applicationMaster).incrementAndGet();
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onGetContainerStatusError(ContainerId containerId, Throwable throwable) {
            void containerId2;
            int n = 0;
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            System.out.println("Failed to query the status of Container " + containerId2);
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onStopContainerError(ContainerId containerId, Throwable throwable) {
            void containerId2;
            int n = 0;
            __cobertura_counters[35] = __cobertura_counters[35] + 1;
            System.out.println("Failed to stop Container " + containerId2);
            __cobertura_counters[36] = __cobertura_counters[36] + 1;
            this.containers.remove(containerId2);
            __cobertura_counters[37] = __cobertura_counters[37] + 1;
        }

        static {
            NMCallbackHandler.__cobertura_init();
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[38];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(1076, 1, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)V");
            lightClassmapListener2.putLineTouchPoint(1080, 2, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)V");
            lightClassmapListener2.putLineTouchPoint(1081, 3, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)V");
            lightClassmapListener2.putLineTouchPoint(1082, 4, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)V");
            lightClassmapListener2.putLineTouchPoint(1085, 5, "addContainer", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Lorg/apache/hadoop/yarn/api/records/Container;)V");
            lightClassmapListener2.putLineTouchPoint(1086, 6, "addContainer", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Lorg/apache/hadoop/yarn/api/records/Container;)V");
            lightClassmapListener2.putLineTouchPoint(1090, 7, "onContainerStopped", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;)V");
            lightClassmapListener2.putJumpTouchPoint(1090, 9, 8);
            lightClassmapListener2.putLineTouchPoint(1091, 10, "onContainerStopped", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;)V");
            lightClassmapListener2.putLineTouchPoint(1093, 11, "onContainerStopped", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;)V");
            lightClassmapListener2.putLineTouchPoint(1094, 12, "onContainerStopped", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;)V");
            lightClassmapListener2.putLineTouchPoint(1099, 13, "onContainerStatusReceived", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Lorg/apache/hadoop/yarn/api/records/ContainerStatus;)V");
            lightClassmapListener2.putJumpTouchPoint(1099, 15, 14);
            lightClassmapListener2.putLineTouchPoint(1100, 16, "onContainerStatusReceived", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Lorg/apache/hadoop/yarn/api/records/ContainerStatus;)V");
            lightClassmapListener2.putLineTouchPoint(1103, 17, "onContainerStatusReceived", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Lorg/apache/hadoop/yarn/api/records/ContainerStatus;)V");
            lightClassmapListener2.putLineTouchPoint(1108, 18, "onContainerStarted", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/util/Map;)V");
            lightClassmapListener2.putJumpTouchPoint(1108, 20, 19);
            lightClassmapListener2.putLineTouchPoint(1109, 21, "onContainerStarted", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/util/Map;)V");
            lightClassmapListener2.putLineTouchPoint(1111, 22, "onContainerStarted", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/util/Map;)V");
            lightClassmapListener2.putLineTouchPoint(1112, 23, "onContainerStarted", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/util/Map;)V");
            lightClassmapListener2.putJumpTouchPoint(1112, 25, 24);
            lightClassmapListener2.putLineTouchPoint(1113, 26, "onContainerStarted", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/util/Map;)V");
            lightClassmapListener2.putLineTouchPoint(1115, 27, "onContainerStarted", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/util/Map;)V");
            lightClassmapListener2.putLineTouchPoint(1119, 28, "onStartContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1120, 29, "onStartContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1121, 30, "onStartContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1122, 31, "onStartContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1123, 32, "onStartContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1128, 33, "onGetContainerStatusError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1129, 34, "onGetContainerStatusError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1133, 35, "onStopContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1134, 36, "onStopContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1135, 37, "onStopContainerError", "(Lorg/apache/hadoop/yarn/api/records/ContainerId;Ljava/lang/Throwable;)V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/ApplicationMaster$NMCallbackHandler");
            lightClassmapListener2.setSource("ApplicationMaster.java");
            NMCallbackHandler.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private class ArtifactRMCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        public static final transient int[] __cobertura_counters;
        final /* synthetic */ ApplicationMaster this$0;

        private ArtifactRMCallbackHandler(ApplicationMaster applicationMaster) {
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.this$0 = applicationMaster;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainersCompleted(List<ContainerStatus> list) {
            void completedContainers;
            int n = 0;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            System.out.println("Got response from RM for container ask, completedCnt=" + completedContainers.size());
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            Iterator i$ = completedContainers.iterator();
            while (true) {
                n = 7;
                if (!i$.hasNext()) break;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                n = 0;
                ContainerStatus containerStatus = (ContainerStatus)i$.next();
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                System.out.println("Got container status for containerID=" + containerStatus.getContainerId() + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + containerStatus.getDiagnostics());
                __cobertura_counters[9] = __cobertura_counters[9] + 1;
                n = 11;
                if (!$assertionsDisabled) {
                    __cobertura_counters[10] = __cobertura_counters[10] + 1;
                    n = 0;
                    n = 13;
                    if (containerStatus.getState() != ContainerState.COMPLETE) {
                        __cobertura_counters[12] = __cobertura_counters[12] + 1;
                        n = 0;
                        throw new AssertionError();
                    }
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[14] = __cobertura_counters[14] + 1;
                int exitStatus = containerStatus.getExitStatus();
                __cobertura_counters[15] = __cobertura_counters[15] + 1;
                n = 17;
                if (0 != exitStatus) {
                    __cobertura_counters[16] = __cobertura_counters[16] + 1;
                    n = 0;
                    __cobertura_counters[18] = __cobertura_counters[18] + 1;
                    n = 20;
                    if (-100 != exitStatus) {
                        __cobertura_counters[19] = __cobertura_counters[19] + 1;
                        n = 0;
                        __cobertura_counters[21] = __cobertura_counters[21] + 1;
                        ApplicationMaster.access$1200(this.this$0).incrementAndGet();
                        __cobertura_counters[22] = __cobertura_counters[22] + 1;
                        ApplicationMaster.access$1300(this.this$0).incrementAndGet();
                        __cobertura_counters[23] = __cobertura_counters[23] + 1;
                        ApplicationMaster.access$1400(this.this$0).incrementAndGet();
                        __cobertura_counters[24] = __cobertura_counters[24] + 1;
                        System.out.println("container failed, not gonna retry.  incremending totalcompletedthisstage,failedthisstage,failedallstages\ntotalCompletedThisStage=" + ApplicationMaster.access$1200(this.this$0) + "\ntotalFailedThisStage=" + ApplicationMaster.access$1300(this.this$0) + "\ntotalFailedAllStages=" + ApplicationMaster.access$1400(this.this$0));
                    } else {
                        int n3 = n;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n = 0;
                        __cobertura_counters[25] = __cobertura_counters[25] + 1;
                        System.out.println("decrementing totalAllocatedContainersInStage and totalRequestedThisStage, b/c killed by framework");
                        __cobertura_counters[26] = __cobertura_counters[26] + 1;
                        ApplicationMaster.access$1500(this.this$0).decrementAndGet();
                        __cobertura_counters[27] = __cobertura_counters[27] + 1;
                        ApplicationMaster.access$1600(this.this$0).decrementAndGet();
                    }
                } else {
                    int n4 = n;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n = 0;
                    __cobertura_counters[28] = __cobertura_counters[28] + 1;
                    ApplicationMaster.access$1200(this.this$0).incrementAndGet();
                    __cobertura_counters[29] = __cobertura_counters[29] + 1;
                    System.out.println("Container completed successfully., containerId=" + containerStatus.getContainerId());
                }
                __cobertura_counters[30] = __cobertura_counters[30] + 1;
            }
            int n5 = n;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n = 0;
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            System.out.println("totalContainersInStage:" + ApplicationMaster.access$1700(this.this$0) + " - totalRequestedThisStage:" + ApplicationMaster.access$1600(this.this$0));
            __cobertura_counters[32] = __cobertura_counters[32] + 1;
            int askCount = ApplicationMaster.access$1700(this.this$0).get() - ApplicationMaster.access$1600(this.this$0).get();
            __cobertura_counters[33] = __cobertura_counters[33] + 1;
            ApplicationMaster.access$1600(this.this$0).addAndGet(askCount);
            __cobertura_counters[34] = __cobertura_counters[34] + 1;
            n = 36;
            if (askCount > 0) {
                __cobertura_counters[35] = __cobertura_counters[35] + 1;
                n = 0;
                __cobertura_counters[37] = __cobertura_counters[37] + 1;
                System.out.println("asking for " + askCount + " more containers");
                __cobertura_counters[38] = __cobertura_counters[38] + 1;
                int i = 0;
                while (true) {
                    n = 40;
                    if (i >= askCount) break;
                    __cobertura_counters[39] = __cobertura_counters[39] + 1;
                    n = 0;
                    __cobertura_counters[42] = __cobertura_counters[42] + 1;
                    AMRMClient.ContainerRequest containerAsk = ApplicationMaster.access$700(this.this$0);
                    __cobertura_counters[43] = __cobertura_counters[43] + 1;
                    ApplicationMaster.access$800(this.this$0).addContainerRequest(containerAsk);
                    __cobertura_counters[41] = __cobertura_counters[41] + 1;
                    ++i;
                }
            }
            int n6 = n;
            __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
            n = 0;
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            n = 46;
            if (ApplicationMaster.access$1200(this.this$0).get() == ApplicationMaster.access$1700(this.this$0).get()) {
                __cobertura_counters[45] = __cobertura_counters[45] + 1;
                n = 0;
                __cobertura_counters[47] = __cobertura_counters[47] + 1;
                ApplicationMaster.access$1802(this.this$0, true);
                __cobertura_counters[48] = __cobertura_counters[48] + 1;
                ApplicationMaster.access$1900(this.this$0).set(0);
            }
            int n7 = n;
            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
            n = 0;
            __cobertura_counters[49] = __cobertura_counters[49] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainersAllocated(List<Container> list) {
            void allocatedContainers;
            int n = 0;
            __cobertura_counters[50] = __cobertura_counters[50] + 1;
            System.out.println("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size());
            __cobertura_counters[51] = __cobertura_counters[51] + 1;
            ApplicationMaster.access$1500(this.this$0).addAndGet(allocatedContainers.size());
            __cobertura_counters[52] = __cobertura_counters[52] + 1;
            Iterator i$ = allocatedContainers.iterator();
            while (true) {
                n = 54;
                if (!i$.hasNext()) break;
                __cobertura_counters[53] = __cobertura_counters[53] + 1;
                n = 0;
                Container allocatedContainer = (Container)i$.next();
                __cobertura_counters[55] = __cobertura_counters[55] + 1;
                System.out.println("Launching shell command on a new container., containerId=" + allocatedContainer.getId() + ", containerNode=" + allocatedContainer.getNodeId().getHost() + ":" + allocatedContainer.getNodeId().getPort() + ", containerNodeURI=" + allocatedContainer.getNodeHttpAddress() + ", containerResourceMemory" + allocatedContainer.getResource().getMemory() + ", containerResourceVirtualCores" + allocatedContainer.getResource().getVirtualCores());
                __cobertura_counters[56] = __cobertura_counters[56] + 1;
                LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(this.this$0, allocatedContainer, ApplicationMaster.access$1000(this.this$0));
                __cobertura_counters[57] = __cobertura_counters[57] + 1;
                Thread launchThread = new Thread(runnableLaunchContainer);
                __cobertura_counters[58] = __cobertura_counters[58] + 1;
                ApplicationMaster.access$2000(this.this$0).add(launchThread);
                __cobertura_counters[59] = __cobertura_counters[59] + 1;
                launchThread.start();
                __cobertura_counters[60] = __cobertura_counters[60] + 1;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[61] = __cobertura_counters[61] + 1;
        }

        public void onShutdownRequest() {
            int n = 0;
            __cobertura_counters[62] = __cobertura_counters[62] + 1;
            ApplicationMaster.access$902(this.this$0, true);
            __cobertura_counters[63] = __cobertura_counters[63] + 1;
        }

        public void onNodesUpdated(List<NodeReport> list) {
            int n = 0;
            __cobertura_counters[64] = __cobertura_counters[64] + 1;
        }

        public float getProgress() {
            int n = 0;
            __cobertura_counters[65] = __cobertura_counters[65] + 1;
            float progress = (float)ApplicationMaster.access$2100(this.this$0).get() / (float)ApplicationMaster.access$2200(this.this$0).get();
            __cobertura_counters[66] = __cobertura_counters[66] + 1;
            return progress;
        }

        public void onError(Throwable throwable) {
            int n = 0;
            __cobertura_counters[67] = __cobertura_counters[67] + 1;
            ApplicationMaster.access$902(this.this$0, true);
            __cobertura_counters[68] = __cobertura_counters[68] + 1;
            ApplicationMaster.access$800(this.this$0).stop();
            __cobertura_counters[69] = __cobertura_counters[69] + 1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ ArtifactRMCallbackHandler(ApplicationMaster applicationMaster, 1 var2_2) {
            void x0;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this((ApplicationMaster)x0);
        }

        static {
            ArtifactRMCallbackHandler.__cobertura_init();
            int n = 0;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[70];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/ApplicationMaster$ArtifactRMCallbackHandler");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(948, 1, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)V");
            lightClassmapListener2.putLineTouchPoint(948, 2, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$1;)V");
            lightClassmapListener2.putLineTouchPoint(948, 3, "<clinit>", "()V");
            lightClassmapListener2.putLineTouchPoint(954, 4, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(956, 5, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(956, 7, 6);
            lightClassmapListener2.putLineTouchPoint(957, 8, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(964, 9, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(964, 11, 10);
            lightClassmapListener2.putJumpTouchPoint(964, 13, 12);
            lightClassmapListener2.putLineTouchPoint(967, 14, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(968, 15, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(968, 17, 16);
            lightClassmapListener2.putLineTouchPoint(970, 18, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(970, 20, 19);
            lightClassmapListener2.putLineTouchPoint(973, 21, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(974, 22, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(975, 23, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(976, 24, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(984, 25, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(985, 26, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(986, 27, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(993, 28, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(994, 29, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(997, 30, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1000, 31, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1003, 32, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1004, 33, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1006, 34, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(1006, 36, 35);
            lightClassmapListener2.putLineTouchPoint(1007, 37, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1008, 38, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(1008, 40, 39);
            lightClassmapListener2.putLineTouchPoint(1008, 41, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1009, 42, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1010, 43, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1014, 44, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(1014, 46, 45);
            lightClassmapListener2.putLineTouchPoint(1015, 47, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1016, 48, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1018, 49, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1022, 50, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1024, 51, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1025, 52, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(1025, 54, 53);
            lightClassmapListener2.putLineTouchPoint(1026, 55, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1038, 56, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1040, 57, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1045, 58, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1046, 59, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1047, 60, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1048, 61, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1052, 62, "onShutdownRequest", "()V");
            lightClassmapListener2.putLineTouchPoint(1053, 63, "onShutdownRequest", "()V");
            lightClassmapListener2.putLineTouchPoint(1056, 64, "onNodesUpdated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(1061, 65, "getProgress", "()F");
            lightClassmapListener2.putLineTouchPoint(1062, 66, "getProgress", "()F");
            lightClassmapListener2.putLineTouchPoint(1067, 67, "onError", "(Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1068, 68, "onError", "(Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(1069, 69, "onError", "(Ljava/lang/Throwable;)V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/ApplicationMaster$ArtifactRMCallbackHandler");
            lightClassmapListener2.setSource("ApplicationMaster.java");
            ArtifactRMCallbackHandler.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private class RMCallbackHandler
    implements AMRMClientAsync.CallbackHandler {
        public static final transient int[] __cobertura_counters;
        final /* synthetic */ ApplicationMaster this$0;

        private RMCallbackHandler(ApplicationMaster applicationMaster) {
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            this.this$0 = applicationMaster;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainersCompleted(List<ContainerStatus> list) {
            void completedContainers;
            int n = 0;
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            System.out.println("Got response from RM for container ask, completedCnt=" + completedContainers.size());
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            Iterator i$ = completedContainers.iterator();
            while (true) {
                n = 7;
                if (!i$.hasNext()) break;
                __cobertura_counters[6] = __cobertura_counters[6] + 1;
                n = 0;
                ContainerStatus containerStatus = (ContainerStatus)i$.next();
                __cobertura_counters[8] = __cobertura_counters[8] + 1;
                System.out.println("Got container status for containerID=" + containerStatus.getContainerId() + ", state=" + containerStatus.getState() + ", exitStatus=" + containerStatus.getExitStatus() + ", diagnostics=" + containerStatus.getDiagnostics());
                __cobertura_counters[9] = __cobertura_counters[9] + 1;
                n = 11;
                if (!$assertionsDisabled) {
                    __cobertura_counters[10] = __cobertura_counters[10] + 1;
                    n = 0;
                    n = 13;
                    if (containerStatus.getState() != ContainerState.COMPLETE) {
                        __cobertura_counters[12] = __cobertura_counters[12] + 1;
                        n = 0;
                        throw new AssertionError();
                    }
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[14] = __cobertura_counters[14] + 1;
                int exitStatus = containerStatus.getExitStatus();
                __cobertura_counters[15] = __cobertura_counters[15] + 1;
                n = 17;
                if (0 != exitStatus) {
                    __cobertura_counters[16] = __cobertura_counters[16] + 1;
                    n = 0;
                    __cobertura_counters[18] = __cobertura_counters[18] + 1;
                    n = 20;
                    if (-100 != exitStatus) {
                        __cobertura_counters[19] = __cobertura_counters[19] + 1;
                        n = 0;
                        __cobertura_counters[21] = __cobertura_counters[21] + 1;
                        ApplicationMaster.access$200(this.this$0).incrementAndGet();
                        __cobertura_counters[22] = __cobertura_counters[22] + 1;
                        ApplicationMaster.access$300(this.this$0).incrementAndGet();
                    } else {
                        int n3 = n;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n = 0;
                        __cobertura_counters[23] = __cobertura_counters[23] + 1;
                        ApplicationMaster.access$400(this.this$0).decrementAndGet();
                        __cobertura_counters[24] = __cobertura_counters[24] + 1;
                        ApplicationMaster.access$500(this.this$0).decrementAndGet();
                    }
                } else {
                    int n4 = n;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n = 0;
                    __cobertura_counters[25] = __cobertura_counters[25] + 1;
                    ApplicationMaster.access$200(this.this$0).incrementAndGet();
                    __cobertura_counters[26] = __cobertura_counters[26] + 1;
                    System.out.println("Container completed successfully., containerId=" + containerStatus.getContainerId());
                }
                __cobertura_counters[27] = __cobertura_counters[27] + 1;
            }
            int n5 = n;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n = 0;
            __cobertura_counters[28] = __cobertura_counters[28] + 1;
            int askCount = ApplicationMaster.access$600(this.this$0) - ApplicationMaster.access$500(this.this$0).get();
            __cobertura_counters[29] = __cobertura_counters[29] + 1;
            ApplicationMaster.access$500(this.this$0).addAndGet(askCount);
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            n = 32;
            if (askCount > 0) {
                __cobertura_counters[31] = __cobertura_counters[31] + 1;
                n = 0;
                __cobertura_counters[33] = __cobertura_counters[33] + 1;
                int i = 0;
                while (true) {
                    n = 35;
                    if (i >= askCount) break;
                    __cobertura_counters[34] = __cobertura_counters[34] + 1;
                    n = 0;
                    __cobertura_counters[37] = __cobertura_counters[37] + 1;
                    AMRMClient.ContainerRequest containerAsk = ApplicationMaster.access$700(this.this$0);
                    __cobertura_counters[38] = __cobertura_counters[38] + 1;
                    ApplicationMaster.access$800(this.this$0).addContainerRequest(containerAsk);
                    __cobertura_counters[36] = __cobertura_counters[36] + 1;
                    ++i;
                }
            }
            int n6 = n;
            __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
            n = 0;
            __cobertura_counters[39] = __cobertura_counters[39] + 1;
            n = 41;
            if (ApplicationMaster.access$200(this.this$0).get() == ApplicationMaster.access$600(this.this$0)) {
                __cobertura_counters[40] = __cobertura_counters[40] + 1;
                n = 0;
                __cobertura_counters[42] = __cobertura_counters[42] + 1;
                ApplicationMaster.access$902(this.this$0, true);
            }
            int n7 = n;
            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
            n = 0;
            __cobertura_counters[43] = __cobertura_counters[43] + 1;
        }

        /*
         * WARNING - void declaration
         */
        public void onContainersAllocated(List<Container> list) {
            void allocatedContainers;
            int n = 0;
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            System.out.println("Got response from RM for container ask, allocatedCnt=" + allocatedContainers.size());
            __cobertura_counters[45] = __cobertura_counters[45] + 1;
            ApplicationMaster.access$400(this.this$0).addAndGet(allocatedContainers.size());
            __cobertura_counters[46] = __cobertura_counters[46] + 1;
            Iterator i$ = allocatedContainers.iterator();
            while (true) {
                n = 48;
                if (!i$.hasNext()) break;
                __cobertura_counters[47] = __cobertura_counters[47] + 1;
                n = 0;
                Container allocatedContainer = (Container)i$.next();
                __cobertura_counters[49] = __cobertura_counters[49] + 1;
                System.out.println("Launching shell command on a new container., containerId=" + allocatedContainer.getId() + ", containerNode=" + allocatedContainer.getNodeId().getHost() + ":" + allocatedContainer.getNodeId().getPort() + ", containerNodeURI=" + allocatedContainer.getNodeHttpAddress() + ", containerResourceMemory" + allocatedContainer.getResource().getMemory() + ", containerResourceVirtualCores" + allocatedContainer.getResource().getVirtualCores());
                __cobertura_counters[50] = __cobertura_counters[50] + 1;
                LaunchContainerRunnable runnableLaunchContainer = new LaunchContainerRunnable(this.this$0, allocatedContainer, ApplicationMaster.access$1000(this.this$0));
                __cobertura_counters[51] = __cobertura_counters[51] + 1;
                Thread launchThread = new Thread(runnableLaunchContainer);
                __cobertura_counters[52] = __cobertura_counters[52] + 1;
                ApplicationMaster.access$1100(this.this$0).add(launchThread);
                __cobertura_counters[53] = __cobertura_counters[53] + 1;
                launchThread.start();
                __cobertura_counters[54] = __cobertura_counters[54] + 1;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[55] = __cobertura_counters[55] + 1;
        }

        public void onShutdownRequest() {
            int n = 0;
            __cobertura_counters[56] = __cobertura_counters[56] + 1;
            ApplicationMaster.access$902(this.this$0, true);
            __cobertura_counters[57] = __cobertura_counters[57] + 1;
        }

        public void onNodesUpdated(List<NodeReport> list) {
            int n = 0;
            __cobertura_counters[58] = __cobertura_counters[58] + 1;
        }

        public float getProgress() {
            int n = 0;
            __cobertura_counters[59] = __cobertura_counters[59] + 1;
            float progress = (float)ApplicationMaster.access$200(this.this$0).get() / (float)ApplicationMaster.access$600(this.this$0);
            __cobertura_counters[60] = __cobertura_counters[60] + 1;
            return progress;
        }

        public void onError(Throwable throwable) {
            int n = 0;
            __cobertura_counters[61] = __cobertura_counters[61] + 1;
            ApplicationMaster.access$902(this.this$0, true);
            __cobertura_counters[62] = __cobertura_counters[62] + 1;
            ApplicationMaster.access$800(this.this$0).stop();
            __cobertura_counters[63] = __cobertura_counters[63] + 1;
        }

        /*
         * WARNING - void declaration
         */
        /* synthetic */ RMCallbackHandler(ApplicationMaster applicationMaster, 1 var2_2) {
            void x0;
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            this((ApplicationMaster)x0);
        }

        static {
            RMCallbackHandler.__cobertura_init();
            int n = 0;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[64];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/ApplicationMaster$RMCallbackHandler");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(834, 1, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;)V");
            lightClassmapListener2.putLineTouchPoint(834, 2, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster;Lorg/graphlab/hadoop/yarn/applications/ApplicationMaster$1;)V");
            lightClassmapListener2.putLineTouchPoint(834, 3, "<clinit>", "()V");
            lightClassmapListener2.putLineTouchPoint(838, 4, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(840, 5, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(840, 7, 6);
            lightClassmapListener2.putLineTouchPoint(841, 8, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(848, 9, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(848, 11, 10);
            lightClassmapListener2.putJumpTouchPoint(848, 13, 12);
            lightClassmapListener2.putLineTouchPoint(851, 14, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(852, 15, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(852, 17, 16);
            lightClassmapListener2.putLineTouchPoint(854, 18, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(854, 20, 19);
            lightClassmapListener2.putLineTouchPoint(857, 21, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(858, 22, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(862, 23, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(863, 24, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(870, 25, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(871, 26, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(874, 27, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(877, 28, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(878, 29, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(880, 30, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(880, 32, 31);
            lightClassmapListener2.putLineTouchPoint(881, 33, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(881, 35, 34);
            lightClassmapListener2.putLineTouchPoint(881, 36, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(882, 37, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(883, 38, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(887, 39, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(887, 41, 40);
            lightClassmapListener2.putLineTouchPoint(888, 42, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(890, 43, "onContainersCompleted", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(894, 44, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(896, 45, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(897, 46, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putJumpTouchPoint(897, 48, 47);
            lightClassmapListener2.putLineTouchPoint(898, 49, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(910, 50, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(912, 51, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(917, 52, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(918, 53, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(919, 54, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(920, 55, "onContainersAllocated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(924, 56, "onShutdownRequest", "()V");
            lightClassmapListener2.putLineTouchPoint(925, 57, "onShutdownRequest", "()V");
            lightClassmapListener2.putLineTouchPoint(928, 58, "onNodesUpdated", "(Ljava/util/List;)V");
            lightClassmapListener2.putLineTouchPoint(933, 59, "getProgress", "()F");
            lightClassmapListener2.putLineTouchPoint(935, 60, "getProgress", "()F");
            lightClassmapListener2.putLineTouchPoint(940, 61, "onError", "(Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(941, 62, "onError", "(Ljava/lang/Throwable;)V");
            lightClassmapListener2.putLineTouchPoint(942, 63, "onError", "(Ljava/lang/Throwable;)V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/ApplicationMaster$RMCallbackHandler");
            lightClassmapListener2.setSource("ApplicationMaster.java");
            RMCallbackHandler.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }
}

