"use strict";define("sgraph",["react","plots","common_util","taskqueue","common_controls","d3","logging"],function(React,Plots,Util,TaskQueue,Controls,d3,Logging){return{View:React.createClass({displayName:"View",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(props){if(!props){props=this.props}if(props.ipython){return{vertices:Util.tryGetProperty(props,"vertices",[]),vertices_labels:Util.tryGetProperty(props,"vertices_labels",[]),edges:Util.tryGetProperty(props,"edges",[]),edges_labels:Util.tryGetProperty(props,"edges_labels",[]),layoutAlgorithm:"forceDirected",positions:Util.tryGetProperty(props,"positions",[]),error_type:Util.tryGetProperty(props,"error_type",0),error_msg:Util.tryGetProperty(props,"error_msg",[])}}return{vertices:[],vertices_labels:[],edges:[],edges_labels:[],layoutAlgorithm:"forceDirected",positions:null,error_type:0,error_msg:""}},customLayout:function(vertices,edges){return{vertices:vertices.map(function(v,idx){return Util.merge(v,{x:this.state.positions.x[idx],y:this.state.positions.y[idx]})}.bind(this)),edges:edges.map(function(e){return Util.merge(e,{points:[[this.state.positions.x[e.source],this.state.positions.y[e.source]],[this.state.positions.x[e.target],this.state.positions.y[e.target]]]})}.bind(this))}},setLayoutAlgorithm:function(evt){var algo=evt.target.value;this.setState({layoutAlgorithm:algo})},getLayoutAlgorithm:function(){if(this.state.layoutAlgorithm in Plots.GraphLayout.layoutAlgorithms){return Plots.GraphLayout.layoutAlgorithms[this.state.layoutAlgorithm]}return this.customLayout},shouldComponentUpdate:function(nextProps,nextState){return!Util.deepEquals(this.props,nextProps)||!Util.deepEquals(this.state,nextState)},updateAsyncState:function(nextProps){var pageTasks=[];["vertices","edges"].forEach(function(name){pageTasks.push(new TaskQueue.SingleTask("/"+name,"get_"+name+"()").done(function(n,data){var st={};st[n]=data.values;if(data.labels!==null){st[n+"_labels"]=data.labels}if(n==="vertices"){st.positions=data.positions;if(data.positions!==null){st.layoutAlgorithm=JSON.stringify(data.positions.names)}}this.setState(st)}.bind(this,name)).fail(function(jqxhr,type,error){if(typeof jqxhr!=="undefined"&&jqxhr.status==413){this.setState({error_type:413,error_msg:error})}}.bind(this)))}.bind(this));this.addTask(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"SGraph"})}))},get_color:function(rgb_triple){return d3.rgb(rgb_triple[0]*255,rgb_triple[1]*255,rgb_triple[2]*255).toString()},scale_node_size:function(){return this.props.selected_variable.view_params.node_size/37.5},render:function(){if(this.state.vertices.length===0){if(this.state.error_type!==0){return React.DOM.div({className:"alert alert-info"},this.state.error_msg)}return React.DOM.div(null)}var getHighlightColors=function(){var ret={};for(var k in this.props.selected_variable.view_params.highlight){ret[k]=this.get_color(this.props.selected_variable.view_params.highlight[k])}return ret}.bind(this);var getParamColor=function(view_param){var rgb_triple=this.props.selected_variable.view_params[view_param];return this.get_color(rgb_triple)}.bind(this);var graph=Plots.GraphLayout(Util.merge({vertices:this.state.vertices,edges:this.state.edges,vlabels:this.state.vertices_labels!==null?this.state.vertices_labels:[],vcolor:getParamColor("vcolor"),highlight:getHighlightColors(),node_size:this.scale_node_size(),elabels:this.state.edges_labels!==null?this.state.edges_labels:[],ecolor:getParamColor("ecolor"),layoutAlgorithm:this.getLayoutAlgorithm()},Util.partial(this.props.selected_variable.view_params,["vlabel_hover","elabel_hover","ewidth","v_offset","h_offset","arrows"])));var defaultLayoutAlgo=this.state.positions===null?"forceDirected":JSON.stringify(this.state.positions.names);return React.DOM.div({className:"tab-content",style:{"max-width":this.state.windowWidth-(190+50),"max-height":this.props.ipython?"none":this.state.windowHeight-(74+50),overflow:"auto"}},React.DOM.div({className:"canvas canvas-view-main sgraph"},React.DOM.div({className:"canvas-singlecolumn-plot"},this.state.positions===null?null:React.DOM.div(null,React.DOM.label({htmlFor:"canvas-sgraph-layout-selector"},"Layout algorithm: "),React.DOM.select({defaultValue:defaultLayoutAlgo,onChange:this.setLayoutAlgorithm},React.DOM.option({value:"forceDirected"},"Force-directed"),React.DOM.option({value:JSON.stringify(this.state.positions.names)},JSON.stringify(this.state.positions.names)))),graph)))}})}});