define("sarray",["react","d3","plots","common_util","taskqueue","common_controls","logging"],function(React,d3,Plots,Util,TaskQueue,Controls,Logging){"use strict";var ImageView=React.createClass({displayName:"ImageView",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(){return{images:this.props.ipython?this.props.rows:[]}},updateAsyncState:function(nextProps){var rows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);if(rows!==0){this.addTask(new TaskQueue.SingleTask("/rows/0/20","get_rows").done(function(data){this.setState({images:data.values})}.bind(this)))}},render:function(){var name=this.props.selected_variable.name;var selected_column=Array.isArray(name)?name[name.length-1]:name;var rows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);var header="All "+String(rows)+" images in ";if(rows>=20){header="The first 20 images in "}return React.DOM.div({className:"tab-content",style:{"max-width":this.state.windowWidth-(190+50),"max-height":this.props.ipython?"none":this.state.windowHeight-(74+50),overflow:"auto"}},React.DOM.div({className:"canvas canvas-view-main sarray"},React.DOM.h3(null,header," ",React.DOM.em(null,selected_column)),this.state.images.map(function(image,idx){return React.DOM.div({key:idx,style:{padding:10,margin:10,border:"1px solid #5e5555",display:"inline-block"}},Util.formatSArrayValue(image,200))}.bind(this))))}});var CategoricalView=React.createClass({displayName:"CategoricalView",statics:{tabName:"Categorical"},getInitialState:function(){return{frequentItemsShown:30}},getDefaultProps:function(){return{show_title:true}},showMoreFrequentItems:function(){this.setState({frequentItemsShown:this.state.frequentItemsShown+30})},render:function(){var sketch=this.props.sketch;var frequent_items=Util.tryGetProperty(sketch,"frequent_items",[]);var showMoreLink=Object.keys(frequent_items).length>this.state.frequentItemsShown?React.DOM.div(null,React.DOM.a({href:"javascript:",onClick:this.showMoreFrequentItems},"Show More")):null;frequent_items=Util.sortFrequentItems(frequent_items,this.state.frequentItemsShown);var tableValues=frequent_items.map(function(item){return[Util.formatSArrayValue(item.value.value,26),Util.formatNumber(item.value.frequency),Util.formatNumber(item.value.frequency/sketch.size*100)+"%"]}.bind(this));var tableClasses=["table","table-bordered","table-condensed","canvas-singlecolumn-table"];var scaleX=d3.scale.linear().domain([0,d3.max(frequent_items.map(function(item){return item.value.frequency}))]).range([0,250]);var plotTitle=this.props.show_title?React.DOM.h3({style:{marginTop:0,marginBottom:20,height:28}},"Most frequent items from ",React.DOM.em(null,this.props.selected_column)):null;var plotValue=frequent_items.length===0?React.DOM.span(null,"No values appear with ≥ 0.01% occurrence."):React.DOM.table({className:tableClasses.join(" "),style:{borderRight:"none",borderBottom:"none"}},React.DOM.thead(null,React.DOM.tr(null,React.DOM.th(null,"Value"),React.DOM.th(null,"Count"),React.DOM.th(null,"Percent"))),React.DOM.tbody(null,tableValues.map(function(row,rowIdx){return React.DOM.tr({key:rowIdx},row.map(function(col,colIdx){return React.DOM.td({key:colIdx},col)}.bind(this)),React.DOM.td({style:{width:"250px",border:"none",padding:"0px 0px 0px 5px"}},React.DOM.div({style:{width:scaleX(frequent_items[rowIdx].value.frequency),height:26,backgroundColor:"#85bd00",transition:"width 0.3s ease"}})))}.bind(this))));return React.DOM.div({className:"canvas-sarray-table categorical"},plotTitle,plotValue,showMoreLink)}});var NumericView=React.createClass({displayName:"NumericView",statics:{tabName:"Numeric"},render:function(){var sketch=this.props.sketch;var rows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);var plot,tableValues;var quantile=Util.tryGetProperty(sketch,"quantile",[]);var starting_bins=Util.tryGetProperty(sketch,"num_unique",20);starting_bins=Math.max(2,Math.min(starting_bins,20));plot=Plots.QuantileHistogram({quantile:quantile,starting_bins:starting_bins,rows:rows,selected_column:this.props.selected_column});tableValues=["min","max","mean","std"].map(function(name){var ret=[name];if(name in sketch){ret.push(Util.formatNumber(sketch[name]))}else{ret.push(null)}return ret;return[name,Util.tryGetProperty(sketch,name)]}.bind(this)).concat([1,25,50,75,99].map(function(q){var ret=["quantile("+String(q/100)+") (est.)"];if("quantile"in sketch&&sketch.quantile.length>0){ret.push(Util.formatNumber(sketch.quantile[q]))}else{ret.push(null)}return ret}.bind(this)));var tableClasses=["table","table-striped","table-bordered","table-condensed","canvas-singlecolumn-table"];return React.DOM.div(null,React.DOM.div({className:"canvas-singlecolumn-plot"},plot),React.DOM.div({className:"canvas-sarray-table numeric"},React.DOM.table({className:tableClasses.join(" ")},React.DOM.tbody(null,tableValues.map(function(row,rowIdx){return React.DOM.tr({key:rowIdx},row.map(function(col,colIdx){return React.DOM.td({key:colIdx},col)}.bind(this)))}.bind(this))))))}});var HasSubcolumns={getInitialState:function(){return{subcolumn:null,subsketch:null}},updateAsyncState:function(nextProps){this.setState({subcolumn:null,subsketch:null})},getSubsketch:function(subcol){this.setState({subcolumn:subcol});var task=new TaskQueue.ProgressTask("/subsketch/"+subcol,"sketch_summary().element_sub_sketch()",function(data){this.setState({subsketch:data})}.bind(this),2e3);this.addTask(task.always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"SArray<dict>"})}))},onItemClick:function(subcol){if(this.state.subcolumn===subcol){this.setState(this.getInitialState())}else{this.getSubsketch(subcol)}}};var DictView=React.createClass({displayName:"DictView",mixins:[Controls.AsyncState,HasSubcolumns],statics:{tabName:"Dictionary"},render:function(){var keyPlot=Plots.Frequency({data:Util.tryGetProperty(this.props.sketch,"keys",{}),width:600,aspectRatio:5,maxValues:50,onItemClick:this.onItemClick,highlightElement:this.state.subcolumn,disabled:this.props.ipython});var numericValues=Util.tryGetProperty(this.props.sketch,["values","numeric"],false);var valuePlot=numericValues?NumericView:CategoricalView;var valueSketch=this.state.subsketch===null?Util.tryGetProperty(this.props.sketch,"values",{}):this.state.subsketch;var valuePlotSource=this.state.subcolumn!=null?React.DOM.em(null," ",this.state.subcolumn):React.DOM.span(null," all keys");var valuePlotTitle=numericValues?React.DOM.span(null,"Distribution of values from"):React.DOM.span(null,"Most frequent values from");return React.DOM.div(null,React.DOM.h3({style:{marginTop:0,marginBottom:20,height:28}},"Most frequent keys from ",React.DOM.em(null,this.props.selected_column),", sorted by frequency"),keyPlot,React.DOM.hr(null),React.DOM.h3({style:{marginTop:30,marginBottom:20,height:28}},valuePlotTitle,valuePlotSource),this.transferPropsTo(valuePlot({sketch:valueSketch,show_title:false})))}});var ListView=React.createClass({displayName:"ListView",statics:{tabName:"List"},render:function(){return React.DOM.div(null,React.DOM.h3({style:{marginTop:0,marginBottom:20,height:28}},React.DOM.span(null,"Most frequent values in ",React.DOM.em(null,this.props.selected_column)," ",React.DOM.small(null,"(aggregated across all sub-columns)"))),this.transferPropsTo(CategoricalView({show_title:false})))}});var ArrayView=React.createClass({displayName:"ArrayView",mixins:[Controls.AsyncState,HasSubcolumns],statics:{tabName:"Array"},onSelect:function(evt){var subcol=evt.target.value;if(subcol==="all (aggregate)"){this.setState(this.getInitialState())}else{this.getSubsketch(subcol)}},render:function(){var sketch=this.state.subsketch===null?this.props.sketch:this.state.subsketch;return React.DOM.div(null,React.DOM.h3({style:{marginTop:0,marginBottom:20,height:28}},React.DOM.span(null,"Distribution of values in ",React.DOM.em(null,this.props.selected_column),","+" "+"all sub-columns (aggregate)")),this.transferPropsTo(NumericView({sketch:sketch})))}});var SArrayView=React.createClass({displayName:"SArrayView",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(props){if(!props){props=this.props}if(props.ipython==true){return{sketch:props.sketch}}return{sketch:{}}},updateAsyncState:function(nextProps){var pageTasks=[];var rows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);if(rows!==0){pageTasks.push(new TaskQueue.ProgressTask("/sketch/","sketch_summary()",function(data){this.setState({sketch:data})}.bind(this),Util.getSketchPollInterval(rows)).fail(function(){if(this.canceled){$.get("/cancel_sketch")}}));this.addTask(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"SArray"})}))}},render:function(){var rows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);if(rows===0){return React.DOM.div(null,React.DOM.h5(null,"No data in this column."))}var name=this.props.selected_variable.name;var selected_column=Array.isArray(name)?name[name.length-1]:name;var view=this.props.view;var viewInstance=this.transferPropsTo(view({sketch:this.state.sketch,selected_column:selected_column}));return React.DOM.div({className:"tab-content",style:{"max-width":this.state.windowWidth-(190+50),"max-height":this.props.ipython?"none":this.state.windowHeight-(74+50),overflow:"auto"}},React.DOM.div({className:"canvas canvas-view-main sarray"},viewInstance))}});var SArrayViewWrapper=function(view){return React.createClass({render:function(){return this.transferPropsTo(SArrayView({view:view}))}})};var viewComponents={Categorical:SArrayViewWrapper(CategoricalView),Numeric:SArrayViewWrapper(NumericView),Dictionary:SArrayViewWrapper(DictView),Array:SArrayViewWrapper(ArrayView),List:SArrayViewWrapper(ListView),Images:ImageView};viewComponents["View"]=React.createClass({render:function(){var Tabs=Controls.Tabs;var views=this.props.selected_variable.view_components.map(function(c){return[c,viewComponents[c]]}.bind(this));return Tabs({selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable,tabs:views,initialTab:this.props.selected_variable.view_component})}});return viewComponents});