define("sframe",["react","plots","page_layout","common_util","taskqueue","common_controls","logging","jquery","lodash","d3","bowser","scatter","bar","heatmap"],function(React,Plots,PageLayout,Util,TaskQueue,Controls,Logging,jQuery,_,d3,Bowser,Scatter,Bar,HeatMap){"use strict";var cursors={grab:Bowser.webkit?"-webkit-grab":"grab",grabbing:Bowser.webkit?"-webkit-grabbing":"grabbing"};var _getColumns=function(props){var allColumns=Util.tryGetProperty(props.selected_variable,"columns",[]);var columnOrder=Util.tryGetProperty(props.selected_variable,["view_params","columns"],[]);return _(allColumns).filter(function(column){return columnOrder.indexOf(column.name)!==-1}).sortBy(function(column){return columnOrder.indexOf(column.name)}).value()};var _getColumnWidth=function(dtype){return{"int":110,"float":110,str:260,dict:260,list:260,array:260,Image:140,datetime:220}[dtype]};var _getTableWidth=function(columns,minWidth){return columns.reduce(function(prev,col){return prev+_getColumnWidth(col.dtype)},minWidth+1)};var Column=React.createClass({displayName:"Column",handleClick:function(evt){var selected_column=this.props.selected_variable.name.concat([this.props.name]);this.props.selectVariable(selected_column)},render:function(){var getColumnName=function(){if(this.props.ipython){return this.props.name}else{return React.DOM.a({href:"javascript:",onClick:this.handleClick,className:"canvas-sframe-column-title"},this.props.name)}}.bind(this);return React.DOM.div({className:"canvas-sframe-column-header",style:this.props.style},getColumnName())}});var ColumnView=React.createClass({displayName:"ColumnView",mixins:[Controls.AsyncState,Controls.Menu,Controls.Searchable],getInitialState:function(props){if(!props){props=this.props}return{sortColumn:0,sortDesc:false,visibleColumns:props.selected_variable.view_params.columns}},getColumns:function(props){return Util.tryGetProperty(props.selected_variable,"columns",[])},updateAsyncState:function(nextProps){this.setState(this.getInitialState())},onSort:function(sortColumn,sortDesc){this.setState({sortColumn:sortColumn,sortDesc:sortDesc})},toggleColumn:function(col){var visibleIdx=this.state.visibleColumns.indexOf(col.name);var newColumns;if(visibleIdx===-1){newColumns=this.state.visibleColumns.slice().concat([col.name])}else{newColumns=this.state.visibleColumns.slice();newColumns.splice(visibleIdx,1)}this.setState({visibleColumns:newColumns})},setColumns:function(){$.post("/columns",{columns:JSON.stringify(this.state.visibleColumns),_xsrf:Util.getCookie("_xsrf")}).done(function(){this.props.modalClose()}.bind(this))},render:function(){var columns=this.getColumns(this.props);var visibleColumns=this.state.visibleColumns;var toggleFn=this.toggleColumn;var loading={};var headers=["Index","Name","Type",""];var data=columns.map(function(column,i){return[i,column.name,column.dtype,null]}.bind(this)).filter(function(row,i){if(this.state.search_value===""){return true}var matches=false;row.forEach(function(val,idx,arr){if(String(val).toLocaleLowerCase().indexOf(this.state.search_value.toLocaleLowerCase())===0){matches=true}}.bind(this));return matches}.bind(this));var sortableRange=headers.length-1;var sortable=d3.range(sortableRange).filter(function(i){if(i in loading){return false}return true}.bind(this));return React.DOM.div({style:{position:"relative"}},React.DOM.div({style:{position:"absolute",top:0,right:0,zIndex:5e3}},React.DOM.a({href:"javascript:",onClick:this.props.modalClose},React.DOM.i({className:"fa fa-times fa-lg",style:{color:"black"}}))),React.DOM.div({className:"container-fluid",style:{color:"black"}},React.DOM.div({className:"row"},React.DOM.div({className:"col-xs-6"},React.DOM.h3(null,"All Columns"),React.DOM.div({style:{margin:"14px 0px"}},React.DOM.div({style:{display:"inline-block"}},this.getSearchBox("Search/Filter by Keyword",{border:"1px solid #dedede",width:192,height:24,paddingLeft:10}))),Controls.SortableTable({headers:headers,types:["number","string","string",null],data:data,sortable:sortable,sortColumn:this.state.sortColumn,sortDesc:this.state.sortDesc,onSort:this.onSort,style:{height:400,overflowY:"scroll",display:"inline-block",width:"100%"},tableStyle:{width:"100%"},renderTD:false,getValue:function(data,rowIdx,colIdx){if(rowIdx===null){var sortLink=null;if(this.props.sortable.indexOf(colIdx)!=-1){var className="fa fa-sort";if(this.props.sortColumn===colIdx){if(this.props.types[colIdx]==="number"){className+="-numeric"}else if(this.props.types[colIdx]==="string"){className+="-alpha"}}if(this.props.sortColumn===colIdx&&this.props.sortDesc){className+="-desc"}else if(this.props.sortColumn===colIdx){className+="-asc"}sortLink=React.DOM.a({onClick:this.sort.bind(this,colIdx),href:"javascript:"},React.DOM.i({className:className,style:{marginLeft:6,marginRight:6,color:"white"}}))}return React.DOM.div({style:{paddingLeft:12,paddingRight:6,backgroundColor:"#bbb",color:"white",width:"100%",height:23,fontWeight:500,fontSize:12,lineHeight:"23px"}},data[colIdx],sortLink)}var style={borderLeft:"1px solid #dedede",lineHeight:"40px",height:40,paddingLeft:14,paddingRight:14};var tdStyle={padding:0,verticalAlign:"middle",border:"none"};var contents=colIdx===headers.length-1?React.DOM.a({href:"javascript:",onClick:toggleFn.bind(null,columns[data[rowIdx][0]])},visibleColumns.indexOf(data[rowIdx][1])!==-1?React.DOM.i({className:"fa fa-eye",style:{color:"#0a8cc4"}}):React.DOM.i({className:"fa fa-eye-slash",style:{color:"#b8b8b8"}})):data[rowIdx][colIdx];if(colIdx===0){style["paddingLeft"]=30}if(rowIdx%2===0){style["backgroundColor"]="#f7f7f7"}if(colIdx===1){tdStyle["width"]="100%";style["position"]="relative";style["paddingLeft"]=0;style["paddingRight"]=0;contents=React.DOM.div({style:{position:"absolute",overflow:"hidden",textOverflow:"ellipsis",width:"100%",whiteSpace:"nowrap",margin:"auto",top:0,bottom:0,paddingLeft:14,paddingRight:14}},contents)}return React.DOM.td({style:tdStyle,key:colIdx},React.DOM.div({style:style},contents))}})),React.DOM.div({className:"col-xs-6"},React.DOM.h3(null,"Visible Columns"),React.DOM.p(null,"Choose which columns will be available in the Summary, Table,"+" "+"and Plots tabs."),React.DOM.div({style:{backgroundColor:"#f0f0f0",width:"100%",padding:10,height:400,overflowY:"scroll",display:"inline-block"}},React.DOM.table(null,React.DOM.tbody(null,columns.map(function(col,idx){if(visibleColumns.indexOf(col.name)===-1){return null}return React.DOM.tr({key:idx,style:{backgroundColor:"white",width:"100%",height:38,marginTop:2,marginBottom:2,lineHeight:"38px"}},React.DOM.td({style:{width:"50%"}},React.DOM.span({style:{paddingLeft:16}},idx),React.DOM.span({style:{paddingLeft:28}},col.name)),React.DOM.td({style:{width:"50%"}},React.DOM.span(null,"(",col.dtype,")")),React.DOM.td({style:{width:38,borderLeft:"1px solid #dedede"}},React.DOM.a({href:"javascript:",onClick:toggleFn.bind(null,columns[idx])},React.DOM.i({className:"fa fa-eye",style:{color:"#0a8cc4",paddingLeft:8,paddingRight:8}}))))}.bind(this))))))),React.DOM.div({className:"row"},React.DOM.div({className:"col-xs-12"},React.DOM.div({style:{"float":"right"}},Controls.Button({onClick:this.setColumns,style:{width:130,marginTop:16}},"View Columns"))))))}});var SingleColumn=React.createClass({displayName:"SingleColumn",render:function(){var rows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);if(rows===0){return React.DOM.div(null,React.DOM.h5(null,"No data in this column."))}var formatSArrayValue=_.memoize(Util.formatSArrayValue,JSON.stringify);var categorical=!Util.tryGetProperty(this.props.sketch,"numeric",false);var dtype=Util.tryGetProperty(this.props.column,"dtype");var summaryPlots=[];if(dtype==="dict"){var keysSketch=Util.tryGetProperty(this.props.sketch,"keys",{});var valuesSketch=Util.tryGetProperty(this.props.sketch,"values",{});var valuesNumeric=Util.tryGetProperty(valuesSketch,"numeric",false);var valueDescription=valuesNumeric?"distribution of values (all keys):":"frequent items (all keys):";summaryPlots.push(React.DOM.div({key:"dict_summary"},React.DOM.div({className:"canvas-sframe-summary-plot-title"},"frequent keys:"),SummaryPlot({data:keysSketch,categorical:!Util.tryGetProperty(keysSketch,"numeric",false),maxItems:5}),React.DOM.div({className:"canvas-sframe-summary-plot-title"},valueDescription),SummaryPlot({data:valuesSketch,categorical:!Util.tryGetProperty(valuesSketch,"numeric",false),width:32,vertical:true,maxItems:5})))}else if(dtype!=="Image"){var description=categorical?"frequent items":"distribution of values";if(dtype==="list"||dtype==="array"){description+=" (all sub-columns)"}summaryPlots.push(React.DOM.div({key:"nondict_summary"},React.DOM.div({className:"canvas-sframe-summary-plot-title"},description,":"),SummaryPlot({data:this.props.sketch,categorical:categorical,width:32,vertical:true,maxItems:12})))}else{var sampleImages=Util.tryGetProperty(this.props.sketch,"samples",[]);summaryPlots.push(React.DOM.div({key:"nondict_summary"},React.DOM.div({className:"canvas-sframe-summary-plot-title"},"First 4 images:"),sampleImages.map(function(image,i){var displayImage=formatSArrayValue(image,66);return React.DOM.div({style:{paddingBottom:"4px"}},displayImage)})))}var loading=!("complete"in this.props.sketch)||!this.props.sketch.complete;var num_unique=dtype==="dict"?SummaryStatistic({name:"unique keys (est.)",value:Util.tryGetProperty(this.props.sketch,["keys","num_unique"]),loading:loading}):dtype!=="Image"?SummaryStatistic({name:"num_unique (est.)",value:this.props.sketch.num_unique,loading:loading}):null;var additionalStats=!categorical?["min","max","mean","std"].map(function(stat,idx){return SummaryStatistic({key:idx,name:stat,value:this.props.sketch[stat],loading:false})}.bind(this)):null;var num_undefined=dtype!=="Image"?SummaryStatistic({name:"num_undefined",value:this.props.sketch.num_undefined,loading:loading}):null;return React.DOM.div(null,React.DOM.table({className:"canvas-sframe-inner-table"},React.DOM.tbody(null,SummaryStatistic({name:"dtype",value:dtype}),num_unique,num_undefined,additionalStats)),summaryPlots)}});var ColumnFrequencyPlot=React.createClass({displayName:"ColumnFrequencyPlot",render:function(){if(!("frequent_items"in this.props.data)||this.props.data.frequent_items.length===0){return React.DOM.div(null)}var width=176;var maxItems=Util.tryGetProperty(this.props,"maxItems",10);var sorted=Util.sortFrequentItems(this.props.data.frequent_items,maxItems);if(sorted.length===0){return React.DOM.div({className:"canvas-sframe-summary-statistic-name"},"No values appear with ≥ 0.01% occurrence.")}var scale=d3.scale.linear().domain([0,sorted[0].value.frequency]).range([0,width]);return React.DOM.div(null,React.DOM.table(null,React.DOM.tbody(null,sorted.map(function(pair,idx){var label=Util.formatSArrayValue(pair.value.value,20);return React.DOM.tr({key:idx},React.DOM.td({style:{position:"relative",width:width,height:22}},React.DOM.div({style:{position:"absolute",left:0,top:0,width:scale(pair.value.frequency),height:20,backgroundColor:"rgba(133, 189, 0, 0.2)"}}),React.DOM.div({style:{paddingLeft:8,paddingRight:8,width:width,height:20,overflow:"hidden"}},label)))}.bind(this)))))}});var SummaryPlot=React.createClass({displayName:"SummaryPlot",render:function(){var plot=this.props.categorical?ColumnFrequencyPlot():Plots.BoxAndWhisker();return React.DOM.div({className:"canvas-sframe-column-plot"},this.transferPropsTo(plot))}});var SummaryStatistic=React.createClass({displayName:"SummaryStatistic",render:function(){var value=this.props.value;if(this.props.loading){value=React.DOM.span({style:{position:"relative",marginLeft:30,marginRight:-10}},React.DOM.i({className:"fa-li fa fa-spinner fa-spin"}))}else if(typeof value==="number"){value=Util.formatNumber(value)}return React.DOM.tr(null,React.DOM.td({className:"canvas-sframe-summary-statistic-name"},this.props.name,": "),React.DOM.td({className:"canvas-sframe-summary-statistic-value"},value))}});var SummaryView=React.createClass({displayName:"SummaryView",mixins:[Controls.AsyncState],getInitialState:function(props){if(!props){props=this.props}if(props.ipython===true){return{sketch:props.sketch,getColumns:_.memoize(_getColumns)}}return{sketch:{},getColumns:_.memoize(_getColumns)}},updateAsyncState:function(nextProps){this.setState({getColumns:_.memoize(_getColumns)},function(){var rows=Util.tryGetProperty(nextProps.selected_variable,["descriptives","rows"],0);if(rows!==0){this.addTask(new TaskQueue.SingleTask("/cached_sketches","cached sketch summaries").done(function(data){var sketch={};var pageTasks=[];this.state.getColumns(this.props).forEach(function(colObj,idx){var column=colObj.name;if(data[column]!==null){sketch[column]=data[column]}if(data[column]===null||!data[column].complete){pageTasks.push(new TaskQueue.ProgressTask("/sketch/"+column,'["'+column+'"].sketch_summary()',function(data){var sketch={};sketch[column]=data;this.setState({sketch:Util.merge(this.state.sketch,sketch)})}.bind(this),Util.getSketchPollInterval(rows)).fail(function(){if(this.canceled&&this.running()){$.get("/cancel_sketch/"+column)}}))}}.bind(this));this.setState({sketch:sketch},function(){this.addTask(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"SFrame"})}))}.bind(this))}.bind(this)))}}.bind(this))},render:function(){var columns=this.state.getColumns(this.props);var ipythonStyle=this.props.ipython?{"overflow-x":"auto",maxHeight:600}:{height:PageLayout.contentHeight(),width:PageLayout.contentWidth(),overflow:"auto"};return React.DOM.div({style:ipythonStyle},React.DOM.table({className:"canvas canvas-sframe-table"},React.DOM.thead(null,React.DOM.tr(null,columns.map(function(column){return React.DOM.th({key:column.name,className:"padding"},Column({selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable,name:column.name,ipython:this.props.ipython}))}.bind(this)))),React.DOM.tbody(null,React.DOM.tr(null,columns.map(function(column){return React.DOM.td({key:column.name,className:"padding"},SingleColumn({sketch:Util.tryGetProperty(this.state.sketch,column.name,{}),column:column,selected_variable:this.props.selected_variable}))}.bind(this))))))}});var TabularView=React.createClass({displayName:"TabularView",mixins:[Controls.AsyncState,Controls.SizeToWindow],getDefaultProps:function(){return{rowsToFetch:300,rowHeight:38,imageRowHeight:50+16,headerHeight:46}},getInitialState:function(){return{rows:[],rowStart:0,scrollTop:0,scrollLeft:0,currentTask:null,taskTimeout:null,pageOffset:0,pageDragOffset:0,pageDragStart:null,highlightRow:null,getColumnWidth:_.memoize(_getColumnWidth),getColumns:_.memoize(_getColumns),getTableWidth:_.memoize(_getTableWidth)}},updateAsyncState:function(nextProps){this.setState({getColumnWidth:_.memoize(_getColumnWidth),getColumns:_.memoize(_getColumns),getTableWidth:_.memoize(_getTableWidth)},function(){var pageTasks=[];if(Util.tryGetProperty(nextProps.selected_variable,["descriptives","rows"],0)!==0){pageTasks.push(new TaskQueue.SingleTask("/rows/"+String(this.state.rowStart)+"/"+String(this.props.rowsToFetch+this.state.rowStart),".head()").done(function(data){this.setState({rows:data.values})}.bind(this)));this.addTask(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"SFrame"})}))}}.bind(this))},scrollTable:function(evt){var scrollTop=$(evt.target).scrollTop();var scrollLeft=$(evt.target).scrollLeft();this.setState({scrollTop:scrollTop,scrollLeft:scrollLeft});this.updateTable(scrollTop,this.state.pageOffset)},updateTable:function(scrollTop,pageOffset){var newDimensions=this.getDimensions(scrollTop,pageOffset);if(newDimensions.currentRowStart>this.state.rowStart+this.props.rowsToFetch-50||Math.max(newDimensions.currentRowStart-5,0)<this.state.rowStart){var newStart=Math.max(newDimensions.currentRowStart-50,0);if(newStart!==this.state.rowStart){var task=new TaskQueue.SingleTask("/rows/"+String(newStart)+"/"+String(newStart+this.props.rowsToFetch)).done(function(data){this.setState({rows:data.values,rowStart:newStart,currentTask:null})}.bind(this)).fail(function(){this.setState({currentTask:null})}.bind(this));if(this.state.taskTimeout!==null){clearTimeout(this.state.taskTimeout)}if(this.state.currentTask!==null){this.state.currentTask.cancel()}this.setState({currentTask:task,taskTimeout:setTimeout(function(){task.run()},200)})}}},getDimensions:function(scrollTop,pageOffset){if(typeof scrollTop==="undefined"){scrollTop=this.state.scrollTop}if(typeof pageOffset==="undefined"){pageOffset=this.state.pageOffset}var totalRows=Util.tryGetProperty(this.props.selected_variable,["descriptives","rows"],0);var docScrollerThreshold=1e5;var docScrollerWidth=PageLayout.get("table_nav_width");var elementHeight=PageLayout.tableHeight();var columnHeaderHeight=this.props.headerHeight;var docScrollerHeight=elementHeight-24-10;var docScrollerPageHeight=Math.min(1,docScrollerThreshold/totalRows)*docScrollerHeight;var docScrollerVisualPadding=Math.max(0,10-docScrollerPageHeight);var elementWidth=PageLayout.tableWidth();var columns=this.state.getColumns(this.props);var rowHeight=columns.some(function(col){return col.dtype==="Image"})?this.props.imageRowHeight:this.props.rowHeight;var rowsInView=Math.min(totalRows,docScrollerThreshold);var currentPageStart=Math.ceil(pageOffset/docScrollerHeight*totalRows);var currentRowStart=currentPageStart+Math.floor(scrollTop/rowHeight);currentRowStart-=currentRowStart%2;var rowsVisible=Math.ceil(elementHeight/rowHeight)+3;var currentRowEnd=currentRowStart+rowsVisible;var fillerAbove=Math.min(rowsVisible,this.state.rowStart-currentRowStart);var fillerBelow=Math.min(rowsVisible,currentRowEnd-(this.state.rowStart+this.props.rowsToFetch));var heightAbove=(currentRowStart-currentPageStart)*rowHeight;var heightBelow=Math.max(0,(rowsInView-(currentRowEnd-currentPageStart))*rowHeight);var rowHeaderWidth=18+Math.floor(10*Math.log(totalRows)/Math.LN10);var tableWidth=Math.min(elementWidth,this.state.getTableWidth(columns,rowHeaderWidth+1));return{elementHeight:elementHeight,currentRowStart:currentRowStart,currentRowEnd:currentRowEnd,fillerAbove:fillerAbove,fillerBelow:fillerBelow,heightAbove:heightAbove,heightBelow:heightBelow,rowHeaderWidth:rowHeaderWidth,tableWidth:tableWidth,docScrollerWidth:docScrollerWidth,docScrollerHeight:docScrollerHeight,docScrollerPageHeight:docScrollerPageHeight,docScrollerVisualPadding:docScrollerVisualPadding,rowsInView:rowsInView,columnHeaderHeight:columnHeaderHeight,rowHeight:rowHeight,totalRows:totalRows,docScrollerThreshold:docScrollerThreshold}},highlightRow:function(idx){if(idx===this.state.highlightRow){idx=null}this.setState({highlightRow:idx})},render:function(){var dimensions=this.getDimensions();var columns=this.state.getColumns(this.props);var formatSArrayValue=_.memoize(Util.formatSArrayValue,JSON.stringify);var getHeaderCellStyle=function(w,styleToMerge){var defaultStyle={overflow:"hidden",width:w,minWidth:w,maxWidth:w,height:dimensions.columnHeaderHeight-2,minHeight:dimensions.columnHeaderHeight-2,maxHeight:dimensions.columnHeaderHeight-2};if(typeof styleToMerge=="object"){return Util.merge(defaultStyle,styleToMerge)}return defaultStyle}.bind(this);var getCellStyle=_.memoize(function(w,styleToMerge){var defaultStyle={overflow:"hidden",width:w,minWidth:w,maxWidth:w,height:dimensions.rowHeight-2,minHeight:dimensions.rowHeight-2,maxHeight:dimensions.rowHeight-2};if(typeof styleToMerge=="object"){return Util.merge(defaultStyle,styleToMerge)}return defaultStyle}.bind(this),function(w,s){return JSON.stringify({w:w,s:s})});var getCellContentStyle=_.memoize(function(w,styleToMerge,header){if(Boolean(header)===true){return getHeaderCellStyle(w,styleToMerge)}return Util.objectMap(getCellStyle(w,styleToMerge),function(name,value){var ret={};ret[name]=typeof value==="number"?value-16:value;return ret})},function(w,s,h){return JSON.stringify({w:w,s:s,h:h})});var getRowHTML=function(i,row){var formattedValue,margin;var rowStyle=this.state.highlightRow===i?{backgroundColor:"rgba(255, 85, 0, 0.2)"}:{};return React.DOM.tr({key:i,className:"canvas-sframe-table-head-row",onClick:this.highlightRow.bind(this,i)},React.DOM.th({style:getCellStyle(dimensions.rowHeaderWidth,rowStyle)},React.DOM.div({style:getCellContentStyle(dimensions.rowHeaderWidth,{color:"#85bd00",fontWeight:300},false)},Util.formatNumber(i))),row===undefined?React.DOM.td({className:"padding canvas-sframe-table-head-value",style:getCellStyle(this.state.getColumnWidth(columns[0].dtype),rowStyle),colSpan:columns.length},React.DOM.div({style:{position:"relative",marginLeft:dimensions.rowHeight}},React.DOM.i({className:"fa-li fa fa-spinner fa-spin"}))):row.map(function(value,j){formattedValue=formatSArrayValue(value,dimensions.rowHeight);margin=Util.isSArrayImageType(value)?{margin:"0 auto"}:null;return React.DOM.td({key:j,className:"padding canvas-sframe-table-head-value",style:getCellStyle(this.state.getColumnWidth(columns[j].dtype),rowStyle)},React.DOM.div({style:getCellContentStyle(this.state.getColumnWidth(columns[j].dtype),margin,false)},formattedValue))}.bind(this)))}.bind(this);var goToRowChange=function(evt){var value=null;try{value=parseInt($("#goToRow").val(),10)}catch(e){return}var dimensions=this.getDimensions();var pageOffset=value/dimensions.totalRows*dimensions.docScrollerHeight;var maxValueForPageOffset=dimensions.totalRows-dimensions.rowsInView;var scrollOffset=0;if(value<0){value=0}if(value>dimensions.totalRows-1){value=dimensions.totalRows-1}if(value>maxValueForPageOffset){var scrollForward=value-maxValueForPageOffset;pageOffset=maxValueForPageOffset/dimensions.totalRows*dimensions.docScrollerHeight;scrollOffset=scrollForward/dimensions.rowsInView*(dimensions.rowsInView*dimensions.rowHeight)}this.setState({pageOffset:pageOffset,pageDragOffset:pageOffset});$("#tableArea").scrollTop(scrollOffset);this.updateTable(scrollOffset,pageOffset)}.bind(this);var goToRowHeight=20;var goToRowGreyBorder="1px solid #dedede";var goToRow=React.DOM.div({style:{width:dimensions.docScrollerWidth,height:goToRowHeight}},React.DOM.input({id:"goToRow",style:{width:69,height:goToRowHeight,borderLeft:goToRowGreyBorder,borderTop:goToRowGreyBorder,borderBottom:goToRowGreyBorder,borderRight:"none",paddingLeft:5},type:"number",placeholder:"row #"}),React.DOM.a({style:{display:"inline-block",width:27,height:goToRowHeight,backgroundColor:"#85bd41",color:"white",textTransform:"uppercase",verticalAlign:"top",textDecoration:"none",lineHeight:String(goToRowHeight)+"px",textAlign:"center",fontSize:11},href:"javascript:",onClick:goToRowChange},"Go"));var docScrollerDragStart=function(evt){evt.preventDefault();evt.stopPropagation();this.setState({pageDragStart:evt.clientY})}.bind(this);var _docScrollerDrag=function(evt){if(this.state.pageDragStart===null){return null}var diff=evt.clientY-this.state.pageDragStart;var dimensions=this.getDimensions();var newOffset=Math.min(dimensions.docScrollerHeight-dimensions.docScrollerPageHeight,Math.max(0,this.state.pageOffset+diff));return newOffset}.bind(this);var docScrollerDrag=function(evt){if(this.state.pageDragStart!==null){evt.preventDefault();evt.stopPropagation();this.setState({pageDragOffset:_docScrollerDrag(evt)})}}.bind(this);var docScrollerDragEnd=function(evt){evt.preventDefault();evt.stopPropagation();if(this.state.pageDragStart!==null){var newOffset=_docScrollerDrag(evt);this.setState({pageDragStart:null,pageOffset:newOffset,pageDragOffset:newOffset});this.updateTable(this.state.scrollTop,newOffset)}}.bind(this);var docScrollerClick=function(evt){if(this.state.pageDragStart===null){evt.preventDefault();evt.stopPropagation();var dimensions=this.getDimensions();var offset=Math.max(0,evt.clientY-$(evt.currentTarget).offset().top-dimensions.docScrollerPageHeight/2);var newOffset=Math.min(dimensions.docScrollerHeight-dimensions.docScrollerPageHeight,offset);this.setState({pageOffset:offset,pageDragOffset:newOffset});this.updateTable(this.state.scrollTop,newOffset)}else{docScrollerDragEnd(evt)}}.bind(this);var docScrollerPoints=[[0,this.state.pageDragOffset],[0,this.state.pageDragOffset+dimensions.docScrollerPageHeight+dimensions.docScrollerVisualPadding],[50,dimensions.elementHeight+dimensions.columnHeaderHeight+dimensions.docScrollerVisualPadding-goToRowHeight-18],[50,dimensions.columnHeaderHeight-goToRowHeight-18]];var notScrollable=dimensions.totalRows<=dimensions.docScrollerThreshold;var docScrollerRectColor=notScrollable?"#dfe0e1":"#85bd00";var docScroller=dimensions.docScrollerWidth==0?null:React.DOM.div({style:{width:dimensions.docScrollerWidth}},React.DOM.div({style:{paddingTop:5},className:"canvas-docscroller-label"},"0"),React.DOM.svg({style:{width:10,height:dimensions.docScrollerHeight}},d3.range(10).map(function(i){var y=i/9*dimensions.docScrollerHeight;return React.DOM.line({key:i,x1:4,x2:10,y1:y,y2:y,stroke:"#dfe0e1",strokeWidth:2})}.bind(this))),React.DOM.div({style:{width:36,height:dimensions.docScrollerHeight+dimensions.docScrollerVisualPadding,display:"inline-block",cursor:notScrollable?"auto":"pointer",position:"relative"},onMouseMove:docScrollerDrag,onMouseLeave:docScrollerDragEnd,onClick:docScrollerClick},React.DOM.svg({style:{position:"absolute",top:0,left:0,width:36,height:dimensions.docScrollerHeight}},React.DOM.rect({x:0,y:this.state.pageDragOffset,width:36,height:dimensions.docScrollerPageHeight+dimensions.docScrollerVisualPadding,fill:"#d9e3cd",style:{opacity:notScrollable?0:1}}),d3.range(dimensions.docScrollerHeight/5).map(function(y){return d3.range(5).map(function(x){var fill="#dfe0e1";if(y*5>=this.state.pageDragOffset&&y*5+4<=this.state.pageDragOffset+dimensions.docScrollerPageHeight){fill=docScrollerRectColor}return React.DOM.rect({key:String(x)+"_"+String(y),x:6+x*5,y:y*5,width:4,height:4,fill:fill})}.bind(this))}.bind(this))),React.DOM.div({style:{position:"absolute",top:this.state.pageDragOffset,left:0,width:36,height:dimensions.docScrollerPageHeight+dimensions.docScrollerVisualPadding,cursor:notScrollable?"auto":this.state.pageDragStart!==null?cursors.grabbing:cursors.grab},onMouseDown:docScrollerDragStart})),React.DOM.svg({style:{width:50,height:dimensions.docScrollerHeight+dimensions.docScrollerVisualPadding+10,display:"inline-block",verticalAlign:"top",opacity:notScrollable?0:1}},React.DOM.linearGradient({id:"docScrollerGradient"},React.DOM.stop({offset:"0%",style:{stopColor:"#d9e3cd"}}),React.DOM.stop({offset:"100%",style:{stopColor:"#f0f4ec"}})),React.DOM.polygon({points:docScrollerPoints.map(function(xy){return xy.join(",")}).join(" "),style:{fill:"url(#docScrollerGradient)"}})),React.DOM.div({style:{marginTop:-10},className:"canvas-docscroller-label"},Util.formatNumber(dimensions.totalRows-1)));return React.DOM.div({className:"canvas sframe",style:{width:PageLayout.contentWidth()}},React.DOM.div({style:{"float":"left"}},goToRow,docScroller),React.DOM.div({style:{overflow:"hidden"}},React.DOM.table({className:"sframe-table table table-striped",style:{marginBottom:0,marginLeft:-this.state.scrollLeft}},React.DOM.thead(null,React.DOM.tr(null,React.DOM.td({style:getHeaderCellStyle(dimensions.rowHeaderWidth)}),columns.map(function(col,idx){var handleClick=function(c){var selected_column=this.props.selected_variable.name.concat([c.name]);this.props.selectVariable(selected_column)}.bind(this,col);return React.DOM.th({key:idx,style:getHeaderCellStyle(this.state.getColumnWidth(col.dtype))},Column({style:getCellContentStyle(this.state.getColumnWidth(col.dtype),{},true),name:col.name,selected_variable:this.props.selected_variable,selectVariable:this.props.selectVariable}))}.bind(this)))))),React.DOM.div({id:"tableArea",style:{height:dimensions.elementHeight,overflow:"auto"},onScroll:this.scrollTable},React.DOM.table({className:"sframe-table table table-striped",style:{marginTop:dimensions.heightAbove,marginBottom:dimensions.heightBelow}},React.DOM.tbody(null,d3.range(dimensions.fillerAbove).map(function(i){return getRowHTML(i+dimensions.currentRowStart)}.bind(this)),this.state.rows.slice(dimensions.currentRowStart-this.state.rowStart,dimensions.currentRowEnd-this.state.rowStart).map(function(row,i){return getRowHTML(i+dimensions.currentRowStart,row)}.bind(this)),d3.range(dimensions.fillerBelow).map(function(i){return getRowHTML(i+dimensions.currentRowStart)}.bind(this))))))}});var PlotAxisPicker=React.createClass({displayName:"PlotAxisPicker",render:function(){return this.transferPropsTo(React.DOM.div({style:{display:"inline-block",verticalAlign:"top",marginTop:15}},React.DOM.label(null,React.DOM.div(null,this.props.label),React.DOM.select({onChange:this.props.onSelect,value:this.props.selected},this.props.options.map(function(opt,idx){return React.DOM.option({key:idx,value:opt},opt)}.bind(this))))))}});var PlotCreator=React.createClass({displayName:"PlotCreator",statics:{plotTypes:[["Scatter Plot","scatter"],["Heat Map","heatmap"],["Bar Chart","bar"],["Line Chart","line"]]},getInitialState:function(props){if(!props){props=this.props}var view_params=props.selected_variable.view_params;var view=view_params.view;var columnsX=this.getColumns("x",props);var columnsY=this.getColumns("y",props);var ret={selectedPlotType:this.constructor.plotTypes[0],axis1:view_params["x"],axis2:view_params["y"]};if(view!=null){ret.selectedPlotType=this.constructor.plotTypes.filter(function(t){return t[0]==view}.bind(this))[0]}if(!ret.axis1){ret.axis1=Util.tryGetProperty(columnsX,0)}if(!ret.axis2){ret.axis2=Util.tryGetProperty(columnsY,0)}return ret},componentWillReceiveProps:function(nextProps){if(!Util.deepEquals(this.props,nextProps)){this.setState(this.getInitialState(nextProps))}},selectPlotType:function(plotType){this.setState({selectedPlotType:plotType})},selectAxis:function(axis,evt){var newState={};newState[axis]=evt.target.value;this.setState(newState)},includeColumn:function(axis,col){var selectedPlotType=Util.tryGetProperty(this.state,"selectedPlotType",this.constructor.plotTypes[0])[0];if(axis==="y"||selectedPlotType==="Scatter Plot"||selectedPlotType==="Line Chart"||selectedPlotType==="Heat Map"){return col.dtype==="int"||col.dtype==="float"}else{Util.assert(axis==="x");Util.assert(selectedPlotType==="Bar Chart");return col.dtype==="int"||col.dtype==="float"||col.dtype==="str"}},getColumnName:function(col){return col.name},getColumns:function(axis,props){if(!props){props=this.props}return props.selected_variable.columns.filter(this.includeColumn.bind(this,axis)).map(this.getColumnName)},render:function(){return React.DOM.div({style:{height:86,borderBottom:"1px solid #c5c5c5"}},this.constructor.plotTypes.map(function(plotType,idx){var selected=plotType[0]==this.state.selectedPlotType[0];return React.DOM.a({key:idx,style:{paddingLeft:3,paddingRight:12,paddingTop:3,paddingBottom:0,display:"inline-block"},onClick:this.selectPlotType.bind(this,plotType),href:"javascript:"},React.DOM.img({src:"/images/sframe_plot_"+plotType[1]+".png",style:{marginBottom:4,border:selected?"2px solid #ff5500":"2px solid transparent",width:66,height:50}}),React.DOM.div({style:{fontSize:12,textAlign:"center",color:selected?"#ff5500":"#0a8cc4"}},plotType[0]))}.bind(this)),PlotAxisPicker({label:this.state.selectedPlotType[1]==="geo"?"Latitude":"X axis",options:this.getColumns("x"),selected:this.state.axis1,onSelect:this.selectAxis.bind(this,"axis1"),style:{marginLeft:70}}),PlotAxisPicker({label:this.state.selectedPlotType[1]==="geo"?"Longitude":"Y axis",options:this.getColumns("y"),selected:this.state.axis2,onSelect:this.selectAxis.bind(this,"axis2"),style:{marginLeft:20}}),Controls.Button({onClick:this.props.show.bind(null,this.state.selectedPlotType,this.state.axis1,this.state.axis2),disabled:!(this.state.axis1&&this.state.axis2),style:{marginTop:28,verticalAlign:"top",marginLeft:30}},"Show"))}});var PlotsView=React.createClass({displayName:"PlotsView",getInitialState:function(){return{plotType:null,col1:null,col2:null}
},componentWillReceiveProps:function(nextProps){if(!Util.deepEquals(this.props.selected_variable.name,nextProps.selected_variable.name)||!Util.deepEquals(this.props.selected_variable.column_identifiers,nextProps.selected_variable.column_identifiers)){this.setState(this.getInitialState())}},show:function(plotType,col1,col2){this.setState({plotType:plotType,col1:col1,col2:col2},function(){$.post("/plot_params",{view:plotType[0],col1:col1,col2:col2,col3:null,_xsrf:Util.getCookie("_xsrf")})})},render:function(){var plot=null;var view=Util.tryGetProperty(this.props.selected_variable.view_params,"view");if(view!==null){plot={"Bar Chart":Bar.View,"Line Chart":Scatter["Line Chart"],"Scatter Plot":Scatter.View,"Heat Map":HeatMap.View}[view];plot=this.transferPropsTo(plot(null))}var plotCreator=this.props.ipython?null:PlotCreator({show:this.show,selected_variable:this.props.selected_variable});return React.DOM.div(null,plotCreator,plot)}});var viewComponents={Summary:SummaryView,Table:TabularView,Plots:PlotsView};var views=Object.keys(viewComponents).map(function(c){var viewComponent=viewComponents[c];return[c,React.createClass({render:function(){return React.DOM.div(null,viewComponent(this.props))}})]});viewComponents["View"]=React.createClass({mixins:[Controls.Modal],openColumnPicker:function(){this.modalOpen("",ColumnView({selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable,shown:this.props.selected_variable.view_params.columns,modalClose:this.modalClose}),"modal-lg")},shouldComponentUpdate:function(nextProps,nextState){var ret=!Util.deepEquals(this.props,nextProps)||!Util.deepEquals(this.state,nextState);return ret},render:function(){var Tabs=Controls.Tabs;return React.DOM.div(null,React.DOM.div({style:{marginRight:20,marginTop:10,marginBottom:20}},React.DOM.div({style:{display:"inline-block",marginRight:20}},"Showing ",this.props.selected_variable.view_params.columns.length," of ",this.props.selected_variable.descriptives.columns," columns."),Controls.Button({onClick:this.openColumnPicker},React.DOM.i({className:"fa fa-pencil"})," "+" "+"Select Visible Columns")),Tabs({selectVariable:this.props.selectVariable,selected_variable:Util.merge(this.props.selected_variable,{columns:this.props.selected_variable.columns.filter(function(c){return this.props.selected_variable.view_params.columns.indexOf(c.name)!==-1}.bind(this))}),openColumnPicker:this.openColumnPicker,tabs:views,initialTab:this.props.selected_variable.view_component}),this.getModal())}});return viewComponents});