"use strict";define("plot_heatmap",["react","d3","jquery","common_controls","common_util"],function(React,d3,jQuery,Controls,Util){var FRAME_PADDING=75;var TICK_WIDTH=10;var TICK_HEIGHT=10;var FRAME_THICKNESS=1;var formatLabels=function(num){if(d3.format(".3g")(num).length>7)return d3.format(".1g")(num);else return d3.format(".3g")(num)};function getRGB(binWeight,heatScale){var normalizedWeight=heatScale(binWeight);var red;var blue;var green;if(normalizedWeight<.5){red=0;blue=2*(1-2*normalizedWeight);if(blue>1)blue=1}else{blue=0;red=4*(normalizedWeight-.5);if(red>1)red=1}var distFromMiddle=Math.abs(normalizedWeight-.5);if(distFromMiddle<.25)green=1;else green=4*(.5-distFromMiddle);return[Math.floor(red*255),Math.floor(green*255),Math.floor(blue*255)]}function incrementAdjacentCells(array,incrementAmount,i,j){for(var iitr=i-1;iitr<=i+1;iitr++){if(iitr<0||iitr>=array.length)continue;for(var jitr=j-1;jitr<=j+1;jitr++){if(jitr<0||jitr>=array[i].length)continue;array[iitr][jitr]+=incrementAmount}}}var AxisLabel=React.createClass({displayName:"AxisLabel",handleClick:function(evt){var selected_column=[this.props.plotName,this.props.name];this.props.selectVariable(selected_column)},render:function(){var link=this.props.ipython?this.props.name:React.DOM.a({href:"javascript:",onClick:this.handleClick},this.props.name);return React.DOM.span({className:"canvas-heatmap-axesLabel",style:{position:"absolute",top:""+this.props.y+"px",left:""+this.props.x+"px",width:""+this.props.width+"px"}},link)}});var CanvasFrame=React.createClass({displayName:"CanvasFrame",drawFrame:function(context){context.fillStyle="#444444";context.fillRect(FRAME_PADDING,FRAME_PADDING,this.props.width,this.props.height);context.fillStyle="#0000FF";context.fillRect(FRAME_THICKNESS+FRAME_PADDING,FRAME_THICKNESS+FRAME_PADDING,this.props.width-2*FRAME_THICKNESS,this.props.height-2*FRAME_THICKNESS)},drawTicksAndGrid:function(context){context.lineWidth=1;context.fillStyle="#333333";for(var i=0;i<this.props.xScale.ticks().length;i++){var xValue=this.props.xScale.ticks()[i];if(this.props.gridlinesVisible){context.strokeStyle="#999999";context.beginPath();context.moveTo(FRAME_PADDING+this.props.xScale(xValue),FRAME_PADDING);context.lineTo(FRAME_PADDING+this.props.xScale(xValue),FRAME_PADDING+this.props.height);context.stroke()}context.strokeStyle="#444444";context.beginPath();context.moveTo(FRAME_PADDING+this.props.xScale(xValue),FRAME_PADDING+this.props.height-TICK_HEIGHT);context.lineTo(FRAME_PADDING+this.props.xScale(xValue),FRAME_PADDING+this.props.height+TICK_HEIGHT);context.stroke();context.font="12px Helvetica";context.fillText(""+formatLabels(xValue),FRAME_PADDING+this.props.xScale(xValue)-TICK_WIDTH/2,FRAME_PADDING+this.props.height+2*TICK_HEIGHT)}for(var i=0;i<this.props.yScale.ticks().length;i++){var yValue=this.props.yScale.ticks()[i];if(this.props.gridlinesVisible){context.strokeStyle="#999999";context.beginPath();context.moveTo(FRAME_PADDING,FRAME_PADDING+this.props.yScale(yValue));context.lineTo(FRAME_PADDING+this.props.width,FRAME_PADDING+this.props.yScale(yValue));context.stroke()}context.strokeStyle="#444444";context.beginPath();context.moveTo(FRAME_PADDING-TICK_WIDTH,FRAME_PADDING+this.props.yScale(yValue));context.lineTo(FRAME_PADDING+TICK_WIDTH,FRAME_PADDING+this.props.yScale(yValue));context.stroke();context.font="12px Helvetica";context.fillText(""+formatLabels(yValue),FRAME_PADDING/3,FRAME_PADDING+this.props.yScale(yValue))}},drawAxis:function(context){context.lineWidth=1;var axisXVal=this.props.xScale(0);if(axisXVal<0)axisXVal=0;else if(axisXVal>this.props.width)axisXVal=this.props.width;axisXVal+=FRAME_PADDING;context.strokeStyle="#222222";context.beginPath();context.moveTo(axisXVal-1,FRAME_PADDING);context.lineTo(axisXVal-1,FRAME_PADDING+this.props.height);context.stroke();var axisYVal=this.props.yScale(0);if(axisYVal<0)axisYVal=0;else if(axisYVal>this.props.height)axisYVal=this.props.height;axisYVal+=FRAME_PADDING;context.strokeStyle="#222222";context.beginPath();context.moveTo(FRAME_PADDING,axisYVal+1);context.lineTo(FRAME_PADDING+this.props.width,axisYVal+1);context.stroke()},drawBins:function(context){var binScreenWidth=this.props.xScale(this.props.binWidth)-this.props.xScale(0);var binScreenHeight=this.props.yScale(0)-this.props.yScale(this.props.binHeight);var maxWeight=Number.NEGATIVE_INFINITY;var minWeight=Number.POSITIVE_INFINITY;for(var i=0;i<this.props.bins.length;i++){for(var j=0;j<this.props.bins[i].length;j++){if(this.props.bins[i][j]>maxWeight)maxWeight=this.props.bins[i][j];if(this.props.bins[i][j]<minWeight)minWeight=this.props.bins[i][j]}}this.props.heatScale.domain([minWeight,maxWeight]).range([0,1]);if(this.props.heatScale.clamp()&&minWeight==0)this.props.heatScale.domain([1e-5,maxWeight]);for(var i=0;i<this.props.bins.length;i++){for(var j=0;j<this.props.bins[i].length;j++){var bin=this.props.bins[i][j];var xPos=this.props.xScale(this.props.binningDomain.minX+i*this.props.binWidth)+FRAME_PADDING;var yPos=this.props.yScale(this.props.binningDomain.maxY-j*this.props.binHeight)+FRAME_PADDING;if(xPos<FRAME_PADDING-binScreenWidth||xPos>FRAME_PADDING+this.props.width||yPos<FRAME_PADDING-binScreenHeight||yPos>FRAME_PADDING+this.props.height)continue;var binRenderWidth=binScreenWidth;var binRenderHeight=binScreenHeight;if(xPos<FRAME_PADDING)xPos=FRAME_PADDING;if(yPos>FRAME_PADDING+this.props.height-binScreenHeight)binRenderHeight=FRAME_PADDING+this.props.height-yPos;if(xPos>FRAME_PADDING+this.props.width-binScreenWidth)binRenderWidth=FRAME_PADDING+this.props.width-xPos;if(yPos<FRAME_PADDING)yPos=FRAME_PADDING;var rgb=getRGB(bin,this.props.heatScale);var rgbString="rgb("+rgb[0]+","+rgb[1]+","+rgb[2]+")";context.fillStyle=rgbString;context.fillRect(xPos,yPos,binRenderWidth,binRenderHeight)}}},drawGradientScale:function(context){var grd=context.createLinearGradient(this.props.width+FRAME_PADDING+5,75,this.props.width+FRAME_PADDING+30,275);grd.addColorStop(0,"rgba(255, 0, 0, 1.000)");grd.addColorStop(.25,"rgba(255, 255, 0, 1.000)");grd.addColorStop(.5,"rgba(0, 255, 0, 1.000)");grd.addColorStop(.75,"rgba(0, 255, 255, 1.000)");grd.addColorStop(1,"rgba(0, 0, 255, 1.000)");context.fillStyle=grd;context.fillRect(this.props.width+FRAME_PADDING+5,75,25,200);context.font="12px Helvetica";context.strokeStyle="#444444";context.fillStyle="#444444";for(var i=0;i<3;i++){var colorWeight=i*.5;var pointWeight=this.props.heatScale.invert(colorWeight);if(isNaN(pointWeight)||pointWeight<1e-4){pointWeight=0}context.fillText(""+formatLabels(pointWeight),this.props.width+FRAME_PADDING+30,(2-i)*100+75)}context.fillText("point density",this.props.width+FRAME_PADDING,50)},draw:function(context){this.drawFrame(context);this.drawBins(context);this.drawTicksAndGrid(context);this.drawAxis(context);this.drawGradientScale(context)},componentDidMount:function(){var context=this.getDOMNode().getContext("2d");this.draw(context)},componentDidUpdate:function(){var context=this.getDOMNode().getContext("2d");context.clearRect(0,0,this.props.width+2*FRAME_PADDING,this.props.height+2*FRAME_PADDING);this.draw(context)},render:function(){return React.DOM.canvas({className:"canvas-heatmap-canvas",width:this.props.width+2*FRAME_PADDING,height:this.props.height+2*FRAME_PADDING})}});return{Heatmap:React.createClass({displayName:"Heatmap",getDefaultProps:function(){return{bins:[],binWidth:10,binHeight:10,width:500,height:500,extrema:{minX:0,maxX:10,minY:0,maxY:10},xLabel:"",yLabel:"",numValues:0}},getInitialState:function(){return{heatScale:d3.scale.linear(),gridlinesVisible:true,blurAmount:1,shouldShowBlur:true}},toggleGridlines:function(){this.setState({gridlinesVisible:!this.state.gridlinesVisible})},changeBlur:function(evt){var newBlurVal=evt.target.value;if(newBlurVal==0){this.setState({shouldShowBlur:false})}else{this.setState({shouldShowBlur:true})}this.setState({blurAmount:newBlurVal})},changeHeatFunction:function(event){var functionType=event.target.value;if(functionType=="linear")this.setState({heatScale:d3.scale.linear()});else if(functionType=="log")this.setState({heatScale:d3.scale.log().clamp(true)});else if(functionType=="quadratic")this.setState({heatScale:d3.scale.pow().exponent(2)});else if(functionType=="sqrt")this.setState({heatScale:d3.scale.sqrt()})},render:function(){var numIters=4;var alteredBins=$.extend(true,[],this.props.bins);if(this.state.shouldShowBlur){for(var k=0;k<numIters;k++){var incrementBins=$.extend(true,[],alteredBins);for(var i=0;i<alteredBins.length;i++){for(var j=0;j<alteredBins[i].length;j++){incrementAdjacentCells(alteredBins,this.state.blurAmount*incrementBins[i][j]/250,i,j)}}}var newNumValues=0;for(var i=0;i<alteredBins.length;i++){for(var j=0;j<alteredBins[i].length;j++){newNumValues+=alteredBins[i][j]}}var numCurrentValues=0;for(var i=0;i<this.props.bins.length;i++){for(var j=0;j<this.props.bins[i].length;j++){numCurrentValues+=this.props.bins[i][j]}}for(var i=0;i<alteredBins.length;i++){for(var j=0;j<alteredBins[i].length;j++){Math.round(alteredBins[i][j]*=numCurrentValues/newNumValues)}}}TICK_HEIGHT=this.props.height/50;TICK_WIDTH=this.props.width/50;var minX=this.props.domainToShow.minX;var minY=this.props.domainToShow.minY;var maxX=this.props.domainToShow.maxX;var maxY=this.props.domainToShow.maxY;var xScale=d3.scale.linear().domain([minX,maxX]).range([0,this.props.width]);var yScale=d3.scale.linear().domain([minY,maxY]).range([this.props.height,0]);var SliderControl=Controls.Slider;return React.DOM.div({className:"canvas-heatmap-frame"},CanvasFrame({className:"canvas-heatmap-canvasFrame",width:this.props.width,height:this.props.height,xScale:xScale,yScale:yScale,heatScale:this.state.heatScale,bins:alteredBins,originalBins:this.props.bins,binWidth:this.props.binWidth,binHeight:this.props.binHeight,binningDomain:this.props.extrema,numValues:this.props.numValues,gridlinesVisible:this.state.gridlinesVisible,shouldShowBlur:this.state.shouldShowBlur}),React.DOM.input({className:"canvas-heatmap-toggleButton",type:"checkbox",name:"gridlineToggle",onChange:this.toggleGridlines,style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING+25)/2+"px",left:""+(this.props.width+2*FRAME_PADDING)+"px"}}),React.DOM.p({className:"canvas-heatmap-toggleLabel",style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING+25)/2+"px",left:""+(this.props.width+2.25*FRAME_PADDING)+"px",width:"200px"}},"Hide Gridlines"),SliderControl({label:"blur",min:0,max:100,value:this.state.blurAmount,onChange:this.changeBlur}),React.DOM.select({className:"canvas-heatmap-changeFunction",type:"checkbox",name:"functionSelect",onChange:this.changeHeatFunction,style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING-25)/2+"px",left:""+(this.props.width+2*FRAME_PADDING)+"px"}},React.DOM.option({value:"linear"},"Linear"),React.DOM.option({value:"quadratic"},"Quadratic"),React.DOM.option({value:"sqrt"},"Square Root"),React.DOM.option({value:"log"},"Logarithmic")),React.DOM.p({className:"canvas-heatmap-toggleLabel",style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING-75)/2+"px",left:""+(this.props.width+2*FRAME_PADDING)+"px",width:"200px"}},"Heat Scaling Function"),[{name:this.props.xLabel,x:FRAME_PADDING,y:this.props.height+FRAME_PADDING*1.5,width:this.props.width},{name:this.props.yLabel,x:0,y:FRAME_PADDING/2.5,width:"auto"}].map(function(axis,idx){return AxisLabel({key:idx,name:axis.name,selectVariable:this.props.selectVariable,plotName:this.props.plotName,x:axis.x,y:axis.y,width:axis.width,ipython:this.props.ipython})}.bind(this)))}})}});