"use strict";define("plot_scatter",["react","d3","jquery","common_controls","common_util"],function(React,d3,jQuery,Controls,Util){var LINE_GRAPH_THRESHOLD=1e3;var FRAME_PADDING=75;var FRAME_THICKNESS=1;var TICK_WIDTH=10;var TICK_HEIGHT=10;var PADDING_FRACTION=.01;var POINT_RADIUS=5;var SHIFT_DURATION=1;var SCROLL_DOMAIN_FRACTION=.9;var formatLabels=function(num){if(d3.format(".3g")(num).length>7)return d3.format(".1g")(num);else return d3.format(".3g")(num)};var PointsRenderer=React.createClass({displayName:"PointsRenderer",render:function(){var xScale=this.props.xScaleFunc;var yScale=this.props.yScaleFunc;var height=this.props.height;var width=this.props.width;var data=this.props.data;if(this.props.shouldShowLineGraph){data=Util.deepCopy(data);data.sort(function(point1,point2){return point1.x-point2.x})}function getOpacity(point,idx){if(xScale(point.x)<0||xScale(point.x)>width||yScale(point.y)<0||yScale(point.y)>height)return 0;else return 1}var pointNodes=null;if(!this.props.shouldShowLineGraph){pointNodes=data.map(function(point,idx){var xPos=xScale(point.x)+FRAME_PADDING;var yPos=yScale(point.y)+FRAME_PADDING;if(xPos<FRAME_PADDING)xPos=FRAME_PADDING-5;if(xPos>width+FRAME_PADDING)xPos=width+FRAME_PADDING+5;if(yPos<FRAME_PADDING)yPos=FRAME_PADDING-5;if(yPos>FRAME_PADDING+height)yPos=height+FRAME_PADDING+5;var key=idx;var circlePoint=React.DOM.circle({className:"canvas-scatter-point",cx:"0",cy:"0",style:{transform:"translate("+xPos+"px, "+yPos+"px)","-webkit-transform":"translate("+xPos+"px, "+yPos+"px)",opacity:""+getOpacity(point,idx)},r:POINT_RADIUS,key:key},React.DOM.title(null," ","("+point.x+", "+point.y+")"," "));return circlePoint})}var lines=[];if(this.props.shouldShowLineGraph){var previousX=null;var previousY=null;for(var i=0;i<data.length;i++){if(previousX!=null&&previousY!=null){var x1=xScale(previousX)+FRAME_PADDING;var y1=yScale(previousY)+FRAME_PADDING;var x2=xScale(data[i].x)+FRAME_PADDING;var y2=yScale(data[i].y)+FRAME_PADDING;var lineTooltip="("+previousX+", "+previousY+") -> ("+data[i].x+", "+data[i].y+")";var opacity=1;if(x2<FRAME_PADDING||x1>FRAME_PADDING+width)opacity=0;if(y1<FRAME_PADDING&&y2<FRAME_PADDING||y1>FRAME_PADDING+height&&y2>FRAME_PADDING+height)opacity=0;if(x1<FRAME_PADDING)x1=FRAME_PADDING;if(x1>FRAME_PADDING+width)x1=FRAME_PADDING+width;if(x2<FRAME_PADDING)x2=FRAME_PADDING;if(x2>FRAME_PADDING+width)x2=FRAME_PADDING+width;if(y1<FRAME_PADDING)y1=FRAME_PADDING;if(y1>FRAME_PADDING+height)y1=FRAME_PADDING+height;if(y2<FRAME_PADDING)y2=FRAME_PADDING;if(y2>FRAME_PADDING+height)y2=FRAME_PADDING+height;lines.push(React.DOM.line({className:"canvas-scatter-lineGraph",x1:x1,y1:y1,x2:x2,y2:y2,style:{opacity:opacity},key:i},React.DOM.title(null," ",lineTooltip," ")))}previousX=data[i].x;previousY=data[i].y}}return React.DOM.g(null,lines,pointNodes)}});var TrendlineRenderer=React.createClass({displayName:"TrendlineRenderer",render:function(){var width=this.props.width;var height=this.props.height;var coefficients=this.props.coefficients;var xScale=this.props.xScaleFunc;var yScale=this.props.yScaleFunc;if(coefficients.m==null||!this.props.trendlineVisible){return React.DOM.g(null," ")}var x1=FRAME_PADDING;var y1=FRAME_PADDING+yScale(xScale.invert(0)*coefficients.m+coefficients.b);var y2=FRAME_PADDING+yScale(xScale.invert(width)*coefficients.m+coefficients.b);var x2=width+FRAME_PADDING;if(y1<FRAME_PADDING){y1=FRAME_PADDING;x1=FRAME_PADDING+xScale((yScale.invert(0)-coefficients.b)/coefficients.m)}if(y1>height+FRAME_PADDING){y1=height+FRAME_PADDING;x1=FRAME_PADDING+xScale((yScale.invert(height)-coefficients.b)/coefficients.m)}if(y2<FRAME_PADDING){y2=FRAME_PADDING;x2=FRAME_PADDING+xScale((yScale.invert(0)-coefficients.b)/coefficients.m)}if(y2>height+FRAME_PADDING){y2=height+FRAME_PADDING;x2=FRAME_PADDING+xScale((yScale.invert(height)-coefficients.b)/coefficients.m)}var trendlineEquation="y = "+coefficients.m+"x + "+coefficients.b;return React.DOM.g(null,React.DOM.line({className:"canvas-scatter-trendline",x1:x1,y1:y1,x2:x2,y2:y2},React.DOM.title(null,trendlineEquation)))}});var AxisRenderer=React.createClass({displayName:"AxisRenderer",render:function(){var xScale=this.props.xScaleFunc;var yScale=this.props.yScaleFunc;var width=this.props.width;var height=this.props.height;var gridlinesVisible=this.props.gridlinesVisible;var axisXVal=xScale(0);if(axisXVal<0){axisXVal=0}else if(axisXVal>width){axisXVal=width}axisXVal+=FRAME_PADDING;var axisYVal=yScale(0);if(axisYVal<0){axisYVal=0}else if(axisYVal>height){axisYVal=height}axisYVal+=FRAME_PADDING;var gridlineVisibility=gridlinesVisible?"visible":"hidden";var xLinesAndLabels=xScale.ticks().map(function(xValue,idx){return React.DOM.g({key:"Xg-"+idx},React.DOM.line({className:"canvas-scatter-gridlines",x1:"0",x2:"0",y1:FRAME_PADDING,y2:height+FRAME_PADDING,key:"Xgridline-"+xValue,style:{transform:"translate("+(xScale(xValue)+FRAME_PADDING)+"px, "+0+"px)","-webkit-transform":"translate("+(xScale(xValue)+FRAME_PADDING)+"px, "+0+"px)","transition-property":"transform","-webkit-transition-property":"-webkit-transform","transition-duration":""+SHIFT_DURATION+"s","-webkit-transition-duration":""+SHIFT_DURATION+"s",visibility:gridlineVisibility}}),React.DOM.line({className:"canvas-scatter-ticks",x1:"0",x2:"0",y1:height+FRAME_PADDING+TICK_HEIGHT/2,y2:height+FRAME_PADDING-TICK_HEIGHT/2,key:"Xticks-"+xValue,style:{transform:"translate("+(xScale(xValue)+FRAME_PADDING)+"px, "+0+"px)","-webkit-transform":"translate("+(xScale(xValue)+FRAME_PADDING)+"px, "+0+"px)","transition-property":"transform","-webkit-transition-property":"-webkit-transform","-webkit-transition-duration":""+SHIFT_DURATION+"s","transition-duration":""+SHIFT_DURATION+"s"}}),React.DOM.text({className:"canvas-scatter-numLabel",x:xScale(xValue)+FRAME_PADDING,y:height+FRAME_PADDING*1.35,key:"XnumLabel-"+xValue},formatLabels(xValue)))});var yLinesAndLabels=yScale.ticks().map(function(yValue,idx){return React.DOM.g({key:"Yg-"+idx},React.DOM.line({className:"canvas-scatter-gridlines",x1:FRAME_PADDING,x2:width+FRAME_PADDING,y1:0,y2:0,key:"Ygridline-"+yValue,style:{transform:"translate("+0+"px, "+(yScale(yValue)+FRAME_PADDING)+"px)","-webkit-transform":"translate("+0+"px, "+(yScale(yValue)+FRAME_PADDING)+"px)","transition-property":"transform","-webkit-transition-property":"-webkit-transform","transition-duration":""+SHIFT_DURATION+"s","-webkit-transition-duration":""+SHIFT_DURATION+"s",visibility:gridlineVisibility}}),React.DOM.line({className:"canvas-scatter-ticks",x1:FRAME_PADDING-TICK_WIDTH/2,x2:FRAME_PADDING+TICK_WIDTH/2,y1:0,y2:0,key:"Yticks-"+yValue,style:{transform:"translate("+0+"px, "+(yScale(yValue)+FRAME_PADDING)+"px)","-webkit-transform":"translate("+0+"px, "+(yScale(yValue)+FRAME_PADDING)+"px)","transition-property":"transform","-webkit-transition-property":"-webkit-transform","-webkit-transition-duration":""+SHIFT_DURATION+"s","transition-duration":""+SHIFT_DURATION+"s"}}),React.DOM.text({className:"canvas-scatter-numLabel",x:FRAME_PADDING/1.75,y:yScale(yValue)+FRAME_PADDING+4,key:"YnumLabel-"+yValue},formatLabels(yValue)))});return React.DOM.g(null,xLinesAndLabels,yLinesAndLabels,React.DOM.line({className:"canvas-scatter-axes",x1:0,y1:FRAME_PADDING,x2:0,y2:height+FRAME_PADDING,style:{transform:"translate("+axisXVal+"px, "+0+"px)","-webkit-transform":"translate("+axisXVal+"px, "+0+"px)","transition-property":"transform","-webkit-transition-property":"-webkit-transform","-webkit-transition-duration":""+SHIFT_DURATION+"s","transition-duration":""+SHIFT_DURATION+"s"}}),React.DOM.line({className:"canvas-scatter-axes",x1:FRAME_PADDING,y1:0,x2:width+FRAME_PADDING,y2:0,style:{transform:"translate("+0+"px, "+axisYVal+"px)","-webkit-transform":"translate("+0+"px, "+axisYVal+"px)","transition-property":"transform","-webkit-transition-property":"-webkit-transform","-webkit-transition-duration":""+SHIFT_DURATION+"s","transition-duration":""+SHIFT_DURATION+"s"}}))}});var AxisLabel=React.createClass({displayName:"AxisLabel",handleClick:function(evt){var selected_column=[this.props.plotName,this.props.name];this.props.selectVariable(selected_column)},render:function(){var link=this.props.ipython?this.props.name:React.DOM.a({href:"javascript:",onClick:this.handleClick},this.props.name);return React.DOM.span({className:"canvas-scatter-axesLabel",style:{position:"absolute",top:""+this.props.y+"px",left:""+this.props.x+"px",width:""+this.props.width+"px"}},link)}});return{Scatter:React.createClass({displayName:"Scatter",getDefaultProps:function(){return{width:500,height:500,data:[],extrema:{minX:0,maxX:10,minY:0,maxY:10},xLabel:"",yLabel:"",coefficients:{},lineGraph:false}},getInitialState:function(){var paddedExtrema=this.padExtrema(this.props.extrema);return{domainToShow:paddedExtrema,gridlinesVisible:true,trendlineVisible:true}},padExtrema:function(extrema){var originalDomain=extrema.maxX-extrema.minX;var originalRange=extrema.maxY-extrema.minY;var paddedExtrema={};paddedExtrema.minX=extrema.minX-PADDING_FRACTION*originalDomain;paddedExtrema.minY=extrema.minY-PADDING_FRACTION*originalRange;paddedExtrema.maxX=extrema.maxX+PADDING_FRACTION*originalDomain;paddedExtrema.maxY=extrema.maxY+PADDING_FRACTION*originalRange;return paddedExtrema},toggleTrendline:function(){this.setState({trendlineVisible:!this.state.trendlineVisible})},toggleGridlines:function(){this.setState({gridlinesVisible:!this.state.gridlinesVisible})},componentWillReceiveProps:function(nextProps){this.setState({domainToShow:this.padExtrema(nextProps.extrema)})},render:function(){TICK_HEIGHT=this.props.height/50;TICK_WIDTH=this.props.width/50;var minX=this.state.domainToShow.minX;var minY=this.state.domainToShow.minY;var maxX=this.state.domainToShow.maxX;var maxY=this.state.domainToShow.maxY;if(this.props.lineGraph){var range=maxY-minY;maxY+=range/4;var newMinY=minY-range/4;if(newMinY<0&&minY>=0){newMinY=0}if(newMinY>0&&newMinY-0<range/4){newMinY=0}minY=newMinY}var xScale=d3.scale.linear().domain([minX,maxX]).range([0,this.props.width]);var yScale=d3.scale.linear().domain([minY,maxY]).range([this.props.height,0]);var trendlineButtonVisiblity=this.props.coefficients.m==null?"hidden":"visible";function wheelScrolled(e){e.preventDefault();var zoomScreenX=e.pageX-$(".canvas-scatter-rectFrame").offset().left;var zoomScreenY=e.pageY-$(".canvas-scatter-rectFrame").offset().top;if(zoomScreenX<0||zoomScreenX>this.props.width||zoomScreenY<0||zoomScreenY>this.props.height){return}var zoomValueX=xScale.invert(zoomScreenX);var zoomValueY=yScale.invert(zoomScreenY);if(e.deltaY<0){var newDomainXSize=(this.state.domainToShow.maxX-this.state.domainToShow.minX)*SCROLL_DOMAIN_FRACTION;var newDomainYSize=(this.state.domainToShow.maxY-this.state.domainToShow.minY)*SCROLL_DOMAIN_FRACTION;var newDomainToShow={};if(zoomValueX-newDomainXSize/2<this.state.domainToShow.minX){newDomainToShow.minX=this.state.domainToShow.minX;newDomainToShow.maxX=this.state.domainToShow.minX+newDomainXSize}else if(zoomValueX+newDomainXSize/2>this.state.domainToShow.maxX){newDomainToShow.maxX=this.state.domainToShow.maxX;newDomainToShow.minX=this.state.domainToShow.maxX-newDomainXSize}else{newDomainToShow.minX=zoomValueX-newDomainXSize/2;newDomainToShow.maxX=zoomValueX+newDomainXSize/2}if(zoomValueY-newDomainYSize/2<this.state.domainToShow.minY){newDomainToShow.minY=this.state.domainToShow.minY;newDomainToShow.maxY=this.state.domainToShow.minY+newDomainYSize}else if(zoomValueY+newDomainYSize/2>this.state.domainToShow.maxY){newDomainToShow.maxY=this.state.domainToShow.maxY;newDomainToShow.minY=this.state.domainToShow.maxY-newDomainYSize}else{newDomainToShow.minY=zoomValueY-newDomainYSize/2;newDomainToShow.maxY=zoomValueY+newDomainYSize/2}this.setState({domainToShow:newDomainToShow})}else{this.setState({domainToShow:this.padExtrema(this.props.extrema)})}}return React.DOM.div({className:"canvas-scatter-frame"},React.DOM.svg({className:"canvas-scatter-svgFrame",width:this.props.width+2*FRAME_PADDING,height:this.props.height+2*FRAME_PADDING,onWheel:wheelScrolled.bind(this)},React.DOM.rect({className:"canvas-scatter-rectFrame",width:this.props.width,height:this.props.height,x:FRAME_PADDING,y:FRAME_PADDING}),AxisRenderer({xScaleFunc:xScale,yScaleFunc:yScale,width:this.props.width,height:this.props.height,gridlinesVisible:this.state.gridlinesVisible}),TrendlineRenderer({xScaleFunc:xScale,yScaleFunc:yScale,width:this.props.width,height:this.props.height,coefficients:this.props.coefficients,trendlineVisible:this.state.trendlineVisible}),PointsRenderer({data:this.props.data,xScaleFunc:xScale,yScaleFunc:yScale,height:this.props.height,width:this.props.width,shouldShowLineGraph:this.props.lineGraph})),React.DOM.input({className:"canvas-scatter-toggleButton",type:"checkbox",name:"trendlineToggle",onClick:this.toggleTrendline,style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING-25)/2+"px",left:""+(this.props.width+1.5*FRAME_PADDING)+"px",visibility:trendlineButtonVisiblity}}),React.DOM.p({className:"canvas-scatter-toggleLabel",style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING-25)/2+"px",left:""+(this.props.width+1.75*FRAME_PADDING)+"px",visibility:trendlineButtonVisiblity}},"Toggle trendline"),React.DOM.input({className:"canvas-scatter-toggleButton",type:"checkbox",name:"gridlineToggle",onClick:this.toggleGridlines,style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING+25)/2+"px",left:""+(this.props.width+1.5*FRAME_PADDING)+"px"}}),React.DOM.p({className:"canvas-scatter-toggleLabel",style:{position:"absolute",top:""+(this.props.height+2*FRAME_PADDING+25)/2+"px",left:""+(this.props.width+1.75*FRAME_PADDING)+"px"}},"Toggle gridlines"),[{name:this.props.xLabel,x:FRAME_PADDING,y:this.props.height+FRAME_PADDING*1.5,width:this.props.width},{name:this.props.yLabel,x:0,y:FRAME_PADDING/2.5,width:"auto"}].map(function(axis,idx){return AxisLabel({key:idx,name:axis.name,selectVariable:this.props.selectVariable,plotName:this.props.plotName,x:axis.x,y:axis.y,width:axis.width,ipython:this.props.ipython})}.bind(this)))}})}});