import graphlab.canvas.views.base
import graphlab.canvas.views.predservice


class PredictiveServiceList(graphlab.canvas.views.base.BaseView):
    def __init__(self, obj, params=None):
        super(PredictiveServiceList, self).__init__(obj, params)
        self.objectType = 'PredictiveServiceList'
        self.__child_views = {}
        self.objectType = 'PredictiveServices' # override default object type

    def get_metadata(self):
        pslist = self.__get_ps_list()
        data = {
            'list' : pslist,
            'pslistName' : 'Predictive Service'
        }
        return data

    def __get_ps_list(self):
        pslist = self.obj._list() # returns a SFrame
        self.__child_views = {}
        for row in pslist:
            endpoint = row['S3_path']
            name = row['Name']
            index = row['Index']
            in_memory = row['In-Memory?']
            params = {
                'endpoint' : endpoint,
                'index' : index,
                'in_memory' : in_memory
            }
            self.__child_views[name] = graphlab.canvas.views.predservice.PredictiveService(name, params=params)
        return list(pslist)

    
    def child_views(self):
        self.__get_ps_list()
        return self.__child_views

    def get_js_file(self):
        return 'ps_session'

    def get_temporary_name(self):
        return ('Predictive Services',)
