"""
This module provides Python-variable wrapping/exposing to GraphLab Canvas.
The find_vars decorator allows arbitrary functions to expose their local variables
to Canvas.
"""

from __future__ import absolute_import

import graphlab
import graphlab.canvas

import functools
import inspect

def find_vars(f):
    """
    Wrapper decorator to find all the local variables in the caller, and for any that match
    GraphLab data structures, we will keep a reference (by name) in this module.
    """

    @functools.wraps(f)
    def wrapper(self=None, *args, **kwargs):
        """
        Given a dictionary of local variables from a stack frame, identify which ones correspond to GraphLab data
        structures and store those in _vars so we can update the browser.
        """
        target = graphlab.canvas.get_target()
        var_dict = inspect.currentframe().f_back.f_locals
        for k,v in var_dict.iteritems():
            if k.startswith('_'):
                # ignore underscore names, generated by IPython
                continue
            if graphlab.canvas._same_object(self, v):
                target.add_variable((k,), v)
        return f(self, *args, **kwargs) # call the original function
    return wrapper
