"""
Predictive Services provide an easy way for users to turn one or more GraphLab
models into a cloud service that can be used to provide predictions or
recommendatations to customer applications.
"""

# We keep track of Predictive Service and Predicitve Object schema version here.
# The way to evolve them is:
# * If Predictive Service schema changes, but Predictive Object schema does not
#   need to change, PREDICTIVE_SERVICE_SCHEMA_VERSION is increased by 1, but
#   PREDICTIVE_OBJECT_SCHEMA_VERSION stays the same.
# * If Predictive Object schema changes, then both Predictive Service and
#   Predictive Object version are bumped up to be PREDICTIVE_SERVICE_SCHEMA_VERSION
#   plus one

# This scheme allows the following:
# *  A Predictive Service with version Vs can always load Predictive Service with
#    version less than or equal to Vs, it will fail otherwise
# *  A Predictive Service with version Vs can always load Predictive Objects with
#    version less than or equal to Vs, it will fail otherwise

PREDICTIVE_SERVICE_SCHEMA_VERSION = 1
PREDICTIVE_OBJECT_SCHEMA_VERSION = 1
assert(PREDICTIVE_SERVICE_SCHEMA_VERSION >=  PREDICTIVE_OBJECT_SCHEMA_VERSION)

import _predictive_object
import _model_predictive_object
import _file_util
import _predictive_service
import _predictive_service_endpoint

