/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Vector;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.instrument.Archive;
import net.sourceforge.cobertura.instrument.ClassPattern;
import net.sourceforge.cobertura.instrument.CoberturaFile;
import net.sourceforge.cobertura.instrument.CoberturaInstrumenter;
import net.sourceforge.cobertura.util.ArchiveUtil;
import net.sourceforge.cobertura.util.CommandLineBuilder;
import net.sourceforge.cobertura.util.Header;
import net.sourceforge.cobertura.util.IOUtil;
import net.sourceforge.cobertura.util.RegexUtil;
import org.apache.log4j.Logger;

public class Main {
    private static final LoggerWrapper logger = new LoggerWrapper();
    private File destinationDirectory = null;
    private final ClassPattern classPattern = new ClassPattern();
    private final CoberturaInstrumenter coberturaInstrumenter = new CoberturaInstrumenter();
    public static URLClassLoader urlClassLoader;

    private static boolean isClass(ZipEntry entry) {
        return entry.getName().endsWith(".class");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addInstrumentationToArchive(CoberturaFile file, InputStream archive, OutputStream output) throws Exception {
        boolean bl;
        ZipInputStream zis = null;
        ZipOutputStream zos = null;
        try {
            zis = new ZipInputStream(archive);
            zos = new ZipOutputStream(output);
            bl = this.addInstrumentationToArchive(file, zis, zos);
        }
        catch (Throwable throwable) {
            zis = (ZipInputStream)IOUtil.closeInputStream(zis);
            zos = (ZipOutputStream)IOUtil.closeOutputStream(zos);
            throw throwable;
        }
        zis = (ZipInputStream)IOUtil.closeInputStream(zis);
        zos = (ZipOutputStream)IOUtil.closeOutputStream(zos);
        return bl;
    }

    private void addElementsToJVM(String classpath) {
        String[] classpathParsed;
        ArrayList<URL> urlsArray = new ArrayList<URL>();
        for (String element : classpathParsed = classpath.split(File.pathSeparator)) {
            File f = null;
            try {
                f = new File(element);
                urlsArray.add(f.toURI().toURL());
            }
            catch (MalformedURLException e) {
                logger.debug("Warning - could not convert file: " + element + " to a URL.", e);
            }
        }
        urlClassLoader = new URLClassLoader(urlsArray.toArray(new URL[urlsArray.size()]));
    }

    private boolean addInstrumentationToArchive(CoberturaFile file, ZipInputStream archive, ZipOutputStream output) throws Exception {
        ZipEntry entry;
        boolean modified = false;
        while ((entry = archive.getNextEntry()) != null) {
            try {
                String entryName = entry.getName();
                if (ArchiveUtil.isSignatureFile(entry.getName())) continue;
                ZipEntry outputEntry = new ZipEntry(entry.getName());
                outputEntry.setComment(entry.getComment());
                outputEntry.setExtra(entry.getExtra());
                outputEntry.setTime(entry.getTime());
                output.putNextEntry(outputEntry);
                byte[] entryBytes = IOUtil.createByteArrayFromInputStream(archive);
                if (this.classPattern.isSpecified() && ArchiveUtil.isArchive(entryName)) {
                    Archive archiveObj = new Archive(file, entryBytes);
                    this.addInstrumentationToArchive(archiveObj);
                    if (archiveObj.isModified()) {
                        modified = true;
                        entryBytes = archiveObj.getBytes();
                        outputEntry.setTime(System.currentTimeMillis());
                    }
                } else if (Main.isClass(entry) && this.classPattern.matches(entryName)) {
                    try {
                        CoberturaInstrumenter.InstrumentationResult res = this.coberturaInstrumenter.instrumentClass(new ByteArrayInputStream(entryBytes));
                        if (res != null) {
                            logger.debug("Putting instrumented entry: " + entry.getName());
                            entryBytes = res.getContent();
                            modified = true;
                            outputEntry.setTime(System.currentTimeMillis());
                        }
                    }
                    catch (Throwable t) {
                        if (entry.getName().endsWith("_Stub.class")) {
                            logger.debug("Problems instrumenting archive entry: " + entry.getName(), t);
                        }
                        logger.warn("Problems instrumenting archive entry: " + entry.getName(), t);
                    }
                }
                output.write(entryBytes);
                output.closeEntry();
                archive.closeEntry();
            }
            catch (Exception e) {
                logger.warn("Problems with archive entry: " + entry.getName(), e);
            }
            catch (Throwable t) {
                logger.warn("Problems with archive entry: " + entry.getName(), t);
            }
            output.flush();
        }
        return modified;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentationToArchive(Archive archive) throws Exception {
        InputStream in = null;
        ByteArrayOutputStream out = null;
        try {
            in = archive.getInputStream();
            out = new ByteArrayOutputStream();
            boolean modified = this.addInstrumentationToArchive(archive.getCoberturaFile(), in, out);
            if (modified) {
                out.flush();
                byte[] bytes = out.toByteArray();
                archive.setModifiedBytes(bytes);
            }
        }
        finally {
            in = IOUtil.closeInputStream(in);
            out = (ByteArrayOutputStream)IOUtil.closeOutputStream(out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentationToArchive(CoberturaFile archive) {
        logger.debug("Instrumenting archive " + archive.getAbsolutePath());
        File outputFile = null;
        ZipInputStream input = null;
        ZipOutputStream output = null;
        boolean modified = false;
        try {
            try {
                input = new ZipInputStream(new FileInputStream(archive));
            }
            catch (FileNotFoundException e) {
                logger.warn("Cannot open archive file: " + archive.getAbsolutePath(), e);
                input = (ZipInputStream)IOUtil.closeInputStream(input);
                output = (ZipOutputStream)IOUtil.closeOutputStream(output);
                return;
            }
        }
        catch (Throwable throwable) {
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            throw throwable;
        }
        try {
            if (this.destinationDirectory != null) {
                outputFile = new File(this.destinationDirectory, archive.getPathname());
            } else {
                outputFile = File.createTempFile("CoberturaInstrumentedArchive", "jar");
                outputFile.deleteOnExit();
            }
            output = new ZipOutputStream(new FileOutputStream(outputFile));
        }
        catch (IOException e) {
            logger.warn("Cannot open file for instrumented archive: " + archive.getAbsolutePath(), e);
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            return;
        }
        try {
            modified = this.addInstrumentationToArchive(archive, input, output);
        }
        catch (Throwable e) {
            logger.warn("Cannot instrument archive: " + archive.getAbsolutePath(), e);
            input = (ZipInputStream)IOUtil.closeInputStream(input);
            output = (ZipOutputStream)IOUtil.closeOutputStream(output);
            return;
        }
        input = (ZipInputStream)IOUtil.closeInputStream(input);
        output = (ZipOutputStream)IOUtil.closeOutputStream(output);
        if (modified && this.destinationDirectory == null) {
            try {
                logger.debug("Moving " + outputFile.getAbsolutePath() + " to " + archive.getAbsolutePath());
                IOUtil.moveFile(outputFile, archive);
            }
            catch (IOException e) {
                logger.warn("Cannot instrument archive: " + archive.getAbsolutePath(), e);
                return;
            }
        }
        if (this.destinationDirectory != null && !modified) {
            outputFile.delete();
        }
    }

    private void addInstrumentationToSingleClass(File file) {
        logger.info("Instrumenting: " + file.getAbsolutePath() + " to " + this.destinationDirectory);
        this.coberturaInstrumenter.addInstrumentationToSingleClass(file);
    }

    private void addInstrumentation(CoberturaFile coberturaFile) {
        if (coberturaFile.isClass() && this.classPattern.matches(coberturaFile.getPathname())) {
            this.addInstrumentationToSingleClass(coberturaFile);
        } else if (coberturaFile.isDirectory()) {
            String[] contents = coberturaFile.list();
            for (int i = 0; i < contents.length; ++i) {
                File relativeFile = new File(coberturaFile.getPathname(), contents[i]);
                CoberturaFile relativeCoberturaFile = new CoberturaFile(coberturaFile.getBaseDir(), relativeFile.toString());
                this.addInstrumentation(relativeCoberturaFile);
            }
        }
    }

    private void parseArguments(String[] args) {
        Vector<Pattern> ignoreRegexes = new Vector<Pattern>();
        this.coberturaInstrumenter.setIgnoreRegexes(ignoreRegexes);
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        ArrayList<CoberturaFile> filePaths = new ArrayList<CoberturaFile>();
        String baseDir = null;
        boolean threadsafeRigorous = false;
        boolean ignoreTrivial = false;
        boolean failOnError = false;
        HashSet<String> ignoreMethodAnnotations = new HashSet<String>();
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("--basedir")) {
                baseDir = args[++i];
                continue;
            }
            if (args[i].equals("--datafile")) {
                dataFile = new File(args[++i]);
                continue;
            }
            if (args[i].equals("--destination")) {
                this.destinationDirectory = new File(args[++i]);
                this.coberturaInstrumenter.setDestinationDirectory(this.destinationDirectory);
                continue;
            }
            if (args[i].equals("--ignore")) {
                RegexUtil.addRegex(ignoreRegexes, args[++i]);
                continue;
            }
            if (args[i].equals("--ignoreMethodAnnotation")) {
                ignoreMethodAnnotations.add(args[++i]);
                continue;
            }
            if (args[i].equals("--ignoreTrivial")) {
                ignoreTrivial = true;
                continue;
            }
            if (args[i].equals("--includeClasses")) {
                this.classPattern.addIncludeClassesRegex(args[++i]);
                continue;
            }
            if (args[i].equals("--excludeClasses")) {
                this.classPattern.addExcludeClassesRegex(args[++i]);
                continue;
            }
            if (args[i].equals("--failOnError")) {
                failOnError = true;
                logger.setFailOnError(true);
                continue;
            }
            if (args[i].equals("--threadsafeRigorous")) {
                threadsafeRigorous = true;
                continue;
            }
            if (args[i].equals("--auxClasspath")) {
                this.addElementsToJVM(args[++i]);
                continue;
            }
            filePaths.add(new CoberturaFile(baseDir, args[i]));
        }
        this.coberturaInstrumenter.setIgnoreTrivial(ignoreTrivial);
        this.coberturaInstrumenter.setIgnoreMethodAnnotations(ignoreMethodAnnotations);
        this.coberturaInstrumenter.setThreadsafeRigorous(threadsafeRigorous);
        this.coberturaInstrumenter.setFailOnError(failOnError);
        ProjectData projectData = dataFile.isFile() ? CoverageDataFileHandler.loadCoverageData(dataFile) : new ProjectData();
        this.coberturaInstrumenter.setProjectData(projectData);
        logger.info("Instrumenting " + filePaths.size() + " " + (filePaths.size() == 1 ? "file" : "files") + (this.destinationDirectory != null ? " to " + this.destinationDirectory.getAbsoluteFile() : ""));
        for (CoberturaFile coberturaFile : filePaths) {
            if (coberturaFile.isArchive()) {
                this.addInstrumentationToArchive(coberturaFile);
                continue;
            }
            this.addInstrumentation(coberturaFile);
        }
        CoverageDataFileHandler.saveCoverageData(projectData, dataFile);
    }

    public static void main(String[] args) {
        Header.print(System.out);
        long startTime = System.currentTimeMillis();
        Main main = new Main();
        try {
            args = CommandLineBuilder.preprocessCommandLineArguments(args);
        }
        catch (Exception ex) {
            System.err.println("Error: Cannot process arguments: " + ex.getMessage());
            System.exit(1);
        }
        main.parseArguments(args);
        long stopTime = System.currentTimeMillis();
        logger.info("Instrument time: " + (stopTime - startTime) + "ms");
    }

    private static class LoggerWrapper {
        private final Logger logger = Logger.getLogger(Main.class);
        private boolean failOnError = false;

        private LoggerWrapper() {
        }

        public void setFailOnError(boolean failOnError) {
            this.failOnError = failOnError;
        }

        public void debug(String message) {
            this.logger.debug((Object)message);
        }

        public void debug(String message, Throwable t) {
            this.logger.debug((Object)message, t);
        }

        public void info(String message) {
            this.logger.debug((Object)message);
        }

        public void warn(String message, Throwable t) {
            this.logger.warn((Object)message, t);
            if (this.failOnError) {
                throw new RuntimeException("Warning detected and failOnError is true", t);
            }
        }
    }
}

