define("common_controls",["react","page_layout","common_util","taskqueue","jquery","lodash"],function(React,PageLayout,Util,TaskQueue,jQuery,_){"use strict";var Tooltip=React.createClass({displayName:"Tooltip",render:function(){var style={display:this.props.show?"":"none",top:this.props.y-50,left:this.props.x-150};return React.DOM.div({style:style,className:"canvas-tooltip"},this.props.data)}});var Modal=React.createClass({displayName:"Modal",doNothing:function(evt){evt.stopPropagation()},render:function(){var header=this.props.title?React.DOM.div({className:"modal-header"},React.DOM.button({type:"button",className:"close",onClick:this.props.closeModal},"×"),React.DOM.h4({className:"modal-title"},this.props.title)):null;var modalClass="modal-dialog "+(this.props.additionalClass?this.props.additionalClass:"");return React.DOM.div({style:{color:"black"}},React.DOM.div({onClick:this.props.closeModal,className:"modal fade"+(this.props.open?" in":""),style:{display:this.props.open?"block":"none"}},React.DOM.div({onClick:this.doNothing,className:modalClass},React.DOM.div({className:"modal-content"},header,React.DOM.div({className:"modal-body"},this.props.body)))),React.DOM.div({className:"modal-backdrop fade "+(this.props.open?"in":"hidden")}))}});var SizeToWindow={setWindowDimensions:function(){this.setState({windowHeight:$(window).height(),windowWidth:$(window).width()})},componentWillMount:function(){$(window).bind("resize",this.setWindowDimensions)},componentWillUnmount:function(){$(window).unbind("resize",this.setWindowDimensions)}};return{Button:React.createClass({displayName:"Button",getInitialState:function(){return{depressed:false}},getDefaultProps:function(){return{backgroundColor:"#0a8cc4",depressedColor:"#005991"}},mouseDown:function(){this.setState({depressed:true})},mouseUp:function(){this.setState({depressed:false})},click:function(evt){this.mouseUp();if(!this.props.disabled){return this.props.onClick(evt)}},render:function(){var style=Util.merge({display:"inline-block",paddingLeft:12,paddingRight:12,height:26,fontSize:12,color:"white",backgroundColor:this.state.depressed?this.props.depressedColor:this.props.backgroundColor,textTransform:"uppercase",textAlign:"center",textDecoration:"none",lineHeight:"26px",transition:"background-color "+(this.state.depressed?0:200)+"ms linear"},this.props.style);if(this.props.disabled){style.backgroundColor="grey";style.cursor="not-allowed"}return React.DOM.a({href:"javascript:",onClick:this.click,onMouseDown:this.mouseDown,onMouseUp:this.mouseUp,disabled:this.props.disabled,style:style},this.props.children)}}),Menu:{mixins:[SizeToWindow],getInitialState:function(){return{items:[],menuOpen:false,top:0,left:0}},itemClick:function(item,evt){evt.preventDefault();evt.stopPropagation();item.onClick(props.selected_variableevt)},openMenu:function(items,evt){this.setState({menuOpen:true,items:items,top:evt.clientY,left:evt.clientX})},closeMenu:function(){this.setState({menuOpen:false})},getMenu:function(){if(!this.state.menuOpen){return React.DOM.div(null)}return React.DOM.div(null,React.DOM.div({style:{position:"fixed",top:0,left:0,width:this.state.windowWidth,height:this.state.windowHeight,zIndex:40},onClick:this.closeMenu}),React.DOM.div({style:{position:"fixed",top:this.state.top,left:this.state.left,border:"1px solid #ddd",zIndex:41}},this.state.items.map(function(item,idx){return React.DOM.div({key:idx},React.DOM.a({href:"javascript:",onClick:this.itemClick.bind(this,item),style:{display:"inline-block",width:"100%",padding:4,backgroundColor:"white"}},item.label))}.bind(this))))}},Searchable:{getInitialState:function(){return{search_value:""}},getSearchBox:function(placeholder,style){return React.DOM.input({type:"search",value:this.state.search_value,onChange:this.setSearchValue,placeholder:placeholder,style:style})},setSearchValue:function(evt){this.setState({search_value:evt.target.value})}},Slider:React.createClass({displayName:"Slider",render:function(){Util.assert(this.props.value>=this.props.min);Util.assert(this.props.value<=this.props.max);return React.DOM.div({className:"canvas-slider"},React.DOM.div({className:"canvas-slider-label"},this.props.label),React.DOM.div({className:"canvas-slider-control"},this.props.min,this.transferPropsTo(React.DOM.input({type:"range",name:"canvas-slider-range"})),this.props.max),React.DOM.div({className:"canvas-slider-box"},this.transferPropsTo(React.DOM.input({type:"number",name:"canvas-slider-number"}))))}}),SortableTable:React.createClass({displayName:"SortableTable",getValue:function(data,rowIdx,colIdx){var ret=null;if(rowIdx===null){if(this.props.sortable.indexOf(colIdx)!=-1){var className="fa fa-sort";if(this.props.sortColumn===colIdx){if(this.props.types[colIdx]==="number"){className+="-numeric"}else if(this.props.types[colIdx]==="string"){className+="-alpha"}}if(this.props.sortColumn===colIdx&&this.props.sortDesc){className+="-desc"}else if(this.props.sortColumn===colIdx){className+="-asc"}ret=React.DOM.span(null,data[colIdx],React.DOM.a({onClick:this.sort.bind(this,colIdx),href:"javascript:"},React.DOM.i({className:className,style:{marginLeft:6,marginRight:6}})))}else{ret=data[colIdx]}}else{ret=data[rowIdx][colIdx]}return React.DOM.div({style:{padding:8,display:"inline-block"}},ret)},getDefaultProps:function(){return{sortable:[],sortColumn:null,sortDesc:false,renderTD:true}},copyProps:function(){return{data:Util.deepCopy(this.props.data),sortColumn:this.props.sortColumn,sortDesc:this.props.sortDesc}},sort:function(colIdx){var sortDesc=this.props.sortColumn===colIdx&&!this.props.sortDesc;this.props.onSort(colIdx,sortDesc)},render:function(){var data=Util.deepCopy(this.props.data);var sortDesc=this.props.sortDesc;data.sort(function(a,b){a=a[this.props.sortColumn];b=b[this.props.sortColumn];if(this.props.types[this.props.sortColumn]==="number"){if(a==="n/a"){a=null}if(b==="n/a"){b=null}}if(a===null){if(b===null){return 0}return 1}else if(b===null){return 1}else if(typeof a==="number"){return sortDesc?b-a:a-b}Util.assert(typeof a==="string");return sortDesc?b.localeCompare(a):a.localeCompare(b)}.bind(this));var getValue=this.getValue;if("getValue"in this.props){getValue=this.props.getValue.bind(this)}return React.DOM.div({style:this.props.style},React.DOM.table({className:"table table-bordered",style:Util.merge({width:"auto",border:"none"},this.props.tableStyle)},React.DOM.thead(null,React.DOM.tr(null,this.props.headers.map(function(header,idx){return React.DOM.th({key:idx,style:{whiteSpace:"nowrap",verticalAlign:"middle",padding:0,border:"none"}},getValue(this.props.headers,null,idx))}.bind(this)))),React.DOM.tbody(null,data.map(function(row,rowIdx){return React.DOM.tr({key:rowIdx},row.map(function(col,colIdx){var ret=getValue(data,rowIdx,colIdx);if(this.props.renderTD){ret=React.DOM.td({style:{padding:0,verticalAlign:"middle",border:"none"},key:colIdx},ret)}return ret}.bind(this)))}.bind(this)))))}}),Tooltip:{getInitialState:function(){return{tooltip:{show:false,x:0,y:0,data:null,timeoutFn:null}}},tooltipMouseOver:function(data,evt){this.setState({tooltip:{show:false,x:evt.clientX,y:evt.clientY,data:data,timeoutFn:setTimeout(function(){this.setState({tooltip:Util.merge(this.state.tooltip,{show:true})})}.bind(this),400)}})},tooltipMouseOut:function(evt){clearTimeout(this.state.tooltip.timeoutFn);this.setState({tooltip:{show:false,timeoutFn:null}})},getTooltip:function(){return Tooltip({data:this.state.tooltip.data,x:this.state.tooltip.x,y:this.state.tooltip.y-20,show:this.state.tooltip.show})}},Modal:{getInitialState:function(){return{modal:{open:false}}},modalOpen:function(title,body,additionalClass){this.setState({modal:{open:true,title:title,body:body,additionalClass:additionalClass}})},modalClose:function(){this.setState({modal:{open:false}})},getModal:function(){return Modal({open:this.state.modal.open,closeModal:this.modalClose,title:this.state.modal.title,body:this.state.modal.body,additionalClass:Util.tryGetProperty(this.state.modal,"additionalClass","")})}},SizeToWindow:SizeToWindow,Tabs:React.createClass({displayName:"Tabs",mixins:[SizeToWindow],getInitialState:function(){return{initialTab:this.props.initialTab,selectedTab:this.props.initialTab}},componentWillReceiveProps:function(nextProps){if(nextProps.initialTab!=this.state.initialTab){this.setState({initialTab:nextProps.initialTab,selectedTab:nextProps.initialTab})}},selectTab:function(tab,evt){var prev={};prev[this.state.selectedTab]=true;this.setState({selectedTab:tab})},render:function(){return React.DOM.div(null,React.DOM.ul({className:"nav nav-tabs",role:"tablist"},this.props.tabs.map(function(tab,idx){return React.DOM.li({key:idx,className:tab[0]===this.state.selectedTab?"active":""},React.DOM.a({href:"javascript:",onClick:this.selectTab.bind(this,tab[0])},tab[0]))}.bind(this))),React.DOM.div({className:"tab-content",style:{overflow:"auto"}},this.props.tabs.map(function(row,idx){var tab=row[0];var tag=row[1];return React.DOM.div({key:idx,className:"tab-pane"+(tab===this.state.selectedTab?" active":"")},React.DOM.div({className:"canvas-view-main"},tag(Util.partial(this.props,["tabs"],true))))}.bind(this))))}}),AsyncState:{componentWillReceiveProps:function(nextProps){if(!Util.deepEquals(this.props,nextProps)){this.setState(this.getInitialState(nextProps),function(){this.updateAsyncState(nextProps)}.bind(this))}},addTask:function(task){this.tasks.push(task);TaskQueue.add(task)},cancelAllTasks:function(){this.tasks.forEach(function(task){task.cancel()});this.tasks=[]},componentDidMount:function(){this.tasks=[];this.updateAsyncState(this.props)},componentWillUnmount:function(){this.cancelAllTasks()}},SVG:{ellipse:React.createClass({displayName:"ellipse",render:function(){var d="M "+(this.props.cx-this.props.rx)+" "+this.props.cy+" a "+this.props.rx+" "+this.props.ry+" 0 1 0 "+this.props.rx*2+" 0 a "+this.props.rx+" "+this.props.ry+" 0 1 0 "+-(this.props.rx*2)+" 0";return this.transferPropsTo(React.DOM.path({d:d}))}})}}});