define("plot_quantilehist",["react","d3","common_controls","common_util"],function(React,d3,Controls,Util){"use strict";return{QuantileHistogram:React.createClass({displayName:"QuantileHistogram",mixins:[Controls.Tooltip],setScale:function(axis,evt){var scale=evt.target.value;var newScale={};newScale[axis]=scale;this.setState({scale:Util.merge(this.state.scale,newScale)})},setBinCount:function(evt){this.setState({binCount:Number(evt.target.value)})},getInitialState:function(){return{binCount:null,scale:{x:"linear",y:"linear"}}},render:function(){var quantile=this.props.quantile.slice();if(quantile.length===0){return React.DOM.div(null)}var width=500,height=500;var plotWidth=width*.75,plotHeight=height*.65;var plotX=width*.175,plotY=height*.175;var min=d3.min(quantile);var max=d3.max(quantile);var range=max-min;var xBinCount=this.state.binCount!=null?this.state.binCount:this.props.starting_bins;var binScale=d3.scale[this.state.scale.x]().domain([1,xBinCount+1]).range([min,max]);var bins=[];var idx=0;var bin=0;for(var i=0;i<xBinCount;i++){var binMin=binScale(i+1);var binMax=binScale(i+2);bin=0;while(idx<quantile.length-1&&d3.mean([quantile[idx],quantile[idx+1]])<=binMax){bin++,idx++}bins.push(bin)}Util.assert(d3.sum(bins)===quantile.length-1);var yBinCount=d3.max(bins);var scaleX=d3.scale.linear().domain([0,xBinCount]).range([plotX,plotX+plotWidth]);var scaleY=d3.scale.linear().domain([0,yBinCount]).range([plotY,plotY+plotHeight]);var scaleYforLabels=d3.scale.linear().domain([0,yBinCount*.01*this.props.rows]).range([plotY+plotHeight,plotY]);var xTicks=d3.range(bins.length+1);var yTicks=scaleYforLabels.ticks(7);var xLabelPrefix=d3.formatPrefix(max>2?max/2:max);var xLabelPrefixSymbol=Util.siPrefixToShortScale(xLabelPrefix.symbol);var xLabels=xTicks.map(function(x,idx){return{text:d3.round(xLabelPrefix.scale(binScale(x+1)),2),idx:idx}});while(xLabels.length>8){xLabels=xLabels.filter(function(item,idx){return idx%2==0})}var yLabelPrefixMax=yBinCount*.01*this.props.rows;var yLabelPrefix=d3.formatPrefix(yLabelPrefixMax>2?yLabelPrefixMax/2:yLabelPrefixMax);var yLabelPrefixSymbol=Util.siPrefixToShortScale(yLabelPrefix.symbol);var yLabels=yTicks.map(yLabelPrefix.scale);var squares=[];squares=squares.concat.apply(squares,bins.map(function(bin,idx){return d3.range(bin).map(function(y){return[String(scaleX(idx))+"px",String(scaleY(yBinCount-(y+1)))+"px"]}.bind(this))}.bind(this)));var SliderControl=Controls.Slider;var tooltipLine=function(currNum,nextNum){var curr=Util.formatNumber(currNum);var next=Util.formatNumber(nextNum);if(curr==next){return" "+curr}else{return" between "+curr+" and "+next}}.bind(this);return React.DOM.div({className:"canvas-quantile-histogram"},React.DOM.svg({style:{width:width,height:height},preserveAspectRatio:"xMinYMin"},squares.map(function(position,idx){return React.DOM.rect({className:"bar",key:idx,width:plotWidth/xBinCount,height:plotHeight/yBinCount,x:0,y:0,style:{transform:"translate("+position.join(", ")+")","-webkit-transform":"translate("+position.join(", ")+")"},onMouseOver:this.tooltipMouseOver.bind(this,React.DOM.span(null,"Rows between the ",Util.numberWithSuffix(idx)," and ",Util.numberWithSuffix(idx+1)," quantiles have values approximately ",tooltipLine(quantile[idx],quantile[idx+1]),".")),onMouseOut:this.tooltipMouseOut})}.bind(this)),React.DOM.rect({x:plotX,y:plotY,width:plotWidth,height:plotHeight,fill:"none",className:"canvas-sarray-plot-axes"}),xTicks.map(function(bin,idx){var x=scaleX(bin);var y=plotHeight+plotY;return React.DOM.line({key:idx,x1:x,x2:x,y1:y,y2:y+8,className:"canvas-sarray-plot-axes"})}.bind(this)),xLabels.map(function(label,idx){return React.DOM.text({key:idx,x:scaleX(label.idx),y:plotHeight+plotY+20,textAnchor:"middle",className:"canvas-histogram-label"},Util.formatNumber(label.text))}.bind(this)),yTicks.map(function(freq,idx){var y=scaleYforLabels(freq);return React.DOM.g({key:idx},React.DOM.line({x1:plotX-8,x2:plotX,y1:y,y2:y,className:"canvas-sarray-plot-axes"}),React.DOM.text({x:plotX-12,y:y+4,textAnchor:"end",className:"canvas-histogram-label"},Util.formatNumber(yLabels[idx])))}.bind(this)),React.DOM.text({x:plotX+plotWidth/2,y:40,textAnchor:"middle",className:"canvas-histogram-title"},"Histogram of quantiles"),React.DOM.text({x:plotX,y:plotY-28,textAnchor:"end",className:"canvas-histogram-axis-title"},"Frequency"),React.DOM.text({x:plotX,y:plotY-12,textAnchor:"end",className:"canvas-histogram-axis-subtitle"},yLabelPrefixSymbol?"(in "+yLabelPrefixSymbol+"s)":null)),React.DOM.div({className:"canvas-histogram-x-axis"},React.DOM.div(null,React.DOM.span(null,this.props.selected_column," ")),React.DOM.div(null,xLabelPrefixSymbol?"(in "+xLabelPrefixSymbol+"s)":null)),SliderControl({label:"bins",min:2,max:100,value:xBinCount,onChange:this.setBinCount}),this.getTooltip())}})}});