r"""
The GraphLab Create classifier toolkit contains models for classification
problems. Currently, we support binary classification using support vector
machines (SVM), logistic regression, boosted trees, and neural networks.  In
addition to these models, we provide a smart interface that selects the right
model based on the data. If you are unsure about which model to use, simply use
:meth:`~graphlab.classifier.create` function.

Training datasets should contain a column for the 'target' variable and one or
more columns representing feature variables.

.. sourcecode:: python

    # Set up the data
    >>> import graphlab as gl
    >>> data =  gl.SFrame('http://s3.amazonaws.com/GraphLab-Datasets/regression/houses.csv')

    # Create the model
    >>> data['is_expensive'] = data['price'] > 30000
    >>> model = gl.classifier.create(data, target='is_expensive',
    ...                              features=['bath', 'bedroom', 'size'])

    # Make predictions and evaluate results.
    >>> classification = model.classify(data)
    >>> results = model.evaluate(data)
"""

from _classifier import create
import svm_classifier
import logistic_classifier
import boosted_trees_classifier
import neuralnet_classifier

