class BivariateView(object):
    def __init__(self, obj, params):
        self.obj = obj
        self.params = params

    def get_column(self, name, avoid=None, numeric=False):
        if avoid is None:
            avoid = []
        if not(isinstance(avoid, list)):
            avoid = [avoid]

        columns = self.__numeric_columns() if numeric else self.params['columns']
        
        # if a parameter name is specified and valid, use it
        if name in self.params and self.params[name] in columns:
            return self.params[name]

        # if there is something available other than the "avoid" column, use it
        filtered = [col for col in columns if not(col in avoid)]
        if len(filtered) > 0:
            return filtered[0]

        # if there are any valid columns, use them
        if len(columns) > 0:
            return columns[0]

        # no valid columns
        return None

    def get_numeric_column(self, name, avoid=None):
        return self.get_column(name, avoid, numeric=True)
        
    #gets the names of all the numerical columns in a list
    def __numeric_columns(self):
        columnsAndTypes = zip(self.obj.column_names(), self.obj.column_types())
        selected = [(col, dtype) for (col, dtype) in columnsAndTypes if col in self.params['columns']]
        return [col for (col, dtype) in selected if dtype in [int, float, long]]
