define("job",["react","plots","d3","hljs","common_util","taskqueue","jquery","common_controls","logging","page_layout"],function(React,Plots,d3,_hljs,Util,TaskQueue,jQuery,Controls,Logging,PageLayout){"use strict";var SQRT_2=Math.sqrt(2);var taskVertexWidth=60;var taskVertexHeight=15;var taskVertexStageHeight=10;var taskPolygonSide=6;function isJSONEmpty(obj){for(var prop in obj){if(obj.hasOwnProperty(prop)){return false}}return true}var CodeView=React.createClass({displayName:"CodeView",componentDidMount:function(){var node=this.getDOMNode();hljs.highlightBlock(node)},shouldComponentUpdate:function(){return false},render:function(){var code=this.props.code;return React.DOM.pre(null,React.DOM.code({className:"python"},code))}});function constructTaskJSON(name,inputs,params,outputs,tasks){var graphJSON={};var nodesJSON=[];var linksJSON=[];var usedNodes=[];var stageNode={};stageNode["name"]="Stage";stageNode["color"]="#b0007f";stageNode["node"]="none";nodesJSON.push(stageNode);if(isJSONEmpty(inputs)&&isJSONEmpty(params)){var srcNode={};srcNode["name"]="_GL_phantom_preStage";srcNode["node"]="source";srcNode["index"]=0;nodesJSON.push(srcNode);var srcEdge={};srcEdge["source"]="_GL_phantom_preStage";srcEdge["target"]="Stage";linksJSON.push(srcEdge)}if(isJSONEmpty(outputs)){var dstNode={};dstNode["name"]="_GL_phantom_postStage";dstNode["node"]="target";dstNode["index"]=0;nodesJSON.push(dstNode);var dstEdge={};dstEdge["source"]="Stage";dstEdge["target"]="_GL_phantom_postStage";linksJSON.push(dstEdge)}for(var key in inputs){var inputsNode={};inputsNode["name"]=key;inputsNode["color"]="#0a8cc4";inputsNode["node"]="input";nodesJSON.push(inputsNode);var linkNode={};linkNode["source"]=key;linkNode["target"]="Stage";linksJSON.push(linkNode)}for(var key in params){var paramNode={};paramNode["name"]=key;paramNode["color"]="#85bd00";paramNode["node"]="param";nodesJSON.push(paramNode);var linkNode={};linkNode["source"]=key;linkNode["target"]="Stage";linksJSON.push(linkNode)}for(var key in outputs){var outputNode={};outputNode["name"]=key;outputNode["color"]="#0a8cc4";outputNode["node"]="output";nodesJSON.push(outputNode);var linkNode={};linkNode["source"]="Stage";linkNode["target"]=key;linksJSON.push(linkNode)}graphJSON["nodes"]=nodesJSON;graphJSON["links"]=linksJSON;return graphJSON}var TaskGraphLayout=React.createClass({displayName:"TaskGraphLayout",mixins:[Controls.Modal],layout:function(){var layoutFn=Util.dagreLayout;return layoutFn(this.props.vertices,this.props.edges,taskVertexWidth,taskVertexHeight,40,40,"LR")},getColumnsArray:function(vertices){var max_ip=0;var max_o=0;var max_src=0;var max_dst=0;for(var i=0;i<vertices.length;i++){if(vertices[i].node=="input"||vertices[i].node=="param"){max_ip=max_ip+1}else if(vertices[i].node=="output"){max_o=max_o+1}else if(vertices[i].node=="source"){max_src+=1}else if(vertices[i].node=="target"){max_dst+=1}}return[max_ip,max_o,max_src,max_dst]},getMaxX:function(array){var non_zero=0;for(var i in array){if(array[i]>0){non_zero+=1}}return non_zero},getMaxY:function(array){var max=0;for(var i in array){if(array[i]>max){max=array[i]}}return max},getBreaks:function(max_height){if(max_height<100){return React.DOM.div(null,React.DOM.br(null),React.DOM.br(null),React.DOM.br(null))}else{return React.DOM.div(null)}},render:function(){var graph=this.layout();var columnArray=this.getColumnsArray(this.props.vertices);var max_y=this.getMaxY(columnArray);var max_x=this.getMaxX(columnArray);var max_height=-90+max_y*165;var max_width=120+120*max_x;var scaleToAxis=function(axis){var vertexSize=axis=="x"?taskVertexWidth:taskVertexHeight;var idx=axis=="x"?0:1;var scaleMax=axis=="x"?max_width:max_height;var valuesMin=graph.edges.map(function(e){return d3.min(e.points.map(function(p){return p[idx]}))-vertexSize});var valuesMax=graph.edges.map(function(e){return d3.max(e.points.map(function(p){return p[idx]}))+vertexSize});return d3.scale.linear().domain([d3.min(valuesMin),d3.max(valuesMax)]).range([0,scaleMax])};var scaleX=scaleToAxis("x");var scaleY=scaleToAxis("y");return React.DOM.div(null,this.getBreaks(max_height),this.getModal(),React.DOM.svg({width:max_width,height:max_height},React.DOM.line({x1:0,y1:20,x2:0,y2:max_height-10,stroke:"#929292",strokeWidth:1}),graph.edges.map(function(e,idx){if(e.source.indexOf("_GL_phantom_")>-1||e.target.indexOf("_GL_phantom_")>-1){return[]}var ret=[];var p1=[];var p2=[];for(var i=0;i<e.points.length-1;i++){p1=e.points[i];p2=e.points[i+1];var color="#000";if(e.source=="Stage"||e.target=="Stage"){color=Util.getColorFromNodeType("input")}ret.push(React.DOM.line({x1:scaleX(p1[0]),y1:scaleY(p1[1]),x2:scaleX(p2[0]),y2:scaleY(p2[1]),stroke:color,strokeWidth:1,key:e.source+"__"+e.target+i+"_"+idx}))}if(e.target=="Stage"||e.source=="Stage"){var slope=0;var b=0;var arriw_points="";var x1=p1[0];var x2=p2[0];var y1=p1[1];var y2=p2[1];var p_back=[];if(x2!=x1){slope=(y2-y1)/(x2-x1);b=y2-x2*slope;if(slope==0){x2=x2-taskVertexWidth/2;p_back=[x2-polygonSide/2*SQRT_2,y2];var arrow_points=scaleX(x2)+","+scaleY(y2)+" "+scaleX(x2-polygonSide)+","+scaleY(y2+polygonSide/8)+" "+scaleX(x2-polygonSide)+","+scaleY(y2-polygonSide/8)}else{var cutoff_slope=taskVertexHeight/taskVertexWidth;x1=scaleX(x1);x2=scaleX(x2);y1=scaleY(y1);y2=scaleY(y2);slope=(y1-y2)/(x2-x1);var xOffset=Math.sqrt(polygonSide/2*(polygonSide/2)*(slope*slope)/(slope*slope+1));var yOffset=-1/slope*xOffset;var p_tip=[x1,y1];var back_y=Math.sin(Math.atan(slope))*(polygonSide/1.5)*SQRT_2;var back_x=Math.cos(Math.atan(slope))*(polygonSide/1.5)*SQRT_2;p_back=[x1-back_x,y1+back_y];var p_left=[p_back[0]+xOffset/1.5,p_back[1]-yOffset];var p_right=[p_back[0]-xOffset/1.5,p_back[1]+yOffset];arrow_points=p_tip[0]+","+p_tip[1]+" "+p_left[0]+","+p_left[1]+" "+p_right[0]+","+p_right[1]}}ret.push(React.DOM.polygon({points:arrow_points,stroke:"#000",strokeWidth:1,key:e.target+"_"+e.source+"_ar_"+idx}))}return ret}.bind(this)),graph.vertices.map(function(n,idx){if(n.name.indexOf("_GL_phantom_")>-1||n.name.indexOf("_GL_phantom_")>-1){return[]}var ret=[];var x1=scaleX(n.x-taskVertexWidth/2);var y1=scaleY(n.y-taskVertexHeight/2);var x2=scaleX(n.x+taskVertexWidth/2);var y2=scaleY(n.y+taskVertexHeight/2);var name=n.name;var end_x2=x2-1;var points=end_x2+","+y1+" "+end_x2+","+y2+" "+(end_x2+15)+","+scaleY(n.y);if(name=="Stage"){ret.push(React.DOM.rect({className:"no-select pointer",onClick:this.modalOpen.bind(undefined,"Code",CodeView({code:this.props.task.code}),"modal-lg"),width:x2-x1,height:y2-y1,x:x1,y:y1,stroke:"#000",strokeWidth:0,fill:n.color,key:n.name+"_"+idx}));ret.push(React.DOM.polygon({className:"no-select pointer",onClick:this.modalOpen.bind(undefined,"Code",CodeView({code:this.props.task.code}),"modal-lg"),points:points,stroke:n.color,strokeWidth:.5,fill:n.color,key:n.name+"_p_"+idx}));name="Code";y2=y1+taskVertexStageHeight;x1=x1+4;ret.push(React.DOM.g({onClick:this.modalOpen.bind(undefined,"Code",CodeView({code:this.props.task.code}),"modal-lg")},React.DOM.text({className:"no-select pointer canvas-task-label-code",x:x1+3,y:y2+taskVertexHeight,key:n.name+"_name_"+idx},name),React.DOM.text({className:"no-select pointer canvas-task-label-code",x:x1+48,y:y2+taskVertexHeight,key:n.name+"_code_icon_"+idx,style:{fontFamily:"FontAwesome"}},"")))}else{ret.push(React.DOM.rect({width:x2-x1,height:y2-y1,x:x1,y:y1,stroke:"#000",strokeWidth:0,fill:n.color,key:n.name+"_"+idx}));ret.push(React.DOM.polygon({points:points,stroke:n.color,strokeWidth:.5,fill:n.color,key:n.name+"_p_"+idx}));ret.push(React.DOM.text({className:"canvas-task-label-text",x:x1+3,y:y2+taskVertexHeight,key:n.name+"_name_"+idx},name))}return ret}.bind(this))))}});var TaskStatusTime=React.createClass({displayName:"TaskStatusTime",getDuration:function(ms,stat){if(stat=="Failed"){return"N/A"}var seconds=parseFloat(ms).toFixed(2);if(seconds<=60){var concat_secs=Math.round(seconds*100)/100;return concat_secs.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;var concat_secs=Math.round(sec*100)/100;return minutes.toString()+"m "+concat_secs.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;var concat_secs=Math.round(sec*100)/100;return hour.toString()+"h "+minutes.toString()+"m "+concat_secs.toString()+" sec"}},getStatusFA:function(stat){var ret=[];var style={color:Util.getColorFromStatus(stat,false)};if(stat=="Completed"){ret.push(React.DOM.i({style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){ret.push(React.DOM.i({style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({style:style,className:"fa fa-gear fa-lg"}))}return ret},render:function(){var name=this.props.name;var taskstatus=this.props.taskstatus;var stat="Pending";if(taskstatus.hasOwnProperty(name)){stat=taskstatus[name]}var text_style={color:Util.getColorFromStatus(stat,false)};var duration="0";var run_key=name+"_runtime";if(taskstatus.hasOwnProperty(run_key)){duration=taskstatus[run_key]}var duration_str=this.getDuration(duration,stat);return React.DOM.div(null,React.DOM.div({className:"canvas-task-status-header",style:{"float":"left"}},"Status:  ",React.DOM.span({style:text_style},stat)," ",this.getStatusFA(stat)),React.DOM.div({style:{clear:"both"}}),React.DOM.div({className:"canvas-task-info-type",style:{"float":"left"}},"Duration: ",duration_str),React.DOM.div({style:{clear:"both"}}))}});var InputsTable=React.createClass({displayName:"InputsTable",getFAIndex:function(name,tasks,task_status){for(var i in tasks){if(name==tasks[i].name){var color=Util.getColorFromStatusHighlight(task_status);var idx=parseInt(i)+1;return React.DOM.div({style:{"background-color":color},className:"circle-index"},idx)}}return[]},getInputTitle:function(length){var ret=React.DOM.div(null);if(length>0){ret=React.DOM.div({className:"canvas-task-info-val-wrapper",style:{color:Util.getColorFromNodeType("input")}},"GraphLab Objects")}return ret},getParamTitle:function(length){var ret=React.DOM.div(null);if(length>0){ret=React.DOM.div({className:"canvas-task-info-val-wrapper",style:{color:Util.getColorFromNodeType("param")}},"Params")}return ret},render:function(){var inputs=this.props.inputs;var isFunction=this.props.isFunction;var params=this.props.params;var tasks=this.props.tasks;var input_list=Object.keys(inputs);var params_list=Object.keys(params);return React.DOM.div(null,React.DOM.div({className:"canvas-task-info-header"},"INPUTS",React.DOM.span({style:{"float":"right","padding-right":"5px"}},React.DOM.i({style:{color:"#fff"},className:"fa fa-sign-in fa-lg"})),React.DOM.span({style:{clear:"both"}})),React.DOM.div({className:"canvas-task-info-val-wrapper"},this.getInputTitle(input_list.length),input_list.map(function(n,idx){if(!inputs.hasOwnProperty(n)){return[]}var srcNodeName=inputs[n][0];var fa=this.getFAIndex(srcNodeName,tasks,"Completed");if(this.props.isTimeline){return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-input"}," ",n)}return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-input"},React.DOM.div({style:{"float":"left"}},fa," ",React.DOM.i({className:"fa fa-arrow-right"})," ",n),React.DOM.div({style:{clear:"both"}}))}.bind(this)),this.getParamTitle(params_list.length),params_list.map(function(n,idx){if(isFunction&&n=="function"){return React.DOM.div({key:n+"_function_"+idx,className:"canvas-task-info-val-input"},n,":",React.DOM.div({key:n+"_funcname_"+idx,className:"canvas-task-info-val-input-inner"},params[n]))}else if(isFunction&&n=="params"){var param_dict=params[n];return React.DOM.div({key:n+"_params_"+idx,className:"canvas-task-info-val-input"},n,":",Object.keys(param_dict).map(function(param_name,idx_1){return React.DOM.div({key:n+"_param_name_val_"+idx+idx_1,className:"canvas-task-info-val-input-inner"},param_name,": ",param_dict[param_name])}.bind(this)))}return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-param"},n)}.bind(this))))}});var OutputsTable=React.createClass({displayName:"OutputsTable",getFAIndex:function(name,tasks,task_status){for(var i in tasks){if(name==tasks[i].name){var color=Util.getColorFromStatusHighlight(task_status);var idx=parseInt(i)+1;return React.DOM.div({style:{"background-color":color},className:"circle-index"},idx)}}return[]},getOutputTasks:function(output_name,tasks){var ret=[];for(var i in tasks){var inputs=tasks[i].inputs;for(var key in inputs){var input_data=inputs[key];if(Array.isArray(input_data)&&input_data.length==2){if(input_data[1]==output_name){ret.push(parseInt(i)+1)}}}}return ret},getOutputTitle:function(length){var ret=React.DOM.div(null);if(length>0){ret=React.DOM.div({className:"canvas-task-info-val-wrapper",style:{color:Util.getColorFromNodeType("output")}},"GraphLab Objects")}return ret},render:function(){var outputs=this.props.outputs;var tasks=this.props.tasks;var list=Object.keys(outputs);return React.DOM.div(null,React.DOM.div({className:"canvas-task-info-header"},"OUTPUTS",React.DOM.span({style:{"float":"right","padding-right":"5px"}},React.DOM.i({style:{color:"#fff"},className:"fa fa-sign-out fa-lg"})),React.DOM.span({style:{clear:"both"}})),React.DOM.div({className:"canvas-task-info-val-wrapper"},this.getOutputTitle(list.length),list.map(function(n,idx){if(!outputs.hasOwnProperty(n)){return[]}var dstNodes=this.getOutputTasks(n,tasks);if(this.props.isTimeline){return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-output"}," ",n)}return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-output"},React.DOM.div({style:{"float":"left"}},React.DOM.div({style:{"float":"left"}},n," ",React.DOM.i({className:"fa fa-arrow-right"})," "),dstNodes.map(function(index,idx1){var color=Util.getColorFromStatusHighlight("Completed");return React.DOM.div({style:{"background-color":color},className:"circle-index",key:n+"_"+idx+"_outputFA"+idx1},index)}.bind(this))),React.DOM.div({style:{clear:"both"}}))}.bind(this))))}});var vertexWidth=240;var vertexHeight=40;var textLen=14;var maxTextLen=0;var polygonSide=8;var listall=[];function compareTime(t1,t2){if(t1[1]<t2[1]){return 1}else if(t1[1]>t2[1]){return-1}else{return 0}}function constructJobJSON(tasks){var jobJSON={};var nodesJSON=[];var linksJSON=[];var edgesJSON=[];for(var i=0;i<tasks.length;i++){var task=tasks[i];var taskNode={};taskNode["name"]=task.name;taskNode["color"]=Util.getColorFromNodeType("Task");taskNode["status"]="Pending";taskNode["prop"]="Task";nodesJSON.push(taskNode);var sources=Object.keys(task.inputs);var sourceNodes=[];for(var idx=0;idx<sources.length;idx++){var src_node=task.inputs[sources[idx]];if(Array.isArray(src_node)&&src_node.length==2){var srcNodeName=src_node[0];if(sourceNodes.indexOf(srcNodeName)==-1){var linkNode={};linkNode["source"]=src_node[0];linkNode["target"]=task.name;linksJSON.push(linkNode);sourceNodes.push(src_node[0])}}}}for(var i=0;i<nodesJSON.length-1;i++){var taskNode=nodesJSON[i];var nextNode=nodesJSON[i+1];var linkNode={};linkNode["source"]=taskNode["name"];linkNode["target"]=nextNode["name"];edgesJSON.push(linkNode)}jobJSON["nodes"]=nodesJSON;jobJSON["links"]=linksJSON;jobJSON["node_edges"]=edgesJSON;return jobJSON}function shortenName(name,size){if(name.length>size){var substr=name.substring(0,size-3)+"...";return substr}else{return name}}var JobLog=React.createClass({displayName:"JobLog",mixins:[Controls.Modal],handleClick:function(evt){var log_url="";var log_data="";var log="";$.get("/logs").done(function(data){log=Util.tryGetProperty(data,"logfile",{});log_url=Util.tryGetProperty(log,"url","");log_data=Util.tryGetProperty(log,"data","");var isArray=Array.isArray(log_data);if(isArray){log_data=React.DOM.div(null,log_data.map(function(data,idx){return React.DOM.div(null,React.DOM.a({key:"log_dl_link"+idx,href:data,target:"_blank"},"Download Log File ",idx+1))}.bind(this)))}var download_link=React.DOM.div({className:"canvas-log-title"},"Logs");if(this.props.jobtype!=="LocalAsynchronousJob"){var download_link=React.DOM.div({className:"canvas-log-title"},"Logs  ",isArray?null:React.DOM.a({key:"log_dl_link",href:log_url,target:"_blank"},"Download"))}this.modalOpen(download_link,React.DOM.pre({style:{"text-align":"left"}},React.DOM.code(null,log_data)),"modal-lg")}.bind(this)).fail(function(data){log_url="";log_data="Unable to get log file for this Job.";var download_link=React.DOM.div({className:"canvas-log-title"},"Logs  ",React.DOM.a({key:"log_dl_link",href:log_url,download:true},"Download"));this.modalOpen(download_link,React.DOM.pre({style:{"text-align":"left"}},React.DOM.code(null,log_data)),"modal-lg")}.bind(this))},render:function(){if(this.props.jobtype==="Job"){return React.DOM.div(null)}return React.DOM.div({className:"canvas-log-data"},React.DOM.div({className:"canvas-log-button pointer",style:{"float":"right"},onClick:this.handleClick},this.getModal(),React.DOM.span({style:{"text-decoration":"underline"}},"View Logs")," ",React.DOM.i({key:"jobLog_fa",className:"fa fa-file-text-o"})),React.DOM.div({style:{clear:"both"}}))}});var TimelineLayout=React.createClass({displayName:"TimelineLayout",mixins:[Controls.AsyncState,Controls.Modal,Controls.Tooltip,Controls.SizeToWindow],updateAsyncState:function(){},handleViewResults:function(){this.addTask(new TaskQueue.SingleTask("get_results","get results").done(function(data){if("has_results"in data&&data["has_results"]==true){var selected_var=this.props.selected_variable.name.concat(["results"]);this.props.selectVariable(selected_var)}}.bind(this)))},getStatusFA:function(stat,idx){var ret=[];var style={color:Util.getColorFromStatus(stat,false)};if(stat=="Completed"){ret.push(React.DOM.i({key:"timeline_"+idx+"_fa",style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){ret.push(React.DOM.i({key:"timeline_"+idx+"_fa",style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({key:"timeline_"+idx+"_fa",style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({key:"timeline_"+idx+"_fa",style:style,className:"fa fa-gear fa-lg"}))}return ret},getDurationMS:function(ms,stat){if(stat!="Completed"){return"N/A"}var seconds=ms/1e3;if(seconds<=60){var concat_secs=Math.round(seconds*100)/100;return concat_secs.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;var concat_secs=Math.round(sec*100)/100;return minutes.toString()+"m "+concat_secs.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;var concat_secs=Math.round(sec*100)/100;return hour.toString()+"h "+minutes.toString()+"m "+concat_secs.toString()+" sec"}},getDuration:function(ms,stat){if(stat!="Completed"&&stat!="Failed"){return"N/A"}var seconds=parseFloat(ms).toFixed(2);if(seconds<=60){return seconds.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;return minutes.toString()+"m "+sec.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;return hour.toString()+"h "+minutes.toString()+"m "+sec.toString()+" sec"}},getTotalTime:function(tasks,task_status){var cur_total=0;for(var task_idx in tasks){var name=tasks[task_idx].name;var stat="Pending";if(task_status.hasOwnProperty(name)){stat=task_status[name];if(stat=="Completed"){var run_key=name+"_runtime";if(task_status.hasOwnProperty(run_key)){var runtime=task_status[run_key];var actual_runtime=parseFloat(runtime);cur_total+=actual_runtime}}}}return cur_total},getTimeLineDurations:function(width,tasks,task_status){var min_length=10;var min_step=2;var cur_total=0;var task_runtimes=[];for(var task_idx in tasks){var name=tasks[task_idx].name;var stat="Pending";if(task_status.hasOwnProperty(name)){stat=task_status[name];if(stat=="Completed"){var run_key=name+"_runtime";if(task_status.hasOwnProperty(run_key)){var runtime=task_status[run_key];var actual_runtime=parseFloat(runtime);cur_total+=actual_runtime;task_runtimes.push(actual_runtime)}}}}var cur_width=width*task_runtimes.length/tasks.length;if(cur_width/task_runtimes.length<min_length){min_length=Math.floor(cur_width/task_runtimes.length)}var num_buckets=Math.floor(cur_width/min_length);var bucket_width=cur_width/num_buckets;var buckets_for_tasks=[];for(var i=0;i<task_runtimes.length;i++){buckets_for_tasks.push(1);task_runtimes[i]=Math.floor(task_runtimes[i]/min_step);num_buckets--}while(num_buckets>0){var zeros=0;var index_width=[];for(var i=0;i<task_runtimes.length;i++){index_width.push([i,task_runtimes[i]])}index_width.sort(compareTime);var max=index_width[0][1];var min=index_width[index_width.length-1][1];for(var i=0;i<index_width.length;i++){var idx=index_width[i][0];if(task_runtimes[idx]>0){if(num_buckets>0){num_buckets--;buckets_for_tasks[idx]++;if(Math.floor(task_runtimes[idx]/min_step)==0){zeros++}}}else{zeros++}}if((zeros==task_runtimes.length||max-min==1)&&num_buckets>0){while(num_buckets>0){for(var i=0;i<index_width.length;i++){var idx=index_width[i][0];if(task_runtimes[idx]>0&&num_buckets>0){num_buckets--;buckets_for_tasks[idx]++}if(task_runtimes[idx]==max&&num_buckets>0){num_buckets--;buckets_for_tasks[idx]++}}}}for(var i=0;i<task_runtimes.length;i++){task_runtimes[i]=Math.floor(task_runtimes[i]/min_step)}}var width_array=[];var cur_step=0;for(var i=0;i<buckets_for_tasks.length;i++){var step=buckets_for_tasks[i]*bucket_width;width_array.push([cur_step,cur_step+step]);cur_step+=step}var num_incomplete_tasks=tasks.length-task_runtimes.length;for(var i=0;i<num_incomplete_tasks;i++){var step=width/tasks.length;width_array.push([cur_step,cur_step+step]);cur_step+=step}return width_array},getProgressBar:function(cur_status,start_x,bar_width,idx){var test=0;if(cur_status!="Running"){return React.DOM.div(null)}return React.DOM.div({className:"canvas-task-progressbar progress progress-striped active",style:{position:"absolute",left:start_x+"px",width:bar_width+"px",height:"40px"},key:"_"+idx+"_canvas_task_progress_bar"},React.DOM.div({className:"progress-bar",role:"progressbar",style:{width:"100%"}}))},render:function(){var task_status=this.props.taskstatus;var tasks=this.props.tasks;var metrics=this.props.metrics;var starttime="---";if(this.props.starttime){var starttime=this.props.starttime.split(".")[0]}var endtime=this.props.endtime;var duration="---";if(this.props.jobstatus=="Completed"&&endtime&&this.props.starttime){var parsed_time=Date.parse(endtime)-Date.parse(this.props.starttime);duration=this.getDurationMS(parsed_time,this.props.jobstatus);starttime=starttime.replace("T"," ")}else{if(this.props.jobstatus=="Failed"){duration="N/A"}}var view_results=React.DOM.div(null);if(this.props.has_results){view_results=Controls.Button({onClick:this.handleViewResults,style:{"font-size":"12px","font-weight":"300"}},"View Results")}var width=PageLayout.contentWidth()-88;var name_width=300;var min_table_width=710;var time_width=(width>min_table_width?width:min_table_width)-name_width;var min_length=10;var width_array=this.getTimeLineDurations(time_width,tasks,task_status);var x_end_line=time_width;var arrow_points=x_end_line+5+","+32+" "+x_end_line+","+27+" "+x_end_line+","+37;var start_points="0,8 0,16 8,8";var end_points=x_end_line+","+8+" "+(x_end_line-8)+","+8+" "+x_end_line+","+16;return React.DOM.table({className:"canvas-task-timeline-table-outer"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.td(null,React.DOM.div({className:"canvas-task-timeline-table-title"},"Tasks"))),tasks.map(function(task,idx){var name=task.name;var dropDownClassList="no-select pointer fa fa-chevron-circle-right fa-lg";var dropDownClassStyle={color:"#d5d5d5","background-color":"#f8f8f8"};if(this.props.selected==name){dropDownClassList="no-select pointer fa fa-chevron-circle-down fa-lg";dropDownClassStyle={color:"#ff5500","background-color":"#f8f8f8"}}var text_style={color:"#ff5500"};var task_width=width_array[idx];var start_x=Math.floor(task_width[0]);var end_x=Math.floor(task_width[1]);var bar_width=end_x-start_x;var arrow_points=end_x+","+20+" "+(end_x-min_length/2)+","+10+" "+(end_x-min_length/2)+","+30;var cur_task_status="Pending";var cur_task_starttime="N/A";var cur_task_runtime="N/A";if(task_status.hasOwnProperty(name)){cur_task_status=task_status[name];var start_key=name+"_starttime";var run_key=name+"_runtime";if(task_status.hasOwnProperty(start_key)){cur_task_starttime=task_status[start_key];if(task_status.hasOwnProperty(run_key)){cur_task_runtime=this.getDuration(task_status[run_key])}}}var svg_classlist="no-select pointer";var name_link_classlist="canvas-link";var is_task_selected=name==this.props.selected;var rect_fill=Util.getColorFromStatus(cur_task_status,false);var stroke=Util.getColorFromStatus(cur_task_status,is_task_selected);var strokeWidth=2;var style={opacity:1};if(cur_task_status=="Pending"){style={opacity:.3}}var row_style={"background-color":"transparent"};if(is_task_selected){row_style={"background-color":"#DAE6F0"};name_link_classlist+=" active"}return React.DOM.tr(null,React.DOM.td(null,React.DOM.table({className:"canvas-task-timeline-table",key:"_"+idx+"_timeline_inner_table_"},React.DOM.tbody(null,React.DOM.tr({style:row_style},React.DOM.td(null,React.DOM.div(null,React.DOM.i({className:dropDownClassList,onClick:this.props.callback_handleClick.bind(this,0,name),style:dropDownClassStyle,key:"_"+idx+"_timeline_table_dropdown"}))),React.DOM.td(null,React.DOM.div({className:"no-select"},React.DOM.div({style:{"text-align":"left","padding-left":"10px"}},React.DOM.a({href:"javascript:",onClick:this.props.callback_handleClick.bind(this,0,name),className:name_link_classlist,key:"_"+idx+"_timeline_table_taskname"},name)))),React.DOM.td(null,React.DOM.div({className:"no-select pointer"},React.DOM.div({style:{"text-align":"left","padding-right":"5px",width:"25px"},onClick:this.props.callback_handleClick.bind(this,0,name)},this.getStatusFA(cur_task_status,idx)))),React.DOM.td({style:{position:"relative"}},React.DOM.svg({style:{width:time_width,height:"40px"},key:"_"+idx+"_timeline_table_svg",onClick:this.props.callback_handleClick.bind(this,0,name)},React.DOM.rect({className:svg_classlist,style:style,x:start_x+strokeWidth/2,y:0,width:bar_width-strokeWidth/2,height:40,fill:rect_fill,key:"_"+idx+"_timeline_table_svg_rect"})),this.getProgressBar(cur_task_status,start_x,bar_width,idx))))),TimelineTaskViewWrapper({task:task,tasks:tasks,taskstatus:task_status,selected:this.props.selected,callback_handleCode:this.props.callback_handleCode,key:"_"+idx+"_timeline_table_inner_task_view"})))}.bind(this)),React.DOM.tr(null,React.DOM.td(null,React.DOM.table({className:"canvas-task-timeline-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.th({style:{"background-color":"#fff"}}),React.DOM.th({style:{"background-color":"#fff","font-size":"14px","font-weight":"400"}},view_results),React.DOM.th({style:{"background-color":"#fff"}}),React.DOM.th({style:{"background-color":"#fff",height:"60px"}},React.DOM.svg({style:{width:time_width,height:"16px"}},React.DOM.line({x1:0,x2:x_end_line,y1:8,y2:8,strokeWidth:3,stroke:"#d3d3d3"}),React.DOM.polygon({fill:"#d3d3d3",points:start_points}),React.DOM.polygon({fill:"#d3d3d3",points:end_points})),React.DOM.div({className:"canvas-timeline-time-info"},React.DOM.span({style:{"float":"left"}},"Start Time:"),React.DOM.span({style:{"float":"right"}},"Duration:"),React.DOM.div({style:{clear:"both"}})),React.DOM.div({className:"canvas-timeline-time-val"},React.DOM.span({style:{"float":"left"}},starttime),React.DOM.span({style:{"float":"right"}},duration),React.DOM.div({style:{clear:"both"}}))))))))))}});function getKeys(metrics){var keys=[];for(var key in metrics){if(key=="summary"){continue}var keySplit=key.split(".");var name=keySplit[1];if(keys.indexOf(name)==-1){keys.push(name)}}return keys.reverse()}var TaskMetrics=React.createClass({displayName:"TaskMetrics",render:function(){var metricsTable=this.props.metrics;var keys=getKeys(metricsTable);return React.DOM.table({className:"canvas-task-param-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.th(null,"Task Name"),React.DOM.th(null,"Last Run"),React.DOM.th(null,"Run Time")),keys.map(function(k){var ret=[];var lastrun_key="task."+k+".last_run";var time_key="task."+k+".runtime";var lastrun_value=metricsTable[lastrun_key];var time_value=metricsTable[time_key];var lastrun_value_arr=lastrun_value.split(".");lastrun_value_arr.pop();lastrun_value=lastrun_value_arr.join(".");return React.DOM.tr(null,React.DOM.td(null,k),React.DOM.td(null,lastrun_value),React.DOM.td(null,time_value.toFixed(3)))}.bind(this))))}});function compareRun(d1,d2){var t1=Date.parse(d1["order"].split(".")[0]);var t2=Date.parse(d2["order"].split(".")[0]);if(t1<t2){return-1}else if(t1>t2){return 1}else{return 0}}var TaskStatus=React.createClass({displayName:"TaskStatus",printFA:function(tstatus){var ret=[];var style={color:"#85bd00"};if(tstatus=="Running"){style={color:"#85bd00"};ret.push(React.DOM.i({style:style,className:"fa fa-spinner fa-spin fa-lg"}))}else if(tstatus=="Completed"){style={color:"#0a8cc4"};ret.push(React.DOM.i({style:style,className:"fa fa-check fa-lg"}))}else if(tstatus=="Failed"){style={color:"#B80000"};ret.push(React.DOM.i({style:style,className:"fa fa-times fa-lg"}))}else{ret.push(React.DOM.i({style:style,className:"fa fa-clock-o fa-lg"}))}return ret},render:function(){var stat="";var style="";var tstatus=this.props.taskStatus;return React.DOM.div({className:"canvas-task-status-container"},React.DOM.div({className:"canvas-task-status no-select"},"Task Status:"),React.DOM.div({className:"canvas-task-status"},tstatus),React.DOM.div({className:"canvas-task-status-fa"},this.printFA(tstatus)))}});var TaskColumn=React.createClass({displayName:"TaskColumn",getDuration:function(ms){var seconds=parseFloat(ms).toFixed(2);if(seconds<=60){var concat_secs=Math.round(seconds*100)/100;return concat_secs.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;var concat_secs=Math.round(sec*100)/100;return minutes.toString()+"m "+concat_secs.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;var concat_secs=Math.round(sec*100)/100;return hour.toString()+"h "+minutes.toString()+"m "+concat_secs.toString()+" sec"}},getStatusFA:function(stat){var selected=this.props.task.name==this.props.selected||!this.props.selected&&this.props.task.name==this.props.hover;var ret=[];var style={color:Util.getColorFromStatus(stat,selected)};if(stat=="Completed"){ret.push(React.DOM.i({style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){ret.push(React.DOM.i({style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({style:style,className:"fa fa-gear fa-lg"}))}return ret},getIndexNumber:function(stat,index){if(this.props.task.name==this.props.selected||!this.props.selected&&this.props.task.name==this.props.hover){var style={"background-color":Util.getColorFromStatus(stat,true)};return React.DOM.div({style:style,className:"circle-index"},index)}var ret=[];var style={"background-color":Util.getColorFromStatus(stat,false)};ret.push(React.DOM.div({style:style,className:"circle-index"},index));return ret},render:function(){var task=this.props.task;var taskstatus=this.props.taskstatus;var duration="-------------------";var starttime="-------------------";var st_key=task.name+"_starttime";var run_key=task.name+"_runtime";if(taskstatus.hasOwnProperty(st_key)){starttime=taskstatus[st_key]}if(taskstatus.hasOwnProperty(run_key)){duration=taskstatus[run_key]}var tstatus="Pending";if(taskstatus.hasOwnProperty(task.name)){tstatus=taskstatus[task.name]}var getColumnName=function(){var style={color:"#ff5500","text-decoration":"underline"};
if(this.props.task.name==this.props.hover){var style={color:"#ff5500","text-decoration":"underline"}}return React.DOM.a({href:"javascript:",onClick:this.props.callback_handleClick.bind(this,0,this.props.task.name),style:style,onMouseOver:this.props.callback_mouseOver.bind(this,0,this.props.task.name),onMouseOut:this.props.callback_mouseOut},this.props.task.name)}.bind(this);var style={};if(this.props.selected==this.props.task.name||this.props.hover==this.props.task.name){style={"background-color":"#DAE6F0"}}return React.DOM.tr({style:style},React.DOM.td(null,React.DOM.div(null,React.DOM.div({style:{"float":"left",width:"25px"}},this.getStatusFA(tstatus)),React.DOM.div({style:{"float":"left"}},tstatus))),React.DOM.td(null,this.getIndexNumber(tstatus,this.props.index+1),"  ",getColumnName()),React.DOM.td(null,starttime.split(".")[0]),React.DOM.td(null,this.getDuration(duration)))}});var TimelineTaskViewWrapper=React.createClass({displayName:"TimelineTaskViewWrapper",render:function(){if(this.props.task.name!=this.props.selected){return React.DOM.div(null)}var task=this.props.task;var taskstatus=this.props.taskstatus;var name=task.name;var description=task.description;var inputs=task.inputs;var outputs=task.outputs;var params=task.params;var code=task.code;var packages=task.packages;var isFunction=task.isFunction;var taskJSON=constructTaskJSON(name,inputs,params,outputs,this.props.tasks);return React.DOM.div({className:"canvas-task-display"},React.DOM.div({className:"canvas-task-graph"},React.DOM.div({className:"canvas-task-info-table"},TaskStatusTime({taskstatus:taskstatus,name:task.name}),React.DOM.br(null),InputsTable({inputs:inputs,params:params,tasks:this.props.tasks,isTimeline:true,isFunction:isFunction}),React.DOM.br(null),OutputsTable({outputs:outputs,tasks:this.props.tasks,isTimeline:true}),React.DOM.br(null),React.DOM.br(null))),React.DOM.div({className:"canvas-task-graph"},TaskGraphLayout({vertices:taskJSON.nodes,edges:taskJSON.links,task:task,callback_handleCode:this.props.callback_handleCode,tasks:this.props.tasks})),React.DOM.br({style:{clear:"both"}}))}});var TaskMainViews=React.createClass({displayName:"TaskMainViews",mixins:[Controls.Tooltip],getInitialState:function(){return{hover:null,selected:null,code:false,hoverTime:null}},handleClick:function(idx,name,evt){if(this.state.selected==name){this.setState({selected:null,hover:null,code:false,hoverTime:null})}else{this.setState({selected:name,hover:null,code:false,hoverTime:name})}},handleCode:function(idx,value,evt){this.setState({code:!this.state.code})},onMouseOver:function(idx,value,evt){this.setState({hover:value})},onMouseOut:function(evt){this.setState({hover:null})},onMouseOverTime:function(idx,value,evt){this.setState({hoverTime:value})},onMouseOutTime:function(evt){this.setState({hoverTime:null})},render:function(){return React.DOM.div({className:"canvas-job-timeline-container"},TimelineLayout({jobstatus:this.props.jobstatus,tasks:this.props.tasks,hover:this.state.hover,hoverTime:this.state.hoverTime,selected:this.state.selected,taskstatus:this.props.task_status,callback_mouseOver:this.onMouseOver,callback_mouseOut:this.onMouseOut,callback_handleClick:this.handleClick,callback_handleCode:this.handleCode,callback_mouseOverTime:this.onMouseOverTime,callback_mouseOutTime:this.onMouseOutTime,key:"timeline_view",starttime:this.props.starttime,endtime:this.props.endtime,has_results:this.props.has_results,selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable}))}});var JobInfo=React.createClass({displayName:"JobInfo",getDuration:function(ms,stat){if(stat!="Completed"){return"N/A"}var seconds=ms/1e3;if(seconds<=60){var concat_secs=Math.round(seconds*100)/100;return concat_secs.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;var concat_secs=Math.round(sec*100)/100;return minutes.toString()+"m "+concat_secs.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;var concat_secs=Math.round(sec*100)/100;return hour.toString()+"h "+minutes.toString()+"m "+concat_secs.toString()+" sec"}},getStatusFA:function(stat){var ret=[];var style={color:Util.getColorFromStatus(stat,false)};if(stat=="Completed"){ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-gear fa-lg"}))}return ret},render:function(){var starttime="--";if(this.props.starttime){var starttime=this.props.starttime.split(".")[0]}var endtime=this.props.endtime;var duration="--";if(this.props.jobstatus=="Completed"&&endtime){var actual_endtime=endtime.split(".")[0];var parsed_time=Date.parse(actual_endtime)-Date.parse(starttime);duration=this.getDuration(parsed_time,this.props.jobstatus)}else{if(this.props.jobstatus=="Failed"){duration="N/A"}}return React.DOM.table({className:"canvas-job-info-table"},React.DOM.tr(null,React.DOM.th(null,"Job"),React.DOM.th(null,":"),React.DOM.th(null,this.props.jobname),React.DOM.th(null),React.DOM.th(null),React.DOM.th(null)),React.DOM.tr(null,React.DOM.td(null,"Type"),React.DOM.td(null,":"),React.DOM.td(null,this.props.jobtype),React.DOM.td(null,"Environment"),React.DOM.td(null,":"),React.DOM.td(null,this.props.env.name)),React.DOM.tr(null,React.DOM.td(null,"Status"),React.DOM.td(null,":"),React.DOM.td(null,React.DOM.div({style:{"float":"left"}},this.props.jobstatus," ",this.getStatusFA(this.props.jobstatus)),React.DOM.div({style:{clear:"both"}})),React.DOM.td(null,"Start Time"),React.DOM.td(null,":"),React.DOM.td(null,starttime)),React.DOM.tr(null,React.DOM.td(null,"Logs"),React.DOM.td(null,":"),React.DOM.td(null,JobLog({joblog:this.props.joblog})),React.DOM.td(null,"Duration"),React.DOM.td(null,":"),React.DOM.td(null,duration)))}});var JobInfoTable=React.createClass({displayName:"JobInfoTable",mixins:[Controls.SizeToWindow],render:function(){var window_width=PageLayout.contentWidth()-10;var min_width=780;var width=window_width>min_width?window_width:min_width;return React.DOM.div({className:"canvas-job-info-container",style:{width:width}},React.DOM.table({className:"canvas-job-info-table"},React.DOM.tr(null,React.DOM.td(null,React.DOM.span({className:"canvas-job-info-label"},"Job:")," ",this.props.jobname),React.DOM.td(null,React.DOM.span({className:"canvas-job-info-label"},"Type:")," ",this.props.jobtype),React.DOM.td(null,React.DOM.span({className:"canvas-job-info-label"},"Environment:")," ",this.props.env.name),React.DOM.td(null,JobLog({joblog:this.props.joblog,jobtype:this.props.jobtype})))))}});var TaskHeaderBar=React.createClass({displayName:"TaskHeaderBar",mixins:[Controls.SizeToWindow],getStatusFA:function(stat){var ret=[];var style={color:Util.getColorFromStatus(stat,false)};if(stat=="Completed"){ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({key:"infoFA",style:style,className:"fa fa-gear fa-lg"}))}return ret},render:function(){var stat=this.props.stat;var style={color:Util.getColorFromStatus(stat,false)};var window_width=PageLayout.contentWidth()-10;var min_width=780;var width=window_width>min_width?window_width:min_width;return React.DOM.div({className:"canvas-job-task-header",style:{width:width}},React.DOM.div({className:"canvas-job-timeline-header"},React.DOM.div({className:"canvas-job-timeline-title"},React.DOM.i({className:"fa fa-clock-o fa-lg"}),"  TIMELINE"),React.DOM.div({className:"canvas-job-timeline-status"},"STATUS: ",React.DOM.span({style:style},stat)," ",this.getStatusFA(stat)),React.DOM.div({style:{clear:"both"}})))}});return{View:React.createClass({displayName:"View",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(){return{metrics:{},status:false,taskView:"timeline",tabView:"env",envTab:true,tableElementColor:{"background-color":"#fff",color:"#000"},graphElementColor:{"background-color":"#c5c5c5",color:"#0a8cc4"},metricsElementColor:{"background-color":"#fff",color:"#000"},paramsElementColor:{"background-color":"#fff"},envElementColor:{"background-color":"#fff",color:"#000"}}},updateAsyncState:function(nextProps){var pageTasks=[];TaskQueue.add(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"Job"})}))},render:function(){var name=Util.tryGetProperty(this.props.selected_variable,"jobname");var tasks=Util.tryGetProperty(this.props.selected_variable,"tasks");var env=Util.tryGetProperty(this.props.selected_variable,"env");var metrics=Util.tryGetProperty(this.props.selected_variable,"metrics");var isRunning=Util.tryGetProperty(this.props.selected_variable,"status");var task_status=Util.tryGetProperty(this.props.selected_variable,"taskstatus");var starttime=Util.tryGetProperty(this.props.selected_variable,"starttime");var endtime=Util.tryGetProperty(this.props.selected_variable,"endtime");var type=Util.tryGetProperty(this.props.selected_variable,"jobtype");var has_results=Util.tryGetProperty(this.props.selected_variable,"has_results",false);var jobJSON=constructJobJSON(tasks);return React.DOM.div({className:"tab-content",style:{overflow:"auto",color:"#000","background-color":"#eee"}},React.DOM.div({className:"canvas canvas-view-main",style:{"background-color":"#eee"}},JobInfoTable({jobname:name,jobtype:type,env:env}),TaskHeaderBar({stat:isRunning}),React.DOM.div({style:{"max-width":PageLayout.contentWidth()-10}},TaskMainViews({name:this.state.taskView,jobJSON:jobJSON,jobstatus:isRunning,tasks:tasks,task_status:task_status,selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable,starttime:starttime,endtime:endtime,has_results:has_results}))))}})}});