define("job_session",["react","plots","d3","common_util","taskqueue","jquery","common_controls","logging","page_layout"],function(React,Plots,d3,Util,TaskQueue,jQuery,Controls,Logging,PageLayout){"use strict";function compareTime(jobA,jobB){if(jobA.starttime==null&&jobB.starttime==null){return 0}if(jobB.starttime==null){return-1}if(jobA.starttime==null){return 1}var timeA=Date.parse(jobA.starttime);var timeB=Date.parse(jobB.starttime);if(timeA<timeB){return 1}else if(timeA>timeB){return-1}else{return 0}}function compareName(jobA,jobB){var a=jobA.name.toLowerCase();var b=jobB.name.toLowerCase();return a.localeCompare(b)}function compareType(jobA,jobB){var a=jobA.type;var b=jobB.type;return a.localeCompare(b)}function compareStatus(jobA,jobB){var a=jobA.status;var b=jobB.status;return a.localeCompare(b)}function compareDuration(jobA,jobB){if(jobA.starttime==null&&jobB.starttime==null){return 0}if(jobB.starttime==null){return-1}else if(jobA.starttime==null){return 1}if(jobB.endtime==null&&jobB.endtime==null){return 0}if(jobB.endtime==null){return-1}else if(jobA.endtime==null){return 1}var starttime_a=jobA.starttime.split(".")[0];var endtime_a=jobA.endtime.split(".")[0];var duration_a=Date.parse(endtime_a)-Date.parse(starttime_a);var starttime_b=jobB.starttime.split(".")[0];var endtime_b=jobB.endtime.split(".")[0];var duration_b=Date.parse(endtime_b)-Date.parse(starttime_b);if(duration_a<duration_b){return 1}else if(duration_a>duration_b){return-1}else{return 0}}var Column=React.createClass({displayName:"Column",handleClick:function(evt){var selected_column=this.props.selected_variable.name.concat([this.props.name]);this.props.selectVariable(selected_column)},render:function(){var getColumnName=function(){return React.DOM.a({href:"javascript:",onClick:this.handleClick,className:"canvas-sframe-column-title"},this.props.name)}.bind(this);return React.DOM.div({className:"canvas-sframe-column-header"},getColumnName())}});var AllColumn=React.createClass({displayName:"AllColumn",handleClick:function(evt){var selected_column=this.props.selected_variable.name.concat([this.props.job.name]);this.props.selectVariable(selected_column)},getDuration:function(ms){var seconds=ms/1e3;if(seconds<=60){var concat_secs=Math.round(seconds*100)/100;return concat_secs.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;var concat_secs=Math.round(sec*100)/100;return minutes.toString()+"m "+concat_secs.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;var concat_secs=Math.round(sec*100)/100;return hour.toString()+"h "+minutes.toString()+"m "+concat_secs.toString()+" sec"}},getStatusFA:function(stat){var style={color:"#85bd00"};var ret=[];if(stat=="Completed"){style={color:"#0a8cc4"};ret.push(React.DOM.i({style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){style={color:"#B80000"};ret.push(React.DOM.i({style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({style:style,className:"fa fa-clock-o fa-lg"}))}return ret},render:function(){var job=this.props.job;var duration="-------------------";var endtime="-------------------";var starttime="-------------------";if(job.starttime){starttime=job.starttime.split(".")[0]}if(job.status=="Completed"&&job.endtime){var job_endtime=job.endtime.split(".")[0];duration=this.getDuration(Date.parse(job_endtime)-Date.parse(starttime));endtime=job["endtime"].split(".")[0]}var getColumnName=function(){return React.DOM.a({href:"javascript:",onClick:this.handleClick,className:"canvas-link"},this.props.job.name)}.bind(this);return React.DOM.div({className:"canvas-job-history-container"},React.DOM.div({className:"canvas-job-history-val status"},React.DOM.div({style:{"float":"left",width:"25px"}},this.getStatusFA(job.status)),React.DOM.div({style:{"float":"left"}},job.status)),React.DOM.div({className:"canvas-job-history-val name"},getColumnName()),React.DOM.div({className:"canvas-job-history-val starttime"},starttime),React.DOM.div({className:"canvas-job-history-val duration"},duration),React.DOM.div({className:"canvas-job-history-val type"},job.type))}});var AllColumnBar=React.createClass({displayName:"AllColumnBar",render:function(){return React.DOM.div({className:"canvas-job-title-val"},React.DOM.div({className:"canvas-job-title-val status"},"      Status"),React.DOM.div({className:"canvas-job-title-val name"},"Job Name"),React.DOM.div({className:"canvas-job-title-val starttime"},"Submission Time"),React.DOM.div({className:"canvas-job-title-val duration"},"Duration"),React.DOM.div({className:"canvas-job-title-val type"},"Job Type"))}});var AllJobs=React.createClass({displayName:"AllJobs",render:function(){var jobs=this.props.list;jobs.sort(compareTime);return React.DOM.div({className:"canvas-job-container"},AllColumnBar(null),jobs.map(function(job,idx){return AllColumn({job:job,selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable,key:job.name+"_"+idx})}.bind(this)))}});var TableColumn=React.createClass({displayName:"TableColumn",handleClick:function(evt){var selected_column=this.props.selected_variable.name.concat([this.props.job.filename]);this.props.selectVariable(selected_column)},getDuration:function(ms){var seconds=ms/1e3;if(seconds<=60){var concat_secs=Math.round(seconds*100)/100;return concat_secs.toString().concat(" sec")}else if(seconds>60&&seconds<=3600){var minutes=Math.floor(seconds/60);var sec=seconds%60;var concat_secs=Math.round(sec);return minutes.toString()+"m "+concat_secs.toString()+" sec"}else if(seconds>3600){var hour=Math.floor(seconds/3600);var sec1=seconds%3600;var minutes=Math.floor(sec1/60);var sec=sec1%60;var concat_secs=Math.round(sec);return hour.toString()+"h "+minutes.toString()+"m "+concat_secs.toString()+" sec"}},getStatusFA:function(stat){var style={color:"#85bd00"};var ret=[];var idx=this.props.key;if(stat=="Completed"){style={color:"#0a8cc4"};ret.push(React.DOM.i({key:idx+"_fa",style:style,className:"fa fa-check fa-lg"}))}else if(stat=="Failed"){style={color:"#B80000"};ret.push(React.DOM.i({key:idx+"_fa",style:style,className:"fa fa-times fa-lg"}))}else if(stat=="Running"){ret.push(React.DOM.i({key:idx+"_fa",style:style,className:"fa fa-gear fa-spin fa-lg"}))}else{ret.push(React.DOM.i({key:idx+"_fa",style:style,className:"fa fa-clock-o fa-lg"}))}return ret},render:function(){var idx=this.props.key;var job=this.props.job;var duration="------------------";var endtime="------------------";var starttime="------------------";if(job.starttime){starttime=job.starttime.split(".")[0]}if(job.status=="Completed"&&job.endtime&&job.starttime){duration=this.getDuration(Date.parse(job.endtime)-Date.parse(job.starttime));endtime=job.endtime.split(".")[0]}var getColumnName=function(){return React.DOM.a({href:"javascript:",key:idx+"_name",onClick:this.handleClick,className:"canvas-link"},this.props.job.name)}.bind(this);return React.DOM.tr({key:idx+"_row"},React.DOM.td({key:idx+"_status"},React.DOM.div({style:{"float":"left",width:"25px"}},this.getStatusFA(job.status)),React.DOM.div({style:{"float":"left"}},job.status)),React.DOM.td(null,getColumnName()),React.DOM.td(null,job.type),React.DOM.td(null,starttime),React.DOM.td(null,duration))}});var AllJobsTable=React.createClass({displayName:"AllJobsTable",mixins:[Controls.AsyncState],getInitialState:function(){return{sortJobs:"time",orderJobs:true,jobs:[]}},doSort:function(jobs,name){if(name==="status"){jobs=jobs.sort(compareStatus)}else if(name==="name"){jobs=jobs.sort(compareName)}else if(name==="type"){jobs=jobs.sort(compareType)}else if(name==="time"){jobs=jobs.sort(compareTime)}else if(name==="duration"){jobs=jobs.sort(compareDuration)}return jobs},handleSort:function(name){if(name==this.state.sortJobs){this.setState({orderJobs:!this.state.orderJobs,jobs:this.state.jobs.reverse()})}else{var jobs=this.state.jobs;jobs=this.doSort(jobs,name);this.setState({sortJobs:name,orderJobs:true,jobs:jobs})}},updateAsyncState:function(nextProps){var list=nextProps.list;var pageTasks=[];list.forEach(function(jobname,idx){pageTasks.push(new TaskQueue.SingleTask("/load_job/"+encodeURIComponent(jobname),"load job").done(function(data){var job=data["job"];if(job!=null){var new_jobs=this.state.jobs.concat(job);new_jobs=this.doSort(new_jobs,this.state.sortJobs);this.setState({jobs:new_jobs})}}.bind(this)))}.bind(this));this.addTask(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"JobSession"})}))},render:function(){var statusFA_class="fa fa-sort pointer";var nameFA_class="fa fa-sort-alpha-asc pointer";var typeFA_class="fa fa-sort-alpha-asc pointer";var timeFA_class="fa fa-sort-numeric-desc pointer";var durationFA_class="fa fa-sort-amount-desc pointer";var jobs=this.state.jobs;if(!this.state.orderJobs){if(this.state.sortJobs==="status"){var statusFA_class="fa fa-sort pointer"}else if(this.state.sortJobs==="name"){var nameFA_class="fa fa-sort-alpha-desc pointer"}else if(this.state.sortJobs==="type"){var typeFA_class="fa fa-sort-alpha-desc pointer"}else if(this.state.sortJobs==="time"){var timeFA_class="fa fa-sort-numeric-asc pointer"}else if(this.state.sortJobs==="duration"){var durationFA_class="fa fa-sort-amount-asc pointer"}}return React.DOM.div({className:"canvas-job-container"},React.DOM.table({className:"canvas-job-list"},React.DOM.tbody(null,React.DOM.tr({className:"no-select"},React.DOM.th(null,"Status ",React.DOM.i({className:statusFA_class,onClick:this.handleSort.bind(this,"status")})),React.DOM.th(null,"Job Name ",React.DOM.i({className:nameFA_class,onClick:this.handleSort.bind(this,"name")})),React.DOM.th(null,"Job Type ",React.DOM.i({className:typeFA_class,onClick:this.handleSort.bind(this,"type")})),React.DOM.th(null,"Submission Time ",React.DOM.i({className:timeFA_class,onClick:this.handleSort.bind(this,"time")})),React.DOM.th(null,"Duration ",React.DOM.i({className:durationFA_class,onClick:this.handleSort.bind(this,"duration")}))),jobs.map(function(job,idx){return TableColumn({job:job,selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable,key:idx})}.bind(this)))))}});return{View:React.createClass({displayName:"View",mixins:[Controls.AsyncState],getInitialState:function(){return{ses:""}},updateAsyncState:function(nextProps){var pageTasks=[];TaskQueue.add(new TaskQueue.MultiTask(pageTasks).always(function(){var metric=(this.canceled?"page_task":"page_task.canceled")+".duration.ms";Logging.reportMetric(metric,this.elapsed(),{operation:this.operation(),type:"JobSession"})}))},render:function(){var name=Util.tryGetProperty(this.props.selected_variable,"sessionname","test");var jobs=Util.tryGetProperty(this.props.selected_variable,"jobs",[]);var list=Util.tryGetProperty(this.props.selected_variable,"list",[]);return React.DOM.div({className:"tab-content",style:{overflow:"auto",color:"#000","background-color":"#eee"}},React.DOM.div({className:"canvas canvas-view-main",style:{"background-color":"#eee"}},AllJobsTable({list:list,selectVariable:this.props.selectVariable,selected_variable:this.props.selected_variable})))}})}});