define("predservice",["react","common_util","taskqueue","jquery","common_controls","plots"],function(React,Util,TaskQueue,jQuery,Controls,Plots){var DeployedPredictiveObjects=React.createClass({displayName:"DeployedPredictiveObjects",render:function(){var deployed=this.props.deployed;return React.DOM.div({className:"canvas-ps-deployed-objects"},React.DOM.div({className:"canvas-ps-deployed-title"},"Deployed Predictive Objects"),React.DOM.table({className:"canvas-ps-deployed-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.th(null,"Name"),React.DOM.th(null,"Version")),Object.keys(deployed).map(function(object_name,idx){var version=deployed[object_name]["version"];return React.DOM.tr({key:object_name+"_"+idx},React.DOM.td(null,object_name),React.DOM.td(null,version))}.bind(this)))))}});var PendingPredictiveObjects=React.createClass({displayName:"PendingPredictiveObjects",render:function(){var pending=this.props.pending;if(Object.keys(pending).length==0){return React.DOM.div(null)}return React.DOM.div(null,React.DOM.div({className:"canvas-ps-deployed-title"},"Local Pending Changes"),React.DOM.table({className:"canvas-ps-pending-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.th(null,"Name"),React.DOM.th(null,"Action"),React.DOM.th(null,"Version")),Object.keys(pending).map(function(object_name,idx){var action_obj=pending[object_name];var action=action_obj["action"];var version=action_obj["version"];return React.DOM.tr({key:object_name+"_"+idx},React.DOM.td(null,object_name),React.DOM.td(null,action),React.DOM.td(null,version))}.bind(this)))))}});var PredictiveServiceInfo=React.createClass({displayName:"PredictiveServiceInfo",getFAState:function(state,description){var style={color:"#85bd00"};if(state=="InService"){return React.DOM.i({style:style,className:"fa fa-gear"})}else if(state=="OutOfService"){if(description==""){style={color:"#B80000"};return React.DOM.i({style:style,className:"fa fa-times"})}else{return React.DOM.i({style:style,className:"fa fa-gear fa-spin"})}}},getMetricsUrl:function(ps_metrics_url){if(ps_metrics_url.length==0){return React.DOM.div(null)}return React.DOM.div({className:"canvas-ps-metrics-container"},React.DOM.a({className:"canvas-log-button",href:ps_metrics_url,target:"_blank"},React.DOM.span({style:{"text-decoration":"underline"}},"View All Metrics"),React.DOM.span(null," ",React.DOM.i({className:"fa fa-external-link"}))))},render:function(){var ps_s3_endpoint=this.props.ps_s3_endpoint;var ps_name=this.props.ps_name;var ps_description=this.props.ps_description;var ps_api_key=this.props.ps_api_key;var ps_lb_dns=this.props.ps_lb_dns;if(ps_description.length==0){ps_description="--------"}if(ps_api_key.length==0){ps_api_key="--------"}var ps_status=this.props.ps_status;var ps_metrics_url=this.props.ps_metrics_url;return React.DOM.div(null,React.DOM.div({className:"canvas-ps-list-title"},React.DOM.span({style:{"float":"left"}},ps_s3_endpoint),this.getMetricsUrl(ps_metrics_url),React.DOM.div({style:{clear:"both"}})),React.DOM.table({className:"canvas-ps-info-table"},React.DOM.tbody(null,React.DOM.tr(null,React.DOM.td(null,"Name:"),React.DOM.td(null),React.DOM.td(null,ps_name)),React.DOM.tr(null,React.DOM.td(null,"Description:"),React.DOM.td(null),React.DOM.td(null,ps_description)),React.DOM.tr(null,React.DOM.td(null,"API key:"),React.DOM.td(null),React.DOM.td(null,ps_api_key)),React.DOM.tr(null,React.DOM.td(null,"Load Balancer DNS:"),React.DOM.td(null),React.DOM.td(null,ps_lb_dns)),React.DOM.tr(null,React.DOM.td(null,"Instance(s) Status:"),React.DOM.td(null),React.DOM.td(null,Object.keys(ps_status).map(function(instance_id,idx){var state_obj=ps_status[instance_id];var description=state_obj["description"];if(description==="N/A"){description=""}var state=state_obj["state"];return React.DOM.div({key:instance_id+"_"+idx},React.DOM.div({style:{"float":"left",width:"100px"}},instance_id),React.DOM.div({style:{"float":"left","padding-right":"25px"}},this.getFAState(state,description),"  ",state),React.DOM.div({style:{clear:"both"}}))}.bind(this)))))))}});var PSMetrics=React.createClass({displayName:"PSMetrics",render:function(){var metrics=this.props.metrics;if(metrics["requests_data"].length>1){var requests_data=metrics["requests_data"][0];var requests_extrema=metrics["requests_data"][1]}else{return React.DOM.div(null)}if(metrics["latency_data"].length>1){var latency_data=metrics["latency_data"][0];var latency_extrema=metrics["latency_data"][1]}else{return React.DOM.div(null)}if(metrics["hosts_data"].length>1){var hosts_data=metrics["hosts_data"][0];var hosts_extrema=metrics["hosts_data"][1]}else{return React.DOM.div(null)}if(metrics["cache_data"].length>1){var cache_data=metrics["cache_data"][0];var cache_extrema=metrics["cache_data"][1]}else{return React.DOM.div(null)}var plotToShow=Plots.Scatter({data:requests_data,extrema:requests_extrema,xLabel:"Time",yLabel:"Requests (Count)",width:270,height:180,coefficients:{m:null},selectVariable:null,plotName:"Requests",lineGraph:true,ipython:true,isMetrics:true});var plotToShow1=Plots.Scatter({data:latency_data,extrema:latency_extrema,xLabel:"Time",yLabel:"Latency (Seconds)",width:270,height:180,coefficients:{m:null},selectVariable:null,plotName:"Latency",lineGraph:true,ipython:true,isMetrics:true});var plotToShow2=Plots.Scatter({data:hosts_data,extrema:hosts_extrema,xLabel:"Time",yLabel:"Number of Healthy Hosts (Count)",width:270,height:180,coefficients:{m:null},selectVariable:null,plotName:"Number of Healthy Hosts",lineGraph:true,ipython:true,isMetrics:true});var plotToShow3=Plots.Scatter({data:cache_data,extrema:cache_extrema,xLabel:"Time",yLabel:"Number of keys in Cache (Count)",width:270,height:180,coefficients:{m:null},selectVariable:null,plotName:"Number of keys in Cache",lineGraph:true,ipython:true,isMetrics:true});return React.DOM.div(null,React.DOM.div({style:{"float":"left"}},plotToShow,plotToShow1),React.DOM.div({style:{"float":"left"}},plotToShow2,plotToShow3),React.DOM.div({style:{clear:"both"}}))}});var PredictiveServiceTabs=React.createClass({displayName:"PredictiveServiceTabs",getContent:function(view){if(view==="Objects"){return React.DOM.div(null,DeployedPredictiveObjects({deployed:this.props.deployed}),PendingPredictiveObjects({pending:this.props.pending}))}else if(view==="Metrics"){return React.DOM.div(null,PSMetrics({metrics:this.props.metrics}))}},render:function(){return React.DOM.div({className:"canvas-ps-wrapper"},this.getContent(this.props.view))}});var PredictiveServiceView=React.createClass({displayName:"PredictiveServiceView",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(){return{ps_status:{},ps_metrics_url:"blank",view:"Objects",ObjectsColor:{"background-color":"#fff",color:"#000"},MetricsColor:{"background-color":"#dedede",color:"#0a8cc4"},ps_metrics:{requests_data:[],latency_data:[],hosts_data:[],cache_data:[]}}},changeView:function(setView){this.setState({view:setView});if(setView==="Objects"){this.setState({ObjectsColor:{"background-color":"#fff",color:"#000"},MetricsColor:{"background-color":"#dedede",color:"#0a8cc4"}})}else{this.setState({ObjectsColor:{"background-color":"#dedede",color:"#0a8cc4"},MetricsColor:{"background-color":"#fff",color:"#000"}})}},updateAsyncState:function(){this.addTask(new TaskQueue.SingleTask("/get_ps_status","get ps status").done(function(data){var ps_status=Util.tryGetProperty(data,"ps_status",{});var ps_metrics_url=Util.tryGetProperty(data,"ps_metrics_url","");this.setState({ps_status:ps_status,ps_metrics_url:ps_metrics_url})}.bind(this)));this.addTask(new TaskQueue.SingleTask("/get_ps_metrics","get ps metrics").done(function(data){var requests_data=Util.tryGetProperty(data,"num_requests_data",[]);var latency_data=Util.tryGetProperty(data,"latency_data",[]);var hosts_data=Util.tryGetProperty(data,"hosts_data",[]);var cache_data=Util.tryGetProperty(data,"cache_data",[]);this.setState({ps_metrics:{requests_data:requests_data,latency_data:latency_data,hosts_data:hosts_data,cache_data:cache_data}})}.bind(this)))},render:function(){var ps_info=Util.tryGetProperty(this.props.selected_variable,"ps_info",{});var ps_name=Util.tryGetProperty(ps_info,"name","");var ps_s3_endpoint=Util.tryGetProperty(ps_info,"s3_endpoint","");var ps_description=Util.tryGetProperty(ps_info,"description","");var ps_api_key=Util.tryGetProperty(ps_info,"api_key","");var ps_pending=Util.tryGetProperty(ps_info,"pending",{});var ps_deployed=Util.tryGetProperty(ps_info,"deployed",{});var ps_lb_dns=Util.tryGetProperty(ps_info,"lb_dns_name","N/A");var ps_metrics_url=this.state.ps_metrics_url;var ps_status=this.state.ps_status;var ps_metrics=this.state.ps_metrics;return React.DOM.div({className:"tab-content",style:{"max-width":this.state.windowWidth-(190+50),"max-height":this.state.windowHeight-(74+50),overflow:"auto",color:"#000","min-height":this.state.windowHeight-100}},React.DOM.div({className:"canvas canvas-view-main"},React.DOM.div({className:"canvas-ps-info-container"},PredictiveServiceInfo({ps_name:ps_name,ps_s3_endpoint:ps_s3_endpoint,ps_description:ps_description,ps_api_key:ps_api_key,ps_status:ps_status,ps_lb_dns:ps_lb_dns,ps_metrics_url:ps_metrics_url})),React.DOM.div({className:"canvas-ps-tab"},React.DOM.div({className:"canvas-ps-tab-element no-select",style:this.state.ObjectsColor,onClick:this.changeView.bind(null,"Objects")},"Predictive Objects"),React.DOM.div({className:"canvas-ps-tab-element no-select",style:this.state.MetricsColor,onClick:this.changeView.bind(null,"Metrics")},"Metrics")),React.DOM.div(null,PredictiveServiceTabs({view:this.state.view,deployed:ps_deployed,pending:ps_pending,metrics:ps_metrics}))))}});return{View:PredictiveServiceView}});