import os as _os
import _neuralnets as _nn

_pwd = _os.path.dirname(_os.path.realpath(__file__))

_mnist_conf_str = '''
# example configure file for mnist convolution net
netconfig=start
layer[0->1] = conv
  kernel_size = 3
  padding = 1
  stride = 2
  num_channels = 32
  random_type = xavier
layer[1->2] = max_pooling
  kernel_size = 3
  stride = 2
layer[2->3] = flatten
layer[3->4] = dropout
  threshold = 0.5
layer[4->5] = fullc
  num_hidden_units = 100
  init_sigma = 0.01
layer[5->6] = sigmoid
layer[6->7] = fullc
  num_hidden_units = 10
  init_sigma = 0.01
layer[7->8] = softmax
netconfig=end

# input shape not including batch
input_shape = 1,28,28
batch_size = 100

## global parameters
init_random = gaussian

## learning parameters
learning_rate = 0.1
momentum = 0.9
l2_regularization = 0.0
divideby = 255
# end of config
'''

_imagenet_conf_str='''
# example configure file for imagenet

netconfig=start
layer[0->1] = conv
kernel_size = 11
stride = 4
num_channels = 96
layer[1->2] = relu
layer[2->3] = max_pooling
kernel_size = 3
stride = 2
layer[3->4] = lrn
local_size = 5
alpha = 0.001
beta = 0.75
knorm = 1
###############
layer[4->5] = conv
num_groups = 2
num_channels = 256
kernel_size = 5
padding = 2
layer[5->6] = relu
layer[6->7] = max_pooling
kernel_size = 3
stride = 2
layer[7->8] = lrn
local_size = 5
alpha = 0.001
beta = 0.75
knorm = 1
#############
layer[8->9] = conv
num_channels = 384
kernel_size = 3
padding = 1
layer[9->10]= relu
layer[10->11] = conv
num_channels = 384
num_groups = 2
kernel_size = 3
padding = 1
layer[11->12] = relu
layer[12->13] = conv
num_channels = 256
num_groups = 2
kernel_size = 3
padding = 1
init_bias = 1.0
layer[13->14] = relu
layer[14->15] = max_pooling
kernel_size = 3
stride = 2
layer[15->16] = flatten
layer[16->17] = fullc
num_hidden_units = 4096
init_sigma = 0.005
init_bias = 1.0
layer[17->18] = relu
layer[18->19] = dropout
threshold = 0.5
layer[19->20] = fullc
num_hidden_units = 4096
init_sigma = 0.005
init_bias = 1.0
layer[20->21] = relu
layer[21->22] = dropout
threshold = 0.5
layer[22->23] = fullc
num_hidden_units = 1000
layer[23->24] = softmax
netconfig=end

# global parameters in any sectiion outside netconfig, and iter
momentum = 0.9
learning_rate  = 0.01
l2_regularization = 0.0005
bias_learning_rate  = 0.02

# all the learning rate schedule starts with lr
learning_rate_schedule = exponential_decay
learning_rate_gamma = 0.1
learning_rate_step = 100000

# random config
init_random = gaussian
init_sigma = 0.01

# image pre-proc
random_crop = 1
random_mirror = 1
input_shape = 3,227,227
'''

""" Builtin convoluation Neuralnet for MNIST data """
_MNIST_NET = _nn.NeuralNet(conf_str=_mnist_conf_str)

""" Builtin convoluation Neuralnet for IMAGENET data """
_IMAGENET_NET = _nn.NeuralNet(conf_str=_imagenet_conf_str)
