#! /usr/bin/env python
# coding: utf-8
"""
"""
from __future__ import with_statement, absolute_import

import os.path
from optparse import OptionParser


try:
    import json
except ImportError:
    import simplejson as json


option_parser = OptionParser(usage='%prog [TEMPLATENAME] [key=value] ...')


class Template(object):

    def __init__(self, path):
        self._path = path

        configfilename = os.path.join(path, 'graygoo.json')
        if not os.path.exists(configfilename):
            raise UsageError(u'template %s not found.' % templatename)

        with open(configfilename) as fp:
            self._config = json.load(fp)

    def render(self, path, args):
        for tpl in self._config['render']:
            target = os.path.join(path, tpl['target'] % args)
            self._render_source_file(target, tpl['source'], args)

    def _get_source_file(self, filename, args):
        with open(os.path.join(self._path, filename), 'rb') as fp:
            return fp.read() % args

    def _render_source_file(self, target, sourcefile, args):
        if os.path.exists(target):
            self.log(u'%s already exists, skipping it' % target)
            return

#        directory = os.path.dirname(target)
#        if not os.path.exists(directory):
#            os.mkdir

        self.log(u"generating '%s'" % target)
        with open(target, 'wb') as fp:
            fp.write(self._get_source_file(sourcefile, args))

    def log(self, text):
        print(text)


class UsageError(Exception):
    pass



if __name__ == '__main__':
    options, args = option_parser.parse_args()

    if not args:
        option_parser.error('please provide a template name')

    templatename = args[0]

    vars = [pair.split('=', 1) for pair in args[1:]]

    if any(len(pair) != 2 for pair in vars):
        option_parser.error('please provide all template arguments in the form key=value')

    vars = dict(vars)

    try:
        template = Template(os.path.join('templates', templatename))
        template.render('', vars)
    except UsageError, exc:
        option_parser.error(unicode(exc))

