#! /usr/bin/env python
# coding: utf-8
"""
 :copyright: (c) 2012 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""
from __future__ import with_statement, absolute_import
import os.path

try:
    import json
except ImportError:
    import simplejson as json


class Repository(object):

    def __init__(self):
        self._paths = []

    def add_path(self, path):
        self._paths.append(path)

    def add_buildins(self):
        self.add_path(os.path.join(os.path.dirname(__file__), 'templates'))

    def get_template(self, templatename):
        for path in self._paths:
            candidate = os.path.join(path, templatename)
            if os.path.exists(candidate):
                return Template(candidate)
        raise UsageError(u"no template '%s' found." % templatename)


class Template(object):

    def __init__(self, path):
        self._path = path
        with open(os.path.join(path, 'graygoo.json')) as fp:
            self._config = json.load(fp)

    def render(self, path, args):
        for tpl in self._config['render']:
            target = os.path.join(path, tpl['target'] % args)
            self._render_source_file(target, tpl['source'], args)

    def _get_source_file(self, filename, args):
        with open(os.path.join(self._path, filename), 'rb') as fp:
            return fp.read() % args

    def _render_source_file(self, target, sourcefile, args):
        if os.path.exists(target):
            self.log(u'%s already exists, skipping it' % target)
            return

#        directory = os.path.dirname(target)
#        if not os.path.exists(directory):
#            os.mkdir

        self.log(u"generating '%s'" % target)
        with open(target, 'wb') as fp:
            fp.write(self._get_source_file(sourcefile, args))

    def log(self, text):
        print(text)


class UsageError(Exception):
    pass

