# coding: utf-8
"""
 :copyright: (c) 2012 Philipp Benjamin Köppchen
 :license: GPLv3, see LICENSE for more details.
"""
from __future__ import with_statement, absolute_import, unicode_literals

import tarfile
from StringIO import StringIO
import urllib2


class PackageError(Exception):
    """ Error when handling packages
    """


def install_package(url, repopath):
    """ Installs a package from an URL into the repopath

    url
        where the package lies. Understands http(s), file, and everything else
        urllib2 understands
    repopath
        the path where the package should be installed to, e.G. '~/.graygoo'
    """
    try:
        urlfp = urllib2.urlopen(url)
        tar = tarfile.open(fileobj=StringIO(urlfp.read()))
        urlfp.close()
    except urllib2.URLError as exc:
        raise PackageError('There seems to be a problem with the given '
                                                           'source (%s)' % exc)
    except tarfile.ReadError as exc:
        raise PackageError('There seems to be a problem with the format (%s)'
                                                                         % exc)
    tar.extractall(repopath)
