"""
The MIT License

Copyright (c) 2012 Nicholas Orlowski

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.

"""
hl7fields = {'EVN': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'event_code', 'data_type': 'string'},
                                      {'code': 'timestamp',
                                       'subfields': [{'code': 'time',
                                                      'data_type': 'timestamp'},
                                                     {'code': 'resolution',
                                                      'data_type': 'string'}]},
                                      {'code': 'admit_dt', 'data_type': 'timestamp'},
                                      {'code': 'reason_cd', 'data_type': 'string'},
                                      {'code': 'operator_id', 'data_type': 'string'},
                                      {'code': 'event_occurred', 'data_type': 'timestamp'}]},
                'GT1': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'guar_no', 'data_type': 'string'},
                                      {'code': 'guar_name', 'data_type': 'composite'},
                                      {'code': 'guar_spouse_name',
                                       'data_type': 'composite'},
                                      {'code': 'guar_address', 'data_type': 'string'},
                                      {'code': 'guar_home_phone', 'data_type': 'string'},
                                      {'code': 'guar_bus_phone', 'data_type': 'string'},
                                      {'code': 'guar_date_of_birth', 'data_type': 'date'},
                                      {'code': 'guar_sex', 'data_type': 'string'},
                                      {'code': 'guar_type', 'data_type': 'string'},
                                      {'code': 'guar_relation', 'data_type': 'string'},
                                      {'code': 'guar_soc_sec_no', 'data_type': 'string'},
                                      {'code': 'guar_begin_date', 'data_type': 'date'},
                                      {'code': 'guar_end_date', 'data_type': 'date'},
                                      {'code': 'guar_priority', 'data_type': 'string'},
                                      {'code': 'guar_employer', 'data_type': 'string'},
                                      {'code': 'guar_employer_addr', 'data_type': 'string'},
                                      {'code': 'guar_employer_phone',
                                       'data_type': 'string'},
                                      {'code': 'guar_employee_id_no',
                                       'data_type': 'string'},
                                      {'code': 'guar_emplyment_status',
                                       'data_type': 'string'},
                                      {'code': 'guar_organization_name',
                                       'data_type': 'string'},
                                      {'code': 'guar_billing_hold_flag',
                                       'data_type': 'string'},
                                      {'code': 'guar_credit_rating_code',
                                       'data_type': 'string'},
                                      {'code': 'guar_death_date_time',
                                       'data_type': 'timestamp'},
                                      {'code': 'guar_death_flag', 'data_type': 'string'},
                                      {'code': 'guar_charge_adjust_code',
                                       'data_type': 'string'},
                                      {'code': 'guar_household_annual_inc',
                                       'data_type': 'string'},
                                      {'code': 'guar_household_size',
                                       'data_type': 'string'},
                                      {'code': 'guar_employ_id_no', 'data_type': 'string'},
                                      {'code': 'guar_marital_status_code',
                                       'data_type': 'string'},
                                      {'code': 'guar_hire_effect_date',
                                       'data_type': 'date'},
                                      {'code': 'employment_stop_date', 'data_type': 'date'},
                                      {'code': 'living_dependency', 'data_type': 'string'},
                                      {'code': 'ambulatory_status', 'data_type': 'string'},
                                      {'code': 'citzenship', 'data_type': 'string'},
                                      {'code': 'primary_language', 'data_type': 'string'},
                                      {'code': 'living_arrangement', 'data_type': 'string'},
                                      {'code': 'publicity_ind', 'data_type': 'string'},
                                      {'code': 'protection_ind', 'data_type': 'string'},
                                      {'code': 'student_ind', 'data_type': 'string'},
                                      {'code': 'religion', 'data_type': 'string'},
                                      {'code': 'mothers_maiden_name',
                                       'data_type': 'string'},
                                      {'code': 'nationaility', 'data_type': 'string'},
                                      {'code': 'ethnic_group', 'data_type': 'string'},
                                      {'code': 'contact_pers_name', 'data_type': 'string'},
                                      {'code': 'contact_pess_ph_no', 'data_type': 'string'},
                                      {'code': 'contact_reason', 'data_type': 'string'},
                                      {'code': 'contact_relation', 'data_type': 'string'},
                                      {'code': 'job_title', 'data_type': 'string'},
                                      {'code': 'job_class_code', 'data_type': 'string'},
                                      {'code': 'guar_employs_organiz_name',
                                       'data_type': 'string'},
                                      {'code': 'handicap', 'data_type': 'string'},
                                      {'code': 'job_status', 'data_type': 'string'},
                                      {'code': 'guar_financial_class',
                                       'data_type': 'string'},
                                      {'code': 'guar_race', 'data_type': 'string'}]},
                'IN1': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'ins_plan_id', 'data_type': 'string'},
                                      {'code': 'ins_company_id', 'data_type': 'string'},
                                      {'code': 'ins_company_name', 'data_type': 'string'},
                                      {'code': 'ins_company_addr',
                                       'subfields': [{'code': 'street',
                                                      'data_type': 'string'},
                                                     {'code': 'street2',
                                                      'data_type': 'string'},
                                                     {'code': 'city',
                                                      'data_type': 'string'},
                                                     {'code': 'state',
                                                      'data_type': 'string'},
                                                     {'code': 'zip',
                                                      'data_type': 'string'}]},
                                      {'code': 'ins_co_contact_per',
                                       'data_type': 'composite'},
                                      {'code': 'ins_co_phone_no',
                                       'subfields': [{'code': 'number',
                                                      'data_type': 'string'},
                                                     {'code': 'type', 'data_type': 'string'}]},
                                      {'code': 'group_no', 'data_type': 'string'},
                                      {'code': 'group_name', 'data_type': 'string'},
                                      {'code': 'ins_group_emp_id', 'data_type': 'string'},
                                      {'code': 'ins_group_emp_name', 'data_type': 'string'},
                                      {'code': 'plan_effect_date', 'data_type': 'date'},
                                      {'code': 'plan_expire_date', 'data_type': 'date'},
                                      {'code': 'authorization_info', 'data_type': 'string'},
                                      {'code': 'plan_type', 'data_type': 'string'},
                                      {'code': 'name_of_insured', 'data_type': 'composite'},
                                      {'code': 'ins_relation_to', 'data_type': 'string'},
                                      {'code': 'insured_dob', 'data_type': 'date'},
                                      {'code': 'insured_addr', 'data_type': 'string'},
                                      {'code': 'assign_of_benefits', 'data_type': 'string'},
                                      {'code': 'coord_of_benefits', 'data_type': 'string'},
                                      {'code': 'coord_of_bene_priority',
                                       'data_type': 'string'},
                                      {'code': 'note_of_admit_code', 'data_type': 'string'},
                                      {'code': 'note_of_admit_date', 'data_type': 'date'},
                                      {'code': 'rpt_of_elig_code', 'data_type': 'string'},
                                      {'code': 'rpt_of_elig_date', 'data_type': 'date'},
                                      {'code': 'release_info_code', 'data_type': 'string'},
                                      {'code': 'pre_admit_cert_code',
                                       'data_type': 'string'},
                                      {'code': 'verify_date', 'data_type': 'timestamp'},
                                      {'code': 'verify_by', 'data_type': 'string'},
                                      {'code': 'type_of_agree_code', 'data_type': 'string'},
                                      {'code': 'billing_status', 'data_type': 'string'},
                                      {'code': 'lifetime_resv_days', 'data_type': 'string'},
                                      {'code': 'delay_before_lr_days',
                                       'data_type': 'string'},
                                      {'code': 'co_plan_code', 'data_type': 'string'},
                                      {'code': 'policy_no', 'data_type': 'string'},
                                      {'code': 'policy_deductible', 'data_type': 'string'},
                                      {'code': 'policy_amt_limit', 'data_type': 'string'},
                                      {'code': 'policy_days_limit', 'data_type': 'string'},
                                      {'code': 'room_rate_semi_priv',
                                       'data_type': 'string'},
                                      {'code': 'room_rate_private', 'data_type': 'string'},
                                      {'code': 'insured_employ_stat',
                                       'data_type': 'string'},
                                      {'code': 'insured_sex', 'data_type': 'string'},
                                      {'code': 'insured_employ_addr',
                                       'data_type': 'string'},
                                      {'code': 'verifications_status',
                                       'data_type': 'string'},
                                      {'code': 'prior_ins_plan_id', 'data_type': 'string'},
                                      {'code': 'coverage_type', 'data_type': 'string'},
                                      {'code': 'handicap', 'data_type': 'string'},
                                      {'code': 'ins_id_no', 'data_type': 'string'}]},
                'IN2': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'insured_employee_id',
                                       'data_type': 'string'},
                                      {'code': 'insured_soc_sec_no', 'data_type': 'string'},
                                      {'code': 'insured_emplyr_name',
                                       'data_type': 'string'},
                                      {'code': 'employer_info_data', 'data_type': 'string'},
                                      {'code': 'mail_claim_party', 'data_type': 'string'},
                                      {'code': 'medcr_health_ins_crd',
                                       'data_type': 'string'},
                                      {'code': 'medicaid_case_name', 'data_type': 'string'},
                                      {'code': 'medicaid_case_no',
                                       'data_type': 'composite'},
                                      {'code': 'champus_spon_name',
                                       'data_type': 'composite'},
                                      {'code': 'champus_id_no', 'data_type': 'string'},
                                      {'code': 'champus_recip_depend',
                                       'data_type': 'string'},
                                      {'code': 'champus_organization',
                                       'data_type': 'string'},
                                      {'code': 'champus_station', 'data_type': 'string'},
                                      {'code': 'champus_service', 'data_type': 'string'},
                                      {'code': 'champus_rank_grade', 'data_type': 'string'},
                                      {'code': 'champus_status', 'data_type': 'string'},
                                      {'code': 'champus_retire_dt', 'data_type': 'date'},
                                      {'code': 'chmp_non_avail_cert',
                                       'data_type': 'string'},
                                      {'code': 'baby_coverage', 'data_type': 'string'},
                                      {'code': 'combine_baby_bill', 'data_type': 'string'},
                                      {'code': 'blood_deductible', 'data_type': 'string'},
                                      {'code': 'spec_cov_approv_nme',
                                       'data_type': 'composite'},
                                      {'code': 'spec_cov_apprv_title',
                                       'data_type': 'string'},
                                      {'code': 'non_covered_ins_code',
                                       'data_type': 'string'},
                                      {'code': 'payor_id', 'data_type': 'string'},
                                      {'code': 'payor_subscriber_id',
                                       'data_type': 'string'},
                                      {'code': 'eligibility_source', 'data_type': 'string'},
                                      {'code': 'room_cov_type_amt', 'data_type': 'string'},
                                      {'code': 'policy_type_amt', 'data_type': 'string'},
                                      {'code': 'daily_deductible', 'data_type': 'string'},
                                      {'code': 'living_dependency', 'data_type': 'string'},
                                      {'code': 'ambulatory_status', 'data_type': 'string'},
                                      {'code': 'citizenship', 'data_type': 'string'},
                                      {'code': 'primary_language', 'data_type': 'string'},
                                      {'code': 'living_arrangement', 'data_type': 'string'},
                                      {'code': 'publicity_ind', 'data_type': 'string'},
                                      {'code': 'protection_ind', 'data_type': 'string'},
                                      {'code': 'student_ind', 'data_type': 'string'},
                                      {'code': 'religion', 'data_type': 'string'},
                                      {'code': 'mothers_maiden_name',
                                       'data_type': 'string'},
                                      {'code': 'nationality', 'data_type': 'string'},
                                      {'code': 'ethnic_group', 'data_type': 'string'},
                                      {'code': 'marital_status', 'data_type': 'string'},
                                      {'code': 'ins_employ_start_dt', 'data_type': 'date'},
                                      {'code': 'ins_employ_stop_dt', 'data_type': 'date'},
                                      {'code': 'job_title', 'data_type': 'string'},
                                      {'code': 'job_class_code', 'data_type': 'string'},
                                      {'code': 'job_status', 'data_type': 'string'},
                                      {'code': 'employ_contact_pers_name',
                                       'data_type': 'string'},
                                      {'code': 'employ_contact_pers_ph_no',
                                       'data_type': 'string'},
                                      {'code': 'employ_contact_reason',
                                       'data_type': 'string'},
                                      {'code': 'ins_contact_pers_name',
                                       'data_type': 'string'},
                                      {'code': 'ins_contact_pers_ph_no',
                                       'data_type': 'string'},
                                      {'code': 'ins_contact_pers_reason',
                                       'data_type': 'string'},
                                      {'code': 'relation_to_pat_start_dt',
                                       'data_type': 'date'},
                                      {'code': 'relation_to_pat_stop_dt',
                                       'data_type': 'date'},
                                      {'code': 'ins_company_contact_reason',
                                       'data_type': 'string'},
                                      {'code': 'ins_company_contact_ph_no',
                                       'data_type': 'string'},
                                      {'code': 'policy_scope', 'data_type': 'string'},
                                      {'code': 'policy_source', 'data_type': 'string'},
                                      {'code': 'patient_member_no', 'data_type': 'string'},
                                      {'code': 'guar_relation_to_insured',
                                       'data_type': 'string'},
                                      {'code': 'ins_home_ph', 'data_type': 'string'},
                                      {'code': 'ins_work_ph', 'data_type': 'string'},
                                      {'code': 'military_handicap_prog',
                                       'data_type': 'string'},
                                      {'code': 'suspend_flag', 'data_type': 'string'},
                                      {'code': 'copay_limit_flag', 'data_type': 'string'},
                                      {'code': 'stoploss_limit_flag',
                                       'data_type': 'string'},
                                      {'code': 'ins_org_name_and_id',
                                       'data_type': 'string'},
                                      {'code': 'ins_employ_org_name',
                                       'data_type': 'string'},
                                      {'code': 'race', 'data_type': 'string'},
                                      {'code': 'hcfa_pat_rel_to_insured',
                                       'data_type': 'string'}]},
                'MFE': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'rec_level_evn_cd', 'data_type': 'string'},
                                      {'code': 'mfn_ctl_id', 'data_type': 'string'},
                                      {'code': 'effect_dttm', 'data_type': 'timestamp'},
                                      {'code': 'pri_key_value', 'data_type': 'string'}]},
                'MFI': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'master_file_ident',
                                       'subfields': [{'code': 'identifier',
                                                      'data_type': 'string'},
                                                     {'code': 'text',
                                                      'data_type': 'string'},
                                                     {'code': 'name_code_system',
                                                      'data_type': 'string'}]},
                                      {'code': 'file_app_ident',
                                       'subfields': [{'code': 'namespace_id',
                                                      'data_type': 's'},
                                                     {'code': 'uid', 'data_type': 'string'},
                                                     {'code': 'uid_type',
                                                      'data_type': 'string'}]},
                                      {'code': 'file_level_evn_cd', 'data_type': 'string'},
                                      {'code': 'entered_dttm', 'data_type': 'string'},
                                      {'code': 'effect_dttm', 'data_type': 'timestamp'},
                                      {'code': 'response_level', 'data_type': 'string'},
                                      {'code': 'deleted_flag', 'data_type': 'string'},
                                      {'code': 'is_internal', 'data_type': 'string'},
                                      {'code': 'decesed', 'data_type': 'string'},
                                      {'code': 'retired', 'data_type': 'string'}]},
                'MSA': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'ack_cd', 'data_type': 'string'},
                                      {'code': 'msg_ctl_id', 'data_type': 'string'},
                                      {'code': 'msg', 'data_type': 'string'},
                                      {'code': 'seq_no', 'data_type': 'string'},
                                      {'code': 'delay_ack_type', 'data_type': 'string'},
                                      {'code': 'error_condition', 'data_type': 'string'}]},
                'MSH': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'encoding_chars', 'data_type': 'string'},
                                      {'code': 'send_app',
                                       'subfields': [{'code': 'app_name',
                                                      'data_type': 'string'}]},
                                      {'code': 'send_fac', 'data_type': 'string'},
                                      {'code': 'recv_app',
                                       'subfields': [{'code': 'app_name',
                                                      'data_type': 'string'}]},
                                      {'code': 'recv_fac', 'data_type': 'string'},
                                      {'code': 'timestamp', 'data_type': 'timestamp'},
                                      {'code': 'security', 'data_type': 'string'},
                                      {'code': 'msg_type',
                                       'subfields': [{'code': 'message_code',
                                                      'data_type': 'string'},
                                                     {'code': 'event_code',
                                                      'data_type': 'string'}]},
                                      {'code': 'msg_ctl_id', 'data_type': 'string'},
                                      {'code': 'proc_id', 'data_type': 'string'},
                                      {'code': 'version', 'data_type': 'string'},
                                      {'code': 'seq_no', 'data_type': 'string'},
                                      {'code': 'cont_pointer', 'data_type': 'string'},
                                      {'code': 'accept_ack_type', 'data_type': 'string'},
                                      {'code': 'application_ack_type',
                                       'data_type': 'string'},
                                      {'code': 'country_code', 'data_type': 'string'},
                                      {'code': 'character_set', 'data_type': 'string'},
                                      {'code': 'principal_lang_of_msg',
                                       'data_type': 'string'}]},
                'NK1': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'name',
                                       'subfields': [{'code': 'lname', 'data_type': 'string'},
                                                     {'code': 'fname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'suffix',
                                                      'data_type': 'string'},
                                                     {'code': 'prefix',
                                                      'data_type': 'string'},
                                                     {'code': 'degree',
                                                      'data_type': 'string'},
                                                     {'code': 'source_table',
                                                      'data_type': 'string'},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'name_type_cd',
                                                      'data_type': 'string'}]},
                                      {'code': 'relationship',
                                       'subfields': [{'code': 'identifier',
                                                      'data_type': 'string'},
                                                     {'code': 'text', 'data_type': 'string'},
                                                     {'code': 'name_of_coding_system',
                                                      'data_type': 'string'},
                                                     {'code': 'alternate_dentifier',
                                                      'data_type': 'string'},
                                                     {'code': 'alternate_text',
                                                      'data_type': 'string'},
                                                     {'code': 'name_of_alternate_coding_system',
                                                      'data_type': 'string'}]},
                                      {'code': 'address',
                                       'subfields': [{'code': 'street',
                                                      'data_type': 'string'},
                                                     {'code': 'street2',
                                                      'data_type': 'string'},
                                                     {'code': 'city', 'data_type': 'string'},
                                                     {'code': 'state', 'data_type': 'string'},
                                                     {'code': 'zip', 'data_type': 'string'},
                                                     {'code': 'country',
                                                      'data_type': 'string'},
                                                     {'code': 'addr_type',
                                                      'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'}]},
                                      {'code': 'phone_number',
                                       'subfields': [{'code': 'number',
                                                      'data_type': 'string'},
                                                     {'code': 'type', 'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'},
                                                     {'code': 'other3',
                                                      'data_type': 'string'}]},
                                      {'code': 'business_phone_number',
                                       'subfields': [{'code': 'number',
                                                      'data_type': 'string'},
                                                     {'code': 'type', 'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'},
                                                     {'code': 'other3',
                                                      'data_type': 'string'}]},
                                      {'code': 'contact_role',
                                       'subfields': [{'code': 'identifier',
                                                      'data_type': 'string'},
                                                     {'code': 'text', 'data_type': 'string'},
                                                     {'code': 'name_of_coding_system',
                                                      'data_type': 'string'},
                                                     {'code': 'alternate_dentifier',
                                                      'data_type': 'string'},
                                                     {'code': 'alternate_text',
                                                      'data_type': 'string'},
                                                     {'code': 'name_of_alternate_coding_system',
                                                      'data_type': 'string'}]},
                                      {'code': 'start_date', 'data_type': 'timestamp'},
                                      {'code': 'end_date', 'data_type': 'timestamp'},
                                      {'code': 'job_title', 'data_type': 'string'},
                                      {'code': 'job_class_code',
                                       'subfields': [{'code': 'job_ode',
                                                      'data_type': 'string'},
                                                     {'code': 'job_class',
                                                      'data_type': 'string'},
                                                     {'code': 'job_description_text',
                                                      'data_type': 'string'}]},
                                      {'code': 'employee_number', 'data_type': 'string'},
                                      {'code': 'organization_name', 'data_type': 'string'},
                                      {'code': 'marital_status', 'data_type': 'string'},
                                      {'code': 'administrative_sex', 'data_type': 'string'},
                                      {'code': 'datetime_of_birth', 'data_type': 'string'},
                                      {'code': 'living_dependency', 'data_type': 'string'},
                                      {'code': 'ambulatory_status', 'data_type': 'string'},
                                      {'code': 'citizenship', 'data_type': 'string'},
                                      {'code': 'primary_language', 'data_type': 'string'},
                                      {'code': 'living_arrangement', 'data_type': 'string'},
                                      {'code': 'publicity_code', 'data_type': 'string'},
                                      {'code': 'protection_indicator',
                                       'data_type': 'string'},
                                      {'code': 'student_indicator', 'data_type': 'string'},
                                      {'code': 'religion', 'data_type': 'string'},
                                      {'code': 'mothers_maiden_name',
                                       'data_type': 'string'},
                                      {'code': 'nationality', 'data_type': 'string'},
                                      {'code': 'ethnic_group', 'data_type': 'string'},
                                      {'code': 'contact_reason', 'data_type': 'string'},
                                      {'code': 'contact_persons_name',
                                       'data_type': 'string'},
                                      {'code': 'contact_persons_phone',
                                       'data_type': 'string'},
                                      {'code': 'contact_persons_address',
                                       'data_type': 'string'},
                                      {'code': 'identifiers', 'data_type': 'string'},
                                      {'code': 'job_status', 'data_type': 'string'},
                                      {'code': 'race', 'data_type': 'string'},
                                      {'code': 'handicap', 'data_type': 'string'},
                                      {'code': 'contact_person_ssnum',
                                       'data_type': 'string'},
                                      {'code': 'birth_place', 'data_type': 'string'},
                                      {'code': 'vip_indicator', 'data_type': 'string'}]},
                'NTE': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'comment_seq_no', 'data_type': 'string'},
                                      {'code': 'comment_type', 'data_type': 'string'},
                                      {'code': 'comment', 'data_type': 'string'}]},
                'OBR': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'placers_ord',
                                       'subfields': [{'code': 'placer_id',
                                                      'data_type': 'string'}]},
                                      {'code': 'fillers_ord',
                                       'subfields': [{'code': 'filler_id',
                                                      'data_type': 'string'}]},
                                      {'code': 'univ_service_ident',
                                       'subfields': [{'code': 'service_code',
                                                      'data_type': 'string'},
                                                     {'code': 'service_label',
                                                      'data_type': 'string'},
                                                     {'code': 'alt_code',
                                                      'data_type': 'string'}]},
                                      {'code': 'priority', 'data_type': 'string'},
                                      {'code': 'req_dttm', 'data_type': 'timestamp'},
                                      {'code': 'obs_dttm', 'data_type': 'timestamp'},
                                      {'code': 'obs_end_dttm', 'data_type': 'timestamp'},
                                      {'code': 'collection_volume', 'data_type': 'string'},
                                      {'code': 'collector_id', 'data_type': 'string'},
                                      {'code': 'specimen_action_cd', 'data_type': 'string'},
                                      {'code': 'danger_cd', 'data_type': 'string'},
                                      {'code': 'relevant_clin_inf', 'data_type': 'string'},
                                      {'code': 'specmn_recv_dttm',
                                       'data_type': 'timestamp'},
                                      {'code': 'specmn_src', 'data_type': 'string'},
                                      {'code': 'ordng_prov', 'data_type': 'string'},
                                      {'code': 'ord_call_bk_phn_no', 'data_type': 'string'},
                                      {'code': 'placer_fld1', 'data_type': 'string'},
                                      {'code': 'placer_fld2', 'data_type': 'string'},
                                      {'code': 'filler_fld1', 'data_type': 'string'},
                                      {'code': 'filler_fld2', 'data_type': 'string'},
                                      {'code': 'results_status_chg_dttm',
                                       'data_type': 'timestamp'},
                                      {'code': 'charge_to_practice', 'data_type': 'string'},
                                      {'code': 'diag_serv_sect_id', 'data_type': 'string'},
                                      {'code': 'result_status', 'data_type': 'string'},
                                      {'code': 'linked_results', 'data_type': 'string'},
                                      {'code': 'quan_timing', 'data_type': 'string'},
                                      {'code': 'results_copies_to', 'data_type': 'string'},
                                      {'code': 'parent_acc_no', 'data_type': 'string'},
                                      {'code': 'transport_mde', 'data_type': 'string'},
                                      {'code': 'reas_for_stdy', 'data_type': 'string'},
                                      {'code': 'princ_result_intpr', 'data_type': 'string'},
                                      {'code': 'asst_result_intpr', 'data_type': 'string'},
                                      {'code': 'techn', 'data_type': 'string'},
                                      {'code': 'transcriptist', 'data_type': 'string'},
                                      {'code': 'sched_dttm', 'data_type': 'timestamp'},
                                      {'code': 'rtif_report_seq', 'data_type': 'string'},
                                      {'code': 'rtif_add_appl', 'data_type': 'string'},
                                      {'code': 'rtif_rev_status', 'data_type': 'string'},
                                      {'code': 'rtif_report_rowseq', 'data_type': 'string'},
                                      {'code': 'rtif_report_attr1', 'data_type': 'string'},
                                      {'code': 'rtif_report_attr2', 'data_type': 'string'},
                                      {'code': 'rtif_report_prov_rowseq',
                                       'data_type': 'string'},
                                      {'code': 'rtif_prov_id', 'data_type': 'string'},
                                      {'code': 'rtif_prov_id_domain',
                                       'data_type': 'string'},
                                      {'code': 'rtif_prov_role_cd', 'data_type': 'string'},
                                      {'code': 'rtif_src_agent', 'data_type': 'string'}]},
                'OBX': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'value_type', 'data_type': 'string'},
                                      {'code': 'obs_id',
                                       'subfields': [{'code': 'code',
                                                      'data_type': 'string'},
                                                     {'code': 'label',
                                                      'data_type': 'string'},
                                                     {'code': 'system_name',
                                                      'data_type': 'string'}]},
                                      {'code': 'obs_sub_id', 'data_type': 'string'},
                                      {'code': 'obs_results', 'data_type': 'string'},
                                      {'code': 'units', 'data_type': 'string'},
                                      {'code': 'reference_range', 'data_type': 'string'},
                                      {'code': 'abnormal_flags', 'data_type': 'string'},
                                      {'code': 'probability', 'data_type': 'string'},
                                      {'code': 'nature_of_abnormal_test',
                                       'data_type': 'string'},
                                      {'code': 'obs_result_status', 'data_type': 'string'},
                                      {'code': 'last_obs_normal_va_date',
                                       'data_type': 'timestamp'},
                                      {'code': 'usr_def_access_chk', 'data_type': 'string'},
                                      {'code': 'obs_dttm', 'data_type': 'timestamp'},
                                      {'code': 'producer_id', 'data_type': 'string'}]},
                'ORC': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'order_control', 'data_type': 'string'},
                                      {'code': 'placer_order_no', 'data_type': 'string'},
                                      {'code': 'filler_order_no', 'data_type': 'string'},
                                      {'code': 'placer_group_no', 'data_type': 'string'},
                                      {'code': 'order_status', 'data_type': 'string'},
                                      {'code': 'response_flag', 'data_type': 'string'},
                                      {'code': 'timing_qty', 'data_type': 'string'},
                                      {'code': 'parent', 'data_type': 'string'},
                                      {'code': 'trans_date_time', 'data_type': 'timestamp'},
                                      {'code': 'entered_by', 'data_type': 'string'},
                                      {'code': 'verified_by', 'data_type': 'string'},
                                      {'code': 'ordering_provider', 'data_type': 'string'},
                                      {'code': 'enterers_location', 'data_type': 'string'},
                                      {'code': 'call_back_phone', 'data_type': 'string'},
                                      {'code': 'order_effective_dttm',
                                       'data_type': 'timestamp'},
                                      {'code': 'order_control_code_reason',
                                       'data_type': 'string'},
                                      {'code': 'entering_organization',
                                       'data_type': 'string'},
                                      {'code': 'entering_device', 'data_type': 'string'},
                                      {'code': 'action_by', 'data_type': 'string'}]},
                'PD1': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'living_dependency', 'data_type': 'string'},
                                      {'code': 'living_arrangement', 'data_type': 'string'},
                                      {'code': 'patient_primary_facility',
                                       'data_type': 'string'},
                                      {'code': 'patient_primary_care_provider',
                                       'data_type': 'string'},
                                      {'code': 'student_indicator', 'data_type': 'string'},
                                      {'code': 'handicap', 'data_type': 'string'},
                                      {'code': 'living_will_code', 'data_type': 'string'},
                                      {'code': 'organ_donor_code', 'data_type': 'string'},
                                      {'code': 'separate_bill', 'data_type': 'string'},
                                      {'code': 'duplicate_patient', 'data_type': 'string'},
                                      {'code': 'publicity_code', 'data_type': 'string'},
                                      {'code': 'protection_indicator',
                                       'data_type': 'string'},
                                      {'code': 'protection_indicator_date',
                                       'data_type': 'timestamp'},
                                      {'code': 'place_of_worship', 'data_type': 'string'},
                                      {'code': 'advance_directive_code',
                                       'data_type': 'string'},
                                      {'code': 'immun_reg_status', 'data_type': 'string'},
                                      {'code': 'immun_reg_status_effective_dat',
                                       'data_type': 'timestamp'},
                                      {'code': 'publicity_code_effective_date',
                                       'data_type': 'timestamp'},
                                      {'code': 'military_branch', 'data_type': 'string'},
                                      {'code': 'military_rank', 'data_type': 'string'},
                                      {'code': 'militart_status', 'data_type': 'string'}]},
                'PID': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'pat_id_ext', 'data_type': 'string'},
                                      {'code': 'pat_id_int', 'data_type': 'string'},
                                      {'code': 'pat_id_alt', 'data_type': 'string'},
                                      {'code': 'pat_name',
                                       'subfields': [{'code': 'family_name',
                                                      'data_type': 'string'},
                                                     {'code': 'given_name',
                                                      'data_type': 'string'},
                                                     {'code': 'middle_name',
                                                      'data_type': 'string'}]},
                                      {'code': 'mother_name', 'data_type': 'string'},
                                      {'code': 'date_of_birth', 'data_type': 'date'},
                                      {'code': 'sex', 'data_type': 'string'},
                                      {'code': 'pat_alias', 'data_type': 'composite'},
                                      {'code': 'ethnic_group', 'data_type': 'string'},
                                      {'code': 'pat_address',
                                       'subfields': [{'code': 'street',
                                                      'data_type': 'string'},
                                                     {'code': 'street2',
                                                      'data_type': 'string'},
                                                     {'code': 'city', 'data_type': 'string'},
                                                     {'code': 'state', 'data_type': 'string'},
                                                     {'code': 'zip', 'data_type': 'string'},
                                                     {'code': 'country',
                                                      'data_type': 'string'},
                                                     {'code': 'addr_type',
                                                      'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'}]},
                                      {'code': 'county_cd', 'data_type': 'string'},
                                      {'code': 'phone_no_home',
                                       'subfields': [{'code': 'number',
                                                      'data_type': 'string'},
                                                     {'code': 'type', 'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'},
                                                     {'code': 'other3',
                                                      'data_type': 'string'}]},
                                      {'code': 'phone_no_bus',
                                       'subfields': [{'code': 'number',
                                                      'data_type': 'string'},
                                                     {'code': 'type', 'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'},
                                                     {'code': 'other3',
                                                      'data_type': 'string'}]},
                                      {'code': 'pat_lang', 'data_type': 'string'},
                                      {'code': 'marital_status', 'data_type': 'string'},
                                      {'code': 'religion', 'data_type': 'string'},
                                      {'code': 'pat_acct_no', 'data_type': 'string'},
                                      {'code': 'pat_ss_no', 'data_type': 'string'},
                                      {'code': 'pat_driver_lic', 'data_type': 'string'},
                                      {'code': 'mothers_id', 'data_type': 'string'},
                                      {'code': 'ethnic_group_f22', 'data_type': 'string'},
                                      {'code': 'birth_place', 'data_type': 'string'},
                                      {'code': 'multiple_birth_ind', 'data_type': 'string'},
                                      {'code': 'birth_order', 'data_type': 'string'},
                                      {'code': 'citizenship', 'data_type': 'string'},
                                      {'code': 'veterans_military_status',
                                       'data_type': 'string'},
                                      {'code': 'nationality', 'data_type': 'string'},
                                      {'code': 'patient_death_date_time',
                                       'data_type': 'timestamp'},
                                      {'code': 'patient_death_ind', 'data_type': 'string'}]},
                'PRA': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'primary_key_value',
                                       'subfields': [{'code': 'namespace_id',
                                                      'data_type': 's'},
                                                     {'code': 'uid', 'data_type': 'string'},
                                                     {'code': 'uid_type',
                                                      'data_type': 'string'}]},
                                      {'code': 'practicioner_group', 'data_type': 'string'},
                                      {'code': 'practicioner_cat', 'data_type': 'string'},
                                      {'code': 'provider_billing', 'data_type': 'string'},
                                      {'code': 'specialty', 'data_type': 'string'},
                                      {'code': 'practicioner_id_nums',
                                       'subfields': [{'code': 'namespace_id',
                                                      'data_type': 's'},
                                                     {'code': 'uid', 'data_type': 'string'},
                                                     {'code': 'uid_type',
                                                      'data_type': 'string'}]},
                                      {'code': 'privileges', 'data_type': 'string'},
                                      {'code': 'date_entered_practice',
                                       'data_type': 'string'}]},
                'PV1': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'pat_class', 'data_type': 'string'},
                                      {'code': 'pat_loc',
                                       'subfields': [{'code': 'point_of_care',
                                                      'data_type': 'string'},
                                                     {'code': 'room', 'data_type': 'string'},
                                                     {'code': 'bed', 'data_type': 'string'},
                                                     {'code': 'facility',
                                                      'data_type': 'string'},
                                                     {'code': 'location_status',
                                                      'data_type': 'string'},
                                                     {'code': 'person_loc_type',
                                                      'data_type': 'string'},
                                                     {'code': 'building',
                                                      'data_type': 'string'},
                                                     {'code': 'floor', 'data_type': 'string'},
                                                     {'code': 'loc_desc',
                                                      'data_type': 'string'}]},
                                      {'code': 'admit_type', 'data_type': 'string'},
                                      {'code': 'pre_admit_no', 'data_type': 'string'},
                                      {'code': 'prior_pat_loc', 'data_type': 'string'},
                                      {'code': 'attend_doc',
                                       'subfields': [{'code': 'id', 'data_type': 'str'},
                                                     {'code': 'lname', 'data_type': 'string'},
                                                     {'code': 'fname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'suffix',
                                                      'data_type': 'string'},
                                                     {'code': 'prefix',
                                                      'data_type': 'string'},
                                                     {'code': 'degree',
                                                      'data_type': 'string'},
                                                     {'code': 'source_table',
                                                      'data_type': 'string'},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'name_type_cd',
                                                      'data_type': 'string'}]},
                                      {'code': 'refer_doc',
                                       'subfields': [{'code': 'id', 'data_type': 'str'},
                                                     {'code': 'lname', 'data_type': 'string'},
                                                     {'code': 'fname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'suffix',
                                                      'data_type': 'string'},
                                                     {'code': 'prefix',
                                                      'data_type': 'string'},
                                                     {'code': 'degree',
                                                      'data_type': 'string'},
                                                     {'code': 'source_table',
                                                      'data_type': 'string'},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'name_type_cd',
                                                      'data_type': 'string'}]},
                                      {'code': 'consult_doc', 'data_type': 'string'},
                                      {'code': 'hosp_svc', 'data_type': 'string'},
                                      {'code': 'temp_loc', 'data_type': 'string'},
                                      {'code': 'pre_admit_test_ind', 'data_type': 'string'},
                                      {'code': 're_admit_ind', 'data_type': 'string'},
                                      {'code': 'admit_source', 'data_type': 'string'},
                                      {'code': 'ambulatory_stat', 'data_type': 'string'},
                                      {'code': 'vip_ind', 'data_type': 'string'},
                                      {'code': 'admit_doc', 'data_type': 'string'},
                                      {'code': 'pat_type', 'data_type': 'string'},
                                      {'code': 'visit_no', 'data_type': 'string'},
                                      {'code': 'fin_class', 'data_type': 'string'},
                                      {'code': 'chg_price_ind', 'data_type': 'string'},
                                      {'code': 'courtesy_cd', 'data_type': 'string'},
                                      {'code': 'credit_rating', 'data_type': 'string'},
                                      {'code': 'contract_cd', 'data_type': 'string'},
                                      {'code': 'contract_eff_dt', 'data_type': 'date'},
                                      {'code': 'contract_amt', 'data_type': 'string'},
                                      {'code': 'contract_period', 'data_type': 'string'},
                                      {'code': 'interest_cd', 'data_type': 'string'},
                                      {'code': 'tfr_bad_debt', 'data_type': 'string'},
                                      {'code': 'tfr_bad_debt_dt', 'data_type': 'date'},
                                      {'code': 'bad_debt_agency_cd', 'data_type': 'string'},
                                      {'code': 'bad_debt_tfr_amt', 'data_type': 'string'},
                                      {'code': 'bad_debt_rec_amt', 'data_type': 'string'},
                                      {'code': 'delete_acct_ind', 'data_type': 'string'},
                                      {'code': 'delete_acct_dt', 'data_type': 'date'},
                                      {'code': 'disch_disp', 'data_type': 'string'},
                                      {'code': 'disch_to_loc', 'data_type': 'string'},
                                      {'code': 'diet_type', 'data_type': 'string'},
                                      {'code': 'svc_facility', 'data_type': 'string'},
                                      {'code': 'bed_status', 'data_type': 'string'},
                                      {'code': 'acct_status', 'data_type': 'string'},
                                      {'code': 'pend_loc', 'data_type': 'string'},
                                      {'code': 'prior_temp_loc', 'data_type': 'string'},
                                      {'code': 'admit_dt_tm', 'data_type': 'timestamp'},
                                      {'code': 'disch_dt_tm', 'data_type': 'timestamp'},
                                      {'code': 'pat_bal', 'data_type': 'string'},
                                      {'code': 'tot_chgs', 'data_type': 'string'},
                                      {'code': 'tot_adj', 'data_type': 'string'},
                                      {'code': 'tot_paymts', 'data_type': 'string'},
                                      {'code': 'alternate_visit_id', 'data_type': 'string'},
                                      {'code': 'visit_indicator', 'data_type': 'string'},
                                      {'code': 'other_healthcare_prov',
                                       'data_type': 'string'}]},
                'STF': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'primary_key_value',
                                       'subfields': [{'code': 'namespace_id',
                                                      'data_type': 's'},
                                                     {'code': 'uid', 'data_type': 'string'},
                                                     {'code': 'uid_type',
                                                      'data_type': 'string'}]},
                                      {'code': 'staff_id_code',
                                       'subfields': [{'code': 'service_code',
                                                      'data_type': 'string'},
                                                     {'code': 'service_label',
                                                      'data_type': 'string'},
                                                     {'code': 'alt_code',
                                                      'data_type': 'string'}]},
                                      {'code': 'staff_name',
                                       'subfields': [{'code': 'lname', 'data_type': 'string'},
                                                     {'code': 'fname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'mname', 'data_type': 'string'},
                                                     {'code': 'suffix',
                                                      'data_type': 'string'},
                                                     {'code': 'prefix',
                                                      'data_type': 'string'},
                                                     {'code': 'degree',
                                                      'data_type': 'string'},
                                                     {'code': 'source_table',
                                                      'data_type': 'string'},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'assigning_auth',
                                                      'data_type': 'cmp',
                                                      'subfields': [{'code': 'namespace_id',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid',
                                                                     'data_type': 'string'},
                                                                    {'code': 'uid_type',
                                                                     'data_type': 'string'}]},
                                                     {'code': 'name_type_cd',
                                                      'data_type': 'string'}]},
                                      {'code': 'staff_type', 'data_type': 'string'},
                                      {'code': 'sex_id', 'data_type': 'string'},
                                      {'code': 'date_of_birth', 'data_type': 'timestamp'},
                                      {'code': 'active_inactive', 'data_type': 'string'},
                                      {'code': 'department', 'data_type': 'string'},
                                      {'code': 'service', 'data_type': 'string'},
                                      {'code': 'phone',
                                       'subfields': [{'code': 'number',
                                                      'data_type': 'string'},
                                                     {'code': 'type', 'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'},
                                                     {'code': 'other3',
                                                      'data_type': 'string'}]},
                                      {'code': 'address',
                                       'subfields': [{'code': 'street',
                                                      'data_type': 'string'},
                                                     {'code': 'street2',
                                                      'data_type': 'string'},
                                                     {'code': 'city', 'data_type': 'string'},
                                                     {'code': 'state', 'data_type': 'string'},
                                                     {'code': 'zip', 'data_type': 'string'},
                                                     {'code': 'country',
                                                      'data_type': 'string'},
                                                     {'code': 'addr_type',
                                                      'data_type': 'string'},
                                                     {'code': 'other', 'data_type': 'string'},
                                                     {'code': 'other2',
                                                      'data_type': 'string'}]},
                                      {'code': 'activation_date', 'data_type': 'date'},
                                      {'code': 'inactivation_date', 'data_type': 'date'},
                                      {'code': 'backup_person id', 'data_type': 'string'},
                                      {'code': 'email_address', 'data_type': 'string'},
                                      {'code': 'preferred_phone', 'data_type': 'string'},
                                      {'code': 'marital status', 'data_type': 'string'},
                                      {'code': 'job_title', 'data_type': 'string'},
                                      {'code': 'job_code_class', 'data_type': 'string'},
                                      {'code': 'employment_status', 'data_type': 'string'},
                                      {'code': 'additional_insured_on_auto',
                                       'data_type': 'string'},
                                      {'code': 'drivers_license_number',
                                       'data_type': 'string'},
                                      {'code': 'copy_auto_ins', 'data_type': 'string'},
                                      {'code': 'auto_ins_expires', 'data_type': 'string'},
                                      {'code': 'date_last_dmv_review',
                                       'data_type': 'string'},
                                      {'code': 'date_next_dmv_review',
                                       'data_type': 'string'}]},
                'ZBI': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'patient_bal', 'data_type': 'string'},
                                      {'code': 'unknown', 'data_type': 'string'},
                                      {'code': 'insurance_bal', 'data_type': 'string'},
                                      {'code': 'payment_date', 'data_type': 'date'}]},
                'ZPS': {'subfields': [{'code': 'code', 'data_type': 'string'},
                                      {'code': 'set_id', 'data_type': 'string'},
                                      {'code': 'lab_code', 'data_type': 'string'},
                                      {'code': 'lab_name', 'data_type': 'string'},
                                      {'code': 'lab_addr',
                                       'subfields': [{'code': 'street1',
                                                      'data_type': 'string'},
                                                     {'code': 'street2',
                                                      'data_type': 'string'},
                                                     {'code': 'city', 'data_type': 'string'},
                                                     {'code': 'state', 'data_type': 'string'},
                                                     {'code': 'zip_full',
                                                      'data_type': 'string'}]},
                                      {'code': 'num', 'data_type': 'string'},
                                      {'code': 'md_admin',
                                       'subfields': [{'code': 'credentials',
                                                      'data_type': 'string'},
                                                     {'code': 'lname', 'data_type': 'string'},
                                                     {'code': 'fname', 'data_type': 'string'},
                                                     {'code': 'suffix',
                                                      'data_type': 'string'},
                                                     {'code': 'other_1',
                                                      'data_type': 'string'},
                                                     {'code': 'other_2',
                                                      'data_type': 'string'},
                                                     {'code': 'other_3',
                                                      'data_type': 'string'},
                                                     {'code': 'suffix',
                                                      'data_type': 'string'}]}]}}
