
from twisted.web import server
from twisted.web.resource import Resource
from twisted.internet import endpoints
import exocet

from harpoon import visualfactory

class Visualiser(Resource):

    def __init__(self, moduleRef, protocolName):
        self.moduleRef = moduleRef
        self.protocolName = protocolName

        self.module = None
        self.factory = visualfactory.VisualFactory()

        self.ports = []

        try:
            self.load()
        except Exception, e:
            self.error = e

    def listen(self, endpoint_description, reactor=None):
        """
        Cause the factory to listen on this port each time.
        """
        if not reactor:
            from twisted.internet import reactor
        ep = endpoints.serverFromString(reactor, endpoint_description)
        ep.listen(self.factory).addCallback(self.ports.append)

    def load(self):
        module = exocet.loadNamed(self.moduleRef, exocet.pep302Mapper)
        protocol = getattr(module, self.protocolName)

        self.module = module
        self.factory.protocol = protocol

    isLeaf = True

    def render(self, request):
        should_reload = request.args.get('reload', '')
        if should_reload:
            self.load()

            request.redirect('/')
            return ''

        endpoint_description = request.args.get('endpoint', ())
        if endpoint_description:
            self.listen(endpoint_description[0])

            request.redirect('/')
            return ''

        return '''<html><body>

        <form method="post">
        <div>
        <input type="submit" name="reload" value="Reload" />
        </div>
        </form>

        <form method="post">
        <div>
        Listen on: <input type="text" name="endpoint" value="" />
        <input type="submit" value="Listen" />
        </div>
        </form>

        <div>
        %s
        </div>

        <ul> %s
        </ul>

        </body></html>''' % (self.factory, 
                ''.join('<li>%s</li>' % p.getHost() for p in self.ports))
    
if __name__ == '__main__':
    from twisted.internet import reactor
    from twisted.python import log
    import sys
    log.startLogging(sys.stdout)
    reactor.listenTCP(8080, server.Site(Visualiser("twisted.protocols.wire", 'Echo')))
    reactor.run()
    
