#encoding:utf-8
from helmholtz.core.populate import PopulateCommand
from helmholtz.people.models import SkillType

skill_types = [
    {'name':'science'},
     #{'name':'psychology','parent':{'name':'science'}},
     #life sciences
     {'name':'life sciences', 'parent':{'name':'science'}},
      {'name':'biology', 'parent':{'name':'life sciences'}},
       #neuroscience
       {'name':'neuroscience', 'parent':{'name':'biology'}},
        {'name':'behavorial neuroscience', 'parent':{'name':'neuroscience'}},
        {'name':'systems neuroscience', 'parent':{'name':'neuroscience'}},
        {'name':'cognitive neurosciences', 'parent':{'name':'neuroscience'}},
        {'name':'development neuroscience', 'parent':{'name':'neuroscience'}},
        {'name':'molecular neuroscience', 'parent':{'name':'neuroscience'}},
        {'name':'cellular neuroscience', 'parent':{'name':'neuroscience'}},
        {'name':'computational neurosciences', 'parent':{'name':'neuroscience'}},
        {'name':'neurology', 'parent':{'name':'neuroscience'}},
        {'name':'psychiatry', 'parent':{'name':'neuroscience'}},
        {'name':'neurology', 'parent':{'name':'medicine'}},
       {'name':'bioinformatics', 'parent':{'name':'biology'}},
       {'name':'biophysics', 'parent':{'name':'biology'}},
       {'name':'biomathematics', 'parent':{'name':'biology'}},
       {'name':'biostatistics', 'parent':{'name':'biology'}},
       {'name':'endocrinology', 'parent':{'name':'biology'}},
       #{'name':'human biology','parent':{'name':'biology'}},
       {'name':'anatomy', 'parent':{'name':'biology'}},
       {'name':'cell biology', 'parent':{'name':'biology'}},
       {'name':'developmental biology', 'parent':{'name':'biology'}},
       {'name':'genetics', 'parent':{'name':'biology'}},
       {'name':'marine biology', 'parent':{'name':'biology'}},
       {'name':'microbiology', 'parent':{'name':'biology'}},
       {'name':'molecular biology', 'parent':{'name':'biology'}},
       {'name':'physiology', 'parent':{'name':'biology'}},
       {'name':'ethology', 'parent':{'name':'biology'}},
       {'name':'population genetics', 'parent':{'name':'biology'}},
       {'name':'population biology', 'parent':{'name':'biology'}},
       {'name':'histology', 'parent':{'name':'biology'}},
       #{'name':'phylogeography biology','parent':{'name':'biology'}},
       #{'name':'pathology','parent':{'name':'biology'}},
       #{'name':'taxonomy','parent':{'name':'biology'}},
       #{'name':'toxicology','parent':{'name':'biology'}},
     #health science
     {'name':'health science', 'parent':{'name':'science'}},
      {'name':'medicine', 'parent':{'name':'health science'}},
       {'name':'anestesiology', 'parent':{'name':'medicine'}},
       {'name':'pharmacy', 'parent':{'name':'medicine'}},
       {'name':'pharmaceutical sciences', 'parent':{'name':'medicine'}},
        {'name':'pharmaceutics', 'parent':{'name':'pharmaceutical sciences'}},
        {'name':'pharmaceutical chemistry', 'parent':{'name':'pharmaceutical sciences'}},
        {'name':'pharmacology', 'parent':{'name':'pharmaceutical sciences'}},
       {'name':'surgery', 'parent':{'name':'medicine'}},
        {'name':'neurosurgery', 'parent':{'name':'surgery'}},
        {'name':'veterinary surgery', 'parent':{'name':'surgery'}},
       {'name':'veterinary medicine', 'parent':{'name':'medicine'}},
       {'name':'medical physics', 'parent':{'name':'medicine'}},
     #chemistry
     {'name':'chemistry', 'parent':{'name':'science'}},
      {'name':'analytical chemistry', 'parent':{'name':'chemistry'}},
      {'name':'computational chemistry', 'parent':{'name':'chemistry'}},
      {'name':'quantum chemistry', 'parent':{'name':'chemistry'}},
      {'name':'organic chemistry', 'parent':{'name':'chemistry'}},
      {'name':'inorganic chemistry', 'parent':{'name':'chemistry'}},
      {'name':'biochemistry', 'parent':{'name':'chemistry'}},
      {'name':'materials chemistry', 'parent':{'name':'chemistry'}},
      {'name':'physical chemistry', 'parent':{'name':'chemistry'}},
      {'name':'thermochemistry', 'parent':{'name':'physical chemistry'}},
      {'name':'chemical kinetics', 'parent':{'name':'physical chemistry'}},
      {'name':'electrochemistry', 'parent':{'name':'physical chemistry'}},
      {'name':'radiochemistry', 'parent':{'name':'physical chemistry'}},
      {'name':'sonochemistry', 'parent':{'name':'physical chemistry'}},
      {'name':'spectroscopy', 'parent':{'name':'physical chemistry'}},
      {'name':'theoretical chemistry', 'parent':{'name':'chemistry'}},
     #physics
     {'name':'physics', 'parent':{'name':'science'}},
      {'name':'newtonian dynamics', 'parent':{'name':'physics'}},
      {'name':'acoustics', 'parent':{'name':'physics'}},
      {'name':'electromagnetism', 'parent':{'name':'physics'}},
      {'name':'quantum mechanics', 'parent':{'name':'physics'}},
      {'name':'optics', 'parent':{'name':'physics'}},
      {'name':'wave optics', 'parent':{'name':'physics'}},
      {'name':'optical physics', 'parent':{'name':'physics'}},
      {'name':'solid physics', 'parent':{'name':'physics'}},
      {'name':'materials science', 'parent':{'name':'physics'}},
      {'name':'computational physics', 'parent':{'name':'physics'}},
      {'name':'mathematical physics', 'parent':{'name':'physics'}},
      {'name':'statistical physics', 'parent':{'name':'physics'}},
      {'name':'thermodynamics', 'parent':{'name':'statistical physics'}},
      #{'name':'astrophysics','parent':{'name':'physics'}},  
      #{'name':'atomic physics','parent':{'name':'physics'}},
      #{'name':'molecular physics','parent':{'name':'physics'}},
      #{'name':'nuclear physics','parent':{'name':'physics'}},
      #{'name':'particle physics','parent':{'name':'physics'}},
      #{'name':'plasma physics','parent':{'name':'physics'}},
      #{'name':'condense matter physics','parent':{'name':'physics'}},
     #statistics
     {'name':'statistics', 'parent':{'name':'science'}},
     #mathematics
     {'name':'mathematics', 'parent':{'name':'science'}},
     #systems science
     {'name':'systems science', 'parent':{'name':'science'}},
     #computer science
     {'name':'computer science', 'parent':{'name':'science'}},
      #divers
      {'name':'algorithms', 'parent':{'name':'computer science'}},
      {'name':'scientific computing', 'parent':{'name':'computer science'}},
      {'name':'numeric analysis', 'parent':{'name':'computer science'}},
      {'name':'systems simulations', 'parent':{'name':'computer science'}},
      {'name':'signal processing', 'parent':{'name':'computer science'}},
      {'name':'data mining', 'parent':{'name':'computer science'}},
      #artificial intelligence
      {'name':'artificial intelligence', 'parent':{'name':'computer science'}},
       {'name':'cognitive science', 'parent':{'name':'artificial intelligence'}},
        {'name':'automated reasoning', 'parent':{'name':'cognitive science'}},
        {'name':'machine learning', 'parent':{'name':'cognitive science'}},
         {'name':'artificial neural network', 'parent':{'name':'machine learning'}},
         {'name':'support vector machine', 'parent':{'name':'machine learning'}},
        {'name':'natural language processing', 'parent':{'name':'cognitive science'}},
        {'name':'computer vision', 'parent':{'name':'cognitive science'}},
      #computer graphics 
      {'name':'computer graphics', 'parent':{'name':'computer science'}},
       {'name':'image processing', 'parent':{'name':'computer graphics'}},
       {'name':'scientific visualization', 'parent':{'name':'computer graphics'}},
       {'name':'computational geometry', 'parent':{'name':'computer graphics'}},
     #information technology
     {'name':'information technology'},
      #communications
      {'name':'communications', 'parent':{'name':'information technology'}},
      #computer engineering
      {'name':'computer engineering', 'parent':{'name':'information technology'}},
       {'name':'instrumentation', 'parent':{'name':'computer engineering'}},
       {'name':'automation', 'parent':{'name':'computer engineering'}},
       {'name':'integrated circuit design', 'parent':{'name':'computer engineering'}},
       {'name':'robotics', 'parent':{'name':'computer engineering'}},
       {'name':'signal and systems', 'parent':{'name':'computer engineering'}},
       {'name':'database systems', 'parent':{'name':'computer engineering'}},
       {'name':'digital signal processing', 'parent':{'name':'computer engineering'}},
       {'name':'electronics', 'parent':{'name':'computer engineering'}},
       {'name':'programming fundamentals', 'parent':{'name':'computer engineering'}},
       {'name':'software engineering', 'parent':{'name':'computer engineering'}},
       {'name':'computer networking', 'parent':{'name':'computer engineering'}},
       {'name':'parallel and distributed computing', 'parent':{'name':'computer engineering'}},
       {'name':'control engineering', 'parent':{'name':'computer engineering'}},
       {'name':'human-computer interface', 'parent':{'name':'computer engineering'}},
]

class Command(PopulateCommand):
    help = "populate skill types"
    priority = 1
    data = [ 
        {'class':SkillType, 'objects':skill_types} 
    ]
