#encoding:utf-8
from helmholtz.core.populate import PopulateCommand
from helmholtz.storage.models import MimeType

mime_types = [
    {'extension':'ai ', 'name':'application/postscript '},
    {'extension':'aif', 'name':'audio/x-aiff '},
    {'extension':'aifc', 'name':'audio/x-aiff '},
    {'extension':'aiff', 'name':'audio/x-aiff '},
    {'extension':'asc', 'name':'text/plain '},
    {'extension':'atom', 'name':'application/atom+xml '},
    {'extension':'au', 'name':'audio/basic '},
    {'extension':'avi', 'name':'video/x-msvideo '},
    {'extension':'bcpio', 'name':'application/x-bcpio '},
    {'extension':'bin', 'name':'application/octet-stream '},
    {'extension':'bmp', 'name':'image/bmp '},
    {'extension':'cdf', 'name':'application/x-netcdf '},
    {'extension':'cgm', 'name':'image/cgm '},
    {'extension':'class', 'name':'application/octet-stream '},
    {'extension':'cpio', 'name':'application/x-cpio '},
    {'extension':'cpt', 'name':'application/mac-compactpro '},
    {'extension':'csh', 'name':'application/x-csh '},
    {'extension':'css', 'name':'text/css '},
    {'extension':'csv', 'name':'text/csv '},
    {'extension':'dcr', 'name':'application/x-director '},
    {'extension':'dif', 'name':'video/x-dv '},
    {'extension':'dir', 'name':'application/x-director '},
    {'extension':'djv', 'name':'image/vnd.djvu '},
    {'extension':'djvu', 'name':'image/vnd.djvu '},
    {'extension':'dll', 'name':'application/octet-stream '},
    {'extension':'dmg', 'name':'application/octet-stream '},
    {'extension':'dms', 'name':'application/octet-stream '},
    {'extension':'doc', 'name':'application/msword '},
    {'extension':'dtd', 'name':'application/xml-dtd '},
    {'extension':'dv', 'name':'video/x-dv '},
    {'extension':'dvi', 'name':'application/x-dvi '},
    {'extension':'dxr', 'name':'application/x-director '},
    {'extension':'eps', 'name':'application/postscript '},
    {'extension':'etx', 'name':'text/x-setext '},
    {'extension':'exe', 'name':'application/octet-stream '},
    {'extension':'ez', 'name':'application/andrew-inset '},
    {'extension':'gif', 'name':'image/gif '},
    {'extension':'gram', 'name':'application/srgs '},
    {'extension':'grxml', 'name':'application/srgs+xml '},
    {'extension':'gtar', 'name':'application/x-gtar '},
    {'extension':'h5', 'name':'application/x-hdf '},
    {'extension':'hdf', 'name':'application/x-hdf '},
    {'extension':'hqx', 'name':'application/mac-binhex40 '},
    {'extension':'htm', 'name':'text/html '},
    {'extension':'html', 'name':'text/html '},
    {'extension':'ice', 'name':'x-conference/x-cooltalk '},
    {'extension':'ico', 'name':'image/x-icon '},
    {'extension':'ics', 'name':'text/calendar '},
    {'extension':'ief', 'name':'image/ief '},
    {'extension':'ifb', 'name':'text/calendar '},
    {'extension':'iges', 'name':'model/iges '},
    {'extension':'igs', 'name':'model/iges '},
    {'extension':'jnlp', 'name':'application/x-java-jnlp-file '},
    {'extension':'jp2', 'name':'image/jp2 '},
    {'extension':'jpe', 'name':'image/jpeg '},
    {'extension':'jpeg', 'name':'image/jpeg '},
    {'extension':'jpg', 'name':'image/jpeg '},
    {'extension':'js', 'name':'application/x-javascript '},
    {'extension':'kar', 'name':'audio/midi '},
    {'extension':'latex', 'name':'application/x-latex '},
    {'extension':'lha', 'name':'application/octet-stream '},
    {'extension':'lzh', 'name':'application/octet-stream '},
    {'extension':'m3u', 'name':'audio/x-mpegurl '},
    {'extension':'m4a', 'name':'audio/mp4a-latm '},
    {'extension':'m4b', 'name':'audio/mp4a-latm '},
    {'extension':'m4p', 'name':'audio/mp4a-latm '},
    {'extension':'m4u', 'name':'video/vnd.mpegurl '},
    {'extension':'m4v', 'name':'video/x-m4v '},
    {'extension':'mac', 'name':'image/x-macpaint '},
    {'extension':'man', 'name':'application/x-troff-man '},
    {'extension':'mathml', 'name':'application/mathml+xml '},
    {'extension':'me', 'name':'application/x-troff-me '},
    {'extension':'mesh', 'name':'model/mesh '},
    {'extension':'mid', 'name':'audio/midi '},
    {'extension':'midi', 'name':'audio/midi '},
    {'extension':'mif', 'name':'application/vnd.mif '},
    {'extension':'mov', 'name':'video/quicktime '},
    {'extension':'movie', 'name':'video/x-sgi-movie '},
    {'extension':'mp2', 'name':'audio/mpeg '},
    {'extension':'mp3', 'name':'audio/mpeg '},
    {'extension':'mp4', 'name':'video/mp4 '},
    {'extension':'mpe', 'name':'video/mpeg '},
    {'extension':'mpeg', 'name':'video/mpeg '},
    {'extension':'mpg', 'name':'video/mpeg '},
    {'extension':'mpga', 'name':'audio/mpeg '},
    {'extension':'ms', 'name':'application/x-troff-ms '},
    {'extension':'msh', 'name':'model/mesh '},
    {'extension':'mxu', 'name':'video/vnd.mpegurl '},
    {'extension':'nc', 'name':'application/x-netcdf '},
    {'extension':'oda', 'name':'application/oda '},
    {'extension':'ogg', 'name':'application/ogg '},
    {'extension':'pbm', 'name':'image/x-portable-bitmap '},
    {'extension':'pct', 'name':'image/pict '},
    {'extension':'pdb', 'name':'chemical/x-pdb '},
    {'extension':'pdf', 'name':'application/pdf '},
    {'extension':'pgm', 'name':'image/x-portable-graymap '},
    {'extension':'pgn', 'name':'application/x-chess-pgn '},
    {'extension':'pic', 'name':'image/pict '},
    {'extension':'pict', 'name':'image/pict '},
    {'extension':'png', 'name':'image/png '},
    {'extension':'pnm', 'name':'image/x-portable-anymap '},
    {'extension':'pnt', 'name':'image/x-macpaint '},
    {'extension':'pntg', 'name':'image/x-macpaint '},
    {'extension':'ppm', 'name':'image/x-portable-pixmap '},
    {'extension':'ppt', 'name':'application/vnd.ms-powerpoint '},
    {'extension':'ps', 'name':'application/postscript '},
    {'extension':'qt', 'name':'video/quicktime '},
    {'extension':'qti', 'name':'image/x-quicktime '},
    {'extension':'qtif', 'name':'image/x-quicktime '},
    {'extension':'ra', 'name':'audio/x-pn-realaudio '},
    {'extension':'ram', 'name':'audio/x-pn-realaudio '},
    {'extension':'ras', 'name':'image/x-cmu-raster '},
    {'extension':'rdf', 'name':'application/rdf+xml '},
    {'extension':'rgb', 'name':'image/x-rgb '},
    {'extension':'rm', 'name':'application/vnd.rn-realmedia '},
    {'extension':'roff', 'name':'application/x-troff '},
    {'extension':'rtf', 'name':'text/rtf '},
    {'extension':'rtx', 'name':'text/richtext '},
    {'extension':'sgm', 'name':'text/sgml '},
    {'extension':'sgml', 'name':'text/sgml '},
    {'extension':'sh', 'name':'application/x-sh '},
    {'extension':'shar', 'name':'application/x-shar '},
    {'extension':'silo', 'name':'model/mesh '},
    {'extension':'sit', 'name':'application/x-stuffit '},
    {'extension':'skd', 'name':'application/x-koan '},
    {'extension':'skm', 'name':'application/x-koan '},
    {'extension':'skp', 'name':'application/x-koan '},
    {'extension':'skt', 'name':'application/x-koan '},
    {'extension':'smi', 'name':'application/smil '},
    {'extension':'smil', 'name':'application/smil '},
    {'extension':'snd', 'name':'audio/basic '},
    {'extension':'so', 'name':'application/octet-stream '},
    {'extension':'spl', 'name':'application/x-futuresplash '},
    {'extension':'src', 'name':'application/x-wais-source '},
    {'extension':'sv4cpio', 'name':'application/x-sv4cpio '},
    {'extension':'sv4crc', 'name':'application/x-sv4crc '},
    {'extension':'svg', 'name':'image/svg+xml '},
    {'extension':'swf', 'name':'application/x-shockwave-flash '},
    {'extension':'t', 'name':'application/x-troff '},
    {'extension':'tar', 'name':'application/x-tar '},
    {'extension':'tcl', 'name':'application/x-tcl '},
    {'extension':'tex', 'name':'application/x-tex '},
    {'extension':'texi', 'name':'application/x-texinfo '},
    {'extension':'texinfo', 'name':'application/x-texinfo '},
    {'extension':'tif', 'name':'image/tiff '},
    {'extension':'tiff', 'name':'image/tiff '},
    {'extension':'tr', 'name':'application/x-troff '},
    {'extension':'tsv', 'name':'text/tab-separated-values '},
    {'extension':'txt', 'name':'text/plain '},
    {'extension':'ustar', 'name':'application/x-ustar '},
    {'extension':'vcd', 'name':'application/x-cdlink '},
    {'extension':'vrml', 'name':'model/vrml '},
    {'extension':'vxml', 'name':'application/voicexml+xml '},
    {'extension':'wav', 'name':'audio/x-wav '},
    {'extension':'wbmp', 'name':'image/vnd.wap.wbmp '},
    {'extension':'wbmxl', 'name':'application/vnd.wap.wbxml '},
    {'extension':'wml', 'name':'text/vnd.wap.wml '},
    {'extension':'wmlc', 'name':'application/vnd.wap.wmlc '},
    {'extension':'wmls', 'name':'text/vnd.wap.wmlscript '},
    {'extension':'wmlsc', 'name':'application/vnd.wap.wmlscriptc '},
    {'extension':'wrl', 'name':'model/vrml '},
    {'extension':'xbm', 'name':'image/x-xbitmap '},
    {'extension':'xht', 'name':'application/xhtml+xml '},
    {'extension':'xhtml', 'name':'application/xhtml+xml '},
    {'extension':'xls', 'name':'application/vnd.ms-excel '},
    {'extension':'xml', 'name':'application/xml '},
    {'extension':'xpm', 'name':'image/x-xpixmap '},
    {'extension':'xsl', 'name':'application/xml '},
    {'extension':'xslt', 'name':'application/xslt+xml '},
    {'extension':'xul', 'name':'application/vnd.mozilla.xul+xml '},
    {'extension':'xwd', 'name':'image/x-xwindowdump '},
    {'extension':'xyz', 'name':'chemical/x-xyz '},
    {'extension':'zip', 'name':'application/zip '},
    #elphy
    {'extension':'dat', 'name':'application/octet-stream'}
]

class Command(PopulateCommand):
    help = "populate mimetypes"
    priority = 0
    data = [
        {'class':MimeType, 'objects':mime_types}    
    ]
