#encoding:utf-8
from helmholtz.core.populate import PopulateCommand
from helmholtz.neuralstructures.models import CellType

#data of cell_type come from The Brain Architecture Management System : http://brancusi.usc.edu/bkms/ 
# more info: http://www.ncbi.nlm.nih.gov/pmc/articles/PMC2525975/pdf/fninf-02-002.pdf     
cell_types = [
    {'id':206, 'name':'360 nm-cone'},
    {'id':205, 'name':'510 nm-cone'},
    {'id':291, 'name':'B1 neuron'},
    {'id':292, 'name':'B2 neuron'},
    {'id':45, 'name':'basket neuron'},
    {'id':231, 'name':'beaded neuron'},
    {'id':111, 'name':'bistratified amacrine cell'},
    {'id':135, 'name':'candelabrum cell'},
    {'id':132, 'name':'cerebellar granule cell'},
    {'id':145, 'name':'cerebellar molecular layer interneuron'},
    {'id':289, 'name':'class A neuron'},
    {'id':290, 'name':'class B neuron'},
    {'id':227, 'name':'common spiny neuron'},
    {'id':54, 'name':'cone'},
    {'id':234, 'name':'constrained-range neuron'},
    {'id':248, 'name':'curly bipolar neuron'},
    {'id':273, 'name':'deep horizontal cell'},
    {'id':280, 'name':'deep vertical fusiform cell'},
    {'id':229, 'name':'dense axon plexus-forming neurons'},
    {'id':32, 'name':'descending neuron'},
    {'id':256, 'name':'descending neuron, sympathetic system'},
    {'id':257, 'name':'descending neuron, sympathetic/parasympathetic system'},
    {'id':8, 'name':'fusiform neuron'},
    {'id':258, 'name':'GABA-IR neuron, cerebellar nuclei'},
    {'id':263, 'name':'Glu-IR neuron, cerebellar nuclei'},
    {'id':47, 'name':'Golgi neuron'},
    {'id':48, 'name':'Golgi neuron, big'},
    {'id':49, 'name':'Golgi neuron, small'},
    {'id':236, 'name':'heterodendritic neuron'},
    {'id':127, 'name':'horizontal cell'},
    {'id':271, 'name':'HSD2 neuron'},
    {'id':279, 'name':'intermediate vertical fusiform cell'},
    {'id':22, 'name':'interneuron'},
    {'id':103, 'name':'interplexiform cell'},
    {'id':6, 'name':'inverted pyramidal cell'},
    {'id':268, 'name':'IO projecting neuron, cerebellar nuclei'},
    {'id':30, 'name':'local interneuron'},
    {'id':50, 'name':'Lugaro neuron'},
    {'id':274, 'name':'marginal cell'},
    {'id':247, 'name':'monopolar neuron'},
    {'id':26, 'name':'motor neuroendocrine magnocellular neuron'},
    {'id':28, 'name':'motor neuroendocrine magnocellular oxytocin neuron'},
    {'id':27, 'name':'motor neuroendocrine magnocellular vasopressin neuron'},
    {'id':25, 'name':'motor neuroendocrine neuron'},
    {'id':39, 'name':'motor neuroendocrine parvicellular CRH neuron'},
    {'id':255, 'name':'motor neuroendocrine parvicellular DA neuron'},
    {'id':254, 'name':'motor neuroendocrine parvicellular GRH neuron'},
    {'id':14, 'name':'motor neuroendocrine parvicellular neuron'},
    {'id':253, 'name':'motor neuroendocrine parvicellular SOM neuron'},
    {'id':252, 'name':'motor neuroendocrine parvicellular TRH neuron'},
    {'id':20, 'name':'motor neuron'},
    {'id':251, 'name':'motor neuron, extraocular muscles'},
    {'id':23, 'name':'motor somatic neuron'},
    {'id':288, 'name':'multipolar cell (ganglion zone of SC)'},
    {'id':276, 'name':'narrow field vertical cell'},
    {'id':112, 'name':'narrow-field bistratified amacrine cell'},
    {'id':5, 'name':'neurogliaform'},
    {'id':260, 'name':'non-reciprocal projections neuron, cerebellar nuclei'},
    {'id':262, 'name':'nucleocortical neuron'},
    {'id':52, 'name':'photoreceptor'},
    {'id':275, 'name':'piriform cell'},
    {'id':233, 'name':'projecting star neuron'},
    {'id':29, 'name':'projection interneuron'},
    {'id':40, 'name':'Purkinje neuron'},
    {'id':1, 'name':'pyramidal cell'},
    {'id':249, 'name':'radial multipolar neuron'},
    {'id':264, 'name':'reciprocal GABA-IR neuron, cerebellar nuclei'},
    {'id':265, 'name':'reciprocal Glu-IR neuron, cerebellar nuclei'},
    {'id':259, 'name':'reciprocal projections neuron, cerebellar nuclei'},
    {'id':101, 'name':'retinal amacrine cell'},
    {'id':116, 'name':'retinal bipolar cell'},
    {'id':70, 'name':'retinal ganglion cell'},
    {'id':55, 'name':'retinal ganglion cell A'},
    {'id':56, 'name':'retinal ganglion cell A1'},
    {'id':68, 'name':'retinal ganglion cell A2'},
    {'id':57, 'name':'retinal ganglion cell A2 inner'},
    {'id':58, 'name':'retinal ganglion cell A2 outer'},
    {'id':59, 'name':'retinal ganglion cell B'},
    {'id':60, 'name':'retinal ganglion cell B1'},
    {'id':61, 'name':'retinal ganglion cell B2'},
    {'id':62, 'name':'retinal ganglion cell B3'},
    {'id':67, 'name':'retinal ganglion cell C'},
    {'id':66, 'name':'retinal ganglion cell C others'},
    {'id':63, 'name':'retinal ganglion cell C1'},
    {'id':69, 'name':'retinal ganglion cell C2'},
    {'id':64, 'name':'retinal ganglion cell C2 inner'},
    {'id':65, 'name':'retinal ganglion cell C2 outer'},
    {'id':53, 'name':'rod'},
    {'id':117, 'name':'rod bipolar cell'},
    {'id':19, 'name':'sensory neuron'},
    {'id':246, 'name':'simple bipolar neuron'},
    {'id':215, 'name':'small pyramidal neuron'},
    {'id':214, 'name':'spiny bipolar neuron'},
    {'id':230, 'name':'spiny neurogliaform neuron'},
    {'id':250, 'name':'spiny neuron SCN'},
    {'id':228, 'name':'spiny neuron with chandelier-like axon'},
    {'id':232, 'name':'spiny projection neuron'},
    {'id':285, 'name':'stellate cell of the zone of horizontal cells'},
    {'id':287, 'name':'stellate cell of the zone of optic fibers'},
    {'id':286, 'name':'stellate cell of the zone of vertical cells'},
    {'id':9, 'name':'stellate neuron'},
    {'id':104, 'name':'stratified amacrine cell'},
    {'id':114, 'name':'stratified diffuse amacrine cell'},
    {'id':272, 'name':'superficial horizontal cell'},
    {'id':226, 'name':'superficial spiny neuron'},
    {'id':278, 'name':'superficial vertical fusiform cell'},
    {'id':266, 'name':'symmetrical GABA-IR neuron, cerebellar nuclei'},
    {'id':267, 'name':'symmetrical Glu-IR neuron, cerebellar nuclei'},
    {'id':261, 'name':'symmetrical projections neuron, cerebellar nuclei'},
    {'id':216, 'name':'triangular neuron'},
    {'id':105, 'name':'type (a) narrow-field unistratified amacrine cell'},
    {'id':108, 'name':'type (a) wide-field unistratified amacrine cell'},
    {'id':106, 'name':'type (b) narrow-field unistratified amacrine cell'},
    {'id':109, 'name':'type (b) wide-field unistratified amacrine cell'},
    {'id':110, 'name':'type (c) wide-field unistratified amacrine cell'},
    {'id':118, 'name':'type 1 cone bipolar cell'},
    {'id':119, 'name':'type 2 cone bipolar cell'},
    {'id':120, 'name':'type 3 cone bipolar cell'},
    {'id':121, 'name':'type 4 cone bipolar cell'},
    {'id':122, 'name':'type 5 cone bipolar cell'},
    {'id':123, 'name':'type 6 cone bipolar cell'},
    {'id':124, 'name':'type 7 cone bipolar cell'},
    {'id':125, 'name':'type 8 cone bipolar cell'},
    {'id':126, 'name':'type 9 cone bipolar cell'},
    {'id':283, 'name':'type II ganglion cell'},
    {'id':284, 'name':'type III ganglion cell'},
    {'id':51, 'name':'unipolar brush neuron'},
    {'id':277, 'name':'vertical fusiform cell'},
    {'id':102, 'name':'wide field diffuse amacrine cell'},
    {'id':281, 'name':'wide field vertical cell'},
    {'id':113, 'name':'wide-field bistratified amacrine cell'},
    {'id':107, 'name':'wide-field unistratified amacrine cell'},
    {'id':235, 'name':'wide-range neuron'}
]


class Command(PopulateCommand):
    help = "populate cell types"
    priority = 0
    data = [
        {'class':CellType, 'objects':cell_types}    
    ]
