from __future__ import print_function, division

# Numerical constants, in cgs

from numpy import pi

lsun = 3.846e33
'''Luminosity of the Sun (erg/s)'''

rsun = 6.95508e10
'''Radius of the Sun (cm)'''

msun = 1.989e33
'''Mass of the Sun (g)'''

tsun = 5778.
'''Effective temperature of the Sun (K)'''

au = 1.49598e13
'''One Astronomical Unit (cm)'''

year = 365.25 * 24. * 3600.
'''Length of a year (s)'''

yr = year

h = 6.626068e-27
'''Planck constant (erg.s)'''

k = 1.3806503e-16
'''Boltzmann constant (erg/K)'''

c = 2.99792458e10
'''Speed of light (cm/s)'''

G = 6.67300e-8
'''Gravitational constant (cm^3/g/s^2)'''

m_h = 1.6733e-24
'''Mass of a hydrogen atom (g)'''

sigma = 5.67051e-5
'''Stefan-Boltzmann constant (erg/cm^2/K^4/s)'''

pc = 3.08568025e18
'''One parsec (cm)'''

kpc = 1e3 * pc
'''One kiloparsec (cm)'''
