# IDLE2HTML - IDLE extension
# saves the contents of the editwindow (file or shell)
# to a html file using css styles
#
# creator:        d2m <michael@d2m.at>
# 0.1/2006-07-22: initial revision
# 0.2/2007-06-14: added styles for BODY
#                     thanks to Tal Einat who pointed out a problem
#                     with non Black-on-White color schemes
#                 removed Selection highlightning
#                 added ERROR highlightning
#
# todo:           check for valid css color values
#                 use elementtree for html generation
#                 enable Selection highlightning

__version__ = '0.2'

import Tkinter
import tkFileDialog
import cgi

class IDLE2HTML:
    menudefs=[('options',[('Save to HTML', '<<idle2html>>')])]

    def __init__(self,editwin):
        self.editwin=editwin
        self.text=editwin.text
            
    def idle2html_event(self, event=None):
        filetypes = [
            ("All HTML files", "*.htm *.html", "TEXT"),
            ("All files", "*"),
            ]
        filename=tkFileDialog.SaveAs(master=self.text, filetypes=filetypes).show()
        f=open(filename,'w')
        f.write(self.idle2html())
        f.close()
        
    def idle2html(self):
        """format tags 2 html
        """
        out=['<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" \
"http://www.w3.org/TR/2002/REC-xhtml1-20020801/DTD/xhtml1-transitional.dtd">\n']
        out.append('<html>\n<head>\n<title>IDLE2HTML</title>\n')
        out.append('<meta name="generator" content="IDLE2HTML - IDLE extension (%s)" />\n' % __version__)
        out.append('<style type="text/css">\n')
        out.append('%s {color: %s; background-color: %s;}\n' % (
                       'BODY',
                       self.text.cget('foreground'),
                       self.text.cget('background'),
                       )
                    )
        for tagname in self.text.tag_names():
            fg=self.text.tag_cget(tagname,'foreground')
            bg=self.text.tag_cget(tagname,'background')
            if fg and bg and tagname.lower() != 'sel':
                out.append('.%s {color: %s; background-color: %s;}\n' % (
                                tagname,
                                fg,
                                bg,
                                )
                            )
        out.append('</style>\n')
        out.append('</head>\n<body>\n<pre>')
        inside_error=0
        for tagname,content,dummy in self.text.dump('1.0',self.text.index('end')):
            if tagname=='tagon' and not (content.upper() in ('SYNC','TODO','SEL')):
                if not inside_error:
                    out.append('<span class="%s">' % content)
                if content.upper() == 'ERROR':
                    inside_error=1
            if tagname=='text':
                out.append(cgi.escape(content))
            if tagname=='tagoff' and not (content.upper() in ('SYNC','TODO','SEL')):
                if content.upper() == 'ERROR':
                    inside_error=0
                if not inside_error:
                    out.append('</span>')
        out.append('</pre>\n</body>\n</html>')
        return ''.join(out)

