from datetime import datetime, date, time
from xml.sax.saxutils import escape

__author__ = 'shillaker'


# Builds a commit request
def build_commit_request():
    return '/update?commit=true'


# Builds a delete all request
def build_delete_all_request(commit):
    xml_content = '<delete><query>*:*</query></delete>'

    request_string = '/update'
    if commit:
        request_string += '?commit=true'

    return request_string, xml_content


# Builds a delete request for multiple IDs
def build_delete_by_ids_request(doc_ids, commit):
    xml_content = '<update>'

    for doc_id in doc_ids:
        doc_id = escape(doc_id)
        xml_content += '<delete>'
        xml_content += '<id>' + doc_id + '</id>'
        xml_content += '</delete>'

    xml_content += '</update>'

    request_string = '/update'
    if commit:
        request_string += '?commit=true'

    return request_string, xml_content


# Builds an add request
def build_add_request(doc, commit=False):
    xml_content = '<update><add><doc>'

    # Add all fields of the document
    for field, value in doc.iteritems():
        # Check if we have an array-like value
        if isinstance(value, (frozenset, list, set, tuple)):
            for v in value:
                v = escape(v)
                xml_content += '<field name="%s">%s</field>' % (field, v)
        # Boolean
        elif isinstance(value, bool):
            str_value = 'true' if value else 'false'
            xml_content += '<field name="%s">%s</field>' % (field, str_value)
        # Date
        elif isinstance(value, (datetime, date, time)):
            str_value = value.strftime('%Y-%m-%dT%H:%M:%SZ')
            xml_content += '<field name="%s">%s</field>' % (field, str_value)
        # String
        elif isinstance(value, basestring):
            value = escape(value)
            xml_content += '<field name="%s">%s</field>' % (field, value)
        # Misc other value
        else:
            xml_content += '<field name="%s">%s</field>' % (field, value)

    xml_content += '</doc></add></update>'

    request_string = '/update'
    if commit:
        request_string += '?commit=true'

    return request_string, xml_content