from icarus.result.result_classes import SearchResult

__author__ = 'shillaker'


# Builds the result of a select query
def build_select_result(raw_response):
    result = SearchResult()
    result.n_total = raw_response['response'].get('numFound')
    result.items = raw_response['response'].get('docs')

    result.facet_counts = handle_facet_response(raw_response)

    return result


# Constructs our desired facet structure from a response
def handle_facet_response(response):
    # Build desired facet counts object
    facet_counts = dict()
    facet_counts['facet_fields'] = _extract_facet_fields(response)
    facet_counts['facet_ranges'] = _extract_facet_ranges(response)
    return facet_counts


# Extracts the facet range counts in a useful format
def _extract_facet_ranges(response):
    facet_ranges = dict()

    # Process the facet_ranges response
    try:
        facet_range_fields = response['facet_counts']['facet_ranges']
    except KeyError:
        return

    # Build up list of tuples from facets
    for facet_range_field, data in facet_range_fields.iteritems():
        filter_tuples = _even_list_to_tuples(data['counts'])

        # Map the remaining facet_range response values
        this_range_field = dict()
        this_range_field['counts'] = filter_tuples
        this_range_field['start'] = data['start']
        this_range_field['end'] = data['end']
        this_range_field['gap'] = data['gap']

        facet_ranges[facet_range_field] = this_range_field

    return facet_ranges


# Extracts the facet field counts in a useful format
def _extract_facet_fields(response):
    facet_fields = dict()

    # Process the facet_fields response
    try:
        facet_fields_fields = response['facet_counts']['facet_fields']
    except KeyError:
        return

    # Build up list of tuples from facets
    for field, counts in facet_fields_fields.iteritems():
        filter_tuples = _even_list_to_tuples(counts)
        facet_fields[field] = filter_tuples

    return facet_fields


# Convert an even numbered list to a list of tuples
def _even_list_to_tuples(even_list):
    tuple_list = list()
    for i in xrange(0, len(even_list), 2):
        tuple_list.append((even_list[i], even_list[i + 1]))

    return tuple_list
