from urllib import unquote
import urlparse
from icarus.query.select_request_builder import build_select_request

__author__ = 'shillaker'


# Checks the correct select query is created
def check_select_url(test_case, query, expected):
    # Add the default parameters
    expected['rows'] = ['10']
    expected['start'] = ['0']
    expected['wt'] = ['json']

    # Generate the select request with default parameters
    actual = build_select_request(query, 0, 10)
    actual = unquote(actual)

    # Check the get params
    _check_get_params(test_case, actual, expected)

    # Check the path is a select
    path = urlparse.urlparse(actual).path
    test_case.assertEqual(path, '/select')


# Checks the get params are as expected
def _check_get_params(test_case, actual, expected):
    # Convert just the query params into a dict
    actual_query = urlparse.urlparse(actual).query
    actual_query = urlparse.parse_qs(actual_query)
    test_case.assertDictEqual(actual_query, expected)